/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.util.AbstractDescribable;
import java.lang.reflect.Method;

public class MethodContainer
extends AbstractDescribable {
    private EJBPackage jar;
    private MethodDescriptor[] methods;

    public MethodContainer(EJBPackage jar) {
        this.jar = jar;
    }

    public int implies(String beanName, Method method, boolean home, boolean local) {
        int level = 0;
        if (this.methods != null) {
            for (int i = 0; i < this.methods.length; ++i) {
                int newLevel = this.methods[i].implies(beanName, method, local ? (home ? 4 : 3) : (home ? 2 : 1));
                if (newLevel <= level) continue;
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
        }
        return level;
    }

    public int implies(String beanName, Method method, int methodOrigin) {
        int level = 0;
        if (this.methods != null) {
            for (int i = 0; i < this.methods.length; ++i) {
                int newLevel = this.methods[i].implies(beanName, method, methodOrigin);
                if (newLevel <= level) continue;
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
        }
        return level;
    }

    public int implies(String beanName, Method method, boolean home) {
        return this.implies(beanName, method, home, false);
    }

    public void addMethod(MethodDescriptor descriptor) {
        if (this.methods != null) {
            for (int i = 0; i < this.methods.length; ++i) {
                if (!descriptor.equals(this.methods[i])) continue;
                return;
            }
        }
        MethodDescriptor[] newMethods = new MethodDescriptor[this.methods == null ? 1 : this.methods.length + 1];
        if (this.methods != null) {
            System.arraycopy(this.methods, 0, newMethods, 0, this.methods.length);
        }
        this.methods = newMethods;
        this.methods[this.methods.length - 1] = descriptor;
        this.firePropertyChangeEvent("methods", null, descriptor);
    }

    public MethodDescriptor[] getMethods() {
        if (this.methods == null) {
            return new MethodDescriptor[0];
        }
        return this.methods;
    }

    public EJBPackage getJar() {
        return this.jar;
    }

    public void removeMethod(MethodDescriptor descriptor) {
        if (this.methods == null) {
            return;
        }
        for (int i = 0; i < this.methods.length; ++i) {
            if (!descriptor.equals(this.methods[i])) continue;
            MethodDescriptor[] newMethods = new MethodDescriptor[this.methods.length - 1];
            System.arraycopy(this.methods, 0, newMethods, 0, i);
            System.arraycopy(this.methods, i + 1, newMethods, i, newMethods.length - i);
            break;
        }
        this.firePropertyChangeEvent("methods", descriptor, null);
    }

    public String toString() {
        return "[" + this.getName() + ": " + this.methods + "]";
    }
}

