/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.deployment.RoleNameContainer;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.MethodContainer;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MethodPermission
extends MethodContainer
implements XMLizable,
RoleNameContainer {
    private List roleNames;
    private boolean unchecked;
    private boolean isOverride = false;

    public MethodPermission(EJBPackage jar) {
        super(jar);
    }

    public MethodPermission(EJBPackage jar, MethodDescriptor md) {
        super(jar);
        this.addMethod(md);
    }

    public MethodPermission(EJBPackage jar, Node parent) throws InstantiationException {
        super(jar);
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("role-name")) {
                this.addRoleName(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("method")) {
                this.addMethod(new MethodDescriptor(node));
                continue;
            }
            if (name.equals("description")) {
                this.setDescription(XMLUtils.getStringValue(node));
                continue;
            }
            if (!name.equals("unchecked")) continue;
            this.setUnchecked(true);
        }
    }

    public void addRoleName(String name) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList();
        }
        if (this.roleNames.contains(name)) {
            return;
        }
        this.roleNames.add(name);
        this.firePropertyChangeEvent("roleNames", null, name);
    }

    public List getRoleNames() {
        if (this.roleNames == null) {
            return Collections.EMPTY_LIST;
        }
        return this.roleNames;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        if (this.roleNames == null || this.roleNames.isEmpty() || this.getMethods().length == 0) {
            return;
        }
        out.println(indention + "<method-permission>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.unchecked) {
            out.println(indention + "\t<unchecked />");
        } else if (this.roleNames != null) {
            XMLUtils.writeStrings(this.roleNames, "role-name", out, indention + "\t");
        }
        XMLUtils.writeAll(Arrays.asList(this.getMethods()), out, indention + "\t");
        out.println(indention + "</method-permission>");
    }

    public void removeRoleName(String name) {
        if (this.roleNames == null) {
            return;
        }
        this.roleNames.remove(name);
    }

    public void setUnchecked(boolean unchecked) {
        this.unchecked = unchecked;
        if (unchecked) {
            this.roleNames = null;
        }
    }

    public boolean isUnchecked() {
        return this.unchecked;
    }

    public void setIsOverride(boolean isOverride) {
        this.isOverride = isOverride;
    }

    public boolean isOverride() {
        return this.isOverride;
    }
}

