/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.compilation.ORCompilation;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.database.TableNameContainer;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EJBDeploymentContext;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EJBRelationshipRole;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ORNameMapper;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.evermind.util.EJBProperties;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ORMapping
implements PrimaryKeyContext,
XMLizable,
TableNameContainer {
    public static final boolean ASSOC_TABLES_USER_PREF = EJBProperties.getAssociateUsingThirdTable();
    public ORCompilation compilation;
    public EJBRelationshipRole peer;
    private int type;
    protected ContainerManagedField orField;
    protected ORMapping peerORMapping;
    protected String tableName;
    protected boolean tableNameExplicitlyDefined;
    protected ContainerManagedField keyField;
    protected ContainerManagedField valueField;
    protected String typeName;
    private boolean valueImmutable;
    private int maxTableNameLength = 0;
    public boolean associateUsingThirdTable = ASSOC_TABLES_USER_PREF;
    private boolean lazyLoading;

    protected ORMapping(ContainerManagedField orField, int type) {
        if (orField == null) {
            throw new NullPointerException("orField was null");
        }
        this.orField = orField;
        this.type = type;
        this.setValueImmutable(this.type == 7);
    }

    protected ORMapping(Node parent, ContainerManagedField orField, int type, EJBPackage ejbPackage) throws InstantiationException {
        NodeList nodes;
        if (orField == null) {
            throw new NullPointerException("orField was null");
        }
        this.orField = orField;
        this.type = type;
        this.lazyLoading = XMLUtils.getBooleanNodeAttribute(parent.getParentNode(), "load-lazily") == 1;
        this.tableName = XMLUtils.getNodeAttribute(parent, "table");
        if (this.tableName != null) {
            this.tableNameExplicitlyDefined = true;
            ContainerManagedField resolved = orField.getPeer().getRelation().getResolved();
            EntityBeanDescriptor peerBeanDesc = (EntityBeanDescriptor)resolved.getContext();
            String fkTableName = this.getPeerTableName(parent, peerBeanDesc.getName());
            if (fkTableName == null) {
                fkTableName = peerBeanDesc.getTableName();
            }
            this.associateUsingThirdTable = !this.tableName.equalsIgnoreCase(fkTableName) && (ASSOC_TABLES_USER_PREF || orField.isManyToMany());
        }
        if ((nodes = parent.getChildNodes()) != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (XMLUtils.isCommentOrID(name)) continue;
                if (name.equals("primkey-mapping") || name.equals("primary-key-mapping")) {
                    this.keyField = ORMapping.parseField(node, orField.getContext(), ejbPackage);
                    continue;
                }
                if (!name.equals("value-mapping")) continue;
                this.typeName = XMLUtils.getNodeAttribute(node, "type");
                this.valueField = ORMapping.parseField(node, orField.getContext(), ejbPackage);
                if (this.type == 7) {
                    this.setValueImmutable(!"false".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "immutable")));
                    continue;
                }
                this.setValueImmutable("true".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "immutable")));
            }
        }
    }

    public ContainerManagedField getPrimaryKey() {
        return this.keyField.getContext().getPrimaryKey();
    }

    public ContainerManagedField getKeyField() {
        return this.keyField;
    }

    public ContainerManagedField getValueField() {
        return this.valueField;
    }

    public ContainerManagedField getValueFieldPrimaryKey() {
        return this.valueField.getContext().getPrimaryKey();
    }

    public ClassLoader getClassLoader() {
        return this.orField.getContext().getClassLoader();
    }

    public boolean isManyToMany() {
        return this.peer != null && this.peer.getPeer().isMany();
    }

    public boolean isManyToManyMaster() {
        if (this.isManyToMany()) {
            if (this.peer.getRelation() == null || this.peer.getPeer().getRelation().isSynthetic()) {
                return false;
            }
            if (this.peer.getPeer().getRelation() == null || this.peer.getPeer().getRelation().isSynthetic()) {
                return true;
            }
            return this.peer == this.peer.getEJBRelationship().getFirstRole();
        }
        return false;
    }

    public boolean isManyToManySlave() {
        if (this.isManyToMany()) {
            if (this.peer.getRelation() == null || this.peer.getRelation().isSynthetic()) {
                return true;
            }
            if (this.peer.getPeer().getRelation() == null || this.peer.getPeer().getRelation().isSynthetic()) {
                return false;
            }
            return this.peer == this.peer.getEJBRelationship().getSecondRole();
        }
        return false;
    }

    public boolean isOneToManyMaster() {
        return this.peer != null && this.peer.getPeer() != null && !this.peer.isMany() && this.peer.getPeer().isMany();
    }

    public boolean isOneToManySlave() {
        return this.peer != null && this.peer.getPeer() != null && this.peer.isMany() && !this.peer.getPeer().isMany();
    }

    public boolean isOneToMany() {
        return this.isOneToManyMaster() || this.isOneToManySlave();
    }

    public boolean isOneToManyBiSlave() {
        if (this.isOneToManySlave()) {
            if (this.associateUsingThirdTable) {
                return false;
            }
            return this.peer.getRelation() != null && !this.peer.getRelation().isSynthetic();
        }
        return false;
    }

    public EntityBeanDescriptor getDescriptor() {
        return this.orField.getEntity();
    }

    public EntityBeanDescriptor getPeerDescriptor() {
        ContainerManagedField aField = this.peer.getRelation().getResolved();
        return aField.getEntity();
    }

    public ORMapping getPeerORMapping() {
        ContainerManagedField aField = this.peer.getRelation().getResolved();
        return aField.getORMapping();
    }

    public ContainerManagedField getPeerKeyField() {
        ContainerManagedField aField = this.peer.getRelation().getResolved();
        if (aField != null && aField.getORMapping() != null) {
            return aField.getORMapping().getKeyField();
        }
        return null;
    }

    public ContainerManagedField getPeerValueField() {
        ContainerManagedField aField = this.peer.getRelation().getResolved();
        if (aField != null && aField.getORMapping() != null) {
            return aField.getORMapping().getValueField();
        }
        return null;
    }

    public static ORMapping getPeerORMapping(ContainerManagedField field, EJBRelationshipRole peer) throws InstantiationException {
        if (peer.getRoleSource() == null) {
            throw new InstantiationException("role-source must be defined for both roles in a many to many ejb-relation, not defined in ejb-relation '" + peer.getEJBRelationship().getDescription() + "'");
        }
        if (peer.getRelation() == null) {
            throw new InstantiationException("No cmr-field defined for relationship-role in ejb-relation '" + peer.getEJBRelationship().getDescription() + "', must be defined for both roles in a many to many relation");
        }
        return peer.getRelation().getResolved().getORMapping();
    }

    public String getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        try {
            this.peerORMapping = ORMapping.getPeerORMapping(this.orField, this.peer);
        }
        catch (InstantiationException e) {
            throw new InternalError(e.getMessage());
        }
        this.tableName = this.peerORMapping.getTableName();
        return this.tableName;
    }

    private String getValueTypeName(ContainerManagedField field) {
        String valueTypeName = null;
        PrimaryKeyContext context = field.getContext();
        if (context instanceof EntityBeanDescriptor) {
            valueTypeName = ((EntityBeanDescriptor)context).getLocalInterfaceName() != null ? ((EntityBeanDescriptor)context).getLocalInterfaceName() : ((EntityBeanDescriptor)context).getRemoteInterfaceName();
        }
        return valueTypeName;
    }

    public void init(ContainerManagedField primaryKey, EJBDeploymentContext container, ORNameMapper nameMapper, DatabaseSchema schema, Class type) throws InstantiationException {
        String valueFieldName;
        if (schema == null) {
            throw new NullPointerException("schema was null");
        }
        this.maxTableNameLength = schema.getMaxTableNameLength();
        ContainerManagedField resolved = this.peer.getRelation().getResolved();
        String bean1 = ((EntityBeanDescriptor)this.orField.getContext()).getName();
        String pk1 = this.orField.getContext().getPrimaryKey().getDatabaseName();
        String pk1Name = this.orField.getContext().getPrimaryKey().getEntity().isAutomaticIdentity() ? pk1 : this.orField.getContext().getPrimaryKey().getName();
        String cmr1 = this.orField.getName();
        String masterTableName = bean1 + "_" + cmr1;
        String keyFieldName = this.isOneToManyBiSlave() ? (pk1Name == null || pk1Name.equals("") ? resolved.getName() : resolved.getName() + "_" + pk1Name) : (pk1Name != null && !pk1Name.equals("") ? bean1 + "_" + pk1Name : resolved.getName());
        String keyFieldTypeName = this.getValueTypeName(this.orField);
        String keyFieldParentTypeName = ((BeanDescriptor)((Object)resolved.getContext())).getEJBClass().getName();
        if (this.keyField == null) {
            this.keyField = new ContainerManagedField(null, this.orField.getContext(), keyFieldName, this);
        }
        try {
            EntityBeanDescriptor aDescriptor;
            String aDatabaseName;
            if (this.isOneToManyBiSlave() && (aDatabaseName = (String)(aDescriptor = this.getPeerDescriptor()).getFieldsMap().get(keyFieldName)) != null) {
                this.keyField.setDatabaseName(aDatabaseName);
            }
            this.keyField.init(container, schema, null, Class.forName(keyFieldTypeName, true, this.orField.getContext().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Bean-type '" + keyFieldTypeName + "' used in or-mapping not found");
        }
        String bean2 = ((EntityBeanDescriptor)resolved.getContext()).getName();
        String pk2 = resolved.getContext().getPrimaryKey().getDatabaseName();
        String pk2Name = resolved.getContext().getPrimaryKey().getEntity().isAutomaticIdentity() ? pk2 : resolved.getContext().getPrimaryKey().getName();
        String cmr2 = resolved.getName();
        String slaveTableName = null;
        slaveTableName = !resolved.isSynthetic() ? bean2 + "_" + cmr2 : bean2;
        if (this.isOneToManyBiSlave()) {
            valueFieldName = pk2Name == null || pk2Name.equals("") ? this.orField.getName() : this.orField.getName() + "_" + pk2Name;
        } else {
            String string = valueFieldName = pk2Name != null && !pk2Name.equals("") ? bean2 + "_" + pk2Name : this.orField.getName();
        }
        if (keyFieldName.equals(valueFieldName)) {
            valueFieldName = valueFieldName + "_x";
        }
        String valueFieldTypeName = this.getValueTypeName(resolved);
        String valueFieldParentTypeName = ((BeanDescriptor)((Object)this.orField.getContext())).getEJBClass().getName();
        if (this.valueField == null) {
            this.valueField = new ContainerManagedField(null, resolved.getContext(), valueFieldName, this);
        }
        try {
            EntityBeanDescriptor aDescriptor;
            String aDatabaseName;
            if (this.isOneToManyBiSlave() && (aDatabaseName = (String)(aDescriptor = this.getPeerDescriptor()).getFieldsMap().get(aDescriptor.getPrimaryKey().getName())) != null) {
                this.valueField.setDatabaseName(aDatabaseName);
            }
            this.valueField.init(container, schema, null, Class.forName(valueFieldTypeName, true, resolved.getContext().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Bean-type '" + valueFieldTypeName + "' used in or-mapping not found");
        }
        String tableName = this.isOneToManyBiSlave() ? this.getPeerDescriptor().getTableName() : ((EntityBeanDescriptor)this.orField.getContext()).getEJBPackage().appendNamespace(masterTableName + "_" + slaveTableName);
        if (this.tableName == null && !this.isManyToManySlave()) {
            this.setTableName(tableName);
        }
        if (nameMapper != null && this.tableName != null) {
            nameMapper.lookupTable(this, this.isTableExplicitlyDefined(), schema);
        }
    }

    public void validateDatabaseFieldName() {
        Set fields = this.keyField.getEJBReferenceField().getPropertyFields();
        if (fields == null) {
            return;
        }
        Iterator keyFieldProperties = fields.iterator();
        while (keyFieldProperties.hasNext()) {
            ContainerManagedField aKeyField = (ContainerManagedField)keyFieldProperties.next();
            ContainerManagedField aValueField = this.valueField.getEJBReferenceField().getPropertyField(aKeyField.getName());
            if (aValueField == null || !aKeyField.getDatabaseName().equals(aValueField.getDatabaseName())) continue;
            aKeyField.setDatabaseName(this.keyField.getName() + "_" + aValueField.getDatabaseName());
        }
    }

    public boolean isValueImmutable() {
        return this.valueImmutable;
    }

    public void setValueImmutable(boolean immutable) {
        this.valueImmutable = immutable;
    }

    public static ContainerManagedField parseField(Node parent, PrimaryKeyContext owner, EJBPackage ejbPackage) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        Node node = XMLUtils.getSubnode(parent, "cmp-field-mapping");
        if (node == null) {
            return null;
        }
        ContainerManagedField field = new ContainerManagedField(null, owner, XMLUtils.getNodeAttribute(node, "name"));
        if (field.getName() == null) {
            throw new InstantiationException("<cmp-field-mapping> node with missing 'name' attribute");
        }
        field.parseOrionXML(node, ejbPackage);
        return field;
    }

    public abstract String getWrapperName();

    public boolean isTableExplicitlyDefined() {
        return this.tableNameExplicitlyDefined;
    }

    public void setTableName(String name) {
        this.tableName = name;
    }

    public void setValueTypeName(String name) {
        this.typeName = name;
    }

    public int getPersistenceType() {
        return this.type;
    }

    public Set getContainerManagedFields() {
        HashSet<ContainerManagedField> fields = new HashSet<ContainerManagedField>();
        if (this.keyField != null) {
            fields.add(this.keyField);
        }
        if (this.valueField != null) {
            fields.add(this.valueField);
        }
        return fields;
    }

    public ContainerManagedField getContainerManagedField(String name, PrimaryKeyContext owner) {
        if (owner == this) {
            if (this.keyField != null && name.equals(this.keyField.getName())) {
                return this.keyField;
            }
            if (this.valueField != null && name.equals(this.valueField.getName())) {
                return this.valueField;
            }
        }
        return this.orField.getContext().getContainerManagedField(name, owner);
    }

    public PropertyDescriptor[] getProperties() {
        return new PropertyDescriptor[0];
    }

    public ContainerManagedField getORField() {
        return this.orField;
    }

    public void setPrimaryKeyField(ContainerManagedField field) {
        this.keyField = field;
    }

    public void setValueField(ContainerManagedField field) {
        this.valueField = field;
    }

    public boolean isPropertyMethod(Method method) throws IntrospectionException {
        return false;
    }

    private String getPeerTableName(Node parent, String ejbName) {
        Node entBeanNode = parent.getParentNode().getParentNode().getParentNode();
        NodeList nodes = entBeanNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("entity-deployment") || !XMLUtils.getNodeAttribute(node, "name").equals(ejbName)) continue;
            return XMLUtils.getNodeAttribute(node, "table");
        }
        return null;
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public boolean isAssociateUsingThirdTable() {
        if (this.tableNameExplicitlyDefined) {
            return this.associateUsingThirdTable;
        }
        ContainerManagedField resolved = this.orField.getPeer().getRelation().getResolved();
        EntityBeanDescriptor peerBeanDesc = (EntityBeanDescriptor)resolved.getContext();
        String fkTableName = peerBeanDesc.getTableName();
        return !this.tableName.equalsIgnoreCase(fkTableName) && (ASSOC_TABLES_USER_PREF || this.orField.isManyToMany());
    }
}

