/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor;

import com.evermind.server.DependencyManager;
import com.evermind.server.deployment.ClassUtils;
import com.evermind.server.ejb.AbstractEJBContext;
import com.evermind.server.ejb.EJBDependencyManager;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.InterceptorDescriptor;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.interceptor.BeanLifecycleCallbackInterceptor;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.logging.DiagnosticContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;

public class UserInterceptor {
    private static final String AROUND_INVOKE = "aroundInvoke";
    private InterceptorDescriptor interceptorDescriptor;
    private List aroundInvokeInterceptors;
    private List postConstructInterceptors;
    private List preDestroyInterceptors;
    private List postActivateInterceptors;
    private List prePassivateInterceptors;
    private Object interceptorInstance;
    private static Class[] interceptorArgs;
    private static Constructor methodBasedSingletonInterceptorConstr;
    private static Constructor methodBasedDynamicInterceptorConstr;
    private int index;
    private boolean usesSingletonInterceptors = false;
    private InterceptorInstanceFactory instanceFactory;
    private DependencyManager dependencyManager;
    private boolean singletonInjectionComplete = false;

    public UserInterceptor(InterceptorDescriptor interceptorDescriptor, BeanDescriptor beanDescriptor) {
        this(interceptorDescriptor, beanDescriptor, -1);
    }

    public UserInterceptor(InterceptorDescriptor interceptorDescriptor, BeanDescriptor beanDescriptor, int index) {
        this.index = index;
        this.interceptorDescriptor = interceptorDescriptor;
        this.initialize(beanDescriptor);
    }

    protected Object getNewInterceptorInstance() {
        if (this.usesSingletonUserInterceptors()) {
            return this.interceptorInstance;
        }
        return this.instanceFactory.createInterceptorInstance();
    }

    protected int getIndex() {
        return this.index;
    }

    private void initialize(BeanDescriptor beanDescriptor) {
        InterceptorInstanceFactory factory = new InterceptorInstanceFactory(beanDescriptor);
        if (!this.isBeanInterceptor()) {
            this.configurePerBeanInterceptors(beanDescriptor, factory);
            if (this.usesSingletonUserInterceptors()) {
                this.interceptorInstance = factory.createInterceptorInstance();
            } else {
                this.instanceFactory = factory;
            }
        }
        this.aroundInvokeInterceptors = this.initializeCallbackInterceptors(beanDescriptor, factory.interceptorClass, this.interceptorDescriptor.getAroundInvokeMethods(), AROUND_INVOKE);
        this.postConstructInterceptors = this.initializeCallbackInterceptors(beanDescriptor, factory.interceptorClass, this.interceptorDescriptor.getPostConstructMethods(), "postConstruct");
        this.preDestroyInterceptors = this.initializeCallbackInterceptors(beanDescriptor, factory.interceptorClass, this.interceptorDescriptor.getPreDestroyMethods(), "preDestroy");
        this.postActivateInterceptors = this.initializeCallbackInterceptors(beanDescriptor, factory.interceptorClass, this.interceptorDescriptor.getPostActivateMethods(), "postActivate");
        this.prePassivateInterceptors = this.initializeCallbackInterceptors(beanDescriptor, factory.interceptorClass, this.interceptorDescriptor.getPrePassivateMethods(), "prePassivate");
        if (!this.isBeanInterceptor()) {
            this.dependencyManager = new EJBDependencyManager(beanDescriptor, this.interceptorDescriptor.getConfigDelegate(), factory.interceptorClass);
            try {
                this.dependencyManager.initialize();
            }
            catch (InstantiationException e) {
                throw DeploymentException.exceptionInstantiatingDependencyManager(beanDescriptor, factory.interceptorClass.getName(), e);
            }
        }
    }

    private List initializeCallbackInterceptors(BeanDescriptor beanDescriptor, Class interceptorClass, List callbackMethodDefs, String callbackName) {
        if (callbackMethodDefs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List callbackMethods = this.getCallbackMethods(beanDescriptor, interceptorClass, callbackMethodDefs, callbackName);
        ArrayList<Interceptor> interceptors = null;
        if (this.isBeanInterceptor() && callbackName != AROUND_INVOKE) {
            interceptors = new ArrayList(1);
            interceptors.add(new BeanLifecycleCallbackInterceptor(callbackMethods));
        } else {
            interceptors = new ArrayList<Interceptor>(callbackMethods.size());
            Iterator callbackMethodsIter = callbackMethods.iterator();
            while (callbackMethodsIter.hasNext()) {
                if (this.isBeanInterceptor() || this.usesSingletonUserInterceptors()) {
                    interceptors.add(this.createMethodBasedSingletonInterceptor(beanDescriptor, (Method)callbackMethodsIter.next(), this.getInterceptorInstance()));
                    continue;
                }
                interceptors.add(this.createMethodBasedDynamicInterceptor(beanDescriptor, (Method)callbackMethodsIter.next(), this.getIndex()));
            }
        }
        return interceptors;
    }

    private List getCallbackMethods(BeanDescriptor beanDescriptor, Class interceptorClass, List callbackMethodDefs, String callbackName) {
        ArrayList<Method> callbackMethods = new ArrayList<Method>(callbackMethodDefs.size());
        Iterator callbacks = callbackMethodDefs.iterator();
        while (callbacks.hasNext()) {
            InterceptorDescriptor.InterceptorCallback callback = (InterceptorDescriptor.InterceptorCallback)callbacks.next();
            Method interceptorMethod = this.getCallbackMethod(beanDescriptor, interceptorClass, callback.declaringClassName, callback.methodName, callbackName);
            callback.declaringClassName = interceptorMethod.getDeclaringClass().getName();
            Iterator callbackMethodsIter = callbackMethods.iterator();
            while (callbackMethodsIter.hasNext()) {
                Method oldMethod = (Method)callbackMethodsIter.next();
                if (oldMethod.getDeclaringClass().getName().equals(callback.declaringClassName)) {
                    if (oldMethod.getName().equals(callback.methodName)) continue;
                    throw DeploymentException.duplicateInterceptorCallback(beanDescriptor, callbackName, oldMethod.getName(), callback.methodName, callback.declaringClassName);
                }
                if (!ClassUtils.isMethodOverridden(interceptorClass, interceptorMethod)) continue;
                Method foundMethod = ClassUtils.getMethod(interceptorClass, interceptorMethod.getName(), interceptorMethod.getParameterTypes());
                throw DeploymentException.overriddenCallbackMethod(beanDescriptor, interceptorMethod.getName(), interceptorMethod.getDeclaringClass().getName(), foundMethod.getDeclaringClass().getName());
            }
            callbackMethods.add(interceptorMethod);
        }
        return callbackMethods;
    }

    private Method getCallbackMethod(BeanDescriptor beanDescriptor, Class interceptorBaseClass, String declaringClassName, String methodName, String callbackName) {
        Class interceptorClass = interceptorBaseClass;
        if (declaringClassName == null) {
            declaringClassName = beanDescriptor.getEJBClassName();
        }
        while (!interceptorClass.getName().equals(declaringClassName)) {
            if (interceptorClass.getName().equals("java.lang.Object")) {
                throw DeploymentException.invalidCallbackClass(beanDescriptor, interceptorBaseClass.getName(), declaringClassName, methodName);
            }
            interceptorClass = interceptorClass.getSuperclass();
        }
        Object args = !this.isBeanInterceptor() || callbackName == AROUND_INVOKE ? this.getInterceptorArgs(beanDescriptor) : null;
        Method method = ClassUtils.getMethod(interceptorClass, methodName, args);
        if (method == null) {
            throw DeploymentException.missingInterceptorMethod(beanDescriptor, interceptorBaseClass.getName(), methodName, !this.isBeanInterceptor() || callbackName == AROUND_INVOKE);
        }
        if (Modifier.isFinal(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) {
            throw DeploymentException.errorStaticOrFinalInterceptorMethod(beanDescriptor, interceptorClass.getName(), methodName);
        }
        method.setAccessible(true);
        return method;
    }

    private Object getInterceptorInstance() {
        return this.interceptorInstance;
    }

    private boolean isBeanInterceptor() {
        return !this.interceptorDescriptor.hasClassName();
    }

    private void configurePerBeanInterceptors(BeanDescriptor descriptor, InterceptorInstanceFactory factory) {
        this.usesSingletonInterceptors = descriptor.getInterceptorType() == "singleton" ? true : (descriptor.getInterceptorType() == "bean" ? false : !EJBUtils.classContainsStatefulFields(factory.interceptorClass));
    }

    protected boolean usesSingletonUserInterceptors() {
        return this.usesSingletonInterceptors;
    }

    protected List getInterceptors(byte methodType) {
        switch (methodType) {
            case 1: 
            case 13: {
                return this.getAroundInvokeInterceptors();
            }
            case 6: {
                return this.getPostConstructInterceptors();
            }
            case 8: {
                return this.getPreDestroyInterceptors();
            }
            case 9: {
                return this.getPostActivateInterceptors();
            }
            case 10: {
                return this.getPrePassivateInterceptors();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List getAroundInvokeInterceptors() {
        return this.aroundInvokeInterceptors;
    }

    private List getPostActivateInterceptors() {
        return this.postActivateInterceptors;
    }

    private List getPostConstructInterceptors() {
        return this.postConstructInterceptors;
    }

    private List getPreDestroyInterceptors() {
        return this.preDestroyInterceptors;
    }

    private List getPrePassivateInterceptors() {
        return this.prePassivateInterceptors;
    }

    public InterceptorDescriptor getInterceptorDescriptor() {
        return this.interceptorDescriptor;
    }

    public void resolveDependencies(AbstractEJBContext ctx, Context j2eeContext) throws InstantiationException {
        if (this.singletonInjectionComplete) {
            return;
        }
        if (this.usesSingletonUserInterceptors()) {
            this.dependencyManager.resolveDependencies(j2eeContext, this.getInterceptorInstance());
            this.singletonInjectionComplete = true;
        } else {
            this.dependencyManager.resolveDependencies(j2eeContext, ctx.getUserInterceptorInstances()[this.getIndex()]);
        }
    }

    private Class[] getInterceptorArgs(DiagnosticContext ctx) {
        if (interceptorArgs == null) {
            String className = "javax.interceptor.InvocationContext";
            if (!EJBUtils.isJdk50()) {
                throw EJBUtils.createEJBException(className + " requires jdk5");
            }
            interceptorArgs = new Class[]{this.lookupClass(ctx, className)};
        }
        return interceptorArgs;
    }

    private Interceptor createMethodBasedSingletonInterceptor(DiagnosticContext ctx, Method method, Object obj) {
        if (methodBasedSingletonInterceptorConstr == null) {
            methodBasedSingletonInterceptorConstr = this.buildConstructor(ctx, "com.evermind.server.ejb.interceptor.MethodBasedSingletonInterceptor", method, new Class[]{Method.class, Object.class});
        }
        Interceptor interceptor = null;
        try {
            interceptor = (Interceptor)methodBasedSingletonInterceptorConstr.newInstance(method, obj);
        }
        catch (Exception e) {
            throw EJBUtils.createEJBException(e);
        }
        return interceptor;
    }

    private Interceptor createMethodBasedDynamicInterceptor(DiagnosticContext ctx, Method method, int index) {
        if (methodBasedDynamicInterceptorConstr == null) {
            methodBasedDynamicInterceptorConstr = this.buildConstructor(ctx, "com.evermind.server.ejb.interceptor.MethodBasedDynamicInterceptor", method, new Class[]{Method.class, Integer.TYPE});
        }
        Interceptor interceptor = null;
        try {
            interceptor = (Interceptor)methodBasedDynamicInterceptorConstr.newInstance(method, new Integer(index));
        }
        catch (Exception e) {
            throw EJBUtils.createEJBException(e);
        }
        return interceptor;
    }

    private Class lookupClass(DiagnosticContext ctx, String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw EJBUtils.createEJBException(e);
        }
        return clazz;
    }

    private Constructor buildConstructor(DiagnosticContext ctx, String className, Method method, Class[] args) {
        Constructor constructor = null;
        try {
            constructor = this.lookupClass(ctx, className).getConstructor(args);
        }
        catch (NoSuchMethodException e) {
            throw EJBUtils.createEJBException(e);
        }
        return constructor;
    }

    class InterceptorInstanceFactory {
        private Class interceptorClass;
        private DiagnosticContext ctx;
        private Class outerClass;
        private Constructor interceptorConstructor;

        public InterceptorInstanceFactory(BeanDescriptor beanDescriptor) {
            this.ctx = beanDescriptor;
            this.interceptorClass = beanDescriptor.getEJBClass();
            if (!UserInterceptor.this.isBeanInterceptor()) {
                try {
                    this.interceptorClass = beanDescriptor.getPackage().getEJBClassLoader().loadClass(UserInterceptor.this.interceptorDescriptor.getInterceptorClassName());
                }
                catch (ClassNotFoundException e) {
                    throw DeploymentException.missingInterceptorClass(beanDescriptor, UserInterceptor.this.interceptorDescriptor.getInterceptorClassName(), e);
                }
                int innerClassIndex = UserInterceptor.this.interceptorDescriptor.getInterceptorClassName().indexOf(36);
                if (innerClassIndex != -1 && !Modifier.isStatic(this.interceptorClass.getModifiers())) {
                    try {
                        this.outerClass = beanDescriptor.getPackage().getEJBClassLoader().loadClass(UserInterceptor.this.interceptorDescriptor.getInterceptorClassName().substring(0, innerClassIndex));
                    }
                    catch (ClassNotFoundException e) {
                        throw DeploymentException.missingInterceptorClass(beanDescriptor, UserInterceptor.this.interceptorDescriptor.getInterceptorClassName().substring(0, innerClassIndex), e);
                    }
                    try {
                        this.interceptorConstructor = this.interceptorClass.getDeclaredConstructor(this.outerClass);
                    }
                    catch (Exception e) {
                        throw DeploymentException.errorInstantiatingInterceptor(beanDescriptor, UserInterceptor.this.interceptorDescriptor.getInterceptorClassName(), e);
                    }
                }
            }
        }

        public Object createInterceptorInstance() {
            if (this.outerClass != null) {
                try {
                    return this.interceptorConstructor.newInstance(this.outerClass.newInstance());
                }
                catch (Exception e) {
                    throw DeploymentException.errorInstantiatingInterceptor(this.ctx, UserInterceptor.this.interceptorDescriptor.getInterceptorClassName(), e);
                }
            }
            try {
                return this.interceptorClass.newInstance();
            }
            catch (Exception e) {
                throw DeploymentException.errorInstantiatingInterceptor(this.ctx, UserInterceptor.this.interceptorDescriptor.getInterceptorClassName(), e);
            }
        }
    }
}

