/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.logging;

import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EJBPackage;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class EJBMessages {
    protected static String buildMessagePrefix(String appName, String packageName, String beanName) {
        StringBuffer prefix = new StringBuffer("[");
        prefix.append(appName).append(":").append(packageName);
        if (beanName != null) {
            prefix.append(":").append(beanName);
        }
        return prefix.append("]").toString();
    }

    public static String getApplicationName(BeanDescriptor desc) {
        return desc.getPackage().getApplication().getName();
    }

    public static String getModuleName(BeanDescriptor desc) {
        return desc.getPackage().getName();
    }

    public static String getBeanName(BeanDescriptor desc) {
        return desc.getName();
    }

    public static String getApplicationName(EJBPackage pkg) {
        if (pkg.getApplication() != null) {
            return pkg.getApplication().getName();
        }
        return null;
    }

    public static String getModuleName(EJBPackage pkg) {
        return pkg.getName();
    }

    public static void logException(Logger logger, Level level, String message, Object[] params, Throwable t) {
        LogRecord lr = new LogRecord(level, message);
        lr.setParameters(params);
        lr.setThrown(t);
        lr.setLoggerName(logger.getName());
        lr.setResourceBundleName(logger.getResourceBundleName());
        lr.setResourceBundle(logger.getResourceBundle());
        logger.log(lr);
    }

    static {
        Logger logger = Logger.getLogger("oracle.j2ee.ejb");
    }
}

