/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.naming.ContextUtils;
import com.evermind.server.Application;
import com.evermind.server.deployment.ClientModule;
import com.evermind.server.deployment.EJBModule;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.persistence.PersistenceModule;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import oracle.classloader.PolicyClassLoader;

public class EARPersistenceModule
implements PersistenceModule {
    Application application;

    public EARPersistenceModule(Application packageDeployment) {
        this.application = packageDeployment;
    }

    public String getName() {
        return this.application.getName();
    }

    public String getPath() {
        return this.getName();
    }

    public String getRelativePersistenceUnitPath(URL persistenceUnitRoot) {
        String persistenceUnitRootString = persistenceUnitRoot.toString();
        return persistenceUnitRootString.substring(persistenceUnitRootString.lastIndexOf(this.getPath()) + this.getPath().length() + 1);
    }

    public List getPersistenceRoots() {
        ArrayList roots = new ArrayList();
        Context rootCtx = this.application.getConfig().getContext();
        if (rootCtx == null) {
            return roots;
        }
        try {
            Context libCtx;
            this.addPersistenceRoots(rootCtx, roots);
            File libFile = ContextUtils.getFile(rootCtx, "lib", true);
            if (libFile.exists() && (libCtx = ContextUtils.getContext(rootCtx, "lib", false)) != null) {
                this.addPersistenceRoots(libCtx, roots);
            }
        }
        catch (Exception e) {
            throw DeploymentException.exceptionGettingPersistenceUnitRoots(this.application.getName(), this.getContextId(), e);
        }
        return roots;
    }

    public PolicyClassLoader getClassLoader() {
        return (PolicyClassLoader)this.application.getClassLoader();
    }

    public String getDefaultDataSourceName() {
        return this.application.getDefaultDataSourceJNDILocation();
    }

    public Context getApplicationContext() {
        return this.application.getContext();
    }

    private void addPersistenceRoots(Context ctx, List roots) throws Exception {
        NamingEnumeration<NameClassPair> ctxEnum = ctx.list("");
        while (ctxEnum.hasMore()) {
            NameClassPair pair = ctxEnum.next();
            String name = pair.getName();
            if (!name.endsWith("jar") || this.application.getConfig().getEJBPackages().contains(new EJBModule(name)) || this.application.getConfig().getClients().contains(new ClientModule(name))) continue;
            roots.add(ContextUtils.getContext(ctx, name, false));
        }
    }

    public String getContextId() {
        return this.getPath();
    }

    public boolean isDeployed() {
        return !this.application.isFirstInitialization();
    }
}

