/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.proxy;

import com.evermind.server.ejb.proxy.ProxyClassLoader;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import javax.ejb.Handle;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Constants;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class ProxyGenerator
implements Constants {
    protected static int count = 0;
    private boolean remote;
    private boolean corba;
    private boolean home;
    private boolean staticMethodState = true;
    private boolean copyByValue = true;
    private Class parentClass;
    private String proxyClassName;
    private ArrayList proxyInterfaces = new ArrayList();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public ProxyGenerator(Class parentClass, Class proxyInterface) {
        this.setParentClass(parentClass);
        this.proxyInterfaces.add(proxyInterface);
    }

    public void setParentClass(Class parentClass) {
        this.parentClass = parentClass;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public void setCorba(boolean corba) {
        this.corba = corba;
    }

    public void setHome(boolean home) {
        this.home = home;
    }

    public void setStaticMethodState(boolean staticMethodState) {
        this.staticMethodState = staticMethodState;
    }

    public void setCopyByValue(boolean copyByValue) {
        this.copyByValue = copyByValue;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isCorba() {
        return this.corba;
    }

    public boolean isHome() {
        return this.home;
    }

    public boolean isStaticMethodState() {
        return this.staticMethodState;
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public Class getProxyInterface() {
        return (Class)this.proxyInterfaces.get(0);
    }

    public List getProxyInterfaces() {
        return this.proxyInterfaces;
    }

    public String getProxyClassName() {
        return this.proxyClassName;
    }

    public boolean isCopyByValue() {
        return this.copyByValue;
    }

    protected String generateProxyClassName() {
        String baseName = Type.getInternalName((Class)this.getProxyInterface());
        if (baseName.startsWith("java")) {
            baseName = baseName.substring(baseName.lastIndexOf(47) + 1);
        }
        return baseName + count++;
    }

    public Class generateProxy(ProxyClassLoader cl) {
        this.proxyClassName = this.generateProxyClassName();
        String[] interfaces = new String[this.proxyInterfaces.size()];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = Type.getInternalName((Class)((Class)this.proxyInterfaces.get(i)));
        }
        ClassWriter cw = new ClassWriter(true);
        cw.visit(46, 33, this.proxyClassName, Type.getInternalName((Class)this.parentClass), interfaces, null);
        this.generateConstructor((ClassVisitor)cw);
        HashSet<String> generatedMethods = new HashSet<String>();
        for (int i = 0; i < this.proxyInterfaces.size(); ++i) {
            Class proxyInterface = (Class)this.proxyInterfaces.get(i);
            Method[] methods = proxyInterface.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                String key;
                Method method = methods[j];
                if (Modifier.isStatic(method.getModifiers()) || method.getName().equals("<clinit>") || !this.shouldGenerateMethod(method) || generatedMethods.contains(key = method.getName() + Type.getMethodDescriptor((Method)method))) continue;
                this.generateMethodProxy(method, (ClassVisitor)cw);
                generatedMethods.add(key);
            }
        }
        this.afterGenerateMethods((ClassVisitor)cw);
        cw.visitEnd();
        byte[] classFile = cw.toByteArray();
        return cl.makeProxy(this.proxyClassName.replace('/', '.'), classFile, this.getProxyInterface().getProtectionDomain());
    }

    protected boolean shouldGenerateMethod(Method method) {
        return method.getDeclaringClass() != EJBLocalObject.class && method.getDeclaringClass() != EJBObject.class && method.getDeclaringClass() != EJBHome.class && method.getDeclaringClass() != EJBLocalHome.class;
    }

    protected void afterGenerateMethods(ClassVisitor cw) {
    }

    protected void generateConstructor(ClassVisitor cw) {
        CodeVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.getParentClass()), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    protected String generateMethodState(ClassVisitor cw, Method method) {
        String methodStateName = "methodState" + count++;
        int modifiers = 2;
        if (this.isStaticMethodState()) {
            modifiers += 8;
        }
        cw.visitField(modifiers, methodStateName, "Lcom/evermind/server/ejb/interceptor/MethodState;", null, null);
        return methodStateName;
    }

    protected void generateAccessMethodState(CodeVisitor mv, String methodStateName) {
        if (this.isStaticMethodState()) {
            mv.visitFieldInsn(178, this.proxyClassName, methodStateName, "Lcom/evermind/server/ejb/interceptor/MethodState;");
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.proxyClassName, methodStateName, "Lcom/evermind/server/ejb/interceptor/MethodState;");
        }
    }

    protected void generateMethodProxy(Method method, ClassVisitor cw) {
        Class[] params = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        int[] param_offsets = new int[params.length];
        if (params.length > 0) {
            param_offsets[0] = 1;
            for (int i = 1; i < params.length; ++i) {
                Type t = Type.getType(params[i - 1]);
                param_offsets[i] = param_offsets[i - 1] + t.getSize();
            }
        }
        int var_this = 0;
        int var_offset = 1;
        if (params.length > 0) {
            var_offset = param_offsets[params.length - 1] + Type.getType(params[params.length - 1]).getSize();
        }
        int var_threadState = var_offset++;
        int var_firstOnStack = var_offset++;
        int var_params = var_offset++;
        String methodStateName = this.generateMethodState(cw, method);
        Class<?>[] exceptions = method.getExceptionTypes();
        String[] exceptionNames = new String[exceptions.length];
        Label[] exceptionLabels = new Label[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptionNames[i] = Type.getInternalName(exceptions[i]);
        }
        CodeVisitor mv = cw.visitMethod(1, method.getName(), Type.getMethodDescriptor((Method)method), exceptionNames, null);
        this.generateInitMethodState(method, mv, methodStateName);
        mv.visitMethodInsn(184, "com/evermind/server/ThreadState", "getCurrentState", "()Lcom/evermind/server/ThreadState;");
        mv.visitVarInsn(58, var_threadState);
        mv.visitVarInsn(25, var_threadState);
        mv.visitMethodInsn(182, "com/evermind/server/ThreadState", "getAndReset_firstEJBOnStack", "()Z");
        mv.visitVarInsn(54, var_firstOnStack);
        int var_clone = 0;
        if (this.isRemote() && this.isCopyByValue()) {
            var_clone = var_offset++;
            this.generateCloneCheck(var_threadState, var_firstOnStack, mv, var_clone);
        }
        Label lbl_outer_try = new Label();
        mv.visitLabel(lbl_outer_try);
        mv.visitVarInsn(25, var_this);
        mv.visitVarInsn(25, var_threadState);
        mv.visitVarInsn(21, var_firstOnStack);
        mv.visitMethodInsn(182, this.proxyClassName, "OC4J_startCall", "(Lcom/evermind/server/ThreadState;Z)V");
        this.generateParameterArray(params, param_offsets, var_params, mv, var_clone);
        int var_return = 0;
        if (returnType != Void.TYPE) {
            var_return = var_offset++;
            var_offset = this.generateResponseVariable(returnType, var_offset, mv, var_return);
        }
        Label lbl_inner_try = new Label();
        mv.visitLabel(lbl_inner_try);
        mv.visitVarInsn(25, var_this);
        this.generateAccessMethodState(mv, methodStateName);
        mv.visitVarInsn(25, var_params);
        mv.visitVarInsn(25, var_threadState);
        mv.visitMethodInsn(182, this.proxyClassName, "OC4J_invokeMethod", "(Lcom/evermind/server/ejb/interceptor/MethodState;[Ljava/lang/Object;Lcom/evermind/server/ThreadState;)Ljava/lang/Object;");
        if (returnType == Void.TYPE) {
            mv.visitInsn(87);
        } else {
            this.generateStoreResponse(returnType, mv, var_return);
        }
        Label lbl_prepare_return = new Label();
        mv.visitJumpInsn(167, lbl_prepare_return);
        int var_exception = var_offset++;
        for (int i = 0; i < exceptions.length; ++i) {
            exceptionLabels[i] = new Label();
            mv.visitLabel(exceptionLabels[i]);
            mv.visitVarInsn(58, var_exception);
            mv.visitVarInsn(25, var_exception);
            mv.visitInsn(191);
        }
        Label lbl_inner_last_catch = new Label();
        mv.visitLabel(lbl_inner_last_catch);
        mv.visitVarInsn(58, var_exception);
        mv.visitVarInsn(25, var_this);
        mv.visitVarInsn(25, var_exception);
        mv.visitMethodInsn(182, this.proxyClassName, "OC4J_handleUncheckedException", "(Ljava/lang/Throwable;)V");
        mv.visitLabel(lbl_prepare_return);
        Label lbl_outer_finally = new Label();
        mv.visitJumpInsn(168, lbl_outer_finally);
        Label lbl_return = new Label();
        mv.visitLabel(lbl_return);
        if (returnType == Void.TYPE) {
            mv.visitInsn(177);
        } else if (returnType.isPrimitive() && !returnType.isArray()) {
            Type t = Type.getType(returnType);
            mv.visitVarInsn(t.getOpcode(21), var_return);
            mv.visitInsn(t.getOpcode(172));
        } else {
            mv.visitVarInsn(25, var_return);
            if (this.isRemote()) {
                if (this.shouldCloneReturnValue(method, returnType)) {
                    this.generateConditionalClone(mv, returnType, var_clone, var_return);
                }
                if (this.isCorba() && (EJBObject.class.isAssignableFrom(returnType) || EJBHome.class.isAssignableFrom(returnType))) {
                    this.generateTransportSpecificResponse(mv, var_return, returnType);
                }
            }
            mv.visitInsn(176);
        }
        Label lbl_outer_catch = new Label();
        mv.visitLabel(lbl_outer_catch);
        mv.visitVarInsn(58, var_exception);
        mv.visitJumpInsn(168, lbl_outer_finally);
        mv.visitVarInsn(25, var_exception);
        mv.visitInsn(191);
        mv.visitLabel(lbl_outer_finally);
        int var_jsr = var_offset++;
        mv.visitVarInsn(58, var_jsr);
        mv.visitVarInsn(25, var_this);
        mv.visitVarInsn(25, var_threadState);
        mv.visitVarInsn(21, var_firstOnStack);
        mv.visitMethodInsn(182, this.proxyClassName, "OC4J_endCall", "(Lcom/evermind/server/ThreadState;Z)V");
        mv.visitVarInsn(21, var_firstOnStack);
        Label lbl_if2 = new Label();
        mv.visitJumpInsn(153, lbl_if2);
        mv.visitVarInsn(25, var_threadState);
        mv.visitMethodInsn(182, "com/evermind/server/ThreadState", "set_firstEJBOnStack", "()V");
        mv.visitLabel(lbl_if2);
        mv.visitVarInsn(169, var_jsr);
        for (int i = 0; i < exceptionLabels.length; ++i) {
            mv.visitTryCatchBlock(lbl_inner_try, exceptionLabels[0], exceptionLabels[i], Type.getInternalName(exceptions[i]));
        }
        if (exceptionLabels.length > 0) {
            mv.visitTryCatchBlock(lbl_inner_try, exceptionLabels[0], lbl_inner_last_catch, "java/lang/Exception");
        } else {
            mv.visitTryCatchBlock(lbl_inner_try, lbl_inner_last_catch, lbl_inner_last_catch, "java/lang/Exception");
        }
        mv.visitTryCatchBlock(lbl_outer_try, lbl_outer_catch, lbl_outer_catch, null);
        mv.visitMaxs(0, 0);
    }

    protected void generateTransportSpecificResponse(CodeVisitor mv, int var_return, Class returnType) {
        Label l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(1);
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, var_return);
        mv.visitMethodInsn(182, this.proxyClassName, "OC4J_getTransportSpecificResponse", "(Ljava/lang/Object;)Ljava/lang/Object;");
        if (returnType != Object.class) {
            mv.visitTypeInsn(192, Type.getInternalName((Class)returnType));
        }
        mv.visitLabel(l1);
    }

    protected void generateStoreResponse(Class returnType, CodeVisitor mv, int var_return) {
        Type t = Type.getType((Class)returnType);
        if (returnType.isPrimitive() && !returnType.isArray()) {
            if (returnType == Integer.TYPE) {
                mv.visitTypeInsn(192, "java/lang/Integer");
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
            }
            if (returnType == Long.TYPE) {
                mv.visitTypeInsn(192, "java/lang/Long");
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
            }
            if (returnType == Byte.TYPE) {
                mv.visitTypeInsn(192, "java/lang/Byte");
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
            }
            if (returnType == Boolean.TYPE) {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            }
            if (returnType == Character.TYPE) {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
            }
            if (returnType == Short.TYPE) {
                mv.visitTypeInsn(192, "java/lang/Short");
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
            }
            if (returnType == Float.TYPE) {
                mv.visitTypeInsn(192, "java/lang/Float");
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
            }
            if (returnType == Double.TYPE) {
                mv.visitTypeInsn(192, "java/lang/Double");
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
            }
        } else {
            mv.visitTypeInsn(192, Type.getInternalName((Class)returnType));
        }
        mv.visitVarInsn(t.getOpcode(54), var_return);
    }

    protected void generateCloneCheck(int var_threadState, int var_firstOnStack, CodeVisitor mv, int var_clone) {
        mv.visitVarInsn(21, var_firstOnStack);
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitVarInsn(25, var_threadState);
        if (this.isCorba()) {
            mv.visitMethodInsn(182, "com/evermind/server/ThreadState", "isRMICall", "()Z");
        } else {
            mv.visitMethodInsn(182, "com/evermind/server/ThreadState", "isCallerORMI", "()Z");
        }
        mv.visitJumpInsn(153, l0);
        mv.visitInsn(3);
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(4);
        mv.visitLabel(l1);
        mv.visitVarInsn(54, var_clone);
    }

    protected int generateResponseVariable(Class returnType, int var_offset, CodeVisitor mv, int var_return) {
        Type t = Type.getType((Class)returnType);
        if (t.getSize() > 1) {
            ++var_offset;
        }
        if (returnType.isPrimitive()) {
            if (returnType == Integer.TYPE || returnType == Byte.TYPE || returnType == Boolean.TYPE || returnType == Character.TYPE || returnType == Short.TYPE) {
                mv.visitInsn(3);
            }
            if (returnType == Long.TYPE) {
                mv.visitInsn(9);
            }
            if (returnType == Float.TYPE) {
                mv.visitInsn(11);
            }
            if (returnType == Double.TYPE) {
                mv.visitInsn(14);
            }
        } else {
            mv.visitInsn(1);
        }
        mv.visitVarInsn(t.getOpcode(54), var_return);
        return var_offset;
    }

    protected void generateParameterArray(Class[] params, int[] param_offsets, int var_params, CodeVisitor mv, int var_clone) {
        if (params.length == 0) {
            mv.visitInsn(1);
            mv.visitTypeInsn(192, "[Ljava/lang/Object;");
            mv.visitVarInsn(58, var_params);
        } else {
            this.pushIntValue(mv, params.length);
            mv.visitTypeInsn(189, "java/lang/Object");
            for (int i = 0; i < params.length; ++i) {
                mv.visitInsn(89);
                this.pushIntValue(mv, i);
                Type t = Type.getType((Class)params[i]);
                mv.visitVarInsn(t.getOpcode(21), param_offsets[i]);
                if (params[i].isPrimitive() && !params[i].isArray()) {
                    Class wrapperType = null;
                    if (params[i] == Integer.TYPE) {
                        Class clazz = wrapperType = class$java$lang$Integer == null ? ProxyGenerator.class$("java.lang.Integer") : class$java$lang$Integer;
                    }
                    if (params[i] == Long.TYPE) {
                        Class clazz = wrapperType = class$java$lang$Long == null ? ProxyGenerator.class$("java.lang.Long") : class$java$lang$Long;
                    }
                    if (params[i] == Byte.TYPE) {
                        Class clazz = wrapperType = class$java$lang$Byte == null ? ProxyGenerator.class$("java.lang.Byte") : class$java$lang$Byte;
                    }
                    if (params[i] == Short.TYPE) {
                        Class clazz = wrapperType = class$java$lang$Short == null ? ProxyGenerator.class$("java.lang.Short") : class$java$lang$Short;
                    }
                    if (params[i] == Boolean.TYPE) {
                        Class clazz = wrapperType = class$java$lang$Boolean == null ? ProxyGenerator.class$("java.lang.Boolean") : class$java$lang$Boolean;
                    }
                    if (params[i] == Character.TYPE) {
                        Class clazz = wrapperType = class$java$lang$Character == null ? ProxyGenerator.class$("java.lang.Character") : class$java$lang$Character;
                    }
                    if (params[i] == Float.TYPE) {
                        Class clazz = wrapperType = class$java$lang$Float == null ? ProxyGenerator.class$("java.lang.Float") : class$java$lang$Float;
                    }
                    if (params[i] == Double.TYPE) {
                        wrapperType = class$java$lang$Double == null ? ProxyGenerator.class$("java.lang.Double") : class$java$lang$Double;
                    }
                    String methodDesc = Type.getMethodDescriptor((Type)Type.getType((Class)wrapperType), (Type[])new Type[]{Type.getType((Class)params[i])});
                    mv.visitMethodInsn(184, "com/evermind/server/ejb/PrimitiveTypeCache", "valueOf", methodDesc);
                } else if (this.isRemote() && this.shouldClone(params[i])) {
                    this.generateConditionalClone(mv, null, var_clone, param_offsets[i]);
                }
                mv.visitInsn(83);
            }
            mv.visitVarInsn(58, var_params);
        }
    }

    protected void pushIntValue(CodeVisitor mv, int value) {
        switch (value) {
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            case 5: {
                mv.visitInsn(8);
                break;
            }
            default: {
                mv.visitIntInsn(16, value);
            }
        }
    }

    protected boolean shouldCloneReturnValue(Method method, Class returnType) {
        return this.shouldClone(returnType);
    }

    protected boolean shouldClone(Class type) {
        if (!this.isCopyByValue()) {
            return false;
        }
        return Handle.class != type && !ClassUtils.getPrimitiveType(type).isPrimitive() && type != String.class && !EJBObject.class.isAssignableFrom(type) && !EntityContext.class.isAssignableFrom(type) && !EJBHome.class.isAssignableFrom(type) && !EJBLocalObject.class.isAssignableFrom(type) && !EJBLocalHome.class.isAssignableFrom(type) && !Remote.class.isAssignableFrom(type) && !UserTransaction.class.isAssignableFrom(type) && !Locale.class.isAssignableFrom(type) && !BigInteger.class.isAssignableFrom(type) && !InitialContext.class.isAssignableFrom(type);
    }

    protected void generateConditionalClone(CodeVisitor mv, Class returnType, int var_clone, int var_arg) {
        Label l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitVarInsn(25, var_arg);
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitVarInsn(21, var_clone);
        Label l2 = new Label();
        mv.visitJumpInsn(153, l2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, var_arg);
        mv.visitMethodInsn(182, this.proxyClassName, "OC4J_cloneParameter", "(Ljava/lang/Object;)Ljava/lang/Object;");
        if (returnType != null && returnType != Object.class) {
            mv.visitTypeInsn(192, Type.getInternalName((Class)returnType));
        }
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, var_arg);
        mv.visitLabel(l1);
    }

    protected void generateInitMethodState(Method method, CodeVisitor mv, String methodStateName) {
        String methodStateMethodName = method.getName() + ClassUtils.getCodedArguments(method);
        mv.visitFieldInsn(178, this.proxyClassName, methodStateName, "Lcom/evermind/server/ejb/interceptor/MethodState;");
        Label lbl_if1 = new Label();
        mv.visitJumpInsn(199, lbl_if1);
        mv.visitVarInsn(25, 0);
        if (this.isRemote()) {
            mv.visitInsn(3);
        } else {
            mv.visitInsn(4);
        }
        if (this.isHome()) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitLdcInsn((Object)methodStateMethodName);
        mv.visitMethodInsn(182, this.proxyClassName, "OC4J_getMethodState", "(ZZLjava/lang/String;)Lcom/evermind/server/ejb/interceptor/MethodState;");
        mv.visitFieldInsn(179, this.proxyClassName, methodStateName, "Lcom/evermind/server/ejb/interceptor/MethodState;");
        mv.visitLabel(lbl_if1);
    }
}

