/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.proxy;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.LocalStatefulSessionEJBObject;
import com.evermind.server.ejb.RemoteStatefulSessionEJBObject;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.proxy.ProxyGenerator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class StatefulProxyGenerator
extends ProxyGenerator {
    private SessionBeanDescriptor sd;

    public StatefulProxyGenerator(SessionBeanDescriptor sd, boolean local) {
        Class clazz = local ? LocalStatefulSessionEJBObject.class : RemoteStatefulSessionEJBObject.class;
        super(clazz, local ? sd.getLocalInterface() : sd.getRemoteInterface());
        this.sd = sd;
        this.setRemote(!local);
        this.setCopyByValue(sd.isCopyByValue());
        if (this.isRemote() && sd.getGenerateIIOP()) {
            this.setCorba(true);
        }
    }

    protected String generateProxyClassName() {
        return EJBUtils.getProxyName(this.sd, this.isRemote(), this.isHome());
    }

    protected void afterGenerateMethods(ClassVisitor cw) {
        this.generateStaticInitializer(cw);
    }

    private void generateStaticInitializer(ClassVisitor cw) {
        cw.visitField(24, "serialVersionUID", "J", null, null);
        CodeVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitLdcInsn((Object)this.getProxyClassName());
        mv.visitMethodInsn(184, "com/evermind/server/ApplicationServer", "computeSerialVersionUID", "(Ljava/lang/String;)J");
        mv.visitFieldInsn(179, this.getProxyClassName(), "serialVersionUID", "J");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    protected void generateConstructor(ClassVisitor cw) {
        super.generateConstructor(cw);
        CodeVisitor mv = cw.visitMethod(1, "<init>", "(Lcom/evermind/server/ejb/AbstractEJBHome;Lcom/evermind/server/ejb/StatefulSessionContext;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.getParentClass()), "<init>", "(Lcom/evermind/server/ejb/AbstractEJBHome;Lcom/evermind/server/ejb/StatefulSessionContext;)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv = cw.visitMethod(1, "<init>", "(Lcom/evermind/server/ejb/AbstractEJBHome;Lcom/evermind/server/ejb/StatefulSessionContext;JJLjava/lang/String;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(22, 3);
        mv.visitVarInsn(22, 5);
        mv.visitVarInsn(25, 7);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.getParentClass()), "<init>", "(Lcom/evermind/server/ejb/AbstractEJBHome;Lcom/evermind/server/ejb/StatefulSessionContext;JJLjava/lang/String;)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }
}

