/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.io.ChunkedInputStream;
import com.evermind.io.IOUtils;
import com.evermind.net.AddressContainer;
import com.evermind.security.User;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ThreadState;
import com.evermind.server.http.AJPHttpServletRequest;
import com.evermind.server.http.CookieValueCoder;
import com.evermind.server.http.EvermindFilterChain;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.EvermindServletInputStream;
import com.evermind.server.http.FileInformation;
import com.evermind.server.http.FileRequestDispatcher;
import com.evermind.server.http.FormHttpAuthenticator;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.http.HttpException;
import com.evermind.server.http.HttpIOException;
import com.evermind.server.http.HttpQueryParser;
import com.evermind.server.http.HttpRequestHandler;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.OC4JRequestDispatcher;
import com.evermind.server.http.ParameterMap;
import com.evermind.server.http.RuntimeFilterMapping;
import com.evermind.server.http.ServletRequestDispatcher;
import com.evermind.util.Base64Utils;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import com.evermind.util.ObjectUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.CertificateEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.SecurityUtil;

public class EvermindHttpServletRequest
implements HttpServletRequest,
AddressContainer {
    private static CertificateFactory certificateFactory;
    private static final int STATE_PROTOCOL = 0;
    private static final int STATE_HOST = 1;
    private static final int STATE_DONE = 2;
    private static final Integer INTEGER_200;
    public static final byte[] POST_RESPONSE;
    private static final String HEADER_SERVER_STRING;
    public static final byte[] HEADER_SERVER;
    static final byte[] ETAG_HEADER;
    static final byte[] IF_MODIFIED_SINCE_HEADER;
    static final byte[] IF_MATCH_HEADER;
    static final byte[] IF_NONE_MATCH_HEADER;
    static final byte[] IF_UNMODIFIED_SINCE_HEADER;
    static final byte[] IF_RANGE_HEADER;
    static final byte[] CONNECTION_HEADER;
    static final byte[] CONTENT_TYPE_HEADER;
    static final byte[] CONTENT_LENGTH_HEADER;
    static final byte[] COOKIE_HEADER;
    static final byte[] HOST_HEADER;
    static final byte[] AUTHORIZATION_HEADER;
    static final byte[] CONTENT_ENCODING_HEADER;
    static final byte[] ACCEPT_CHARSET_HEADER;
    static final byte[] ACCEPT_LANGUAGE_HEADER;
    static final byte[] CONTENT_RANGE_HEADER;
    static final byte[] RANGE_HEADER;
    static final byte[] REFERER_HEADER;
    static final byte[] ACCEPT_ENCODING_HEADER;
    static final byte[] TRANSFER_ENCODING_HEADER;
    static final ByteString SLASH_BYTESTRING;
    static final String CONNECTION_CLOSE = "close";
    static final String CONNECTION_KEEP_ALIVE = "Keep-Alive";
    private static final int READING_URI = 0;
    private static final int READING_QUERY = 1;
    private static final int READING_SESSION = 2;
    public static final boolean ENFORCE_MINIMUM_ID_LENGTH = true;
    private static ByteString CHUNKED;
    public static final byte INPUT_INPUTSTREAM = 1;
    public static final byte INPUT_READER = 2;
    private static final byte[] SESSION_ID;
    private static final byte[] SESSION_ID_UPPERCASE;
    public static final String AUTH_SESSION_ID = "ORA_OC4J_AuthSessionID";
    public static final String DEBUG_REQUEST_URI;
    public static final String DEBUG_REQUEST_QUERYSTRING;
    public static final boolean ENCODE_COOKIE;
    public static final boolean FORCE_USE_SESSION_COOKIE;
    public static boolean executeBreakpointMethods;
    private static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    private static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    private static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    private static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    private static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    private static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    private static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    private static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    private static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    private static final int MAX_PACKET_SIZE;
    HttpSite site;
    HttpApplication application;
    Socket socket;
    InputStream in;
    EvermindServletInputStream servletIn;
    BufferedReader servletInReader;
    InetAddress clientInetAddress;
    byte[] input = new byte[MAX_PACKET_SIZE];
    int headerLineLength;
    int headerLineRealLength;
    int headerStartPos;
    int contentLength;
    String contentType;
    ByteString hostHeader;
    ByteString hostHeaderPort;
    HashMap dynamicHeaders;
    byte inputFetchStatus;
    HttpApplication originalApplication;
    private ArrayList dispatcherChain = new ArrayList(1);
    private OC4JRequestDispatcher m_currentDispatcher = null;
    private boolean m_isDispatcherChainEmpty = true;
    private Cookie[] cookies;
    String method;
    public ByteString requestURI;
    ByteString defaultRequestURI = this.requestURI = new ByteString();
    ByteString resolvedRequestURI = null;
    private static Logger m_traceLogger;
    boolean isContextRootRemovedInURI = false;
    ByteString queryString;
    ByteString servletPath;
    ByteString pathInfo;
    String servletName;
    ByteString authType = null;
    ByteString jvmRoute = null;
    HashMap attributes;
    ParameterMap m_internalParameters = new ParameterMap(null);
    private ParameterMap formAuthParameters = null;
    protected boolean isPerformingFormAuth = false;
    User remoteUser;
    boolean remoteUserIsInitialized = false;
    public boolean requestedSessionFromCookie;
    boolean requestedSessionFromURL;
    EvermindHttpSession session;
    HttpSession externalSession;
    public Servlet currentPostFilterServlet;
    public FileRequestDispatcher currentPostFilterFile;
    public boolean currentFilePostFilterInclude;
    public int filterChainCacheCount = 0;
    public EvermindFilterChain[] filterChainCache;
    EvermindHttpServletResponse response;
    int inputStartPos;
    int inputEndPos;
    int sessionIDStart;
    int sessionIDEnd;
    protected Locale locale;
    protected String characterEncoding;
    protected boolean readPostedData = true;
    private boolean isPostedDataProcessed = false;
    boolean inApplicationContext = true;
    protected long startParseToken;
    protected long stopParseToken;
    protected boolean AJPRequest;
    private static final String HTTP_SCHEME = "http";
    private static final String HTTP_SECURE_SCHEME;
    private static final int HTTP_PORT = 80;
    private static final int HTTP_SECURE_PORT = 443;
    protected static SimpleDateFormat[] formats;
    Vector escapedOctetLocation;
    private boolean isJSPRequest;
    private static final Map locales;

    public void setResponse(EvermindHttpServletResponse response) {
        this.response = response;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        byte[] buffer = new byte[]{97};
        String dummy = new String(buffer, characterEncoding);
        this.characterEncoding = characterEncoding;
    }

    void preset(Socket socket) {
        this.socket = socket;
        this.clientInetAddress = this.socket != null ? socket.getInetAddress() : null;
    }

    void resetSocket() {
        this.preset(null);
    }

    public void reset() {
        this.requestURI = this.defaultRequestURI;
        this.resolvedRequestURI = null;
        this.site = null;
        this.in = null;
        this.dynamicHeaders = null;
        this.characterEncoding = null;
        this.sessionIDStart = 0;
        this.sessionIDEnd = 0;
        this.servletIn = null;
        this.servletInReader = null;
        this.headerLineLength = 0;
        this.headerLineRealLength = 0;
        this.headerStartPos = 0;
        this.contentLength = 0;
        this.contentType = null;
        this.hostHeader = null;
        this.hostHeaderPort = null;
        this.inputFetchStatus = 0;
        this.application = null;
        this.originalApplication = null;
        this.cookies = null;
        this.method = null;
        this.queryString = null;
        this.servletPath = null;
        this.pathInfo = null;
        this.servletName = null;
        this.attributes = null;
        this.dispatcherChain.clear();
        this.m_currentDispatcher = null;
        this.m_isDispatcherChainEmpty = true;
        this.m_internalParameters.reset(null);
        this.formAuthParameters = null;
        this.remoteUser = null;
        this.remoteUserIsInitialized = false;
        this.authType = null;
        this.jvmRoute = null;
        this.requestedSessionFromCookie = false;
        this.requestedSessionFromURL = false;
        this.session = null;
        this.externalSession = null;
        this.inputStartPos = 0;
        this.inputEndPos = 0;
        this.locale = null;
        this.readPostedData = true;
        this.isPostedDataProcessed = false;
        this.escapedOctetLocation = null;
        this.isContextRootRemovedInURI = false;
        this.isPerformingFormAuth = false;
        this.filterChainCacheCount = 0;
        this.filterChainCache = null;
        this.startParseToken = 0L;
        this.stopParseToken = 0L;
        this.currentPostFilterServlet = null;
        this.currentPostFilterFile = null;
        this.isJSPRequest = false;
    }

    private static int readChunk(InputStream in, byte[] input, int bytesRead, int bytePos, int max, boolean throwIfEnd) throws IOException, HttpException {
        while (bytesRead <= bytePos) {
            int readThisTurn = in.read(input, bytesRead, max - bytesRead);
            if (readThisTurn <= 0) {
                if (readThisTurn < 0) {
                    if (throwIfEnd) {
                        throw new HttpException(400, "Corrupt request, not properly terminated");
                    }
                    return -1;
                }
                if (bytesRead >= max) {
                    throw new HttpException(400, "Too long request header");
                }
            }
            bytesRead += readThisTurn;
        }
        return bytesRead;
    }

    boolean init(InputStream in, OutputStream out, HttpSite[] sites, int oldInputStartPos, int oldInputEndPos) throws HttpIOException, HttpException {
        try {
            byte[] input = this.input;
            int isReading = 0;
            try {
                int index;
                int i;
                int readThisTurn;
                if (oldInputStartPos < oldInputEndPos) {
                    readThisTurn = oldInputEndPos - oldInputStartPos;
                    if (oldInputStartPos != 0) {
                        System.arraycopy(input, oldInputStartPos, input, 0, readThisTurn);
                    }
                } else {
                    readThisTurn = in.read(input, 0, 2048);
                }
                if (readThisTurn < 0) {
                    return false;
                }
                if (HTTPProperties.getHttpDebug()) {
                    m_traceLogger.log(Level.FINE, new String(input, 0, readThisTurn));
                }
                if (sites[0].server.requestWriter != null) {
                    sites[0].server.requestWriter.println(new String(input, 0, readThisTurn));
                }
                int bytesRead = readThisTurn;
                this.in = in;
                int lineLengthPos = 0;
                int pos = 0;
                int bytePos = 0;
                if (bytesRead <= bytePos) {
                    if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos, MAX_PACKET_SIZE, false)) < 0) {
                        return false;
                    }
                }
                while (input[bytePos] == 13) {
                    if (bytesRead > (bytePos += 2)) continue;
                    if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos, MAX_PACKET_SIZE, false)) >= 0) continue;
                    return false;
                }
                while (bytesRead <= bytePos) {
                    if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos + 6, MAX_PACKET_SIZE, false)) >= 0) continue;
                    return false;
                }
                this.input = input;
                this.headerStartPos = bytePos;
                if (input[bytePos] == 71 && input[bytePos + 1] == 69 && input[bytePos + 2] == 84 && input[bytePos + 3] == 32) {
                    this.method = "GET";
                    bytePos += 4;
                } else if (input[bytePos] == 80 && input[bytePos + 1] == 85 && input[bytePos + 2] == 84) {
                    this.method = "PUT";
                    bytePos += 4;
                } else if (input[bytePos] == 80 && input[bytePos + 1] == 79 && input[bytePos + 2] == 83 && input[bytePos + 3] == 84) {
                    this.method = "POST";
                    bytePos += 5;
                } else {
                    byte[] chars = new byte[32];
                    int methodPos = 0;
                    while (input[bytePos + methodPos] != 32) {
                        chars[methodPos] = input[bytePos + methodPos];
                        if (methodPos++ == 31) {
                            throw new HttpException(400, "Request method too long");
                        }
                        if (bytesRead > bytePos + methodPos) continue;
                        if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos + methodPos, MAX_PACKET_SIZE, false)) >= 0) continue;
                        return false;
                    }
                    bytePos += methodPos + 1;
                    this.method = this.newISOString(chars, 0, methodPos);
                    if (this.method.equals("DELETE")) {
                        this.method = "DELETE";
                    } else if (this.method.equals("HEAD")) {
                        this.method = "HEAD";
                    } else if (this.method.equals("OPTIONS")) {
                        this.method = "OPTIONS";
                    } else if (this.method.equals("TRACE")) {
                        this.method = HTTPProperties.getHttpMethodTraceAllow() ? "TRACE" : "NONE";
                    } else if (this.method.equals("GET")) {
                        this.method = "GET";
                    } else if (this.method.equals("POST")) {
                        this.method = "POST";
                    } else if (this.method.equals("PUT")) {
                        this.method = "PUT";
                    }
                }
                if (bytesRead <= bytePos) {
                    if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos, MAX_PACKET_SIZE, false)) < 0) {
                        return false;
                    }
                }
                pos = bytePos;
                int startPos = pos++;
                if (input[bytePos++] != 47) {
                    if (bytesRead <= bytePos) {
                        if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos, MAX_PACKET_SIZE, false)) < 0) {
                            return false;
                        }
                    }
                    int state = 0;
                    int hostStart = 0;
                    while (input[bytePos] != 32) {
                        byte currentChar;
                        input[pos] = currentChar = input[bytePos];
                        switch (currentChar) {
                            case 58: {
                                if (state != 0) break;
                                state = 1;
                                hostStart = pos + 3;
                                if (input[++bytePos] != 47) {
                                    throw new HttpException(400, "Illegal URL");
                                }
                                ++pos;
                                if (input[++bytePos] != 47) {
                                    throw new HttpException(400, "Illegal URL");
                                }
                                ++pos;
                                break;
                            }
                            case 47: {
                                if (state != 1) {
                                    throw new HttpException(400, "Illegal URL");
                                }
                                ByteString hostString = new ByteString(input, hostStart, pos - hostStart);
                                this.parseHostHeader(hostString);
                                state = 2;
                            }
                        }
                        if (state == 2) break;
                        ++pos;
                        if (bytesRead > ++bytePos) continue;
                        if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos, MAX_PACKET_SIZE, false)) >= 0) continue;
                        return false;
                    }
                    if (state != 2) {
                        throw new HttpException(400, "Illegal URL");
                    }
                    startPos = pos = bytePos++;
                }
                ++pos;
                if (bytesRead <= bytePos) {
                    if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos, MAX_PACKET_SIZE, true)) < 0) {
                        return false;
                    }
                }
                boolean zeroDotNineRequest = false;
                while (input[bytePos] != 32) {
                    byte currentChar;
                    input[pos] = currentChar = input[bytePos];
                    switch (currentChar) {
                        case 63: {
                            if (isReading == 0) {
                                this.requestURI.data = input;
                                this.requestURI.offset = startPos;
                                this.requestURI.length = pos - startPos;
                                startPos = pos + 1;
                            } else if (isReading == 2) {
                                this.sessionIDStart = startPos + 1;
                                this.sessionIDEnd = pos;
                                startPos = pos + 1;
                            }
                            isReading = 1;
                            break;
                        }
                        case 47: {
                            if (isReading != 0) break;
                            if (pos > startPos && input[pos - 1] == 47) {
                                --pos;
                                break;
                            }
                            if (pos > startPos + 1 && input[pos - 1] == 46 && input[pos - 2] == 47) {
                                pos -= 2;
                                break;
                            }
                            if (pos <= startPos + 2 || input[pos - 1] != 46 || input[pos - 2] != 46 || input[pos - 3] != 47) break;
                            int prevSegmentStart = pos - 4;
                            if (prevSegmentStart <= startPos) {
                                throw new HttpException(400, "Invalid path");
                            }
                            while (prevSegmentStart >= startPos && input[prevSegmentStart] != 47) {
                                --prevSegmentStart;
                            }
                            if (prevSegmentStart > startPos) {
                                pos = prevSegmentStart;
                                break;
                            }
                            pos = startPos;
                            break;
                        }
                        case 10: {
                            System.arraycopy(input, bytePos, input, bytePos + 1, bytesRead - bytePos);
                            ++bytesRead;
                        }
                        case 13: {
                            input[bytePos--] = 32;
                            --pos;
                            zeroDotNineRequest = true;
                            break;
                        }
                        case 59: {
                            int k;
                            int j;
                            ByteString unparsedURI;
                            if (isReading == 1) break;
                            if (isReading == 0) {
                                String unparsedURIstr;
                                if (this instanceof AJPHttpServletRequest && (unparsedURIstr = ((AJPHttpServletRequest)this).getUnparsedURI()) != null) {
                                    unparsedURI = new ByteString(unparsedURIstr);
                                    if (pos - startPos < unparsedURI.length) {
                                        j = 0;
                                        k = 0;
                                        j = startPos;
                                        for (k = 0; j < pos && k < unparsedURI.length; ++j, ++k) {
                                            if (input[j] == unparsedURI.data[k] && (k >= unparsedURI.length - 2 || unparsedURI.data[k] != 37 || unparsedURI.data[k + 1] != 50 || unparsedURI.data[k + 2] != 53)) continue;
                                            k += 2;
                                        }
                                        if (k < unparsedURI.length && input[j] != unparsedURI.data[k]) break;
                                    }
                                }
                                this.requestURI.data = input;
                                this.requestURI.offset = startPos;
                                this.requestURI.length = pos - startPos;
                            }
                            isReading = 2;
                            startPos = pos;
                            if (this.sessionIDStart == 0 && this.isSessionID(input, startPos)) {
                                this.sessionIDStart = startPos + 1;
                                break;
                            }
                            if (this.sessionIDStart <= 0 || this.sessionIDEnd != 0) break;
                            this.sessionIDEnd = pos;
                            break;
                        }
                        case 37: {
                            String unparsedURIstr;
                            int k;
                            int j;
                            ByteString unparsedURI;
                            if (isReading != 0) break;
                            if (this instanceof AJPHttpServletRequest && (unparsedURIstr = ((AJPHttpServletRequest)this).getUnparsedURI()) != null) {
                                unparsedURI = new ByteString(unparsedURIstr);
                                if (pos - startPos < unparsedURI.length) {
                                    j = startPos;
                                    for (k = 0; j < pos && k < unparsedURI.length; ++j, ++k) {
                                        if (input[j] == unparsedURI.data[k] && (k >= unparsedURI.length - 2 || unparsedURI.data[k] != 37 || unparsedURI.data[k + 1] != 50 || unparsedURI.data[k + 2] != 53)) continue;
                                        k += 2;
                                    }
                                    if (k < unparsedURI.length - 2 && unparsedURI.data[k] == 37 && unparsedURI.data[k + 1] == 50 && unparsedURI.data[k + 2] == 53) break;
                                }
                            }
                            if (bytesRead <= ++bytePos) {
                                if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos, MAX_PACKET_SIZE, true)) < 0) {
                                    return false;
                                }
                            }
                            if ((i = input[bytePos]) != 117) {
                                int highBits;
                                if (i >= 48 && i <= 57) {
                                    highBits = (i - 48) * 16;
                                } else if (i >= 97 && i <= 102) {
                                    highBits = (i + 10 - 97) * 16;
                                } else if (i >= 65 && i <= 70) {
                                    highBits = (i + 10 - 65) * 16;
                                } else {
                                    --bytePos;
                                    break;
                                }
                                if (bytesRead <= ++bytePos) {
                                    if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos, MAX_PACKET_SIZE, true)) < 0) {
                                        return false;
                                    }
                                }
                                if ((i = input[bytePos]) >= 48 && i <= 57) {
                                    input[pos] = (byte)(highBits + (i - 48));
                                } else if (i >= 97 && i <= 102) {
                                    input[pos] = (byte)(highBits + (i + 10 - 97));
                                } else if (i >= 65 && i <= 70) {
                                    input[pos] = (byte)(highBits + (i + 10 - 65));
                                    highBits = input[pos];
                                } else {
                                    bytePos -= 2;
                                    break;
                                }
                                if (this.escapedOctetLocation == null) {
                                    this.escapedOctetLocation = new Vector();
                                }
                                this.escapedOctetLocation.add(new Integer(pos));
                            }
                            if (input[pos] == 0 && isReading == 0) {
                                throw new HttpException(400, "Invalid path");
                            }
                            currentChar = input[pos];
                            break;
                        }
                    }
                    ++pos;
                    if (bytesRead > ++bytePos) continue;
                    if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos, MAX_PACKET_SIZE, true)) >= 0) continue;
                    return false;
                }
                switch (isReading) {
                    case 0: {
                        this.requestURI.data = input;
                        this.requestURI.offset = startPos;
                        this.requestURI.length = pos - startPos;
                        break;
                    }
                    case 1: {
                        this.queryString = new ByteString(input, startPos, pos - startPos);
                        break;
                    }
                    case 2: {
                        if (this.sessionIDStart > 0) {
                            this.sessionIDEnd = this.sessionIDEnd == 0 ? pos : this.sessionIDEnd;
                            break;
                        }
                        if (!this.isSessionID(input, startPos)) break;
                        this.sessionIDStart = startPos + 1;
                        this.sessionIDEnd = pos;
                    }
                }
                if (this.requestURI.length > 1 && this.requestURI.data[index = this.requestURI.offset + this.requestURI.length - 1] == 46 && --index >= 0) {
                    if (this.requestURI.data[index] == 47) {
                        --this.requestURI.length;
                    } else if (this.requestURI.data[index] == 46 && --index >= 0 && this.requestURI.data[index] == 47) {
                        if (index == this.requestURI.offset) {
                            throw new HttpException(400, "Invalid path");
                        }
                        --index;
                        while (index >= this.requestURI.offset && this.requestURI.data[index] != 47) {
                            --index;
                        }
                        this.requestURI.length = index > this.requestURI.offset ? index - this.requestURI.offset + 1 : 1;
                    }
                }
                if (!zeroDotNineRequest) {
                    bytePos += 9;
                    this.headerLineRealLength = pos + 9;
                } else {
                    bytePos += 2;
                    this.headerLineRealLength = pos + 2;
                }
                this.headerLineLength = bytePos;
                lineLengthPos = bytePos;
                bytePos += 2;
                boolean beforeColon = true;
                while (true) {
                    if (bytesRead <= bytePos) {
                        while (bytesRead <= bytePos) {
                            if (bytesRead >= input.length - 1) {
                                if (bytesRead > sites[0].requestMaxSize) {
                                    throw new HttpException(413, null);
                                }
                                byte[] smallInput = input;
                                input = this.input = new byte[smallInput.length * 2];
                                System.arraycopy(smallInput, 0, input, 0, smallInput.length);
                            }
                            if ((readThisTurn = in.read(input, bytesRead, input.length - 1 - bytesRead)) < 0) {
                                throw new HttpException(400, "Not properly terminated");
                            }
                            bytesRead += readThisTurn;
                        }
                    }
                    i = input[bytePos];
                    if (beforeColon) {
                        if (i >= 65 && i <= 90) {
                            int n = bytePos;
                            input[n] = (byte)(input[n] - -32);
                        } else if (i == 58) {
                            beforeColon = false;
                        }
                    }
                    if (i == 10) {
                        if (++bytesRead >= input.length - 1) {
                            if (bytesRead > sites[0].requestMaxSize) {
                                throw new HttpException(413, null);
                            }
                            byte[] smallInput = input;
                            input = this.input = new byte[smallInput.length * 2];
                            System.arraycopy(smallInput, 0, input, 0, smallInput.length);
                        }
                        System.arraycopy(input, bytePos, input, bytePos + 1, bytesRead - bytePos);
                        i = 13;
                    }
                    if (i == 13) {
                        if (bytePos == lineLengthPos + 2) {
                            input[lineLengthPos] = 0;
                            input[lineLengthPos + 1] = 0;
                            if ((bytePos += 2) <= bytesRead) break;
                            if ((bytesRead = EvermindHttpServletRequest.readChunk(in, input, bytesRead, bytePos - 1, input.length, true)) >= 0) break;
                            return false;
                        }
                        beforeColon = true;
                        input[lineLengthPos] = (byte)(bytePos - lineLengthPos);
                        input[lineLengthPos + 1] = (byte)((bytePos - lineLengthPos) / 256);
                        lineLengthPos = bytePos++;
                    }
                    if (++bytePos < input.length) continue;
                    if (input.length > 8096) {
                        throw new HttpException(413, null);
                    }
                    byte[] oldArray = input;
                    input = this.input = new byte[oldArray.length * 2];
                    System.arraycopy(oldArray, 0, input, 0, oldArray.length);
                }
                if (this.sendPostContinue() && this.method == "POST" && (input[this.headerLineLength - 3] - 48) * 10 + (input[this.headerLineLength - 1] - 48) >= 11) {
                    byte[] dateHeader = HttpDateFormat.getDateHeader();
                    byte[] responseData = new byte[POST_RESPONSE.length + HEADER_SERVER.length + dateHeader.length + 2];
                    int responsePos = 0;
                    System.arraycopy(POST_RESPONSE, 0, responseData, 0, POST_RESPONSE.length);
                    System.arraycopy(HEADER_SERVER, 0, responseData, responsePos += POST_RESPONSE.length, HEADER_SERVER.length);
                    System.arraycopy(dateHeader, 0, responseData, responsePos += HEADER_SERVER.length, dateHeader.length);
                    responsePos += dateHeader.length;
                    responseData[responsePos++] = 13;
                    responseData[responsePos++] = 10;
                    out.write(responseData);
                    out.flush();
                }
                this.inputStartPos = bytePos;
                this.inputEndPos = bytesRead;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new HttpException(413, null);
            }
        }
        catch (IOException e) {
            return false;
        }
        ByteString localHostHeader = null;
        if (sites.length > 1) {
            for (int x = 0; x < sites.length; ++x) {
                if (sites[x].hostNameHeader != null) {
                    if (localHostHeader == null && (localHostHeader = this.getHostnameHeader()) == null) continue;
                    boolean containedName = false;
                    for (int y = 0; y < sites[x].hostNameHeader.length; ++y) {
                        if (!sites[x].hostNameHeader[y].equalsIgnoreCase(localHostHeader)) continue;
                        containedName = true;
                        break;
                    }
                    if (!containedName) continue;
                }
                if (sites[x].particularAddress != null && !sites[x].particularAddress.equals(this.socket.getLocalAddress())) continue;
                this.site = sites[x];
                break;
            }
        } else {
            this.site = sites[0];
        }
        if (DEBUG_REQUEST_URI != null && this.requestURI.toString().equalsIgnoreCase(DEBUG_REQUEST_URI)) {
            if (DEBUG_REQUEST_QUERYSTRING != null) {
                if (this.queryString.toString().equalsIgnoreCase(DEBUG_REQUEST_QUERYSTRING)) {
                    executeBreakpointMethods = true;
                }
            } else {
                executeBreakpointMethods = true;
            }
        }
        return true;
    }

    private boolean isSessionID(byte[] input, int startPos) {
        boolean isSessionID = true;
        for (int x = 0; x < SESSION_ID.length; ++x) {
            if (input[startPos + (x + 1)] == SESSION_ID[x] || input[startPos + (x + 1)] == SESSION_ID_UPPERCASE[x]) continue;
            isSessionID = false;
            break;
        }
        return isSessionID;
    }

    protected String newISOString(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            if (HTTPProperties.getHttpErrorDebug()) {
                m_traceLogger.log(Level.FINE, "Encoding Warning:", ex);
            }
            return new String(bytes, offset, len);
        }
    }

    public String getHeader(String name) {
        String value;
        if (this.dynamicHeaders != null && (value = (String)this.dynamicHeaders.get(name.toUpperCase())) != null) {
            if (value == "<reset-header>") {
                return null;
            }
            return value;
        }
        int stringLength = name.length();
        byte[] byteArray = new byte[stringLength + 1];
        for (int i = 0; i < stringLength; ++i) {
            byteArray[i] = ObjectUtils.toByte(name.charAt(i));
            if (byteArray[i] < 65 || byteArray[i] > 90) continue;
            int n = i;
            byteArray[n] = (byte)(byteArray[n] - -32);
        }
        byteArray[stringLength] = 58;
        return this.getHeader(byteArray);
    }

    public Enumeration getHeaders(String name) {
        int stringLength = name.length();
        byte[] byteArray = new byte[stringLength + 1];
        for (int i = 0; i < stringLength; ++i) {
            byteArray[i] = ObjectUtils.toByte(name.charAt(i));
            if (byteArray[i] < 65 || byteArray[i] > 90) continue;
            int n = i;
            byteArray[n] = (byte)(byteArray[n] - -32);
        }
        byteArray[stringLength] = 58;
        return this.getHeaders(byteArray);
    }

    public long getDateHeader(String name) {
        int stringLength = name.length();
        byte[] byteArray = new byte[stringLength + 1];
        for (int i = 0; i < stringLength; ++i) {
            byteArray[i] = ObjectUtils.toByte(name.charAt(i));
            if (byteArray[i] < 65 || byteArray[i] > 90) continue;
            int n = i;
            byteArray[n] = (byte)(byteArray[n] - -32);
        }
        byteArray[stringLength] = 58;
        return this.getDateHeader(byteArray);
    }

    public Enumeration getHeaders(byte[] name) {
        ArrayList<String> values = null;
        try {
            int lineStart = this.headerLineLength;
            int pos = lineStart + 2;
            int stringLength = name.length;
            byte[] input = this.input;
            while (true) {
                int lineLength;
                if ((lineLength = ((char)input[lineStart] & 0xFF) + input[lineStart + 1] * 256) == 0) {
                    if (values == null) {
                        return Collections.enumeration(Collections.EMPTY_SET);
                    }
                    return Collections.enumeration(values);
                }
                if (lineLength > stringLength) {
                    while (input[pos] == name[pos - lineStart - 2]) {
                        if (++pos - lineStart - 2 != stringLength) continue;
                        while (input[pos] == 32) {
                            ++pos;
                        }
                        int headerValueLength = lineStart + lineLength - pos;
                        if (headerValueLength < 0) {
                            headerValueLength = 0;
                        }
                        if (values == null) {
                            values = new ArrayList<String>();
                        }
                        values.add(this.newISOString(input, pos, headerValueLength));
                        break;
                    }
                }
                pos = (lineStart += lineLength) + 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (values == null) {
                return Collections.enumeration(Collections.EMPTY_SET);
            }
            return Collections.enumeration(values);
        }
    }

    public String getHeader(byte[] name) {
        try {
            int lineStart = this.headerLineLength;
            int pos = lineStart + 2;
            int stringLength = name.length;
            byte[] input = this.input;
            while (true) {
                int lineLength;
                if ((lineLength = ((char)input[lineStart] & 0xFF) + input[lineStart + 1] * 256) == 0) {
                    return null;
                }
                if (lineLength > stringLength) {
                    while (input[pos] == name[pos - lineStart - 2]) {
                        int headerValueLength;
                        if (++pos - lineStart - 2 != stringLength) continue;
                        while (input[pos] == 32) {
                            ++pos;
                        }
                        for (headerValueLength = lineStart + lineLength - pos; headerValueLength > 0 && input[pos + headerValueLength - 1] == 32; --headerValueLength) {
                        }
                        if (headerValueLength < 0) {
                            headerValueLength = 0;
                        }
                        return this.newISOString(input, pos, headerValueLength);
                    }
                }
                pos = (lineStart += lineLength) + 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public ByteString getByteHeader(byte[] name) {
        try {
            int lineStart = this.headerLineLength;
            int pos = lineStart + 2;
            int stringLength = name.length;
            byte[] input = this.input;
            while (true) {
                int lineLength;
                if ((lineLength = ((char)input[lineStart] & 0xFF) + input[lineStart + 1] * 256) == 0) {
                    return null;
                }
                if (lineLength > stringLength) {
                    while (input[pos] == name[pos - lineStart - 2]) {
                        if (++pos - lineStart - 2 != stringLength) continue;
                        while (input[pos] == 32) {
                            ++pos;
                        }
                        int headerValueLength = lineStart + lineLength - pos;
                        if (headerValueLength < 0) {
                            headerValueLength = 0;
                        }
                        return new ByteString(input, pos, headerValueLength);
                    }
                }
                pos = (lineStart += lineLength) + 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public long getDateHeader(byte[] name) {
        String value = this.getHeader(name);
        if (value != null) {
            if (formats == null) {
                this.initHttpDateFormats();
            }
            for (int i = 0; i < formats.length; ++i) {
                try {
                    return formats[i].parse(value).getTime();
                }
                catch (ParseException e) {
                    continue;
                }
            }
            throw new IllegalArgumentException("Invalid date format: " + value);
        }
        return -1L;
    }

    String getInternalParameter(String name) {
        return this.m_internalParameters.getFirstValue(name);
    }

    ParameterMap parseFormAuthParameters() {
        try {
            this.m_internalParameters.reset(null);
            String _charset = this.getInternalCharacterEncoding();
            HttpQueryParser.parseQueryString(this.m_internalParameters, this, this.queryString, _charset);
            ByteString postBody = this.getFormPostBody();
            HttpQueryParser.parseQueryString(this.m_internalParameters, this, postBody, _charset);
            String j_charset = this.m_internalParameters.getFirstValue("j_character_encoding");
            if (j_charset != null && !j_charset.equalsIgnoreCase(_charset)) {
                this.m_internalParameters.reset(null);
                HttpQueryParser.parseQueryString(this.m_internalParameters, this, this.queryString, j_charset);
                HttpQueryParser.parseQueryString(this.m_internalParameters, this, postBody, j_charset);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UnsupportedEncodingException: " + e.getMessage());
        }
        catch (IOException e2) {
            throw new IllegalStateException("IOException: " + e2.getMessage());
        }
        return this.m_internalParameters;
    }

    ParameterMap getParameters() throws IOException {
        if (this.isPerformingFormAuth) {
            return this.m_internalParameters;
        }
        OC4JRequestDispatcher currentDispatcher = this.getCurrentDispatcher();
        if (currentDispatcher.isParametersParsed()) {
            return currentDispatcher.getParameters();
        }
        return this.parseParameters();
    }

    ParameterMap parseParameters() throws IOException {
        OC4JRequestDispatcher dispatcher = this.getCurrentDispatcher();
        ParameterMap paramMap = null;
        if (!dispatcher.isParametersParsed()) {
            OC4JRequestDispatcher prevDispatcher = null;
            for (int i = 0; i < this.dispatcherChain.size(); ++i) {
                dispatcher = (OC4JRequestDispatcher)this.dispatcherChain.get(i);
                if (!dispatcher.isParametersParsed()) {
                    if (i == 0) {
                        paramMap = dispatcher.getParameters().reset(null);
                        HttpQueryParser.parseQueryString(paramMap, this, dispatcher.getQueryString());
                        HttpQueryParser.parsePostBody(paramMap, this);
                    } else {
                        paramMap = dispatcher.getParameters().reset(prevDispatcher.getParameters());
                        HttpQueryParser.parseQueryString(paramMap, this, dispatcher.getQueryString());
                    }
                    dispatcher.setParametersParsed(true);
                }
                prevDispatcher = dispatcher;
            }
        } else {
            paramMap = dispatcher.getParameters();
        }
        return paramMap;
    }

    ParameterMap parseParametersFromRequest() throws IOException {
        this.m_internalParameters.reset(null);
        HttpQueryParser.parseQueryString(this.m_internalParameters, this, this.queryString);
        HttpQueryParser.parsePostBody(this.m_internalParameters, this);
        return this.m_internalParameters;
    }

    void unsetInternalParameters() {
        this.m_internalParameters = new ParameterMap(null);
    }

    Map getImmutableParameters() throws IOException {
        return this.getParameters().getUnmodifiableMap();
    }

    public Map getParameterMap() {
        try {
            return this.getImmutableParameters();
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException: " + e.getMessage());
        }
    }

    public boolean containsHeader(byte[] name) {
        try {
            int lineStart = this.headerLineLength + 2;
            int pos = 0;
            int stringLength = name.length;
            byte[] input = this.input;
            int lineLength = this.headerLineLength;
            try {
                while (true) {
                    block11: {
                        if ((lineLength = ((char)input[lineStart - 2] & 0xFF) + input[lineStart - 1] * 256 - 2) < 0) {
                            return false;
                        }
                        if (lineLength == stringLength && input[pos + lineStart] == name[pos]) {
                            if (++pos == stringLength) {
                                return true;
                            }
                            do {
                                byte b;
                                if (input[pos + lineStart] == name[pos]) continue;
                                byte a = input[pos + lineStart];
                                if (a >= 65 && a <= 90) {
                                    a = (byte)(a + 32);
                                }
                                if ((b = name[pos]) >= 65 && b <= 90) {
                                    b = (byte)(b + 32);
                                }
                                if (a != b) break block11;
                            } while (++pos != stringLength);
                            return true;
                        }
                    }
                    lineStart += lineLength + 2;
                    pos = 0;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public String getScheme() {
        return this.isSecure() ? HTTP_SECURE_SCHEME : HTTP_SCHEME;
    }

    public int getServerPort() {
        if (!HTTPProperties.getUseCanonicalName() && this.getHostnameHeader() != null) {
            if (this.getHostHeaderPort() != null) {
                return this.hostHeaderPort.getInt();
            }
            return this.isSecure() ? 443 : 80;
        }
        return this.site.posingAsPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cookie[] getCookies() {
        if (this.cookies == null) {
            Enumeration cookieHeaders = this.getHeaders(COOKIE_HEADER);
            if (!cookieHeaders.hasMoreElements()) {
                return null;
            }
            String cookieHeader = null;
            int nr = 0;
            Cookie[] collectCookies = new Cookie[30];
            while (cookieHeaders.hasMoreElements()) {
                Object var20_20;
                cookieHeader = (String)cookieHeaders.nextElement();
                try {
                    try {
                        int oldPos = 0;
                        int pos = 0;
                        int headerLength = cookieHeader.length();
                        Cookie cookie = null;
                        boolean defaultSecure = false;
                        String defaultComment = null;
                        int defaultMaxAge = 0;
                        String defaultDomain = null;
                        String defaultPath = null;
                        int defaultVersion = 0;
                        while (pos < headerLength) {
                            String cookieValue = null;
                            char currentChar = cookieHeader.charAt(pos);
                            while (currentChar == ';' || currentChar == ' ' || currentChar == ',') {
                                currentChar = cookieHeader.charAt(++pos);
                            }
                            oldPos = pos;
                            while (pos < headerLength && (currentChar = cookieHeader.charAt(pos)) != ' ' && currentChar != '=' && currentChar != '\"') {
                                if (currentChar == ';' || currentChar == ',') {
                                    cookieValue = "";
                                    break;
                                }
                                ++pos;
                            }
                            if (pos == headerLength) {
                                cookieValue = "";
                            }
                            String cookieName = cookieHeader.substring(oldPos, pos);
                            oldPos = ++pos;
                            if (cookieName.equalsIgnoreCase("$Secure")) {
                                if (cookie != null) {
                                    cookie.setSecure(true);
                                    continue;
                                }
                                defaultSecure = true;
                                continue;
                            }
                            if (cookieValue == null) {
                                if (pos < headerLength) {
                                    currentChar = cookieHeader.charAt(pos);
                                }
                                if (currentChar == '\"') {
                                    while (cookieHeader.charAt(++pos) != '\"') {
                                    }
                                    cookieValue = cookieHeader.substring(oldPos + 1, pos);
                                    while (++pos < headerLength && ((currentChar = cookieHeader.charAt(pos)) == '\"' || currentChar == ';' || currentChar == ',')) {
                                    }
                                } else {
                                    while (pos < headerLength && cookieHeader.charAt(pos) != ';' && cookieHeader.charAt(pos) != ',') {
                                        ++pos;
                                    }
                                    cookieValue = cookieHeader.substring(oldPos, pos);
                                }
                            }
                            if (cookieName.charAt(0) == '$') {
                                CookieValueCoder cvc = CookieValueCoder.defaultInstance();
                                if (ENCODE_COOKIE && cvc.isOc4jEncodedName(cookieName)) {
                                    cookieName = cvc.originalName(cookieName);
                                    cookieValue = cvc.decode(cookieValue);
                                } else {
                                    if (cookieName.equalsIgnoreCase("$Comment")) {
                                        if (cookie != null) {
                                            cookie.setComment(cookieValue);
                                            continue;
                                        }
                                        defaultComment = cookieValue;
                                        continue;
                                    }
                                    if (cookieName.equalsIgnoreCase("$Max-Age")) {
                                        if (cookie != null) {
                                            cookie.setMaxAge(Integer.parseInt(cookieValue));
                                            continue;
                                        }
                                        defaultMaxAge = Integer.parseInt(cookieValue);
                                        continue;
                                    }
                                    if (cookieName.equalsIgnoreCase("$Domain")) {
                                        if (cookie != null) {
                                            cookie.setDomain(cookieValue);
                                            continue;
                                        }
                                        defaultDomain = cookieValue;
                                        continue;
                                    }
                                    if (cookieName.equalsIgnoreCase("$Path")) {
                                        if (cookie != null) {
                                            cookie.setPath(cookieValue);
                                            continue;
                                        }
                                        defaultPath = cookieValue;
                                        continue;
                                    }
                                    if (!cookieName.equalsIgnoreCase("$Version")) continue;
                                    if (cookie != null) {
                                        cookie.setVersion(Integer.parseInt(cookieValue));
                                        continue;
                                    }
                                    defaultVersion = Integer.parseInt(cookieValue);
                                    continue;
                                }
                            }
                            cookie = new Cookie(cookieName, cookieValue);
                            if (nr >= collectCookies.length) {
                                Cookie[] newCookies = new Cookie[collectCookies.length * 2];
                                System.arraycopy(collectCookies, 0, newCookies, 0, nr);
                                collectCookies = newCookies;
                            }
                            collectCookies[nr++] = cookie;
                            if (defaultSecure) {
                                cookie.setSecure(true);
                            }
                            if (defaultComment != null) {
                                cookie.setComment(defaultComment);
                            }
                            if (defaultMaxAge != 0) {
                                cookie.setMaxAge(defaultMaxAge);
                            }
                            if (defaultDomain != null) {
                                cookie.setDomain(defaultDomain);
                            }
                            if (defaultPath != null) {
                                cookie.setPath(defaultPath);
                            }
                            if (defaultVersion == 0) continue;
                            cookie.setVersion(defaultVersion);
                        }
                        var20_20 = null;
                    }
                    catch (Exception e) {
                        var20_20 = null;
                        this.cookies = new Cookie[nr];
                        System.arraycopy(collectCookies, 0, this.cookies, 0, nr);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var20_20 = null;
                    this.cookies = new Cookie[nr];
                    System.arraycopy(collectCookies, 0, this.cookies, 0, nr);
                    throw throwable;
                }
                this.cookies = new Cookie[nr];
                System.arraycopy(collectCookies, 0, this.cookies, 0, nr);
            }
        }
        return this.cookies;
    }

    public String getRequestURI() {
        ByteString uri = this.requestURI;
        int originalOffset = this.requestURI.offset;
        int originalLength = this.requestURI.length;
        HttpApplication app = this.originalApplication;
        if (app == null) {
            app = this.application;
        }
        if (this.isContextRootRemovedInURI && this.isDirectCall() && app.root != null && this.inApplicationContext) {
            uri.offset -= app.root.length;
            uri.length += app.root.length;
        }
        int start = uri.offset;
        int end = uri.offset + uri.length;
        byte[] data = uri.data;
        if (this.escapedOctetLocation != null && this.isDirectCall()) {
            ByteString newURI = new ByteString(uri.length * 3);
            int newURIPos = 0;
            int _numEscapedOctet = this.escapedOctetLocation.size();
            int _locEscapedOctet = (Integer)this.escapedOctetLocation.elementAt(0);
            int j = 0;
            for (int i = start; i < end; ++i) {
                if (i == _locEscapedOctet) {
                    if (++j < _numEscapedOctet) {
                        _locEscapedOctet = (Integer)this.escapedOctetLocation.elementAt(j);
                    }
                    int higher = ((char)data[i] & 0xF0) >> 4;
                    int lower = data[i] & 0xF;
                    newURI.data[newURIPos++] = 37;
                    newURI.data[newURIPos++] = higher >= 10 ? (byte)(higher - 10 + 97) : (byte)(higher + 48);
                    if (lower >= 10) {
                        newURI.data[newURIPos++] = (byte)(lower - 10 + 97);
                        continue;
                    }
                    newURI.data[newURIPos++] = (byte)(lower + 48);
                    continue;
                }
                newURI.data[newURIPos++] = data[i];
            }
            newURI.length = newURIPos;
            uri = newURI;
        } else {
            uri = (ByteString)uri.clone();
        }
        if (originalOffset != this.requestURI.offset || originalLength != this.requestURI.length) {
            this.requestURI.offset = originalOffset;
            this.requestURI.length = originalLength;
        }
        if (app.root != null && this.inApplicationContext && (this.isForwarded() || this.isIncluded() || !this.isContextRootRemovedInURI && this.isDirectCall())) {
            uri = app.root.concat(uri);
        }
        return this.newISOString(uri.data, uri.offset, uri.length);
    }

    public static EvermindHttpServletRequest getOriginalRequest() {
        ThreadState state = ThreadState.getInheritableCurrentState();
        return state.applicationThread.httpHandler.request;
    }

    public String getServletPath() {
        if (this.servletPath == null) {
            if (this.currentPostFilterFile != null) {
                return this.currentPostFilterFile.requestURI.toString();
            }
            return null;
        }
        return this.servletPath.toString();
    }

    public String getPathInfo() {
        try {
            if (this.pathInfo != null) {
                String origPathInfo = this.pathInfo.toString(this.getInternalCharacterEncoding());
                if (this.isForwarded() || this.isIncluded()) {
                    return URLDecoder.decode(origPathInfo, "UTF-8");
                }
                return origPathInfo;
            }
        }
        catch (IOException e) {
            return this.pathInfo.toString();
        }
        return null;
    }

    public String getPathTranslated() {
        if (this.pathInfo == null) {
            return null;
        }
        return this.application.getRealPath(this.pathInfo.toString());
    }

    public String getQueryString() {
        ByteString qs = this.queryString;
        if (qs == null && (this.isForwarded() || this.isIncluded()) && !this.getCurrentDispatcher().isNamedRequestDispatcher()) {
            OC4JRequestDispatcher dispatcher = this.getFirstDispatcher();
            qs = dispatcher.getQueryString();
        }
        if (qs != null) {
            try {
                return qs.toString(this.getInternalCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                return qs.toString();
            }
        }
        return null;
    }

    public String getRemoteUser() {
        User user = this.getUserPrincipalInternal();
        return this.getUserName(user);
    }

    protected String getUserName(Principal user) {
        if (user == null) {
            return null;
        }
        ApplicationServer appServer = this.site.server.getApplicationServer();
        User anonUser = appServer.getAnonymousUser();
        if (anonUser != null && anonUser.equals(user)) {
            return null;
        }
        return user.getName();
    }

    public int getContentLength() {
        if (this.contentLength != 0) {
            return this.contentLength;
        }
        String contentLengthHeader = this.getHeader(CONTENT_LENGTH_HEADER);
        if (contentLengthHeader == null) {
            return -1;
        }
        try {
            this.contentLength = Integer.parseInt(contentLengthHeader);
            return this.contentLength;
        }
        catch (NumberFormatException e) {
            try {
                this.contentLength = Integer.parseInt(contentLengthHeader.trim());
                return this.contentLength;
            }
            catch (NumberFormatException innerException) {
                return -1;
            }
        }
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader(CONTENT_TYPE_HEADER);
        return this.contentType;
    }

    public String getProtocol() {
        String firstLine = this.newISOString(this.input, 1, this.headerLineLength - 1);
        return firstLine.substring(firstLine.lastIndexOf(32) + 1, firstLine.length());
    }

    public String[] getParameterValues(String name) {
        try {
            String[] values = this.getParameters().getValue(name);
            if (values == null) {
                return null;
            }
            return (String[])values.clone();
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException: " + e.getMessage());
        }
    }

    public String getServerName() {
        if (!OC4JSecurity.isSecurityOn()) {
            return this.unprivileged_getServerName();
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return EvermindHttpServletRequest.this.unprivileged_getServerName();
            }
        };
        return (String)OC4JSecurity.doPrivileged(action);
    }

    public String unprivileged_getServerName() {
        if (!HTTPProperties.getUseCanonicalName()) {
            if (this.getHostnameHeader() != null) {
                return this.hostHeader.toString();
            }
            String host = this.site.getHost();
            if (host != null) {
                return host;
            }
            return this.socket.getLocalAddress().getHostName();
        }
        return this.site.getConfig().getPosingAsHostname();
    }

    public Enumeration getParameterNames() {
        try {
            return this.getParameters().getKeys();
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException: " + e.getMessage());
        }
    }

    public String getRemoteAddr() {
        if (!OC4JSecurity.isSecurityOn()) {
            return this.unprivileged_getRemoteAddr();
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return EvermindHttpServletRequest.this.unprivileged_getRemoteAddr();
            }
        };
        return (String)OC4JSecurity.doPrivileged(action);
    }

    public String unprivileged_getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        if (!OC4JSecurity.isSecurityOn()) {
            return this.unprivileged_getRemoteAddr();
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return EvermindHttpServletRequest.this.unprivileged_getRemoteHost();
            }
        };
        return (String)OC4JSecurity.doPrivileged(action);
    }

    public String unprivileged_getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getRealPath(String path) {
        return this.application.getRealPath(path);
    }

    public ServletInputStream getInputStream() {
        if (this.inputFetchStatus != 0 && this.inputFetchStatus != 1) {
            throw new IllegalStateException("Reader already requested");
        }
        if (this.servletIn != null) {
            return this.servletIn;
        }
        this.createServletInputStream();
        this.inputFetchStatus = 1;
        return this.servletIn;
    }

    protected boolean isChunkedEncoding() {
        ByteString transferEncoding = this.getByteHeader(TRANSFER_ENCODING_HEADER);
        if (transferEncoding != null) {
            if (CHUNKED == null) {
                CHUNKED = new ByteString("chunked");
            }
            return transferEncoding.equalsIgnoreCase(CHUNKED);
        }
        return false;
    }

    void createServletInputStream() {
        if (this.isChunkedEncoding()) {
            InputStream rawIn;
            if (this.inputStartPos < this.inputEndPos) {
                ByteArrayInputStream bytesIn = new ByteArrayInputStream(this.input, this.inputStartPos, this.inputEndPos - this.inputStartPos);
                this.inputStartPos = this.inputEndPos;
                rawIn = new SequenceInputStream(bytesIn, this.in);
            } else {
                rawIn = this.in;
            }
            this.servletIn = new EvermindServletInputStream(this, new ChunkedInputStream(rawIn), -1);
        } else {
            int contentLength = this.getContentLength();
            if (contentLength < 0) {
                contentLength = 0;
            }
            this.servletIn = new EvermindServletInputStream(this, this.in, contentLength);
        }
    }

    public String getParameter(String name) {
        try {
            return this.getParameters().getFirstValue(name);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException: " + e.getMessage());
        }
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.servletInReader != null) {
            return this.servletInReader;
        }
        if (this.inputFetchStatus != 0 && this.inputFetchStatus != 2) {
            throw new IllegalStateException("InputStream already requested");
        }
        if (this.servletIn == null) {
            this.createServletInputStream();
        }
        String encoding = this.getInternalCharacterEncoding();
        this.servletInReader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.servletIn), encoding));
        this.inputFetchStatus = (byte)2;
        return this.servletInReader;
    }

    public String getCharacterEncoding() {
        String retVal = null;
        if (this.characterEncoding != null) {
            retVal = this.characterEncoding;
        } else {
            int encodingIndex;
            String contentType = this.getHeader(CONTENT_TYPE_HEADER);
            if (contentType != null && (encodingIndex = contentType.indexOf("charset=")) > 0) {
                int encodingIndexEnd = contentType.indexOf(59, encodingIndex);
                retVal = contentType.substring(encodingIndex + 8, encodingIndexEnd < 0 ? contentType.length() : encodingIndexEnd).trim();
            }
            if (retVal == null && this.application.defaultCharSet != null) {
                retVal = this.application.defaultCharSet;
            }
        }
        return retVal;
    }

    public String getMethod() {
        return this.method;
    }

    public ByteString getRequestURIWithoutContext() {
        if (this.resolvedRequestURI != null) {
            return this.resolvedRequestURI;
        }
        if (!this.isContextRootRemovedInURI && this.application.root != null && this.requestURI.startsWith(this.application.root.concat(SLASH_BYTESTRING))) {
            return this.requestURI.substring(this.application.root.length, this.requestURI.length());
        }
        return this.requestURI;
    }

    public String getAuthType() {
        if (!OC4JSecurity.isSecurityOn()) {
            return this.unprivileged_getAuthType();
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return EvermindHttpServletRequest.this.unprivileged_getAuthType();
            }
        };
        return (String)OC4JSecurity.doPrivileged(action);
    }

    private String unprivileged_getAuthType() {
        this.getUserPrincipalInternal();
        if (this.authType != null) {
            return EvermindHttpServletRequest.getAuthConstantFor(this.authType.toString());
        }
        if (this.getRemoteUser() == null) {
            return null;
        }
        return EvermindHttpServletRequest.getAuthConstantFor(this.application.authenticator.getAuthType());
    }

    private static String getAuthConstantFor(String authType) {
        if (authType == null || authType.length() == 0) {
            return null;
        }
        switch (authType.charAt(0)) {
            case 'B': 
            case 'b': {
                if (!authType.equalsIgnoreCase("BASIC")) break;
                return "BASIC";
            }
            case 'C': 
            case 'c': {
                if (!authType.equalsIgnoreCase("CLIENT_CERT")) break;
                return "CLIENT_CERT";
            }
            case 'D': 
            case 'd': {
                if (!authType.equalsIgnoreCase("DIGEST")) break;
                return "DIGEST";
            }
            case 'F': 
            case 'f': {
                if (!authType.equalsIgnoreCase("FORM")) break;
                return "FORM";
            }
            case 'S': {
                if (!authType.equals("SSL")) break;
                return "CLIENT_CERT";
            }
        }
        return authType;
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public Enumeration getHeaderNames() {
        if (this.dynamicHeaders == null) {
            return new HeaderNameEnumeration(this.input, this.headerLineLength);
        }
        byte[] input = this.input;
        int currentPos = this.headerLineLength;
        ArrayList<String> names = new ArrayList<String>();
        try {
            while (input[currentPos] != 0 || input[currentPos + 1] != 0) {
                int linePos = currentPos + 2;
                while (input[linePos++] != 58) {
                }
                String name = this.newISOString(input, currentPos + 2, linePos - currentPos - 3).toUpperCase();
                names.add(name);
                currentPos += ((char)input[currentPos] & 0xFF) + input[currentPos + 1] * 256;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (this.dynamicHeaders != null) {
            Iterator iterator = this.dynamicHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() == "<reset-header>") {
                    names.remove(entry.getKey().toString());
                    continue;
                }
                if (names.contains(entry.getKey())) continue;
                names.add((String)entry.getKey());
            }
        }
        return Collections.enumeration(names);
    }

    public Enumeration getAttributeNames() {
        if (this.isIncluded() && !this.getCurrentDispatcher().isNamedRequestDispatcher()) {
            ArrayList<String> list;
            ArrayList<String> arrayList = list = this.attributes == null ? new ArrayList<String>() : new ArrayList(this.attributes.keySet());
            if (!list.contains(INCLUDE_REQUEST_URI) && this.getAttribute(INCLUDE_REQUEST_URI) != null) {
                list.add(INCLUDE_REQUEST_URI);
            }
            if (!list.contains(INCLUDE_CONTEXT_PATH) && this.getAttribute(INCLUDE_CONTEXT_PATH) != null) {
                list.add(INCLUDE_CONTEXT_PATH);
            }
            if (!list.contains(INCLUDE_SERVLET_PATH) && this.getAttribute(INCLUDE_SERVLET_PATH) != null) {
                list.add(INCLUDE_SERVLET_PATH);
            }
            if (!list.contains(INCLUDE_PATH_INFO) && this.getAttribute(INCLUDE_PATH_INFO) != null) {
                list.add(INCLUDE_PATH_INFO);
            }
            if (!list.contains(INCLUDE_QUERY_STRING) && this.getAttribute(INCLUDE_QUERY_STRING) != null) {
                list.add(INCLUDE_QUERY_STRING);
            }
            return Collections.enumeration(list);
        }
        if (this.isForwarded() && !this.getCurrentDispatcher().isNamedRequestDispatcher()) {
            ArrayList<String> list;
            ArrayList<String> arrayList = list = this.attributes == null ? new ArrayList<String>() : new ArrayList(this.attributes.keySet());
            if (!list.contains(FORWARD_REQUEST_URI) && this.getAttribute(FORWARD_REQUEST_URI) != null) {
                list.add(FORWARD_REQUEST_URI);
            }
            if (!list.contains(FORWARD_CONTEXT_PATH) && this.getAttribute(FORWARD_CONTEXT_PATH) != null) {
                list.add(FORWARD_CONTEXT_PATH);
            }
            if (!list.contains(FORWARD_SERVLET_PATH) && this.getAttribute(FORWARD_SERVLET_PATH) != null) {
                list.add(FORWARD_SERVLET_PATH);
            }
            if (!list.contains(FORWARD_PATH_INFO) && this.getAttribute(FORWARD_PATH_INFO) != null) {
                list.add(FORWARD_PATH_INFO);
            }
            if (!list.contains(FORWARD_QUERY_STRING) && this.getAttribute(FORWARD_QUERY_STRING) != null) {
                list.add(FORWARD_QUERY_STRING);
            }
            return Collections.enumeration(list);
        }
        if (this.attributes == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this.attributes.keySet());
    }

    EvermindHttpSession getCurrentSession() {
        if (this.session != null && !this.session.isInvalid()) {
            return this.session;
        }
        return null;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        return this.getSession(create, true);
    }

    protected HttpSession getSession(final boolean create, final boolean executeListeners) {
        if (!OC4JSecurity.isSecurityOn()) {
            return this.unprivileged_getSession(create, executeListeners);
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return EvermindHttpServletRequest.this.unprivileged_getSession(create, executeListeners);
            }
        };
        return (HttpSession)OC4JSecurity.doPrivileged(action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpSession unprivileged_getSession(boolean create, boolean executeListeners) {
        if (null == this.application) {
            return null;
        }
        if (this.application.sessionManager == null) {
            if (HTTPProperties.getHttpSessionDebug()) {
                m_traceLogger.log(Level.FINE, "EvermindHttpServletRequest.getSession(), session=" + this.session);
            }
            if (this.session != null) {
                if (!this.session.getInvalidated()) {
                    if (!this.session.isTimedOut()) return this.session;
                    this.session.invalidate();
                    this.session = null;
                } else {
                    this.session = null;
                }
            }
            boolean useSSLSession = this.useSSLSession();
            ByteString rId = this.getRequestedSessionIdBytes();
            ByteString requestedId = null;
            if (rId != null) {
                if (HTTPProperties.getHttpSessionDebug()) {
                    m_traceLogger.log(Level.FINE, "Requested Id is " + rId);
                }
                requestedId = this.getKeySessionID(rId);
                if (this.jvmRoute != null && this.application.config.getSendSessionCookie()) {
                    this.response.sessionCookiePrefix = this.application.getSessionCookiePrefix();
                    this.response.sessionCookieValue = new byte[requestedId.length()];
                    System.arraycopy(requestedId.getBytes(), 0, this.response.sessionCookieValue, 0, requestedId.length());
                }
            }
            if (requestedId != null) {
                EvermindHttpSession existingSession = this.application.getExistingSession(requestedId);
                if (existingSession == null) {
                    boolean inStrictMode;
                    String sessionCookieIDMode = (String)this.getAttribute("oc4j.sessionCookieMode");
                    boolean bl = inStrictMode = sessionCookieIDMode != null && sessionCookieIDMode.equalsIgnoreCase("strict");
                    if (!(HTTPProperties.getOracleAuthorizationShare() || useSSLSession || HTTPProperties.getOracleUseSessionIDFromCookie() && !inStrictMode)) {
                        requestedId = null;
                    }
                } else {
                    this.session = existingSession;
                }
            }
            if (this.session != null && this.session.isTimedOut()) {
                this.session.invalidate();
                this.session = null;
            }
            if (this.session == null && create) {
                this.application.createSession(this, this.response, requestedId, useSSLSession, rId, executeListeners);
            }
            if (this.session == null) return this.session;
            this.session.beginRequest();
            return this.session;
        }
        if (this.externalSession != null && this.application.sessionManager.isValid(this.externalSession)) {
            return this.externalSession;
        }
        ByteString requestedId = this.getRequestedSessionIdBytes();
        if (requestedId != null) {
            this.externalSession = this.application.sessionManager.getSession(requestedId.toString());
        }
        if (this.externalSession != null) {
            return this.externalSession;
        }
        if (!create) return this.externalSession;
        this.externalSession = this.application.sessionManager.createSession();
        this.response.sessionCookiePrefix = this.application.getSessionCookiePrefix();
        this.response.sessionCookieValue = this.externalSession.getId().getBytes();
        return this.externalSession;
    }

    public String getRequestedSessionId() {
        ByteString id = this.getRequestedSessionIdBytes();
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    public ByteString getRequestedSessionIdBytes() {
        ByteString cookieHeader;
        if (this.useSSLSession()) {
            try {
                SSLSession sslSession = ((SSLSocket)this.socket).getSession();
                if (sslSession != null) {
                    char[] rawData = Base64Utils.encode(sslSession.getId());
                    ByteString id = new ByteString(rawData);
                    if (id.indexOf('/') >= 0) {
                        id = id.replace('/', '_');
                    }
                    return id;
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if ((cookieHeader = this.getByteHeader(COOKIE_HEADER)) != null) {
            int length = cookieHeader.length();
            try {
                int readTo = length - SESSION_ID_UPPERCASE.length;
                for (int i = 0; i < readTo; ++i) {
                    char charAt;
                    int x;
                    if (cookieHeader.charAt(i) != 'J') continue;
                    boolean quoted = false;
                    for (x = 1; x < SESSION_ID_UPPERCASE.length && cookieHeader.charAt(i + x) == SESSION_ID_UPPERCASE[x]; ++x) {
                    }
                    if (x < SESSION_ID_UPPERCASE.length || Character.isLetterOrDigit(cookieHeader.charAt(i += x)) || i - x != 0 && Character.isLetterOrDigit(cookieHeader.charAt(i - x - 1))) continue;
                    while (i < length && cookieHeader.charAt(i) == ' ') {
                        ++i;
                    }
                    while (i < length && cookieHeader.charAt(i) == '=') {
                        ++i;
                    }
                    while (i < length && cookieHeader.charAt(i) == ' ') {
                        ++i;
                    }
                    while (i < length && cookieHeader.charAt(i) == '\"') {
                        ++i;
                        quoted = true;
                    }
                    x = 0;
                    while (i + x < length && (charAt = cookieHeader.charAt(i + x)) != ';' && charAt != '\"' && (charAt != ',' || quoted)) {
                        ++x;
                    }
                    if (x < 32) continue;
                    this.requestedSessionFromCookie = true;
                    return cookieHeader.substring(i, i + x);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.sessionIDStart > 0) {
            for (int i = this.sessionIDStart; i < this.sessionIDEnd; ++i) {
                if (this.input[i] != 61 || this.sessionIDEnd - ++i < 32) continue;
                this.requestedSessionFromURL = true;
                return new ByteString(this.input, i, this.sessionIDEnd - i);
            }
        }
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        ByteString rId = this.getRequestedSessionIdBytes();
        if (rId == null) {
            return false;
        }
        ByteString requestedId = this.getKeySessionID(rId);
        if (requestedId == null) {
            return false;
        }
        EvermindHttpSession existingSession = this.application.getExistingSession(requestedId);
        if (existingSession == null) {
            return false;
        }
        return !existingSession.isInvalid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        this.getSession(false);
        return this.requestedSessionFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        this.getSession(false);
        return this.requestedSessionFromURL;
    }

    public Object setAttribute_oc4j(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
            return null;
        }
        try {
            if (name.charAt(0) == 'h' && name.startsWith("header.")) {
                name = name.substring(7).toUpperCase();
                if (this.dynamicHeaders == null) {
                    this.dynamicHeaders = new HashMap();
                }
                this.dynamicHeaders.put(name, value.toString());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes.put(name, value);
    }

    public void setAttribute(String name, Object value) {
        block5: {
            block4: {
                if (value != null) break block4;
                this.removeAttribute(name);
                break block5;
            }
            Object previous = this.setAttribute_oc4j(name, value);
            if (this.application.requestAttributeListeners == null) break block5;
            if (previous != null) {
                for (int i = 0; i < this.application.requestAttributeListeners.length; ++i) {
                    this.application.requestAttributeListeners[i].attributeReplaced(new ServletRequestAttributeEvent((ServletContext)this.application, (ServletRequest)this, name, previous));
                }
            } else {
                for (int i = 0; i < this.application.requestAttributeListeners.length; ++i) {
                    this.application.requestAttributeListeners[i].attributeAdded(new ServletRequestAttributeEvent((ServletContext)this.application, (ServletRequest)this, name, value));
                }
            }
        }
    }

    public X509Certificate[] getCertificate() throws IllegalArgumentException, RuntimeException, SSLPeerUnverifiedException {
        try {
            if (certificateFactory == null) {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            javax.security.cert.X509Certificate[] encodedCerts = ((SSLSocket)this.socket).getSession().getPeerCertificateChain();
            X509Certificate[] certs = new X509Certificate[encodedCerts.length];
            if (encodedCerts.length == 0) {
                return null;
            }
            for (int i = 0; i < certs.length; ++i) {
                certs[i] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(encodedCerts[i].getEncoded()));
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Must use a JSSE-compliant SSL engine in order to access the X509 cert");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Certificate error: " + e.getMessage());
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("Certificate-encoding error: " + e.getMessage());
        }
    }

    public String getCipherSuite() {
        return ((SSLSocket)this.socket).getSession().getCipherSuite();
    }

    public Integer getCipherKeySize() {
        String cipherSuite = this.getCipherSuite();
        if (cipherSuite != null) {
            if (cipherSuite.indexOf("_WITH_NULL_") >= 0) {
                return new Integer(0);
            }
            if (cipherSuite.indexOf("_WITH_IDEA_CBC_") >= 0) {
                return new Integer(128);
            }
            if (cipherSuite.indexOf("_WITH_RC2_CBC_40_") >= 0) {
                return new Integer(40);
            }
            if (cipherSuite.indexOf("_WITH_RC4_40_") >= 0) {
                return new Integer(40);
            }
            if (cipherSuite.indexOf("_WITH_RC4_128_") >= 0) {
                return new Integer(128);
            }
            if (cipherSuite.indexOf("_WITH_DES40_CBC_") >= 0) {
                return new Integer(40);
            }
            if (cipherSuite.indexOf("_WITH_DES_CBC_") >= 0) {
                return new Integer(56);
            }
            if (cipherSuite.indexOf("_WITH_3DES_EDE_CBC_") >= 0) {
                return new Integer(168);
            }
        }
        return new Integer(0);
    }

    public Object getAttribute(String name) {
        try {
            Object value;
            if (this.attributes != null && (value = this.attributes.get(name)) != null) {
                return value;
            }
            if (name.startsWith("javax.servlet.error")) {
                return null;
            }
            if (this.isSecure() && name.startsWith("javax.servlet.request")) {
                if (name.equals("javax.servlet.request.X509Certificate")) {
                    return this.getCertificate();
                }
                if (name.equals("javax.servlet.request.cipher-suite") || name.equals("javax.servlet.request.cipher_suite")) {
                    return this.getCipherSuite();
                }
                if (name.equals("javax.servlet.request.key-size") || name.equals("javax.servlet.request.key_size")) {
                    return this.getCipherKeySize();
                }
                return null;
            }
            if (this.isIncluded() && !this.getCurrentDispatcher().isNamedRequestDispatcher() && name.startsWith("javax.servlet.include")) {
                value = null;
                if (name.equals(INCLUDE_REQUEST_URI)) {
                    if (this.application.root != null) {
                        return this.application.root.concat(this.getDispatcherRequestURIByteString()).toString();
                    }
                    value = this.getDispatcherRequestURIByteString();
                    return value == null ? null : ((ByteString)value).toString();
                }
                if (name.equals(INCLUDE_CONTEXT_PATH)) {
                    value = this.getDispatcherContextPathByteString();
                    return value == null ? null : ((ByteString)value).toString();
                }
                if (name.equals(INCLUDE_PATH_INFO)) {
                    value = this.getDispatcherPathInfoByteString();
                    return value == null ? null : ((ByteString)value).toString();
                }
                if (name.equals(INCLUDE_SERVLET_PATH)) {
                    value = this.getDispatcherServletPathByteString();
                    return value == null ? null : ((ByteString)value).toString();
                }
                if (name.equals(INCLUDE_QUERY_STRING)) {
                    value = this.getDispatcherQueryStringByteString();
                    return value == null ? null : ((ByteString)value).toString();
                }
                return null;
            }
            if (this.isForwarded() && !this.getCurrentDispatcher().isNamedRequestDispatcher() && name.startsWith("javax.servlet.forward")) {
                OC4JRequestDispatcher dispatcher = this.getFirstDispatcher();
                ByteString value2 = null;
                if (name.equals(FORWARD_REQUEST_URI)) {
                    if (this.application.root != null) {
                        return this.application.root.concat(dispatcher.getRequestURI()).toString();
                    }
                    value2 = dispatcher.getRequestURI();
                    return value2 == null ? null : value2.toString();
                }
                if (name.equals(FORWARD_CONTEXT_PATH)) {
                    value2 = dispatcher.getContextPath();
                    return value2 == null ? null : value2.toString();
                }
                if (name.equals(FORWARD_PATH_INFO)) {
                    value2 = dispatcher.getPathInfo();
                    return value2 == null ? null : value2.toString();
                }
                if (name.equals(FORWARD_SERVLET_PATH)) {
                    value2 = ((ServletRequestDispatcher)dispatcher).getServletPath();
                    return value2 == null ? null : value2.toString();
                }
                if (name.equals(FORWARD_QUERY_STRING)) {
                    value2 = dispatcher.getQueryString();
                    return value2 == null ? null : value2.toString();
                }
                return null;
            }
            if (name.equals("response.status")) {
                if (this.response.status == 0 || this.response.status == 200) {
                    return INTEGER_200;
                }
                return new Integer(this.response.status);
            }
            if (name.equals("response.length")) {
                return new Integer(this.response.contentLength);
            }
            if (name.equals("request.header")) {
                return this.newISOString(this.input, this.headerStartPos, this.headerStartPos + this.headerLineLength);
            }
            return null;
        }
        catch (Exception e) {
            this.application.log("Error in getAttribute", e);
            return null;
        }
    }

    public String getHeadersFormatted() {
        try {
            StringBuffer buffer = new StringBuffer();
            if (this.headerLineLength != this.headerLineRealLength) {
                buffer.append(this.newISOString(this.input, this.headerStartPos, this.headerLineRealLength - 9));
            } else {
                buffer.append(this.newISOString(this.input, this.headerStartPos, this.headerLineLength));
            }
            buffer.append("\r\n");
            int lineStart = this.headerLineLength;
            while (true) {
                int lineLength;
                if ((lineLength = ((char)this.input[lineStart] & 0xFF) + this.input[lineStart + 1] * 256) <= 0) {
                    return buffer.toString();
                }
                buffer.append(this.newISOString(this.input, lineStart + 2, lineLength - 2));
                buffer.append("\r\n");
                lineStart += lineLength;
            }
        }
        catch (Throwable t) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            PrintWriter errorWriter = new PrintWriter(byteOut);
            t.printStackTrace(errorWriter);
            return "Error parsing input: " + new String(this.input, 0, this.input.length) + "\n\n\n" + new String(byteOut.toByteArray());
        }
    }

    protected boolean useSSLSession() {
        if (FORCE_USE_SESSION_COOKIE) {
            return false;
        }
        return this.site.secure && !this.application.shared;
    }

    public boolean isSecure() {
        return this.site.secure;
    }

    public boolean isApplicationShared() {
        return this.application.shared;
    }

    private int getLocaleID(Locale l) {
        return this.getLocaleID(l.getLanguage() + "-" + l.getCountry());
    }

    private int getLocaleID(String localeString) {
        int id = (localeString.charAt(0) << 8) + localeString.charAt(1);
        if (localeString.length() > 4) {
            id += (localeString.charAt(3) << 24) + (localeString.charAt(4) << 16);
        }
        return id;
    }

    public Enumeration getLocales() {
        ArrayList localeList = this.getLocaleList();
        if (localeList == null || localeList.size() == 0) {
            return Collections.enumeration(Collections.singleton(Locale.getDefault()));
        }
        return Collections.enumeration(localeList);
    }

    public Locale getLocale() {
        if (this.locale == null) {
            ArrayList userLocales = this.getLocaleList();
            this.locale = userLocales != null && userLocales.size() > 0 ? (Locale)userLocales.get(0) : Locale.getDefault();
        }
        return this.locale;
    }

    private ArrayList getLocaleList() {
        String acceptLanguages = this.getHeader(ACCEPT_LANGUAGE_HEADER);
        if (acceptLanguages == null) {
            return null;
        }
        ArrayList<ComparableLocale> compLocaleList = new ArrayList<ComparableLocale>();
        StringTokenizer tokenizer = new StringTokenizer(acceptLanguages, ", :");
        int counter = 0;
        while (tokenizer.hasMoreElements()) {
            int qValueIndex;
            String element = tokenizer.nextToken();
            float q = 1.0f;
            if (element.length() >= 5 && (qValueIndex = element.indexOf(59)) > -1) {
                try {
                    q = Float.parseFloat(element.substring(qValueIndex + 3, element.length()));
                    if (q > 1.0f || q < 0.0f) {
                        q = 1.0f;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                element = element.substring(0, qValueIndex);
            }
            if (element.equals("*")) continue;
            int id = this.getLocaleID(element);
            Locale locale = (Locale)locales.get(new Integer(id));
            if (locale == null) {
                char[] localeName = new char[]{(char)(id >> 8 & 0xFF), (char)(id & 0xFF)};
                String country = "";
                if ((id & 0xFFFF0000) != 0) {
                    char[] countryName = new char[]{(char)(id >> 24 & 0xFF), (char)(id >> 16 & 0xFF)};
                    country = new String(countryName);
                }
                locale = new Locale(new String(localeName), country);
                locales.put(new Integer(id), locale);
            }
            compLocaleList.add(new ComparableLocale(q, locale, counter++));
        }
        Collections.sort(compLocaleList);
        int localeSize = compLocaleList.size();
        ArrayList<Locale> returnVal = new ArrayList<Locale>(localeSize);
        for (int i = localeSize - 1; i >= 0; --i) {
            try {
                returnVal.add(((ComparableLocale)compLocaleList.remove(i)).getLocale());
                continue;
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        return returnVal;
    }

    public String getContextPath() {
        if (this.escapedOctetLocation != null && this.isDirectCall() && this.isContextRootRemovedInURI) {
            ByteString ctxPath = this.requestURI.trueClone();
            HttpApplication app = this.originalApplication;
            if (app == null) {
                app = this.application;
            }
            if (app.root != null && this.inApplicationContext) {
                ctxPath.offset -= app.root.length;
                ctxPath.length = app.root.length;
            }
            int start = ctxPath.offset;
            int end = ctxPath.offset + ctxPath.length;
            byte[] data = ctxPath.data;
            ByteString newPath = new ByteString(ctxPath.length * 3);
            int newPathPos = 0;
            int _numEscapedOctet = this.escapedOctetLocation.size();
            int _locEscapedOctet = (Integer)this.escapedOctetLocation.elementAt(0);
            int j = 0;
            for (int i = start; i < end; ++i) {
                if (i == _locEscapedOctet) {
                    if (++j < _numEscapedOctet) {
                        _locEscapedOctet = (Integer)this.escapedOctetLocation.elementAt(j);
                    }
                    int higher = ((char)data[i] & 0xF0) >> 4;
                    int lower = data[i] & 0xF;
                    newPath.data[newPathPos++] = 37;
                    newPath.data[newPathPos++] = higher >= 10 ? (byte)(higher - 10 + 97) : (byte)(higher + 48);
                    if (lower >= 10) {
                        newPath.data[newPathPos++] = (byte)(lower - 10 + 97);
                        continue;
                    }
                    newPath.data[newPathPos++] = (byte)(lower + 48);
                    continue;
                }
                newPath.data[newPathPos++] = data[i];
            }
            newPath.length = newPathPos;
            ctxPath = newPath;
            return this.newISOString(ctxPath.data, ctxPath.offset, ctxPath.length);
        }
        if (this.originalApplication != null) {
            return this.originalApplication.contextPath;
        }
        return this.application.contextPath;
    }

    public boolean isUserInRole(final String role) {
        if (!OC4JSecurity.isSecurityOn()) {
            return this.application.isUserInRole(this.getUserPrincipalInternal(), role, this);
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                boolean is = EvermindHttpServletRequest.this.application.isUserInRole(EvermindHttpServletRequest.this.getUserPrincipalInternal(), role, EvermindHttpServletRequest.this);
                return is ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        Boolean is = (Boolean)OC4JSecurity.doPrivileged(action);
        return is;
    }

    public javax.security.cert.X509Certificate getExtensionCertificate() {
        try {
            javax.security.cert.X509Certificate[] certs = ((SSLSocket)this.socket).getSession().getPeerCertificateChain();
            if (certs == null || certs.length == 0) {
                return null;
            }
            return certs[0];
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    public User getSSLUser() {
        if (!(this.socket instanceof SSLSocket)) {
            return null;
        }
        SSLSession session = ((SSLSocket)this.socket).getSession();
        User user = (User)session.getValue("user");
        if (user != null) {
            return user;
        }
        javax.security.cert.X509Certificate cert = this.getExtensionCertificate();
        try {
            if (cert != null) {
                user = this.application.getUserManager().getUser(cert.getIssuerDN().getName(), cert.getSerialNumber());
            }
            if (user != null) {
                session.putValue("user", user);
            }
            return user;
        }
        catch (Throwable t) {
            this.application.log("Error in UserManager", t);
            return null;
        }
    }

    public Principal getUserPrincipal() {
        User principal = this.getUserPrincipalInternal();
        if (principal == this.site.server.getApplicationServer().getAnonymousUser()) {
            return null;
        }
        return SecurityUtil.shield((Principal)principal);
    }

    protected ByteString getKeySessionID(ByteString rId) {
        int i;
        for (i = 0; i < rId.length() && rId.charAt(i) != '.'; ++i) {
        }
        return rId.substring(0, i);
    }

    public User getUserPrincipalInternal() {
        if (this.remoteUser == null) {
            this.getSession(false);
            if (this.session == null && HTTPProperties.getOracleAuthorizationShare()) {
                ByteString rId = this.getRequestedSessionIdBytes();
                ByteString requestedId = null;
                if (rId != null) {
                    if (HTTPProperties.getHttpSessionDebug()) {
                        m_traceLogger.log(Level.FINE, "Requested Id is " + rId);
                    }
                    requestedId = this.getKeySessionID(rId);
                    this.remoteUser = this.application.tryFindUser(requestedId);
                }
            }
            if (this.remoteUser == null) {
                if (this.isSecure()) {
                    this.remoteUser = this.getSSLUser();
                }
                PasswordAuthentication authentication = this.application.authenticator.getAuthentication(this);
                this.checkAndSetRemoteUser(authentication);
            }
            if (this.remoteUser == null) {
                if (this.session != null && this.session.user != null) {
                    this.remoteUser = this.session.user;
                }
                if (this.remoteUser == null) {
                    this.remoteUser = this.site.server.getApplicationServer().getAnonymousUser();
                }
            }
        }
        return this.remoteUser;
    }

    public boolean checkAndSetRemoteUser(PasswordAuthentication authentication) {
        if (this.remoteUser == null && !this.remoteUserIsInitialized && authentication != null) {
            String passw;
            try {
                this.remoteUser = this.application.getUserManager().getUser(authentication.getUserName());
            }
            catch (Throwable t) {
                this.application.log("Error in UserManager", t);
            }
            if (this.remoteUser != null && !this.remoteUser.authenticate(passw = new String(authentication.getPassword()))) {
                this.remoteUser = null;
            }
            if (this.session != null && (this.session.user != null && !this.session.user.equals(this.remoteUser) || this.session.user == null && this.remoteUser != null)) {
                int status = this.session.status;
                ByteString session_loginPath = this.session.loginPath;
                ByteString session_loginQueryString = this.session.loginQueryString;
                String session_method = this.session.loginMethod;
                ParameterMap session_params = this.session.loginParameters;
                Object[] attributes = null;
                if (this.session.valueCount > 0) {
                    int valuesLength = this.session.values.length;
                    attributes = new Object[valuesLength];
                    System.arraycopy(this.session.values, 0, attributes, 0, valuesLength);
                }
                this.session.invalidate(false);
                this.session = (EvermindHttpSession)this.getSession(true, false);
                this.session.loginPath = session_loginPath;
                this.session.loginQueryString = session_loginQueryString;
                this.session.loginMethod = session_method;
                this.session.loginParameters = session_params;
                this.session.status = status;
                if (attributes != null) {
                    for (int i = 0; i < attributes.length; i += 2) {
                        if (attributes[i] == null) continue;
                        this.session.setAttribute((String)attributes[i], attributes[i + 1], false);
                    }
                }
                this.session.setUser(this.remoteUser);
            }
            this.remoteUserIsInitialized = true;
        }
        return this.remoteUser != null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            ByteString servletPath = this.getDispatcherServletPathByteString();
            if (servletPath != null) {
                String value = servletPath.toString();
                return this.application.getRequestDispatcher(value.substring(0, value.lastIndexOf(47) + 1).toString().concat(path));
            }
            servletPath = this.servletPath;
            if (servletPath == null) {
                servletPath = this.requestURI;
            }
            return this.application.getRequestDispatcher(servletPath.substring(0, servletPath.lastIndexOf('/') + 1).toString().concat(path));
        }
        return this.application.getRequestDispatcher(path);
    }

    public File localize(File requestedFile, FileInformation fileInformation, boolean changeURI) {
        int localeID = this.getLocaleID(this.getLocale());
        if (localeID != -1) {
            if (fileInformation != null) {
                File newFile = fileInformation.getLocalizedVersion(localeID);
                if (newFile != null) {
                    if (changeURI) {
                        byte[] newRequestURIByteArray = new byte[this.requestURI.length + 3];
                        System.arraycopy(this.requestURI.data, this.requestURI.offset, newRequestURIByteArray, 0, this.requestURI.length);
                        newRequestURIByteArray[this.requestURI.length] = 95;
                        newRequestURIByteArray[this.requestURI.length + 1] = (byte)(localeID >> 8);
                        newRequestURIByteArray[this.requestURI.length + 2] = (byte)localeID;
                        this.requestURI = new ByteString(newRequestURIByteArray);
                    }
                    return newFile;
                }
            } else {
                String filePath = requestedFile.getPath();
                int fileDotPos = filePath.lastIndexOf(46);
                filePath = fileDotPos == -1 ? filePath + '_' + (char)(localeID >> 8) + (char)(localeID & 0xFF) : filePath.substring(0, fileDotPos) + '_' + (char)(localeID >> 8) + (char)(localeID & 0xFF) + filePath.substring(fileDotPos);
                File newFile = new File(filePath);
                if (newFile.exists()) {
                    if (changeURI) {
                        String newRequestURI = this.requestURI.toString();
                        fileDotPos = newRequestURI.lastIndexOf(46);
                        newRequestURI = fileDotPos == -1 ? newRequestURI + '_' + (char)(localeID >> 8) + (char)(localeID & 0xFF) : newRequestURI.substring(0, fileDotPos) + '_' + (char)(localeID >> 8) + (char)(localeID & 0xFF) + newRequestURI.substring(fileDotPos);
                        this.requestURI = new ByteString(newRequestURI);
                    }
                    return newFile;
                }
            }
        }
        return null;
    }

    public ByteString getHostnameHeader() {
        if (this.hostHeader == null) {
            this.parseHostHeader(this.getByteHeader(HOST_HEADER));
        }
        return this.hostHeader;
    }

    public ByteString getHostHeaderPort() {
        if (this.hostHeaderPort == null) {
            this.parseHostHeader(this.getByteHeader(HOST_HEADER));
        }
        return this.hostHeaderPort;
    }

    private void parseHostHeader(ByteString headStr) {
        if (headStr != null) {
            int closeSquareBracePos;
            int colonPos = headStr.lastIndexOf(':');
            if (colonPos > (closeSquareBracePos = headStr.indexOf(']'))) {
                this.hostHeader = headStr.substring(0, colonPos);
                this.hostHeaderPort = headStr.substring(colonPos + 1);
            } else {
                this.hostHeader = headStr;
            }
        }
    }

    public byte[] getPostParams(boolean commaSeparateMultipleValues) throws IOException {
        Map params = this.getImmutableParameters();
        if (params == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        Iterator iterator = params.entrySet().iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            int i;
            if (!first) {
                byteOut.write(38);
            }
            first = false;
            Map.Entry entry = iterator.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof String) {
                EvermindHttpServletRequest.writeVar(byteOut, key, (String)value);
                continue;
            }
            if (!(value instanceof String[])) continue;
            String[] valueStrings = (String[])value;
            if (commaSeparateMultipleValues) {
                byteOut.write(URLEncoder.encode(key).getBytes());
                byteOut.write(61);
                for (i = 0; i < valueStrings.length; ++i) {
                    if (i > 0) {
                        byteOut.write(44);
                    }
                    byteOut.write(URLEncoder.encode(valueStrings[i]).getBytes());
                }
                continue;
            }
            for (i = 0; i < valueStrings.length; ++i) {
                if (i > 0) {
                    byteOut.write(38);
                }
                EvermindHttpServletRequest.writeVar(byteOut, key, valueStrings[i]);
            }
        }
        return byteOut.toByteArray();
    }

    public static final void writeVar(OutputStream out, String key, String value) throws IOException {
        out.write(URLEncoder.encode(key).getBytes());
        out.write(61);
        out.write(URLEncoder.encode(value).getBytes());
    }

    public void setRemoteUser(User user) {
        this.remoteUser = user;
        if (this.application.authenticator instanceof FormHttpAuthenticator) {
            this.getSession(true);
        }
        if (this.session != null) {
            this.session.setUser(user);
        }
    }

    public HttpApplication getApplication() {
        return this.application;
    }

    public InetAddress getInetAddress() {
        if (!OC4JSecurity.isSecurityOn()) {
            return this.unprivileged_getInetAddress();
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return EvermindHttpServletRequest.this.unprivileged_getInetAddress();
            }
        };
        return (InetAddress)OC4JSecurity.doPrivileged(action);
    }

    public InetAddress unprivileged_getInetAddress() {
        return this.socket.getInetAddress();
    }

    public void removeAttribute(String name) {
        try {
            if (name.charAt(0) == 'h' && name.startsWith("header.")) {
                name = name.substring(7).toUpperCase();
                if (this.dynamicHeaders == null) {
                    this.dynamicHeaders = new HashMap();
                }
                this.dynamicHeaders.put(name, "<reset-header>");
                return;
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (this.attributes == null) {
            if (this.application.requestAttributeListeners != null) {
                for (int i = 0; i < this.application.requestAttributeListeners.length; ++i) {
                    this.application.requestAttributeListeners[i].attributeRemoved(new ServletRequestAttributeEvent((ServletContext)this.application, (ServletRequest)this, name, null));
                }
            }
            return;
        }
        Object previous = this.attributes.remove(name);
        if (this.application.requestAttributeListeners != null) {
            for (int i = 0; i < this.application.requestAttributeListeners.length; ++i) {
                this.application.requestAttributeListeners[i].attributeRemoved(new ServletRequestAttributeEvent((ServletContext)this.application, (ServletRequest)this, name, previous));
            }
        }
    }

    public boolean canUseGzip() {
        ByteString data = this.getByteHeader(ACCEPT_ENCODING_HEADER);
        if (data == null) {
            return false;
        }
        int end = data.offset + data.length;
        byte[] content = data.data;
        for (int i = data.offset; i < end - 3; ++i) {
            if (content[i] != 103 || content[i + 1] != 122 || content[i + 2] != 105 || content[i + 3] != 112 || i + 4 != end && content[i + 4] != 44) continue;
            return true;
        }
        return false;
    }

    public final int getVersion() {
        byte first = this.input[this.headerLineLength - 3];
        if (first < 48 || first > 57) {
            return 10;
        }
        byte second = this.input[this.headerLineLength - 1];
        if (second < 48 || second > 57) {
            return 10;
        }
        return (first - 48) * 10 + (second - 48);
    }

    protected boolean sendPostContinue() {
        return HTTPProperties.getSendContinueOnPost();
    }

    String getInternalCharacterEncoding() {
        String charset = this.getCharacterEncoding();
        if (charset == null) {
            return "ISO-8859-1";
        }
        return charset;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String requestURI = this.getRequestURI();
        if (!requestURI.startsWith("http://") && !requestURI.startsWith("https://")) {
            String scheme = this.getScheme();
            url.append(scheme);
            url.append("://");
            int port = this.getServerPort();
            if (port < 0) {
                port = 80;
            }
            url.append(this.getServerName());
            if (scheme.equals(HTTP_SCHEME) && port != 80 || scheme.equals("https") && port != 443) {
                url.append(':');
                url.append(port);
            }
        }
        url.append(requestURI);
        return url;
    }

    public FilterChain getFilter(ByteString requestURI, ByteString servletName) throws ServletException {
        RuntimeFilterMapping[] filterMappings = this.application.filterMappings;
        if (filterMappings != null) {
            boolean appliedFilters = false;
            Filter firstFilter = null;
            EvermindFilterChain firstChain = null;
            EvermindFilterChain currentChain = null;
            for (int i = 0; i < filterMappings.length; ++i) {
                try {
                    RuntimeFilterMapping mapping = filterMappings[i];
                    if (!ServletRequestDispatcher.checkFilterDispatcher(mapping, this) || mapping.start != null && !requestURI.startsWith(mapping.start) || mapping.end != null && !requestURI.endsWith(mapping.end) || mapping.servletName != null && (servletName == null || !servletName.equals(mapping.servletName))) continue;
                    if (firstFilter == null) {
                        firstFilter = mapping.instance;
                        if (firstFilter == null) {
                            mapping.config = this.application.getFilterConfig(mapping.filter);
                            firstFilter = mapping.instance = mapping.config.instance;
                        }
                        if (!this.application.development || mapping.config.isUpToDate()) continue;
                        this.application.reset();
                        mapping.config = this.application.getFilterConfig(mapping.filter);
                        firstFilter = mapping.instance = mapping.config.instance;
                        continue;
                    }
                    if (firstChain == null) {
                        firstChain = this.filterChainCacheCount == 0 ? (currentChain = new EvermindFilterChain()) : (currentChain = this.filterChainCache[--this.filterChainCacheCount]);
                        if (mapping.instance == null) {
                            mapping.config = this.application.getFilterConfig(mapping.filter);
                            mapping.instance = mapping.config.instance;
                        }
                        if (this.application.development && !mapping.config.isUpToDate()) {
                            this.application.reset();
                            mapping.config = this.application.getFilterConfig(mapping.filter);
                            mapping.instance = mapping.config.instance;
                        }
                        firstChain.filter = mapping.instance;
                        continue;
                    }
                    if (this.filterChainCacheCount == 0) {
                        currentChain = currentChain.next = new EvermindFilterChain();
                    } else {
                        currentChain.next = currentChain = this.filterChainCache[--this.filterChainCacheCount];
                    }
                    if (mapping.instance == null) {
                        mapping.config = this.application.getFilterConfig(mapping.filter);
                        mapping.instance = mapping.config.instance;
                    }
                    if (this.application.development && !mapping.config.isUpToDate()) {
                        this.application.reset();
                        mapping.config = this.application.getFilterConfig(mapping.filter);
                        mapping.instance = mapping.config.instance;
                    }
                    currentChain.filter = mapping.instance;
                    continue;
                }
                catch (InstantiationException e) {
                    throw new ServletException(e.getMessage());
                }
            }
            if (firstFilter != null) {
                while (true) {
                    if (this.filterChainCacheCount == 0) {
                        if (this.filterChainCache == null) {
                            this.filterChainCache = new EvermindFilterChain[2];
                        }
                        if (firstChain != null) {
                            this.filterChainCache[0] = firstChain;
                            this.filterChainCacheCount = 1;
                        }
                    } else {
                        if (this.filterChainCacheCount >= this.filterChainCache.length) {
                            EvermindFilterChain[] newCache = new EvermindFilterChain[this.filterChainCache.length * 2];
                            System.arraycopy(this.filterChainCache, 0, newCache, 0, this.filterChainCache.length);
                            this.filterChainCache = newCache;
                        }
                        this.filterChainCache[this.filterChainCacheCount++] = firstChain;
                    }
                    if (firstChain == currentChain) break;
                    firstChain = firstChain.next;
                }
                EvermindFilterChain returnChain = new EvermindFilterChain();
                returnChain.filter = firstFilter;
                returnChain.next = firstChain;
                return returnChain;
            }
        }
        return null;
    }

    protected void initHttpDateFormats() {
        formats = new SimpleDateFormat[3];
        EvermindHttpServletRequest.formats[0] = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        EvermindHttpServletRequest.formats[1] = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
        EvermindHttpServletRequest.formats[2] = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
    }

    protected boolean isIncluded() {
        if (this.m_currentDispatcher != null) {
            return this.m_currentDispatcher.getType() == OC4JRequestDispatcher.TYPE_INCLUDE;
        }
        return false;
    }

    protected boolean isForwarded() {
        if (this.m_currentDispatcher != null) {
            return this.m_currentDispatcher.getType() == OC4JRequestDispatcher.TYPE_FORWARD;
        }
        return false;
    }

    protected boolean isDirectCall() {
        if (this.m_currentDispatcher != null) {
            return this.m_currentDispatcher.getType() == OC4JRequestDispatcher.TYPE_DIRECT;
        }
        return true;
    }

    protected boolean isJSPRequest() {
        return this.isJSPRequest;
    }

    protected void setJSPRequest(boolean flag) {
        this.isJSPRequest = flag;
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    public String getLocalName() {
        return this.getServerName();
    }

    public int getLocalPort() {
        return this.getServerPort();
    }

    public String getLocalAddr() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    byte[] getInput(int length) {
        if (length > this.input.length) {
            byte[] newInput = new byte[length];
            System.arraycopy(this.input, 0, newInput, 0, this.input.length);
            this.input = newInput;
        }
        return this.input;
    }

    byte[] getInput() {
        return this.input;
    }

    void pushDispatcher(OC4JRequestDispatcher dispatcher) {
        this.dispatcherChain.add(dispatcher);
        this.m_currentDispatcher = dispatcher;
        this.m_isDispatcherChainEmpty = false;
    }

    void popDispatcher(OC4JRequestDispatcher dispatcher) {
        int _size = this.dispatcherChain.size();
        this.dispatcherChain.remove(--_size);
        if (_size <= 0) {
            this.m_currentDispatcher = null;
            this.m_isDispatcherChainEmpty = true;
        } else {
            this.m_currentDispatcher = (OC4JRequestDispatcher)this.dispatcherChain.get(_size - 1);
        }
    }

    OC4JRequestDispatcher getCurrentDispatcher() {
        return this.m_currentDispatcher;
    }

    OC4JRequestDispatcher getFirstDispatcher() {
        return (OC4JRequestDispatcher)this.dispatcherChain.get(0);
    }

    boolean isDispatcherChainEmpty() {
        return this.m_isDispatcherChainEmpty;
    }

    ArrayList getDispatcherChain() {
        return this.dispatcherChain;
    }

    ByteString getDispatcherRequestURIByteString() {
        return this.getCurrentDispatcher().getRequestURI();
    }

    ByteString getDispatcherContextPathByteString() {
        return this.getCurrentDispatcher().getContextPath();
    }

    ByteString getDispatcherServletPathByteString() {
        return ((ServletRequestDispatcher)this.getCurrentDispatcher()).getServletPath();
    }

    ByteString getDispatcherPathInfoByteString() {
        return this.getCurrentDispatcher().getPathInfo();
    }

    ByteString getDispatcherQueryStringByteString() {
        return this.getCurrentDispatcher().getQueryString();
    }

    public String getIncludeServletPath() {
        ByteString value = this.getDispatcherServletPathByteString();
        return value == null ? null : value.toString();
    }

    public String getIncludeRequestURI() {
        ByteString value = this.getDispatcherRequestURIByteString();
        return value == null ? null : value.toString();
    }

    public static void debugBreakpointMethod() {
        int nothing = 7;
    }

    public boolean persistentConnectionRequested() {
        String connectionValue = this.getHeader(CONNECTION_HEADER);
        return this.getVersion() < 11 ? connectionValue != null && connectionValue.equals(CONNECTION_KEEP_ALIVE) : connectionValue == null || !connectionValue.equals(CONNECTION_CLOSE);
    }

    protected boolean isPerformingFormAuth() {
        return this.isPerformingFormAuth;
    }

    public static EvermindHttpServletRequest getThreadRequest() throws ServletException {
        HttpRequestHandler handler;
        ApplicationServerThread thread = ThreadState.getInheritableCurrentState().getApplicationServerThread();
        if (thread != null && (handler = thread.httpHandler) != null) {
            return handler.request;
        }
        return null;
    }

    ByteString getFormPostBody() throws IOException {
        String contentType;
        boolean isPost;
        boolean bl = isPost = this.method == "POST";
        if (isPost && ((contentType = this.getHeader(CONTENT_TYPE_HEADER)) == null || contentType.indexOf("application/x-www-form-urlencoded") < 0)) {
            isPost = false;
        }
        if (isPost) {
            int contentLength;
            if (this.servletIn == null) {
                this.createServletInputStream();
            }
            if ((contentLength = this.getContentLength()) > 0 && this.servletIn.bytesRead == (long)contentLength) {
                return null;
            }
            if (contentLength >= 0 && this.inputStartPos + contentLength <= this.inputEndPos && this.servletIn.bytesRead == 0L) {
                this.servletIn.bytesRead += (long)contentLength;
                int start = this.inputStartPos;
                this.inputStartPos += contentLength;
                return new ByteString(this.input, start, contentLength);
            }
            if (contentLength >= 0) {
                int readThisTurn;
                byte[] target = new byte[contentLength];
                for (int readSoFar = 0; readSoFar < contentLength; readSoFar += readThisTurn) {
                    readThisTurn = this.servletIn.read(target, readSoFar, contentLength - readSoFar);
                    if (readThisTurn >= 0) continue;
                    throw new HttpIOException("Premature end of POST data");
                }
                return new ByteString(target, 0, contentLength);
            }
            byte[] target = IOUtils.getContent((InputStream)((Object)this.servletIn));
            return new ByteString(target, 0, target.length);
        }
        return null;
    }

    ParameterMap getFormAuthParameters() {
        return this.formAuthParameters;
    }

    void restoreFormAuthInfo() {
        if (this.session == null) {
            return;
        }
        this.requestURI = this.session.loginPath;
        this.queryString = this.session.loginQueryString;
        this.method = this.session.loginMethod;
        this.formAuthParameters = this.session.loginParameters;
        this.session.loginPath = null;
        this.session.loginQueryString = null;
        this.session.loginMethod = null;
        this.session.loginParameters = null;
    }

    void saveFormAuthInfo() {
        if (this.session == null) {
            return;
        }
        this.session.loginPath = (ByteString)this.requestURI.clone();
        this.session.loginQueryString = this.queryString == null ? null : (ByteString)this.queryString.clone();
        this.session.loginMethod = this.getMethod();
        try {
            this.session.loginParameters = this.parseParametersFromRequest();
            this.unsetInternalParameters();
        }
        catch (IOException e) {
            if (HTTPProperties.getHttpSessionDebug()) {
                m_traceLogger.log(Level.FINE, "Parsing Form Authentication throws Exception.", e);
            }
            this.session.loginParameters = new ParameterMap(null);
        }
    }

    static {
        INTEGER_200 = new Integer(200);
        POST_RESPONSE = "HTTP/1.1 100 Continue\r\n".getBytes();
        HEADER_SERVER_STRING = HTTPProperties.getHttpServerHeaderVersion() ? ApplicationServer.INFO : "Oracle Containers for J2EE";
        HEADER_SERVER = ("Server: " + (HTTPProperties.getHttpServerHeader() == null ? HEADER_SERVER_STRING : HTTPProperties.getHttpServerHeader()) + "\r\n").getBytes();
        ETAG_HEADER = "etag:".getBytes();
        IF_MODIFIED_SINCE_HEADER = "if-modified-since:".getBytes();
        IF_MATCH_HEADER = "if-match:".getBytes();
        IF_NONE_MATCH_HEADER = "if-none-match:".getBytes();
        IF_UNMODIFIED_SINCE_HEADER = "if-unmodified-since:".getBytes();
        IF_RANGE_HEADER = "if-range:".getBytes();
        CONNECTION_HEADER = "connection:".getBytes();
        CONTENT_TYPE_HEADER = "content-type:".getBytes();
        CONTENT_LENGTH_HEADER = "content-length:".getBytes();
        COOKIE_HEADER = "cookie:".getBytes();
        HOST_HEADER = "host:".getBytes();
        AUTHORIZATION_HEADER = "authorization:".getBytes();
        CONTENT_ENCODING_HEADER = "content-encoding:".getBytes();
        ACCEPT_CHARSET_HEADER = "accept-charset:".getBytes();
        ACCEPT_LANGUAGE_HEADER = "accept-language:".getBytes();
        CONTENT_RANGE_HEADER = "content-range:".getBytes();
        RANGE_HEADER = "range:".getBytes();
        REFERER_HEADER = "referer:".getBytes();
        ACCEPT_ENCODING_HEADER = "accept-encoding:".getBytes();
        TRANSFER_ENCODING_HEADER = "transfer-encoding:".getBytes();
        SLASH_BYTESTRING = new ByteString("/");
        SESSION_ID = "jsessionid".getBytes();
        SESSION_ID_UPPERCASE = "JSESSIONID".getBytes();
        DEBUG_REQUEST_URI = HTTPProperties.getOc4jBreakpointRequestURI();
        DEBUG_REQUEST_QUERYSTRING = HTTPProperties.getOc4jBreakpointQueryString();
        ENCODE_COOKIE = HTTPProperties.getOc4jCookieEncode();
        FORCE_USE_SESSION_COOKIE = HTTPProperties.getHttpForceUseSessioncookie();
        executeBreakpointMethods = false;
        MAX_PACKET_SIZE = HTTPProperties.getHttpPacketSize();
        m_traceLogger = TraceLogger.getLogger(EvermindHttpServletRequest.class);
        HTTP_SECURE_SCHEME = HTTPProperties.getOc4jSecureScheme();
        locales = new HashMap();
    }

    private class ComparableLocale
    implements Comparable {
        private int create_index;
        private float qValue;
        private Locale loc;

        public ComparableLocale(float q, Locale l, int i) {
            this.loc = l;
            this.qValue = q;
            this.create_index = i;
        }

        public Locale getLocale() {
            return this.loc;
        }

        public float getQValue() {
            return this.qValue;
        }

        public int getCreateIndex() {
            return this.create_index;
        }

        public int compareTo(Object o) {
            float targetQVal = ((ComparableLocale)o).getQValue();
            if (this.qValue != targetQVal) {
                return this.qValue - targetQVal > 0.0f ? 1 : -1;
            }
            return ((ComparableLocale)o).getCreateIndex() - this.create_index;
        }
    }

    private class HeaderNameEnumeration
    implements Enumeration {
        private int currentPos;
        private byte[] input;

        public HeaderNameEnumeration(byte[] input, int headerLineLength) {
            this.input = input;
            this.currentPos = headerLineLength;
        }

        public boolean hasMoreElements() {
            return this.input[this.currentPos] != 0 || this.input[this.currentPos + 1] != 0;
        }

        public Object nextElement() {
            if (this.input[this.currentPos] == 0 && this.input[this.currentPos + 1] == 0) {
                throw new NoSuchElementException();
            }
            int linePos = this.currentPos + 2;
            while (this.input[linePos++] != 58) {
            }
            String name = EvermindHttpServletRequest.this.newISOString(this.input, this.currentPos + 2, linePos - this.currentPos - 3).toUpperCase();
            this.currentPos += ((char)this.input[this.currentPos] & 0xFF) + this.input[this.currentPos + 1] * 256;
            return name;
        }
    }
}

