/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.FileRequestDispatcher;
import com.evermind.server.http.FormHttpAuthenticator;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpConnectionListener;
import com.evermind.server.http.HttpException;
import com.evermind.server.http.HttpIOException;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.NotFoundServlet;
import com.evermind.server.http.OC4JRequestDispatcher;
import com.evermind.server.http.ParameterMap;
import com.evermind.server.http.ProtectedRegion;
import com.evermind.server.http.ServletFilter;
import com.evermind.server.http.ServletInstanceInfo;
import com.evermind.server.http.ServletRequestDispatcher;
import com.evermind.util.AwareRunnable;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.PasswordAuthentication;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import oracle.dms.console.DMSConsole;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.TransTraceIntf;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.network.ServerSocketReadHandler;

public class HttpRequestHandler
extends ServerSocketReadHandler
implements AwareRunnable {
    private static final int WAIT_COUNT = 1;
    private static final ByteString SLASH_BYTESTRING = new ByteString("/");
    protected static final ByteString FORM_LOGIN_STRING = new ByteString("/j_security_check");
    private static final ByteString NOT_FOUND_SERVLET_NAME = new ByteString("com.evermind.server.http.NotFoundServlet");
    private static ServletInstanceInfo NOT_FOUND_SERVLET_INFO;
    public HttpSite[] site;
    public HttpServer server;
    public int oldStartPos = 0;
    public int oldEndPos = 0;
    public EvermindHttpServletRequest request;
    public EvermindHttpServletResponse response;
    public RequestDispatcher currentDispatcher;
    protected PhaseEventIntf processRequest;
    protected PhaseEventIntf contextProcessRequest;
    protected PhaseEventIntf parseRequest;
    private static int soTimeout;
    private static int soLinger;
    private static final int SOCKET_SEND_BUFFER_SIZE = 16384;
    private static Logger m_traceLogger;
    protected boolean errorProcRequest;
    private StringBuffer nameBuffer = new StringBuffer("HttpRequestHandler-");
    protected String oldThreadName;

    public HttpRequestHandler(HttpServer server) {
        this.server = server;
        this.request = new EvermindHttpServletRequest();
        this.request.response = this.response = new EvermindHttpServletResponse();
        this.response.request = this.request;
    }

    HttpRequestHandler() {
    }

    public void reset() {
        this.oldStartPos = 0;
        this.oldEndPos = 0;
    }

    public void run() {
        this.run(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Thread genericThread) {
        ThreadState currentThreadState = ThreadState.getInheritableCurrentState();
        try {
            currentThreadState.setInheritable(true);
            do {
                this.serveOneRequestOpen();
                this.serveOneRequest(genericThread);
                this.serveOneRequestClose();
            } while (this.loopingAgain());
        }
        catch (Throwable throwable) {
        }
        finally {
            currentThreadState.setInheritable(false);
            this.endRun(this.moreOnSocket());
        }
    }

    protected void serveOneRequestOpen() {
        this.response.resetState();
        this.request.reset();
        this.request.AJPRequest = false;
        if (ApplicationServer.DMS_GATE) {
            this.dmsBegin();
        }
        this.errorProcRequest = true;
        this.currentDispatcher = null;
        this.oldEndPos = 0;
        this.oldStartPos = 0;
    }

    protected void serveOneRequestClose() {
        if (ApplicationServer.DMS_GATE) {
            this.dmsEnd();
        }
        if (this.request.application != null && this.request.application.getComponentState() == 2) {
            this.errorProcRequest = true;
            this.checkAndStopWebApplicationIfRequired(this.request.application);
        }
        this.currentDispatcher = null;
    }

    private void dmsBegin() {
        this.processRequest = null;
        this.contextProcessRequest = null;
        DMSConsole cons = ApplicationServer.dmsConsole;
        TransTraceIntf ttFactory = cons.getTransTrace();
        ttFactory.requestStart();
    }

    private void dmsEnd() {
        DMSConsole cons = ApplicationServer.dmsConsole;
        TransTraceIntf ttFactory = cons.getTransTrace();
        ttFactory.requestStop();
    }

    private void dmsProcRequestDone(boolean successful) {
        if (successful) {
            if (this.contextProcessRequest != null) {
                this.contextProcessRequest.stop(this.request.startParseToken);
            }
            if (this.processRequest != null) {
                this.processRequest.stop(this.request.startParseToken);
            }
        } else {
            if (this.contextProcessRequest != null) {
                this.contextProcessRequest.abort(this.request.startParseToken);
            }
            if (this.processRequest != null) {
                this.processRequest.abort(this.request.startParseToken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serveOneRequest(Thread thread) {
        try {
            block23: {
                block21: {
                    boolean bl;
                    block22: {
                        OutputStream out = this.getOutputStream();
                        InputStream in = this.getInputStream();
                        if (ApplicationServer.DMS_GATE) {
                            this.request.startParseToken = ApplicationServer.phaseEventFactory().getToken();
                        }
                        try {
                            try {
                                if (!this.request.init(in, out, this.site, this.oldStartPos, this.oldEndPos)) {
                                    Object var7_5 = null;
                                    if (ApplicationServer.DMS_GATE) {
                                        this.dmsProcRequestDone(!this.errorProcRequest);
                                    }
                                    if (this.errorProcRequest) break block21;
                                    bl = !this.response.keepAlive;
                                    break block22;
                                }
                                if (ApplicationServer.DMS_GATE) {
                                    this.request.stopParseToken = ApplicationServer.phaseEventFactory().getToken();
                                }
                                ++this.request.site.hitsLastMinute;
                                if (this.processRequest((ApplicationServerThread)thread, this.request, this.response, in, out, false)) {
                                    this.errorProcRequest = false;
                                }
                                break block23;
                            }
                            catch (HttpException e) {
                                if (HTTPProperties.getHttpErrorDebug()) {
                                    m_traceLogger.log(Level.FINE, "Exception: ", e);
                                }
                                try {
                                    this.handleHttpException(this.request, this.response, e);
                                }
                                catch (Throwable e2) {
                                }
                                Object var7_7 = null;
                                if (ApplicationServer.DMS_GATE) {
                                    this.dmsProcRequestDone(!this.errorProcRequest);
                                }
                                if (!this.errorProcRequest) {
                                    this.errorProcRequest = !this.response.keepAlive;
                                }
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            if (ApplicationServer.DMS_GATE) {
                                this.dmsProcRequestDone(!this.errorProcRequest);
                            }
                            if (!this.errorProcRequest) {
                                this.errorProcRequest = !this.response.keepAlive;
                            }
                            return;
                        }
                    }
                    this.errorProcRequest = bl;
                }
                return;
            }
            Object var7_6 = null;
            if (ApplicationServer.DMS_GATE) {
                this.dmsProcRequestDone(!this.errorProcRequest);
            }
            if (!this.errorProcRequest) {
                this.errorProcRequest = !this.response.keepAlive;
            }
            return;
        }
        catch (Throwable e) {
            if (HTTPProperties.getHttpErrorDebug()) {
                m_traceLogger.log(Level.FINE, "Exception: ", e);
            }
            return;
        }
    }

    protected boolean loopingAgain() {
        return false;
    }

    protected boolean moreOnSocket() {
        return !this.errorProcRequest;
    }

    protected void pushThreadName(Thread thread) {
        String oldThreadName = thread.getName();
        this.nameBuffer.append(thread.hashCode());
        thread.setName(this.nameBuffer.toString());
    }

    protected void popThreadName() {
        Thread.currentThread().setName(this.oldThreadName);
    }

    public void bindThread() throws Exception {
        ApplicationServerThread thread = (ApplicationServerThread)Thread.currentThread();
        thread.httpHandler = this;
        this.response.preset(this.getOutputStream());
    }

    public void unbindThread() {
        ApplicationServerThread thread = (ApplicationServerThread)Thread.currentThread();
        thread.httpHandler = null;
        this.request.application = null;
        thread.state.reset();
    }

    public HttpConnectionListener getMyListener() {
        return ((HttpConnectionListener.HttpNIOAcceptHandler)this.getAcceptHandler()).getListener();
    }

    public void bindSocket() throws Exception {
        this.setSocketOptions();
        this.site = this.getMyListener().sites;
        this.request.preset(this.getSocket());
    }

    public void unbindSocket() {
        this.request.preset(null);
        this.site = null;
    }

    protected void setSocketOptions() throws IOException {
        this.getSocket().setTcpNoDelay(true);
        if (soLinger >= 0) {
            this.getSocket().setSoLinger(true, soLinger);
        }
        this.setSendBufferSize();
        this.setRecvBufferSize();
    }

    protected void setSendBufferSize() throws IOException {
        int sendBufferSize = HTTPProperties.getHttpSocketSendBufferSize();
        if (sendBufferSize > 0) {
            this.getSocket().setSendBufferSize(sendBufferSize);
        } else if (this.getSocket().getSendBufferSize() < 16384) {
            HTTPProperties.setHttpSocketSendBufferSize(16384);
            this.getSocket().setSendBufferSize(16384);
        }
    }

    protected void setRecvBufferSize() throws IOException {
        int recvBufferSize = HTTPProperties.getHttpSocketRecvBufferSize();
        if (recvBufferSize > 0) {
            this.getSocket().setReceiveBufferSize(recvBufferSize);
        }
    }

    private void resolveApplication(OutputStream out) throws IOException {
        if (this.request.application != null) {
            return;
        }
        try {
            HttpApplication httpApplication = this.request.site.getApplication(this.request.requestURI);
            if (httpApplication == null) {
                PrintWriter errorWriter = new PrintWriter((Writer)new OutputStreamWriter(out), false);
                errorWriter.println("HTTP/1.1 404 Not Found");
                errorWriter.println("Content-Type: text/html");
                errorWriter.println();
                errorWriter.println("<html><head><title>error while accessing web-application. </title></head><body><h1>Error accessing web-application. Check if application is in stopped state</h1></body></html>");
                errorWriter.flush();
                errorWriter.close();
                out.close();
                throw new IOException();
            }
            this.request.application = httpApplication;
        }
        catch (InstantiationException e) {
            PrintWriter errorWriter = new PrintWriter((Writer)new OutputStreamWriter(out), false);
            errorWriter.println("HTTP/1.1 500 Internal Server Error");
            errorWriter.println("Content-Type: text/html");
            errorWriter.println();
            errorWriter.println("<html><head><title>Error instantiating web-application</title></head><body><h1>Error instantiating web-application</h1>" + EvermindHttpServletResponse.markupEncode(e.getMessage()) + "</body></html>");
            errorWriter.flush();
            errorWriter.close();
            out.close();
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRequest(ApplicationServerThread thread, EvermindHttpServletRequest request, EvermindHttpServletResponse response, InputStream in, OutputStream out, boolean inMainThread) throws IOException, ServletException, InstantiationException {
        if (request.application == null) {
            this.resolveApplication(out);
        }
        HttpApplication httpApplication = request.application;
        boolean result = false;
        try {
            httpApplication.incrementReqCount();
            result = this.doProcessRequest(thread, request, response, in, out, inMainThread);
            Object var10_9 = null;
            EvermindHttpSession session = request.getCurrentSession();
            if (session != null) {
                EvermindHttpSession oc4jSession = session;
                oc4jSession.endRequest();
            }
            httpApplication.decrementReqCount();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            EvermindHttpSession session = request.getCurrentSession();
            if (session != null) {
                EvermindHttpSession oc4jSession = session;
                oc4jSession.endRequest();
            }
            httpApplication.decrementReqCount();
            throw throwable;
        }
        return result;
    }

    private boolean checkForWebOrMetaInf(byte[] data, int index, int end) {
        if (end - index < 8) {
            return false;
        }
        if (!(data[index] != 47 || data[index + 1] != 87 && data[index + 1] != 119 || data[index + 2] != 69 && data[index + 2] != 101 || data[index + 3] != 66 && data[index + 3] != 98 || data[index + 4] != 45 || data[index + 5] != 73 && data[index + 5] != 105 || data[index + 6] != 78 && data[index + 6] != 110 || data[index + 7] != 70 && data[index + 7] != 102 || end - index != 8 && data[index + 8] != 47)) {
            return true;
        }
        if (end - index < 9) {
            return false;
        }
        return !(data[index] != 47 || data[index + 1] != 77 && data[index + 1] != 109 || data[index + 2] != 69 && data[index + 2] != 101 || data[index + 3] != 84 && data[index + 3] != 116 || data[index + 4] != 65 && data[index + 4] != 97 || data[index + 5] != 45 || data[index + 6] != 73 && data[index + 6] != 105 || data[index + 7] != 78 && data[index + 7] != 110 || data[index + 8] != 70 && data[index + 8] != 102 || end - index != 9 && data[index + 9] != 47);
    }

    protected boolean checkForWebOrMetaInf(ByteString requestURI) {
        byte[] data = requestURI.data;
        int start = requestURI.offset;
        int end = start + requestURI.length;
        if (this.checkForWebOrMetaInf(data, start, end)) {
            return true;
        }
        for (int pos = start + 2; pos < end; ++pos) {
            if (data[pos - 1] >= 0 && data[pos - 2] >= 0 && (data[pos - 1] != 46 || data[pos - 2] != 46) || !this.checkForWebOrMetaInf(data, pos, end)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doProcessRequest(ApplicationServerThread thread, EvermindHttpServletRequest request, EvermindHttpServletResponse response, InputStream in, OutputStream out, boolean inMainThread) throws IOException, ServletException, InstantiationException {
        block83: {
            if (EvermindHttpServletRequest.executeBreakpointMethods) {
                EvermindHttpServletRequest.debugBreakpointMethod();
            }
            long resolveContextToken = 0L;
            if (ApplicationServer.DMS_GATE) {
                resolveContextToken = ApplicationServer.phaseEventFactory().getToken();
            }
            if (request.application.root != null && !request.requestURI.startsWith(request.application.root) && request.site.getDefaultApplication() != request.application) {
                request.inApplicationContext = false;
                this.handleNotFound(request, response);
                response.close();
                return true;
            }
            request.inApplicationContext = true;
            if (ApplicationServer.DMS_GATE && !request.AJPRequest) {
                PhaseEventIntf resolveContext = request.application.getResolveContextMetric();
                resolveContext.start(resolveContextToken);
                resolveContext.stop(resolveContextToken);
                resolveContext = null;
                this.processRequest = request.application.getProcessRequestMetric();
                this.processRequest.start(request.startParseToken);
                this.contextProcessRequest = request.application.getContextProcessRequestMetric();
                this.contextProcessRequest.start(request.startParseToken);
                this.parseRequest = request.application.getParseRequestMetric();
                this.parseRequest.start(request.startParseToken);
                this.parseRequest.stop(request.startParseToken, request.stopParseToken);
                this.parseRequest = null;
            }
            if (request.application.root != null && !request.isContextRootRemovedInURI && request.requestURI.startsWith(request.application.root)) {
                request.requestURI.offset += request.application.root.length;
                request.requestURI.length -= request.application.root.length;
                request.isContextRootRemovedInURI = true;
            }
            ByteString requestURI = request.requestURI;
            if (requestURI.length >= 8 && this.checkForWebOrMetaInf(requestURI)) {
                try {
                    thread.httpHandler = this;
                    this.handleNotFound(request, response);
                    if (request.method == "POST" || request.method == "PUT") {
                        request.inputFetchStatus = 0;
                        request.getInputStream();
                        request.servletIn.empty();
                    }
                    if (response.getCurrentWriter() != null) {
                        response.writer.flush();
                    }
                    if (!response.out.closed) {
                        response.out.closeFinally();
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    thread.httpHandler = null;
                }
            }
            if (response.out.bufferLength != request.application.responseBufferSize) {
                response.setBufferSize(request.application.responseBufferSize);
            }
            thread.httpHandler = this;
            if (this.currentDispatcher == null && request.application.accessRegion != null && !request.application.accessRegion.allow("http", this.getSocket().getInetAddress())) {
                response.sendError(403, "Access forbidden from this IP/hostname");
            } else {
                boolean handledByFilter = false;
                boolean patchDispatcher = false;
                ParameterMap _originalParameters = null;
                boolean formAuthClientSideRedirectSent = false;
                if (this.currentDispatcher == null) {
                    if (request.requestURI.endsWith(FORM_LOGIN_STRING)) {
                        boolean wasLogin;
                        EvermindHttpSession session = (EvermindHttpSession)request.getSession(true);
                        request.parseFormAuthParameters();
                        boolean bl = wasLogin = (session.status & 1) != 0;
                        if (wasLogin) {
                            session.status &= 0xFFFFFFFE;
                            PasswordAuthentication authentication = FormHttpAuthenticator.getDefaultAuthentication(request);
                            ByteString referer = request.getByteHeader(EvermindHttpServletRequest.REFERER_HEADER);
                            if (session.loginPath != null && wasLogin) {
                                session.status &= 0xFFFFFFFD;
                                if (request.getInternalParameter("j_username") != null) {
                                    session.status |= 2;
                                }
                                request.isPerformingFormAuth = true;
                                FilterChain filterChain = request.getFilter(null, null);
                                try {
                                    if (filterChain != null) {
                                        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                                    }
                                }
                                catch (Exception e) {
                                    request.application.log(e, "Attempted to execute form auth filter");
                                }
                                request.isPerformingFormAuth = false;
                                request.isContextRootRemovedInURI = false;
                                patchDispatcher = true;
                                request.restoreFormAuthInfo();
                                _originalParameters = request.getFormAuthParameters();
                            } else if (referer != null) {
                                int questionIndex = referer.indexOf('?');
                                if (questionIndex > 0) {
                                    referer = referer.substring(0, questionIndex);
                                }
                                if (referer != null) {
                                    request.requestURI = request.requestURI.concat(referer.substring(referer.lastIndexOf('/') + 1));
                                }
                            } else {
                                request.requestURI = request.requestURI.substring(0, request.requestURI.lastIndexOf('/') + 1);
                            }
                            if (HTTPProperties.getFormAuthClientSideRedirect() && request.checkAndSetRemoteUser(authentication)) {
                                String locationURL = request.getRequestURI();
                                if (request.queryString != null && request.queryString.length() > 0) {
                                    locationURL = locationURL + "?" + request.queryString;
                                }
                                if (request.getRequestURI().endsWith(FORM_LOGIN_STRING.toString())) {
                                    response.sendRedirect(this.getParsedRequestURI(request.getRequestURI(), request.requestURI.toString()));
                                } else {
                                    response.sendRedirect(locationURL);
                                }
                                formAuthClientSideRedirectSent = true;
                            }
                        }
                    }
                    if (!formAuthClientSideRedirectSent) {
                        block82: {
                            PhaseEventIntf resolveServletEvent = null;
                            boolean resolvedServlet = false;
                            long resolveServletToken = 0L;
                            try {
                                Object var20_36;
                                try {
                                    if (ApplicationServer.DMS_GATE) {
                                        resolveServletEvent = request.application.getResolveServletMetric();
                                        resolveServletToken = resolveServletEvent.start();
                                    }
                                    if (EvermindHttpServletRequest.executeBreakpointMethods) {
                                        EvermindHttpServletRequest.debugBreakpointMethod();
                                    }
                                    this.currentDispatcher = request.application.getRequestDispatcher(request.requestURI, request, response);
                                    if (this.currentDispatcher instanceof OC4JRequestDispatcher && patchDispatcher) {
                                        OC4JRequestDispatcher dispatcher = (OC4JRequestDispatcher)this.currentDispatcher;
                                        dispatcher.setQueryString(request.queryString);
                                        dispatcher.setParameters(_originalParameters);
                                        dispatcher.setParametersParsed(true);
                                    }
                                    if (ApplicationServer.DMS_GATE) {
                                        resolveServletEvent.stop(resolveServletToken);
                                        resolveServletEvent = null;
                                    }
                                    resolvedServlet = true;
                                }
                                catch (SecurityException e) {
                                    handledByFilter = true;
                                    var20_36 = null;
                                    if (!resolvedServlet && resolveServletEvent != null) {
                                        ((PhaseEvent)resolveServletEvent).abort(resolveServletToken);
                                    }
                                    break block82;
                                }
                                catch (ServletException e) {
                                    response.handleException(e, request);
                                    handledByFilter = true;
                                    var20_36 = null;
                                    if (!resolvedServlet && resolveServletEvent != null) {
                                        ((PhaseEvent)resolveServletEvent).abort(resolveServletToken);
                                    }
                                    break block82;
                                }
                                var20_36 = null;
                                if (resolvedServlet || resolveServletEvent == null) break block82;
                            }
                            catch (Throwable throwable) {
                                Object var20_37 = null;
                                if (resolvedServlet) throw throwable;
                                if (resolveServletEvent == null) throw throwable;
                                ((PhaseEvent)resolveServletEvent).abort(resolveServletToken);
                                throw throwable;
                            }
                            ((PhaseEvent)resolveServletEvent).abort(resolveServletToken);
                        }
                        if (request.application.accessController != null && !handledByFilter) {
                            try {
                                request.application.accessController.service((ServletRequest)request, (ServletResponse)response);
                            }
                            catch (Throwable t) {
                                if (t instanceof HttpIOException) {
                                    throw (IOException)t;
                                }
                                if (!(t instanceof SecurityException)) {
                                    request.application.log("Error in access-controller", t);
                                }
                                ProtectedRegion region = request.application.getProtectedRegion(request.requestURI, request.method);
                                request.application.authenticator.reject(request, response, 2);
                            }
                        }
                        if (request.application.orionFilter != null && !handledByFilter) {
                            ByteString requestURI2 = request.requestURI;
                            for (int i = 0; i < request.application.orionFilter.length; ++i) {
                                ServletFilter filter = request.application.orionFilter[i];
                                try {
                                    if ((filter.prefix == null || requestURI2.startsWith(filter.prefix)) && (filter.suffix == null || requestURI2.endsWith(filter.suffix))) {
                                        filter.info.servlet.service((ServletRequest)request, (ServletResponse)response);
                                    }
                                }
                                catch (Throwable t) {
                                    response.handleException(t);
                                    handledByFilter = true;
                                }
                                if (response.out.bytesWritten <= 0 && response.status == 0 && response.out.out == null) continue;
                                handledByFilter = true;
                            }
                        }
                    }
                }
                if (!formAuthClientSideRedirectSent && !handledByFilter) {
                    if (this.currentDispatcher != null) {
                        if (inMainThread) {
                            if (!(this.currentDispatcher instanceof FileRequestDispatcher)) {
                                return false;
                            }
                            FileRequestDispatcher fileDispatcher = (FileRequestDispatcher)this.currentDispatcher;
                            if (fileDispatcher.fileInformation == null) {
                                return false;
                            }
                        }
                        try {
                            if (EvermindHttpServletRequest.executeBreakpointMethods) {
                                EvermindHttpServletRequest.debugBreakpointMethod();
                            }
                            if (this.currentDispatcher instanceof FileRequestDispatcher) {
                                ((FileRequestDispatcher)this.currentDispatcher).forwardInternal((ServletRequest)request, response);
                                break block83;
                            }
                            if (this.currentDispatcher instanceof ServletRequestDispatcher) {
                                ((ServletRequestDispatcher)this.currentDispatcher).forwardInternal((ServletRequest)request, response);
                                break block83;
                            }
                            this.currentDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                        }
                        catch (Throwable t) {
                            response.handleException(t);
                        }
                    } else if (request.requestURI.endsWith(FORM_LOGIN_STRING)) {
                        ByteString referer = request.getByteHeader(EvermindHttpServletRequest.REFERER_HEADER);
                        if (referer != null) {
                            response.sendRedirect(referer.toString());
                        } else {
                            this.handleNotFound(request, response);
                        }
                    } else {
                        if (request.site != null && request.application == null) {
                            try {
                                request.application = request.site.getDefaultApplication();
                            }
                            catch (InstantiationException e) {
                                response.handleException(e);
                            }
                        }
                        this.handleNotFound(request, response);
                    }
                }
            }
        }
        response.close();
        while (response.chainingHandler != null) {
            byte[] data = ((ByteArrayOutputStream)response.out.out).toByteArray();
            request.in = new ByteArrayInputStream(data);
            request.servletIn = null;
            if (request.servletPath == null) {
                request.servletPath = request.requestURI;
            }
            request.servletInReader = null;
            request.contentLength = data.length;
            request.contentType = response.contentType;
            response.contentLength = -1;
            response.outputFetchStatus = 0;
            response.resetPrintWriter();
            response.committed = false;
            response.contentType = null;
            response.out.reset(response);
            ServletInstanceInfo handler = response.chainingHandler;
            response.chainingHandler = null;
            ContextContainer previousContainer = thread.state.contextContainer;
            try {
                thread.state.contextContainer = request.application;
                handler.servlet.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (Throwable t) {
                if (t instanceof HttpIOException) {
                    throw (IOException)t;
                }
                response.chainingHandler = null;
                response.contentType = "text/html";
                response.handleException(t);
            }
            finally {
                thread.state.contextContainer = previousContainer;
            }
            response.close();
        }
        this.updateAccessLog(request, response);
        if (request.method == "POST" || request.method == "PUT" || request.getContentLength() > 0 || request.isChunkedEncoding()) {
            request.inputFetchStatus = 0;
            request.getInputStream();
        }
        if (request.servletIn != null) {
            request.servletIn.empty();
        }
        this.oldStartPos = request.inputStartPos;
        this.oldEndPos = request.inputEndPos;
        thread.httpHandler = null;
        this.currentDispatcher = null;
        return true;
    }

    private String getParsedRequestURI(String unparsedRequestURIForSecCheck, String flatRequestURI) {
        String firstPart = unparsedRequestURIForSecCheck.substring(0, unparsedRequestURIForSecCheck.indexOf(FORM_LOGIN_STRING.toString()));
        return firstPart + flatRequestURI;
    }

    private void handleNotFound(EvermindHttpServletRequest request, EvermindHttpServletResponse response) throws IOException {
        try {
            HttpApplication app = request.application;
            if (app.filterMappings == null && app.securityFilter == null) {
                NotFoundServlet.sendNotFound(request, response);
            } else {
                ServletRequestDispatcher dispatcher = ServletRequestDispatcher.getDispatcher(app);
                dispatcher.requestURI = request.requestURI;
                dispatcher.servletPath = request.requestURI;
                dispatcher.queryString = request.queryString;
                if (NOT_FOUND_SERVLET_INFO == null) {
                    NOT_FOUND_SERVLET_INFO = app.findServlet(NOT_FOUND_SERVLET_NAME, true);
                }
                dispatcher.info = NOT_FOUND_SERVLET_INFO;
                dispatcher.forwardInternal((ServletRequest)request, response);
            }
        }
        catch (Throwable t) {
            response.handleException(t);
        }
    }

    private void updateAccessLog(EvermindHttpServletRequest request, EvermindHttpServletResponse response) {
        if (request.site.requestLogger != null && request.application.isAccessLog) {
            try {
                request.site.requestLogger.log(request, response);
            }
            catch (Throwable e) {
                try {
                    m_traceLogger.log(Level.SEVERE, "OC4J cannot update access log: " + e.getMessage(), e);
                }
                catch (Throwable e2) {
                    System.err.println("OC4J cannot update access log: " + e.getMessage() + "; cannot update the trace log: " + e2.getMessage());
                }
            }
        }
    }

    public static String textToHTML(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
        StringBuffer result = new StringBuffer();
        while (tokenizer.hasMoreElements()) {
            result.append(tokenizer.nextToken());
            result.append("<BR>\r\n");
        }
        return result.toString();
    }

    public void handleHttpException(EvermindHttpServletRequest request, EvermindHttpServletResponse response, HttpException e) throws IOException {
        if (!response.committed) {
            request.site = this.site[this.site.length - 1];
            try {
                request.application = request.site.getDefaultApplication();
            }
            catch (InstantiationException ie) {
                request.site.log("Error initializing default application: " + ie.getMessage());
            }
            request.requestURI.data = HttpRequestHandler.SLASH_BYTESTRING.data;
            request.requestURI.offset = HttpRequestHandler.SLASH_BYTESTRING.offset;
            request.requestURI.length = HttpRequestHandler.SLASH_BYTESTRING.length;
            response.sendError(e.getStatusCode());
        }
    }

    private void checkAndStopWebApplicationIfRequired(HttpApplication httpApplication) {
        if (httpApplication == null) {
            return;
        }
        if (httpApplication.getComponentState() == 2 && httpApplication.getHttpReqCount() == 0) {
            httpApplication.stopCleanUp(httpApplication.application.getAppComponentList());
        }
    }

    static {
        soTimeout = HTTPProperties.getHttpSocketTimeout();
        soLinger = HTTPProperties.getHttpSocketLinger();
        m_traceLogger = TraceLogger.getLogger(HttpRequestHandler.class);
    }
}

