/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.security.User;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationStateStopped;
import com.evermind.server.Lock;
import com.evermind.server.OC4JMonitorThread;
import com.evermind.server.OC4JServer;
import com.evermind.server.Refreshable;
import com.evermind.server.Server;
import com.evermind.server.ServerMessages;
import com.evermind.server.ThreadState;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationConfigContext;
import com.evermind.server.http.HttpApplicationDestroyer;
import com.evermind.server.http.HttpApplicationReference;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.http.HttpMessages;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSiteConfig;
import com.evermind.server.http.ODLRequestLogger;
import com.evermind.server.http.RequestLogger;
import com.evermind.server.http.XMLHttpSiteConfig;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.Base64Utils;
import com.evermind.util.ByteString;
import com.evermind.util.ErrorHandler;
import com.evermind.util.HTTPProperties;
import com.evermind.util.LogEvent;
import com.evermind.util.ObjectUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import oracle.classloader.util.ArrayUtils;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEAJPWebSiteCallBackIf;
import oracle.oc4j.admin.management.shared.OHSRoutingInfo;
import oracle.oc4j.admin.management.shared.WebBinding;
import oracle.oc4j.admin.management.shared.WebSiteAccessLog;
import oracle.oc4j.admin.management.shared.WebSiteODLAccessLog;

public class HttpSite
extends Server
implements Comparable,
J2EEAJPWebSiteCallBackIf,
Refreshable {
    HttpSiteConfig config;
    String beansClasspath;
    boolean sendETag = HTTPProperties.getHttpSendEtag();
    RequestLogger requestLogger;
    boolean checkServletProperties;
    protected long userApplicationMaxInactivityTime;
    public boolean useKeepAlives;
    boolean logRequestInfo;
    final HttpServer server;
    protected HttpApplicationRunTimeReference[] runTimeReferences;
    protected int runTimeReferencesArrLen = 0;
    protected volatile HashMap contextCache = new HashMap();
    private static final int DEFAULT_ELEMENT_IDX = 0;
    InetAddress address;
    InetAddress particularAddress;
    private String addressString;
    int boundToPort;
    int posingAsPort;
    ByteString host;
    ByteString[] hostNameHeader;
    boolean secure;
    protected Map userApplications;
    public int hits;
    public int hitsLastHourPrevious;
    public int hitsLastHour;
    public int hitsLastMinutePrevious;
    public int hitsLastMinute;
    public long startTime = System.currentTimeMillis();
    public int requestMaxSize;
    private int state_ = 1;
    private String _shortName = null;
    public static final Comparator COMPARATOR_ADDRESS = new Comparator(){

        public int compare(Object a, Object b) {
            HttpSite siteA = (HttpSite)a;
            HttpSite siteB = (HttpSite)b;
            if (siteA.address == null) {
                if (siteB.address == null) {
                    return siteA.boundToPort - siteB.boundToPort;
                }
                return 1;
            }
            if (siteB.address == null) {
                if (siteA.address == null) {
                    return siteA.boundToPort - siteB.boundToPort;
                }
                return -1;
            }
            if (!siteA.address.equals(siteB.address)) {
                return siteA.address.getHostName().compareTo(siteB.address.getHostName());
            }
            return siteA.boundToPort - siteB.boundToPort;
        }
    };
    protected byte[] cookieSuffix;

    public HttpSite(HttpServer server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpApplication getHttpApplication(String applicationName, String name) {
        HttpApplication httpApplication;
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
            }
        }
        catch (Throwable throwable) {
            destroyLock.unlock();
            throw throwable;
        }
        {
            for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                HttpApplication httpApplication2;
                HttpApplicationReference reference = this.runTimeReferences[i].getHttpApplicationReference();
                if (!reference.getApplicationName().equals(applicationName) || !reference.getHttpApplicationName().equals(name)) continue;
                try {
                    httpApplication2 = this.runTimeReferences[i].getHttpApplication();
                }
                catch (InstantiationException e) {
                    HttpApplication httpApplication3 = null;
                    // MONITOREXIT @DISABLED, blocks:[6, 7, 9] lbl18 : MonitorExitStatement: MONITOREXIT : var4_4
                    destroyLock.unlock();
                    return httpApplication3;
                }
                HttpApplication httpApplication4 = httpApplication2;
                // MONITOREXIT @DISABLED, blocks:[6, 9] lbl22 : MonitorExitStatement: MONITOREXIT : var4_4
                destroyLock.unlock();
                return httpApplication4;
            }
            httpApplication = null;
        }
        destroyLock.unlock();
        return httpApplication;
    }

    private void persistApplication(HttpApplication app) {
        if (app != null && !app.isClustered()) {
            try {
                app.persist();
            }
            catch (IOException ex) {
                if (HTTPProperties.getHttpClusterDebug() || HTTPProperties.getHttpSessionDebug()) {
                    app.logAndPrint("Error persisting sessions", ex);
                }
                app.log("Error persisting sessions", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist() {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    try {
                        this.persistApplication(this.runTimeReferences[i].getHttpApplication());
                        continue;
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public void setConfig(HttpSiteConfig config) throws InstantiationException {
        HttpMessages.infoHttpSiteStarting(config.getName());
        this.persist();
        super.setConfig(config);
        this.requestMaxSize = config.getRequestMaxSize();
        if (config.getIslandID() >= 0) {
            int pos;
            this.cookieSuffix = new byte[9];
            byte[] addressBytes = config.getAddress().getAddress();
            int addressInt = (addressBytes[3] << 24) + (addressBytes[2] << 16) + (addressBytes[1] << 8) + addressBytes[0];
            if (addressInt == 0) {
                throw new InstantiationException("Cannot use host=\"[ALL]|0.0.0.0\" when using cluster-island=\"x\", a specific public IP/hostname for the balancer to connect to must be supplied");
            }
            for (pos = 0; pos < 6; ++pos) {
                this.cookieSuffix[pos] = ObjectUtils.toByte(Base64Utils.getCharacter(addressInt & 0x3F));
                addressInt >>= 6;
            }
            addressInt = config.getPort();
            while (pos < 9) {
                this.cookieSuffix[pos] = ObjectUtils.toByte(Base64Utils.getCharacter(addressInt & 0x3F));
                addressInt >>= 6;
                ++pos;
            }
            for (int i = 0; i < 9; ++i) {
                if (this.cookieSuffix[i] == 43) {
                    this.cookieSuffix[i] = 45;
                    continue;
                }
                if (this.cookieSuffix[i] != 47) continue;
                this.cookieSuffix[i] = 95;
            }
        }
        this.config = config;
        this.useKeepAlives = config.getUseKeepAlives();
        this.secure = config.isSecure();
        this.userApplicationMaxInactivityTime = config.getUserApplicationMaxInactivityTime();
        this.address = config.getAddress();
        this.host = new ByteString(this.address.getHostName());
        this.logRequestInfo = config.getLogRequestInfo();
        List headers = config.getHostNameHeaders();
        if (headers.size() > 0) {
            this.hostNameHeader = new ByteString[headers.size()];
            for (int i = 0; i < headers.size(); ++i) {
                this.hostNameHeader[i] = new ByteString((String)headers.get(i));
            }
        } else {
            this.hostNameHeader = null;
        }
        if (config.getPosingAsHostname() != null) {
            this.host = new ByteString(config.getPosingAsHostname());
        } else if (this.hostNameHeader != null) {
            this.host = this.hostNameHeader[0];
        } else if (this.address != null) {
            this.host = new ByteString(this.address.getHostName());
        }
        this.addressString = this.address.getHostAddress();
        this.initSSLProperties();
        this.requestLogger = config.getRequestLogger();
        if (this.requestLogger != null) {
            this.requestLogger.setErrorLogger(config.getLogger());
        }
        this.boundToPort = config.getPort();
        this.posingAsPort = config.getPosingAsPort() > 0 ? config.getPosingAsPort() : this.boundToPort;
        this.initApplications();
        HttpMessages.infoHttpSiteStarted(config.getName());
    }

    public String getHost() {
        if (this.host == null) {
            return null;
        }
        return this.host.toString();
    }

    public ApplicationServer getApplicationServer() {
        return this.server.getApplicationServer();
    }

    public void log(String message, Throwable t, EvermindHttpServletRequest request) {
        if (request == null) {
            try {
                request = ThreadState.getInheritableCurrentState().getApplicationServerThread().httpHandler.request;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (request != null && this.logRequestInfo) {
            StringBuffer requestInfoBuffer = new StringBuffer();
            requestInfoBuffer.append("\r\n\r\nRequest information:\r\n");
            requestInfoBuffer.append(request.getHeadersFormatted());
            requestInfoBuffer.append("\r\n");
            message = message + requestInfoBuffer.toString();
        }
        if (t == null) {
            this.logger.log(new LogEvent(message));
        } else {
            this.logger.log(new LogEvent(message, t));
        }
    }

    /*
     * Exception decompiling
     */
    public RequestDispatcher getRequestDispatcher(HttpApplication from, ByteString path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 12[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final HttpApplication getApplication(ByteString path) throws InstantiationException {
        Lock destroyLock;
        HttpApplication httpApplication;
        block17: {
            HashMap<Object, HttpApplication> newcontextCache;
            int slashPos;
            HttpApplication userApplication;
            if (path.length > 2 && path.charAt(1) == '~' && (userApplication = (slashPos = path.indexOf('/', 2)) < 0 ? this.getUserApplication(path.substring(2)) : this.getUserApplication(path.substring(2, slashPos))) != null) {
                userApplication.used = true;
                return userApplication;
            }
            httpApplication = (HttpApplication)this.contextCache.get(path);
            if (httpApplication != null) {
                return httpApplication;
            }
            destroyLock = this.getApplicationServer().getDestroyLock().readLock();
            destroyLock.lock();
            try {
                HttpSite httpSite = this;
                // MONITORENTER : httpSite
                ApplicationServer applicationServer = this.server.getApplicationServer();
                // MONITORENTER : applicationServer
                int applicationIndex = 0;
                for (int i = 1; i < this.runTimeReferencesArrLen; ++i) {
                    ByteString contextRoot = this.runTimeReferences[i].getHttpApplicationContextRoot();
                    if (path.startsWith(contextRoot) && (path.length == contextRoot.length || path.data[path.offset + contextRoot.length] == 47)) {
                        applicationIndex = i;
                        break;
                    }
                    if (applicationIndex != 0 || !path.startsWith(contextRoot) || !contextRoot.equals("/")) continue;
                    applicationIndex = i;
                }
                if (applicationIndex <= 0) break block17;
                httpApplication = this.runTimeReferences[applicationIndex].getHttpApplication(true);
                newcontextCache = null;
                int maxFileInfoCacheEntries = HTTPProperties.getMaxFileInfoCacheEntries();
                if (0 < maxFileInfoCacheEntries && maxFileInfoCacheEntries < this.contextCache.size()) {
                    newcontextCache = new HashMap<Object, HttpApplication>();
                } else {
                    if (-1 >= maxFileInfoCacheEntries) {
                        this.runTimeReferences[applicationIndex].getHttpApplication().used = true;
                        HttpApplication httpApplication2 = httpApplication;
                        // MONITOREXIT : applicationServer
                        // MONITOREXIT : httpSite
                        destroyLock.unlock();
                        return httpApplication2;
                    }
                    newcontextCache = new HashMap(this.contextCache);
                }
                newcontextCache.put(path.clone(), httpApplication);
            }
            catch (Throwable throwable) {
                destroyLock.unlock();
                throw throwable;
            }
            this.contextCache = newcontextCache;
            this.runTimeReferences[applicationIndex].getHttpApplication().used = true;
            HttpApplication httpApplication3 = httpApplication;
            // MONITOREXIT : applicationServer
            // MONITOREXIT : httpSite
            destroyLock.unlock();
            return httpApplication3;
        }
        httpApplication = this.runTimeReferences[0].getHttpApplication(true);
        this.runTimeReferences[0].getHttpApplication().used = true;
        HttpApplication httpApplication4 = httpApplication;
        // MONITOREXIT : applicationServer
        // MONITOREXIT : httpSite
        destroyLock.unlock();
        return httpApplication4;
    }

    private HttpApplication getUserApplication(ByteString username) {
        if (this.userApplications == null) {
            this.userApplications = new HashMap();
        }
        Map map = this.userApplications;
        synchronized (map) {
            HttpApplication application = (HttpApplication)this.userApplications.get(username);
            if (application != null) {
                return this.checkForUserApplicationUpdates(application);
            }
            try {
                HttpApplicationConfigContext configContext = this.config.getUserApplication(username.toString());
                if (configContext == null) {
                    return null;
                }
                application = new HttpApplication(this.server.getApplicationServer().getDefaultApplication(), this, configContext.getConfiguration(), "/~" + username, "<user-app>", false);
                this.userApplications.put(username, application);
                return application;
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpApplication checkForUserApplicationUpdates(HttpApplication application) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                if (application != null && application.configLastModifiedCheckExpires < HttpDateFormat.currentTimeLong) {
                    application.configLastModifiedCheckExpires = HttpDateFormat.currentTimeLong + 1000L;
                    if (application.config.isUpdated()) {
                        try {
                            HttpApplication oldApplication = application;
                            String contextRoot = application.getContextPath();
                            this.userApplications.remove(contextRoot);
                            application.config.update();
                            application = new HttpApplication(this.server.getApplicationServer().getDefaultApplication(), this, application.config, contextRoot, "<user-app>", oldApplication.isShared());
                            this.userApplications.put(contextRoot, application);
                            this.server.getApplicationServer().getThreadPool().launch(new HttpApplicationDestroyer(oldApplication));
                        }
                        catch (InstantiationException e) {
                            // empty catch block
                        }
                    }
                }
                HttpApplication httpApplication = application;
                return httpApplication;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpApplication getApplicationByName(String name) {
        HttpApplication httpApplication;
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
            }
        }
        catch (Throwable throwable) {
            destroyLock.unlock();
            throw throwable;
        }
        {
            for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                HttpApplication app;
                try {
                    app = this.runTimeReferences[i].getHttpApplication();
                }
                catch (InstantiationException e) {
                    HttpApplication httpApplication2 = null;
                    // MONITOREXIT @DISABLED, blocks:[6, 7, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                    destroyLock.unlock();
                    return httpApplication2;
                }
                if (app == null || !name.equals(app.name)) continue;
                HttpApplication httpApplication3 = app;
                // MONITOREXIT @DISABLED, blocks:[6, 9] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                destroyLock.unlock();
                return httpApplication3;
            }
            httpApplication = null;
        }
        destroyLock.unlock();
        return httpApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addHttpApplicationsOf(Application enclosing, List list) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    HttpApplication httpApplication;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        httpApplication = null;
                    }
                    if (httpApplication == null || httpApplication.getApplication() != enclosing) continue;
                    list.add(httpApplication);
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initApplications() throws InstantiationException {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                HttpApplicationRunTimeReference newElement;
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    HttpApplication httpApplication = this.runTimeReferences[i].getHttpApplication();
                    if (httpApplication == null) continue;
                    this.purgeHttpApplicationEntry(httpApplication);
                    httpApplication.destroy();
                }
                this.runTimeReferences = null;
                this.runTimeReferencesArrLen = 0;
                List applicationConfigs = this.config.getApplications();
                HttpApplicationReference defaultAppRef = this.config.getDefaultApplication();
                if (defaultAppRef != null && defaultAppRef.preload()) {
                    HttpMessages.infoWebAppStarting(defaultAppRef.getHttpApplicationName());
                    try {
                        newElement = new HttpApplicationRunTimeReference(this, defaultAppRef);
                        this.runTimeReferences = (HttpApplicationRunTimeReference[])ArrayUtils.append((Class)HttpApplicationRunTimeReference.class, (Object[])this.runTimeReferences, (int)this.runTimeReferencesArrLen++, (Object)newElement);
                        this.addRoutingInfo(defaultAppRef);
                    }
                    catch (InstantiationException e) {
                        InstantiationException ie = new InstantiationException("Internal error raised trying to instantiate the default web-application for site: " + this.config.getName());
                        ie.initCause(e);
                        throw ie;
                    }
                    HttpMessages.infoWebAppStarted(defaultAppRef.getHttpApplicationName());
                }
                if (!applicationConfigs.isEmpty()) {
                    for (int i = 0; i < applicationConfigs.size(); ++i) {
                        HttpApplicationReference reference = (HttpApplicationReference)applicationConfigs.get(i);
                        if (reference == defaultAppRef) continue;
                        HttpMessages.infoWebAppStarting(reference.getHttpApplicationName());
                        try {
                            newElement = new HttpApplicationRunTimeReference(this, reference);
                            this.runTimeReferences = (HttpApplicationRunTimeReference[])ArrayUtils.append((Class)(class$com$evermind$server$http$HttpSite$HttpApplicationRunTimeReference == null ? HttpSite.class$("com.evermind.server.http.HttpSite$HttpApplicationRunTimeReference") : class$com$evermind$server$http$HttpSite$HttpApplicationRunTimeReference), (Object[])this.runTimeReferences, (int)this.runTimeReferencesArrLen++, (Object)newElement);
                            this.addRoutingInfo(reference);
                        }
                        catch (InstantiationException e) {
                            HttpMessages.internalErrorWhileTryingToInstantiate(this.getdisplayName(), reference.getHttpApplicationName(), e);
                        }
                        catch (Throwable t) {
                            HttpMessages.internalErrorWhileTryingToInstantiate(this.getdisplayName(), reference.getHttpApplicationName(), t);
                        }
                        HttpMessages.infoWebAppStarted(reference.getHttpApplicationName());
                    }
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public void hasChanged(List componentsToRefresh) {
        if (this.config.isUpdated()) {
            componentsToRefresh.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                block16: {
                    try {
                        this.config.update();
                    }
                    catch (InstantiationException e) {
                        HttpMessages.errorUpdatingConfig(this.config.getName(), e);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 9] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                        destroyLock.unlock();
                        return;
                    }
                    try {
                        if (!this.config.getAddress().equals(this.particularAddress == null ? this.address : this.particularAddress) || this.boundToPort != this.config.getPort() || this.secure != this.config.isSecure()) {
                            this.config.invalidate();
                            ApplicationServer e = this.server.getApplicationServer();
                            synchronized (e) {
                                this.server.updateSites();
                                break block16;
                            }
                        }
                        this.setConfig(this.config);
                    }
                    catch (InstantiationException e) {
                        HttpMessages.errorUpdatingConfig(this.config.getName(), e);
                    }
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public int compareTo(Object otherObject) {
        int portDiff;
        HttpSite other = (HttpSite)otherObject;
        if (other.address == null) {
            if (this.address != null) {
                return 1;
            }
        } else if (this.address == null) {
            if (other.address != null) {
                return -1;
            }
        } else {
            String otherName = other.address.getHostAddress();
            String thisName = this.address.getHostAddress();
            int hostOffset = thisName.compareTo(otherName);
            if (hostOffset != 0) {
                return -hostOffset;
            }
        }
        if ((portDiff = this.boundToPort - other.boundToPort) != 0) {
            return portDiff;
        }
        if (this.hostNameHeader != null) {
            if (other.hostNameHeader == null) {
                return -1;
            }
            return this.hostNameHeader[0].compareTo(other.hostNameHeader[0]);
        }
        if (other.hostNameHeader == null) {
            if (this.particularAddress != null) {
                return -1;
            }
            if (other.particularAddress != null) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPreloadServlets() {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication == null) continue;
                    httpApplication.initPreloadServlets();
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public boolean equals(Object otherObject) {
        HttpSite other = (HttpSite)otherObject;
        if (other.address == null) {
            if (this.address != null) {
                return false;
            }
        } else if (this.address == null) {
            if (other.address != null) {
                return false;
            }
        } else {
            String otherName = other.address.getHostAddress();
            String thisName = this.address.getHostAddress();
            if (!thisName.equals(otherName)) {
                return false;
            }
        }
        if (this.boundToPort - other.boundToPort != 0) {
            return false;
        }
        if (this.hostNameHeader != null) {
            if (other.hostNameHeader == null) {
                return false;
            }
            return this.hostNameHeader.equals(other.hostNameHeader);
        }
        return other.hostNameHeader == null;
    }

    public boolean equalsAjp(Object otherObject) {
        HttpSite other = (HttpSite)otherObject;
        if (other.address == null) {
            if (this.address != null) {
                return false;
            }
        } else if (this.address == null) {
            if (other.address != null) {
                return false;
            }
        } else {
            String otherName = other.address.getHostAddress();
            String thisName = this.address.getHostAddress();
            if (!thisName.equals(otherName)) {
                return false;
            }
        }
        if (this.hostNameHeader != null) {
            if (other.hostNameHeader == null) {
                return false;
            }
            return this.hostNameHeader.equals(other.hostNameHeader);
        }
        return other.hostNameHeader == null;
    }

    public String toString() {
        return (this.particularAddress == null ? this.address : this.particularAddress) + ":" + this.boundToPort + (this.hostNameHeader == null ? "" : ":" + Arrays.asList(this.hostNameHeader));
    }

    private void initSSLProperties() {
        if (!this.secure) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy(boolean async) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().writeLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication == null) continue;
                    if (async) {
                        this.server.getApplicationServer().getThreadPool().launch(new HttpApplicationDestroyer(httpApplication));
                        continue;
                    }
                    httpApplication.destroy();
                }
                if (this.userApplications != null) {
                    Map map = this.userApplications;
                    synchronized (map) {
                        Iterator iterator = this.userApplications.values().iterator();
                        while (iterator.hasNext()) {
                            HttpApplication application = (HttpApplication)iterator.next();
                            if (async) {
                                this.server.getApplicationServer().getThreadPool().launch(new HttpApplicationDestroyer(application));
                                continue;
                            }
                            application.destroy();
                        }
                    }
                }
                this.runTimeReferences = null;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnusedCacheFiles() {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication == null) continue;
                    httpApplication.removeUnusedCacheFiles();
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public HttpSiteConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpApplication getDefaultApplication() throws InstantiationException {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                HttpApplication httpApplication = this.runTimeReferences[0].getHttpApplication(true);
                return httpApplication;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSessionTimeouts() {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication == null) continue;
                    httpApplication.checkSessionTimeouts();
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkApplicationActivity() {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication == null || httpApplication.checkActivity(this.runTimeReferences[i].getHttpApplicationReference().getMaxInactivityTime())) continue;
                    this.purgeHttpApplicationEntry(httpApplication);
                    this.server.getApplicationServer().getThreadPool().launch(new HttpApplicationDestroyer(httpApplication));
                }
                if (this.userApplications != null) {
                    Map map = this.userApplications;
                    synchronized (map) {
                        Iterator iterator = this.userApplications.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            HttpApplication application = (HttpApplication)entry.getValue();
                            if (application.checkActivity(this.userApplicationMaxInactivityTime)) continue;
                            this.server.getApplicationServer().getThreadPool().launch(new HttpApplicationDestroyer(application));
                            iterator.remove();
                        }
                    }
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateApplication(HttpApplication application) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication == null || httpApplication != application) continue;
                    this.purgeHttpApplicationEntry(httpApplication);
                    HttpApplicationReference reference = this.runTimeReferences[i].getHttpApplicationReference();
                    if (!reference.preload()) continue;
                    application.addRestartHook(this, reference.getRoot());
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList invalidateHttpApplications(HttpApplicationReference reference) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                ArrayList<HttpApplication> appsToDestroy = new ArrayList<HttpApplication>();
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    if (!this.runTimeReferences[i].getHttpApplicationReference().implies(reference)) continue;
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication == null) continue;
                    appsToDestroy.add(httpApplication);
                    this.updateApplication(httpApplication);
                }
                ArrayList<HttpApplication> arrayList = appsToDestroy;
                return arrayList;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList invalidateHttpApplicationsAndRemoveEntry(HttpApplicationReference reference) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                ArrayList<HttpApplication> appsToDestroy = new ArrayList<HttpApplication>();
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    if (this.runTimeReferences[i] == null || !this.runTimeReferences[i].getHttpApplicationReference().implies(reference)) continue;
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication != null) {
                        this.purgeHttpApplicationEntry(httpApplication);
                        appsToDestroy.add(httpApplication);
                    }
                    ArrayUtils.remove((Object[])this.runTimeReferences, (int)this.runTimeReferencesArrLen--, (int)i--);
                }
                ArrayList<HttpApplication> arrayList = appsToDestroy;
                return arrayList;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public HttpServer getServer() {
        return this.server;
    }

    public Map getApplications(ErrorHandler errorHandler) throws InstantiationException {
        HashMap<String[], Object> applications = new HashMap<String[], Object>();
        try {
            String name = ((HttpApplicationDescriptor)this.getDefaultApplication().getConfig()).getDisplayName();
            applications.put(new String[]{"/", name}, this.getDefaultApplication());
        }
        catch (InstantiationException e) {
            if (errorHandler != null) {
                try {
                    if (!errorHandler.handleEvent(e.getMessage(), 2)) {
                        throw e;
                    }
                    applications.put(new String[]{"/", "<unknown>"}, e.getMessage());
                }
                catch (RemoteException re) {
                    throw e;
                }
            }
            throw e;
        }
        ByteString contextRoot = null;
        for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
            try {
                contextRoot = this.runTimeReferences[i].getHttpApplicationContextRoot();
                HttpApplication application = this.getApplication(contextRoot);
                String name = ((HttpApplicationDescriptor)application.getConfig()).getDisplayName();
                applications.put(new String[]{contextRoot.toString(), name}, application);
                continue;
            }
            catch (InstantiationException e) {
                if (errorHandler != null) {
                    try {
                        if (!errorHandler.handleEvent(e.getMessage(), 2)) {
                            throw e;
                        }
                        applications.put(new String[]{contextRoot.toString(), "<unknown>"}, e.getMessage());
                        continue;
                    }
                    catch (RemoteException re) {
                        throw e;
                    }
                }
                throw e;
            }
        }
        return applications;
    }

    public String getdescriptor() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(bout);
            ((XMLHttpSiteConfig)this.config).writeConfig(pw);
            pw.flush();
            return bout.toString();
        }
        catch (IOException iox) {
            ServerMessages.infoWebSiteError(iox);
            return null;
        }
    }

    public String getdisplayName() {
        return ((XMLHttpSiteConfig)this.config).getDisplayName();
    }

    public WebBinding getdefaultWebApplicationInfo() {
        HttpApplicationReference defaultWebApp = ((XMLHttpSiteConfig)this.config).getDefaultApplication();
        if (defaultWebApp == null) {
            return null;
        }
        WebBinding wb = new WebBinding(defaultWebApp.getApplicationName(), defaultWebApp.getHttpApplicationName(), ((XMLHttpSiteConfig)this.config).getURL(), defaultWebApp.getRoot(), defaultWebApp.preload(), defaultWebApp.isShared());
        wb.setAccessLog(defaultWebApp.isAccessLog());
        return wb;
    }

    public WebBinding[] getwebApplicationsInfo() {
        try {
            List webapps = ((XMLHttpSiteConfig)this.config).getApplications();
            Iterator it = webapps.iterator();
            WebBinding[] res = new WebBinding[webapps.size()];
            int i = 0;
            while (it.hasNext()) {
                HttpApplicationReference webApp = (HttpApplicationReference)it.next();
                res[i] = new WebBinding(webApp.getApplicationName(), webApp.getHttpApplicationName(), ((XMLHttpSiteConfig)this.config).getURL(), webApp.getRoot(), webApp.preload(), webApp.isShared());
                res[i].setAccessLog(webApp.isAccessLog());
                ++i;
            }
            return res;
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public int getPort() {
        return ((XMLHttpSiteConfig)this.config).getPort();
    }

    public boolean getSecure() {
        return ((XMLHttpSiteConfig)this.config).isSecure();
    }

    public String getProtocol() {
        try {
            XMLHttpSiteConfig cfr_ignored_0 = (XMLHttpSiteConfig)this.config;
            return XMLHttpSiteConfig.getProtocolName(((XMLHttpSiteConfig)this.config).getProtocol());
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void start() {
        this.state_ = 1;
    }

    public void stop() {
        this.state_ = 3;
    }

    public void stop(Map params) {
        this.stop();
    }

    public void startRecursive() {
        this.start();
    }

    public final long getstartTime() {
        return this.startTime;
    }

    public final int getstate() {
        return this.state_;
    }

    public OHSRoutingInfo[] getOHSRoutingDetail() {
        try {
            List webapps = ((XMLHttpSiteConfig)this.config).getApplications();
            OHSRoutingInfo[] res = new OHSRoutingInfo[webapps.size()];
            for (int i = 0; i < webapps.size(); ++i) {
                HttpApplicationReference webApp = (HttpApplicationReference)webapps.get(i);
                ApplicationServer appServer = this.server.getApplicationServer();
                Application app = appServer.getApplication(webApp.getApplicationName());
                StringBuffer buf = new StringBuffer();
                buf.append("oc4j").append(":j2eeType=WebModule,name=").append(webApp.getHttpApplicationName()).append(",J2EEApplication=").append(webApp.getApplicationName()).append(",J2EEServer=").append("standalone");
                res[i] = new OHSRoutingInfo(buf.toString(), app.getstate() == 1 && webApp.getOHSRouting());
            }
            return res;
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public boolean getOHSRouting() {
        try {
            boolean res = true;
            List webapps = ((XMLHttpSiteConfig)this.config).getApplications();
            for (int i = 0; i < webapps.size(); ++i) {
                HttpApplicationReference webApp = (HttpApplicationReference)webapps.get(i);
                res = res && webApp.getOHSRouting();
            }
            return res;
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public boolean getOHSRouting(String appName) {
        try {
            boolean res = true;
            boolean hit = false;
            List webapps = ((XMLHttpSiteConfig)this.config).getApplications();
            for (int i = 0; i < webapps.size(); ++i) {
                HttpApplicationReference webApp = (HttpApplicationReference)webapps.get(i);
                if (!appName.equals(webApp.getApplicationName())) continue;
                hit = true;
                res = res && webApp.getOHSRouting();
            }
            if (hit) {
                return res;
            }
            return false;
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public boolean getOHSRouting(String appName, String webModuleName) {
        try {
            List webapps = ((XMLHttpSiteConfig)this.config).getApplications();
            for (int i = 0; i < webapps.size(); ++i) {
                HttpApplicationReference webApp = (HttpApplicationReference)webapps.get(i);
                if (!appName.equals(webApp.getApplicationName()) || !webModuleName.equals(webApp.getHttpApplicationName())) continue;
                return webApp.getOHSRouting();
            }
            return false;
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void setOHSRouting(boolean value) {
        List webapps;
        try {
            webapps = ((XMLHttpSiteConfig)this.config).getApplications();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        boolean hit = false;
        for (int i = 0; i < webapps.size(); ++i) {
            HttpApplicationReference webApp = (HttpApplicationReference)webapps.get(i);
            hit = hit || this.updateOHSRouting(webApp, value);
        }
        try {
            if (hit) {
                this.config.store();
            }
        }
        catch (IOException ioe) {
            ServerMessages.warningUnableWriteWebsite(this.config.getName());
        }
    }

    public void setOHSRouting(String appName, boolean value) {
        List webapps;
        try {
            webapps = ((XMLHttpSiteConfig)this.config).getApplications();
        }
        catch (InstantiationException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        boolean found = false;
        boolean hit = false;
        for (int i = 0; i < webapps.size(); ++i) {
            HttpApplicationReference webApp = (HttpApplicationReference)webapps.get(i);
            if (!appName.equals(webApp.getApplicationName())) continue;
            found = true;
            hit = hit || this.updateOHSRouting(webApp, value);
        }
        if (!found) {
            throw new IllegalArgumentException("invalid app name: " + appName);
        }
        try {
            if (hit) {
                this.config.store();
            }
        }
        catch (IOException ioe) {
            ServerMessages.warningUnableWriteWebsite(this.config.getName());
        }
    }

    public void setOHSRouting(String appName, String webModuleName, boolean value) {
        List webapps;
        try {
            webapps = ((XMLHttpSiteConfig)this.config).getApplications();
        }
        catch (InstantiationException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        boolean found = false;
        boolean hit = false;
        for (int i = 0; i < webapps.size(); ++i) {
            HttpApplicationReference webApp = (HttpApplicationReference)webapps.get(i);
            if (!appName.equals(webApp.getApplicationName()) || !webModuleName.equals(webApp.getHttpApplicationName())) continue;
            found = true;
            hit = this.updateOHSRouting(webApp, value);
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("invalid app name and/or webModuleName: " + appName + ", " + webModuleName);
        }
        try {
            if (hit) {
                this.config.store();
            }
        }
        catch (IOException ioe) {
            ServerMessages.warningUnableWriteWebsite(this.config.getName());
        }
    }

    private boolean updateOHSRouting(HttpApplicationReference webApp, boolean value) {
        boolean oldValue = webApp.getOHSRouting();
        if (oldValue != value) {
            webApp.setOHSRouting(value);
            this.addRoutingInfo(webApp);
            return true;
        }
        return false;
    }

    private void addRoutingInfo(HttpApplicationReference webApp) {
        if (OC4JServer.getOPMNEnabled()) {
            try {
                ApplicationServer appServer = this.server.getApplicationServer();
                Application app = appServer.getApplication(webApp.getApplicationName());
                if (this.config.getProtocol() == 2) {
                    OC4JMonitorThread.addRoutingInfo(app.getRoutingId(), webApp.getApplicationName(), webApp.getRoot(), app.getstate() == 1 && webApp.getOHSRouting());
                }
                OC4JMonitorThread.setAppClassification(app.getName(), app.getcomponentClassification());
            }
            catch (InstantiationException e) {
                ServerMessages.warningWebAppNotFound(webApp.getApplicationName(), webApp.getRoot());
            }
        }
    }

    public void notifyOHSRoutingChange() {
        if (OC4JServer.getOPMNEnabled()) {
            OC4JMonitorThread.oc4jRuntimeConfigChanged();
        }
    }

    public void updateOHSRoutingDetail(String appName) {
        this.updateOHSRoutingDetail(appName, null);
    }

    public void updateOHSRoutingDetail(String appName, String webModuleName) {
        List webapps;
        try {
            webapps = ((XMLHttpSiteConfig)this.config).getApplications();
        }
        catch (InstantiationException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        boolean found = false;
        Iterator it = webapps.iterator();
        while (it.hasNext()) {
            HttpApplicationReference webApp = (HttpApplicationReference)it.next();
            if (!this.isMatchedWebModule(webApp, appName, webModuleName)) continue;
            found = true;
            this.addRoutingInfo(webApp);
            if (webModuleName == null) continue;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("invalid app name and/or webModuleName: " + appName + ", " + webModuleName);
        }
    }

    private boolean isMatchedWebModule(HttpApplicationReference webApp, String appName, String webModuleName) {
        return appName.equals(webApp.getApplicationName()) && (webModuleName == null || webModuleName.equals(webApp.getHttpApplicationName()));
    }

    public boolean getUseKeepAlives() {
        return this.useKeepAlives;
    }

    public int getRequestMaxSize() {
        return this.requestMaxSize;
    }

    public String getDescription() {
        return this.config.getDescription();
    }

    public SSLConfig getSSLConfig() {
        return this.config.getSSLConfig();
    }

    public WebSiteAccessLog getAccessLog() {
        if (this.config.getRequestLogPath() != null && !(this.requestLogger instanceof ODLRequestLogger)) {
            return new WebSiteAccessLog(this.config.getRequestLogFormat(), this.config.getRequestLogPath(), this.config.getRequestLogSplit(), this.config.getRequestLogSuffix());
        }
        return null;
    }

    public void setAccessLog(WebSiteAccessLog logger) throws InstantiationException {
        if (this.requestLogger != null) {
            this.requestLogger.flush();
        }
        this.config.setAccessLog(logger);
        this.requestLogger = this.config.getRequestLogger();
    }

    public WebSiteODLAccessLog getODLAccessLog() {
        if (this.config.getRequestLogPath() != null && this.requestLogger instanceof ODLRequestLogger) {
            ODLRequestLogger logger = (ODLRequestLogger)this.requestLogger;
            return new WebSiteODLAccessLog(logger.getPath(), logger.getMaxFileSize(), logger.getMaxDirectorySize());
        }
        return null;
    }

    public void setODLAccessLog(WebSiteODLAccessLog logger) throws InstantiationException {
        if (this.requestLogger != null) {
            this.requestLogger.flush();
        }
        this.config.setODLAccessLog(logger);
        this.requestLogger = this.config.getRequestLogger();
    }

    public String getShortName() {
        if (this._shortName != null) {
            return this._shortName;
        }
        String name = this.getName();
        if (name.endsWith(".xml")) {
            int idx1 = name.lastIndexOf(47);
            int idx2 = name.lastIndexOf(46);
            this._shortName = name.substring(idx1 + 1, idx2);
        }
        return this._shortName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addHttpApplication(HttpApplicationReference reference, String rootCtx) throws InstantiationException {
        boolean replaceDefaultWebApp = this.config.getDefaultApplication().getRoot().equals(rootCtx);
        this.removeHttpApplication(rootCtx);
        HttpApplicationRunTimeReference element = new HttpApplicationRunTimeReference(this, reference);
        this.addRoutingInfo(reference);
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                if (replaceDefaultWebApp) {
                    this.runTimeReferences = (HttpApplicationRunTimeReference[])ArrayUtils.insert((Class)HttpApplicationRunTimeReference.class, (Object[])this.runTimeReferences, (int)this.runTimeReferencesArrLen, (Object)element, (int)0);
                } else {
                    HttpApplicationRunTimeReference[] newRuntimeReferences = new HttpApplicationRunTimeReference[this.runTimeReferencesArrLen + 1];
                    boolean inserted = false;
                    newRuntimeReferences[0] = this.runTimeReferences[0];
                    for (int i = 1; i < this.runTimeReferencesArrLen; ++i) {
                        String otherRoot = this.runTimeReferences[i].getHttpApplicationReference().getRoot();
                        if (!inserted && !"/".equals(otherRoot) && rootCtx.indexOf(otherRoot) != -1) {
                            HttpApplicationRunTimeReference tmp = this.runTimeReferences[i];
                            newRuntimeReferences[i] = element;
                            element = tmp;
                            inserted = true;
                            continue;
                        }
                        newRuntimeReferences[i] = this.runTimeReferences[i];
                    }
                    newRuntimeReferences[this.runTimeReferencesArrLen] = element;
                    this.runTimeReferences = newRuntimeReferences;
                }
                ++this.runTimeReferencesArrLen;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeHttpApplication(String rootCtx) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    if (!this.runTimeReferences[i].getHttpApplicationContextRoot().equals(rootCtx)) continue;
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication != null) {
                        this.purgeHttpApplicationEntry(httpApplication);
                        httpApplication.destroy();
                    }
                    ArrayUtils.remove((Object[])this.runTimeReferences, (int)this.runTimeReferencesArrLen--, (int)i);
                    break;
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeHttpApplication(Application application) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    if (this.runTimeReferences[i].getApplication() != application) continue;
                    HttpApplication httpApplication = null;
                    try {
                        httpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (httpApplication != null) {
                        this.purgeHttpApplicationEntry(httpApplication);
                        httpApplication.destroy();
                    }
                    ArrayUtils.remove((Object[])this.runTimeReferences, (int)this.runTimeReferencesArrLen--, (int)i--);
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContextFromLookUp(String webName) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                HashMap newContextCache = new HashMap(this.contextCache);
                Iterator iter = newContextCache.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    HttpApplication httpApplication = (HttpApplication)entry.getValue();
                    if (httpApplication == null || !httpApplication.name.equals(webName)) continue;
                    iter.remove();
                }
                this.contextCache = newContextCache;
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    User findTheSessionUser(ByteString id, HttpApplication httpApplication) {
        User user;
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    EvermindHttpSession session;
                    HttpApplication relatedApplication = null;
                    try {
                        relatedApplication = this.getApplication(this.runTimeReferences[i].getHttpApplicationContextRoot());
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (httpApplication == relatedApplication || (session = (EvermindHttpSession)relatedApplication.sessions.get(id)) == null || session.user == null) continue;
                    User user2 = session.user;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl15 : MonitorExitStatement: MONITOREXIT : var4_4
                    destroyLock.unlock();
                    return user2;
                }
                user = null;
            }
        }
        catch (Throwable throwable) {
            destroyLock.unlock();
            throw throwable;
        }
        destroyLock.unlock();
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unBindWebApps(Application application) throws DeployerException {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                Notifier notifier = Notifier.getNotifier();
                String applicationName = application.getName();
                if (notifier != null) {
                    try {
                        String[] params = new String[]{applicationName};
                        notifier.sendNotification("REMOVING_ALL_WEB_BINDINGS_FOR_APPLICATION", params);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                try {
                    if (this.config.unBindApplication(applicationName)) {
                        this.config.store();
                    }
                }
                catch (IOException e) {
                    DeployerException exception = new DeployerException("Unable to remove web bindings for application " + applicationName);
                    exception.initCause(exception);
                    throw exception;
                }
                this.removeHttpApplication(application);
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeHttpApplicationEntry(HttpApplication httpApplication) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    HttpApplication retrievedHttpApplication = null;
                    try {
                        retrievedHttpApplication = this.runTimeReferences[i].getHttpApplication();
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                    if (retrievedHttpApplication == null || retrievedHttpApplication != httpApplication) continue;
                    this.removeContextFromLookUp(httpApplication.name);
                    this.runTimeReferences[i].clearHttpApplication();
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection getUserApplications() {
        if (this.userApplications == null) {
            return null;
        }
        Map map = this.userApplications;
        synchronized (map) {
            return this.userApplications.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHttpApplications(String applicationName) {
        Lock destroyLock = this.getApplicationServer().getDestroyLock().readLock();
        destroyLock.lock();
        try {
            HttpSite httpSite = this;
            synchronized (httpSite) {
                for (int i = 0; i < this.runTimeReferencesArrLen; ++i) {
                    try {
                        Application application = this.runTimeReferences[i].getApplication();
                        if (application == null || !application.getName().equals(applicationName)) continue;
                        this.runTimeReferences[i].getHttpApplication(true);
                        continue;
                    }
                    catch (InstantiationException e) {
                        System.out.println("Error creating web-app in site : " + this + " for application: " + applicationName + e);
                    }
                }
            }
        }
        finally {
            destroyLock.unlock();
        }
    }

    public void persistUpdates() throws IOException, InstantiationException {
        this.config.store();
    }

    private static final class HttpApplicationRunTimeReference {
        private Application application;
        private HttpApplication httpApplication;
        private final HttpApplicationReference httpApplicationReference;
        private final ByteString applicationRoot;
        private final HttpSite site;

        HttpApplicationRunTimeReference(HttpSite site, HttpApplicationReference httpApplicationReference) throws InstantiationException {
            HttpServer server = site.getServer();
            this.site = site;
            this.httpApplicationReference = httpApplicationReference;
            this.applicationRoot = server.getApplicationServer().byteStringCache.getByteString(httpApplicationReference.getRoot());
            this.httpApplication = null;
            this.application = server.getApplicationServer().getApplication(httpApplicationReference.getApplicationName());
            if (this.application == null) {
                throw new InstantiationException("Application: " + httpApplicationReference.getApplicationName() + " does not exist. Error creating Web application: " + httpApplicationReference.getHttpApplicationName());
            }
            if (this.application != null && this.application.isStarted() && httpApplicationReference.preload()) {
                this.httpApplication = this.createHttpApplicationFromReference(httpApplicationReference);
            }
        }

        public HttpApplication getHttpApplication() throws InstantiationException {
            return this.getHttpApplication(false);
        }

        public HttpApplication getHttpApplication(boolean createApplication) throws InstantiationException {
            if (this.httpApplication == null && createApplication && this.application != null && !this.application.isDestroyed()) {
                this.httpApplication = this.createHttpApplicationFromReference();
            }
            return this.httpApplication;
        }

        public void clearHttpApplication() {
            this.httpApplication = null;
        }

        public HttpApplicationReference getHttpApplicationReference() {
            return this.httpApplicationReference;
        }

        public ByteString getHttpApplicationContextRoot() {
            return this.applicationRoot;
        }

        public Application getApplication() {
            return this.application;
        }

        public void setApplication(Application application) {
            this.application = application;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Application: ");
            buffer.append(this.application);
            buffer.append("\nHttpApplication: ");
            buffer.append(this.httpApplicationReference.getApplicationName());
            buffer.append("\nContextRoot: ");
            buffer.append(this.applicationRoot.toString());
            buffer.append("\nHttpApplication object: ");
            buffer.append(this.httpApplication);
            return buffer.toString();
        }

        public HttpApplication createHttpApplicationFromReference() throws InstantiationException {
            return this.createHttpApplicationFromReference(this.httpApplicationReference);
        }

        public HttpApplication createHttpApplicationFromReference(HttpApplicationReference reference) throws InstantiationException {
            if (this.application == null) {
                throw new InstantiationException("No application named '" + reference.getApplicationName() + "' found in the server");
            }
            if (!this.application.isStarted()) {
                throw new InstantiationException("Application named '" + reference.getApplicationName() + "' is in stopped state.");
            }
            try {
                this.httpApplication = this.application.getHttpApplication(reference.getHttpApplicationName(), reference.getRoot(), reference.isShared(), reference.getMaxInactivityTime(), reference.isAccessLog(), this.site, true);
            }
            catch (ApplicationStateStopped.ApplicationStoppedException e) {
                String errMsg = "Application: " + reference.getHttpApplicationName() + " has been stopped";
                InstantiationException ex = new InstantiationException(errMsg);
                ex.initCause(e);
                throw ex;
            }
            if (this.httpApplication == null) {
                String detail;
                Collection webApps = this.application.getConfig().getWebApplications();
                if (webApps == null || webApps.isEmpty()) {
                    detail = "no web-modules at all are defined in the application";
                } else {
                    detail = "found web-modules are: ";
                    try {
                        Iterator iterator = webApps.iterator();
                        detail = detail + "'" + ((WebModule)iterator.next()).getName() + "'";
                        while (iterator.hasNext()) {
                            detail = detail + ", '" + ((WebModule)iterator.next()).getName() + "'";
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        detail = "web-modules unknown: access error.";
                    }
                }
                throw new InstantiationException("No web-app named '" + reference.getHttpApplicationName() + "' found in application '" + reference.getApplicationName() + "' (" + detail + ")'");
            }
            if (ApplicationServer.DMS_GATE) {
                this.httpApplication.initStatisticSensors();
            }
            return this.httpApplication;
        }
    }
}

