/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.security.User;
import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.ejb.EJBOutputStream;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.JGroupHttpService;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import com.oracle.bricks.j2ee.Session;
import com.oracle.bricks.j2ee.SessionEventListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.util.TraceLogger;

public class JGroupHttpSession
extends EvermindHttpSession
implements SessionEventListener {
    static Logger m_logger = TraceLogger.getLogger(JGroupHttpSession.class);
    private JGroupHttpService replicationService;
    private Session internalSession;
    private boolean wasSessionAccessed = false;
    private boolean wasSessionModified = false;
    private boolean warned = false;

    public JGroupHttpSession(JGroupHttpService replicationService, Session internalSession, HttpApplication application, ByteString id, int maxInactiveInterval) {
        super(application, id, id.data, maxInactiveInterval);
        this.replicationService = replicationService;
        this.application = replicationService.getHttpApplication();
        this.internalSession = internalSession;
        this.ip = internalSession.getIp();
        this.creationTime = internalSession.getCreationTime();
        this.lastAccessedTime = internalSession.getLastAccessed();
        internalSession.setSessionEventListener(this);
    }

    public void setMaxInactiveInterval(int timeout) {
        if (timeout != this.maxInactiveInterval) {
            this.internalSession.setMaxInactiveTime(timeout);
        }
        super.setMaxInactiveInterval(timeout);
    }

    protected Object putValueToMap(String name, Object value) {
        if (!(value instanceof EJBObject || value instanceof Serializable || value instanceof EJBHome || value instanceof byte[])) {
            throw new IllegalArgumentException("Only java.io.Serializable, javax.ejb.EJBObject and javax.ejb.EJBHome instances can be bound to a session in a distributable web-application");
        }
        Serializable old = null;
        if (value instanceof Serializable) {
            try {
                old = this.internalSession.put((Serializable)((Object)name), (Serializable)value);
            }
            catch (InterruptedException e) {
                this.error("failed setAttribute: " + name, e);
            }
        } else if (value instanceof EJBObject) {
            try {
                old = this.internalSession.put((Serializable)((Object)name), new RemoteWrapper((EJBObject)value));
            }
            catch (InterruptedException e) {
                this.error("failed setAttribute: " + name, e);
            }
        } else if (value instanceof EJBHome) {
            try {
                old = this.internalSession.put((Serializable)((Object)name), new RemoteWrapper((EJBHome)value));
            }
            catch (InterruptedException e) {
                this.error("failed setAttribute: " + name, e);
            }
        }
        this.wasSessionModified = true;
        if (this.replicationService.getReplicationPolicy().isOnSetAttribute()) {
            this.flush("replication onSetAttribute interrupted");
        }
        return old;
    }

    protected void flush(String errorMsg) {
        try {
            if (this.replicationService.getReplicationPolicy().getReplicationScope() == 8) {
                this.internalSession.flushMap();
            } else {
                this.internalSession.flush();
            }
        }
        catch (InterruptedException e) {
            this.error(errorMsg, e);
        }
    }

    protected Object getValueFromMap(String name) {
        Object value = null;
        try {
            value = this.internalSession.get((Serializable)((Object)name));
        }
        catch (InterruptedException e) {
            this.error("failed getAttribute: " + name, e);
        }
        if (value instanceof RemoteWrapper) {
            value = ((RemoteWrapper)value).getValue(this.application.getClassLoader());
        }
        return value;
    }

    protected Object removeValueFromMap(String name) {
        Serializable ret = null;
        try {
            ret = this.internalSession.remove((Serializable)((Object)name));
        }
        catch (InterruptedException e) {
            this.error("failed internal session removeAttribute:" + name, e);
        }
        this.wasSessionModified = true;
        if (this.replicationService.getReplicationPolicy().isOnSetAttribute()) {
            this.flush("replication onSetAttribute interrupted");
        }
        return ret;
    }

    public void setUser(User user) {
        if (this.user != user) {
            this.internalSession.setUser(user.getName());
        }
        super.setUser(user);
    }

    protected void beginRequest() {
        if (this.isInfoEnabled()) {
            m_logger.log(Level.FINE, "ClusteredHttpSession.beginRequest()");
        }
        super.beginRequest();
        this.internalSession.setLastAccessed(this.getMostRecentAccessedTime());
        this.wasSessionAccessed = true;
    }

    protected void endRequest() {
        if (this.isInfoEnabled()) {
            m_logger.log(Level.FINE, "ClusteredHttpSession.endRequest(), accessed=" + this.wasSessionAccessed + ", modified=" + this.wasSessionModified);
        }
        super.endRequest();
        if (this.wasSessionAccessed || this.wasSessionModified) {
            this.internalSession.setLastAccessed(this.getLastAccessedTimeWithoutRuntimeCheck());
            if (this.replicationService.getReplicationPolicy().isOnRequestEnd()) {
                this.flush("interrupted on RequestEnd");
            }
        }
        this.wasSessionModified = false;
        this.wasSessionAccessed = false;
    }

    private List keyList() {
        try {
            return this.internalSession.keyList();
        }
        catch (InterruptedException e) {
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.log(Level.FINER, "Cannot access state", e);
            }
            throw (IllegalStateException)new IllegalStateException("Cannot access state").initCause(e);
        }
    }

    public String[] getValueNames() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        List keys = this.keyList();
        if (keys.size() == 0) {
            return new String[0];
        }
        String[] names = new String[keys.size()];
        keys.toArray(names);
        return names;
    }

    public Enumeration getAttributeNames() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        List keys = this.keyList();
        if (keys.size() > 0) {
            return Collections.enumeration(keys);
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public synchronized void invalidate() {
        super.invalidate();
        ClusteringMessages.fineInvalidateHttpSession(this.id.toString());
    }

    void doPassivate() throws InterruptedException {
        if (this.isInfoEnabled()) {
            m_logger.log(Level.FINE, "session will passivate " + this.id.toString());
        }
        this.internalSession.doPassivate(new HttpSessionEvent((HttpSession)this));
    }

    void doActivate() {
        block4: {
            String sessionUserName;
            if (this.user == null && (sessionUserName = this.internalSession.getUser()) != null && !"".equals(sessionUserName)) {
                this.user = this.application.getUserManager().getUser(sessionUserName);
            }
            if (this.isInfoEnabled()) {
                m_logger.log(Level.FINE, "session activated " + this.id.toString());
            }
            try {
                this.internalSession.doActivate(new HttpSessionEvent((HttpSession)this));
            }
            catch (InterruptedException e) {
                if (!m_logger.isLoggable(Level.FINER)) break block4;
                m_logger.log(Level.FINER, "session activation failed, sync error, id " + this.id, e);
            }
        }
    }

    void destroy(boolean timedOut, boolean executeListeners) {
        block3: {
            if (this.isInfoEnabled()) {
                m_logger.log(Level.FINE, "Destroying session with id {0} at {1} (created at {2})", new Object[]{this.id.toString(), new Date(System.currentTimeMillis()), new Date(this.getCreationTime())});
            }
            try {
                this.internalSession.destroy(this, executeListeners);
            }
            catch (InterruptedException e) {
                if (!m_logger.isLoggable(Level.FINER)) break block3;
                m_logger.log(Level.FINER, "Could not notify HttpSessionBindingListeners, sync error", e);
            }
        }
    }

    public void attributeAdded(Serializable key, Serializable value) {
        if (this.isInfoEnabled()) {
            m_logger.log(Level.FINE, "attributeAdded -- " + key + " - " + value + " for session id: " + this.getId());
        }
    }

    public void attributeRemoved(Serializable key, Serializable value) {
        if (this.isInfoEnabled()) {
            m_logger.log(Level.FINE, "attributeRemoved -- " + key + " for session id: " + this.getId());
        }
    }

    public void attributeModified(Serializable key, Serializable newValue, Serializable oldValue) {
        if (this.isInfoEnabled()) {
            m_logger.log(Level.FINE, "attributeModified -- " + key + " newValue: " + newValue + " oldValue " + oldValue + " for session id: " + this.getId());
        }
    }

    public void sessionReaped(Session session) {
        if (this.isInfoEnabled()) {
            m_logger.log(Level.FINE, "sessionReaped -- " + session.getId());
        }
    }

    public void sessionMigrated(Session session) {
        if (this.isInfoEnabled()) {
            m_logger.log(Level.FINE, "sessionMigrated -- " + session.getId());
        }
    }

    public void sessionDropped(Session session) {
        block3: {
            if (this.isInfoEnabled()) {
                m_logger.log(Level.FINE, "sessionDropped -- " + session.getId());
            }
            try {
                this.doPassivate();
            }
            catch (InterruptedException e) {
                if (!m_logger.isLoggable(Level.FINER)) break block3;
                m_logger.log(Level.FINER, "Error in session passivation id: " + this.id.toString(), e);
            }
        }
        super.invalidateLocal();
        this.internalSession = null;
    }

    private boolean isInfoEnabled() {
        return m_logger.isLoggable(Level.FINE);
    }

    private void error(String msg, Exception e) {
        m_logger.log(Level.FINER, msg, e);
    }

    static {
        if (HTTPProperties.getHttpClusterDebug()) {
            m_logger.setLevel(Level.FINEST);
        }
    }

    class RemoteWrapper
    implements Serializable {
        transient Remote value;
        transient byte[] broadcastValue;

        RemoteWrapper(EJBObject obj) {
            this.value = obj;
        }

        RemoteWrapper(EJBHome home) {
            this.value = home;
        }

        public Remote getValue(ClassLoader loader) {
            if (this.value != null) {
                return this.value;
            }
            ByteArrayInputStream o = new ByteArrayInputStream(this.broadcastValue);
            try {
                EJBInputStream in = new EJBInputStream((InputStream)o, loader);
                this.value = (Remote)in.readObject();
            }
            catch (IOException e) {
                m_logger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                m_logger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
            }
            return this.value;
        }

        private void writeObject(ObjectOutputStream outStream) throws IOException {
            byte[] bytes = this.broadcastValue;
            if (this.value != null) {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                EJBOutputStream out = new EJBOutputStream(o);
                out.writeObject(this.value);
                out.close();
                bytes = o.toByteArray();
            }
            outStream.writeObject(bytes);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.broadcastValue = (byte[])in.readObject();
        }
    }
}

