/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.security.User;
import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.ejb.EJBOutputStream;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.PersistenceHttpService;
import com.evermind.server.http.persistence.InternalHttpSessionInterface;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import oracle.ias.container.persistence.InternalPM;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.clustering.ClusteringTraceLogger;

public class PersistenceHttpSession
extends EvermindHttpSession {
    static Logger log = Logger.getLogger(PersistenceHttpService.class.getName());
    private static Logger m_traceLogger = ClusteringTraceLogger.getHttpTraceLogger(PersistenceHttpSession.class);
    private PersistenceHttpService persistenceService;
    private InternalHttpSessionInterface internalPersistenceObject;
    private boolean wasSessionAccessed = false;
    private boolean wasSessionModified = false;
    private boolean warned = false;

    public PersistenceHttpSession(PersistenceHttpService aPersistenceService, InternalHttpSessionInterface anInternalSession, HttpApplication application, ByteString id, int maxInactiveInterval) {
        super(application, id, id.data, maxInactiveInterval);
        this.persistenceService = aPersistenceService;
        this.application = this.persistenceService.getHttpApplication();
        this.internalPersistenceObject = anInternalSession;
        if (this.user != null) {
            this.internalPersistenceObject.setUserName(this.user.getName());
        }
        this.internalPersistenceObject.setMaxInactiveTime(maxInactiveInterval);
        this.ip = this.internalPersistenceObject.getIp();
        this.creationTime = this.internalPersistenceObject.getCreationTime();
        this.lastAccessedTime = this.internalPersistenceObject.getLastAccessed();
        if (log.isLoggable(Level.INFO)) {
            log.info("New PersistenceSession created: " + this.getId() + "id = '" + id + "'");
        }
    }

    public PersistenceHttpSession refresh() {
        InternalPM aPM = this.persistenceService.getPersistenceManager();
        InternalHttpSessionInterface aFreshObject = (InternalHttpSessionInterface)aPM.selectById(this.internalPersistenceObject.getClass(), this.internalPersistenceObject.getId());
        if (aFreshObject != null && !aFreshObject.getTimeLastAccessed().before(this.internalPersistenceObject.getTimeLastAccessed())) {
            this.internalPersistenceObject = aFreshObject;
            this.ip = this.internalPersistenceObject.getIp();
            this.creationTime = this.internalPersistenceObject.getCreationTime();
            this.lastAccessedTime = this.internalPersistenceObject.getLastAccessed();
            this.maxInactiveInterval = this.internalPersistenceObject.getMaxInactiveTime();
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("New PersistenceSession created: " + this.getId() + "id = '" + this.id + "'");
        }
        return this;
    }

    public void setMaxInactiveInterval(int timeout) {
        if (timeout != this.maxInactiveInterval) {
            this.internalPersistenceObject.setMaxInactiveTime(timeout);
        }
        super.setMaxInactiveInterval(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object putValueToMap(String name, Object value) {
        InternalHttpSessionInterface anObject = null;
        InternalHttpSessionInterface internalHttpSessionInterface = this.internalPersistenceObject;
        synchronized (internalHttpSessionInterface) {
            anObject = this.internalPersistenceObject;
            if (value instanceof EJBObject) {
                try {
                    anObject.put(name, new RemoteWrapper((EJBObject)value));
                }
                catch (InterruptedException e) {
                    this.error("failed setAttribute: " + name, e);
                }
            } else if (value instanceof EJBHome) {
                try {
                    anObject.put(name, new RemoteWrapper((EJBHome)value));
                }
                catch (InterruptedException e) {
                    this.error("failed setAttribute: " + name, e);
                }
            } else {
                try {
                    anObject.put(name, value);
                }
                catch (InterruptedException e) {
                    this.error("failed getAttribute: " + name, e);
                }
            }
        }
        this.wasSessionModified = true;
        if (this.persistenceService.isOnChange()) {
            this.flush("replication onSetAttribute interrupted");
        }
        return anObject;
    }

    protected Object getValueFromMap(String name) {
        Object value = null;
        try {
            value = this.internalPersistenceObject.get((Serializable)((Object)name));
        }
        catch (InterruptedException e) {
            this.error("failed getAttribute: " + name, e);
        }
        if (value instanceof RemoteWrapper) {
            value = ((RemoteWrapper)value).getValue(this.application.getClassLoader());
        }
        return value;
    }

    protected Object removeValueFromMap(String name) {
        Serializable ret = null;
        try {
            ret = this.internalPersistenceObject.remove((Serializable)((Object)name));
        }
        catch (InterruptedException e) {
            this.error("failed internal session removeAttribute:" + name, e);
        }
        this.wasSessionModified = true;
        if (this.persistenceService.isOnChange()) {
            InternalPM aPM = this.persistenceService.getPersistenceManager();
            aPM.writeObject(this.internalPersistenceObject);
            this.wasSessionModified = false;
        }
        return ret;
    }

    protected void flush(String errorMsg) {
        try {
            InternalPM aPM = this.persistenceService.getPersistenceManager();
            aPM.writeObject(this.internalPersistenceObject);
            this.wasSessionModified = false;
            ClusteringMessages.finestSessionPersistedWithId((Serializable)((Object)this.getId().toString()));
        }
        catch (Exception e) {
            this.error(errorMsg, e);
        }
    }

    public void setUser(User user) {
        if (this.user != user) {
            this.internalPersistenceObject.setUserName(user.getName());
        }
        super.setUser(user);
    }

    protected void beginRequest() {
        if (this.isInfoEnabled()) {
            log.info("ClusteredHttpSession.beginRequest()");
        }
        super.beginRequest();
        this.internalPersistenceObject.setLastAccessed(this.getMostRecentAccessedTime());
        this.wasSessionAccessed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endRequest() {
        if (this.isInfoEnabled()) {
            log.info("ClusteredHttpSession.endRequest(), accessed=" + this.wasSessionAccessed + ", modified=" + this.wasSessionModified);
        }
        super.endRequest();
        if (!this.persistenceService.isOnCall()) {
            return;
        }
        InternalPM aPM = this.persistenceService.getPersistenceManager();
        if (this.wasSessionAccessed || this.wasSessionModified) {
            InternalHttpSessionInterface internalHttpSessionInterface = this.internalPersistenceObject;
            synchronized (internalHttpSessionInterface) {
                this.internalPersistenceObject.setLastAccessed(this.getLastAccessedTimeWithoutRuntimeCheck());
                aPM.writeObject(this.internalPersistenceObject);
                Object object = aPM.selectById(this.internalPersistenceObject.getClass(), this.internalPersistenceObject.getId());
            }
        }
        this.wasSessionModified = false;
        this.wasSessionAccessed = false;
    }

    protected boolean shouldDestroyOnTimeOut() {
        if (!this.warned) {
            this.internalPersistenceObject.setLastAccessed(this.getLastAccessedTimeWithoutRuntimeCheck());
            this.warned = true;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        Set keys = this.internalPersistenceObject.keySet();
        if (keys.size() == 0) {
            return new String[0];
        }
        PersistenceHttpSession persistenceHttpSession = this;
        synchronized (persistenceHttpSession) {
            String[] names = new String[keys.size()];
            keys.toArray(names);
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValues() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        Set values = this.internalPersistenceObject.entrySet();
        if (values.size() == 0) {
            return new String[0];
        }
        PersistenceHttpSession persistenceHttpSession = this;
        synchronized (persistenceHttpSession) {
            String[] names = new String[values.size()];
            values.toArray(names);
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (this.isInvalid()) {
            throw new IllegalStateException("Session was invalidated");
        }
        Set keys = this.internalPersistenceObject.keySet();
        if (keys.size() > 0) {
            PersistenceHttpSession persistenceHttpSession = this;
            synchronized (persistenceHttpSession) {
                ArrayList names = new ArrayList();
                names.addAll(keys);
                return Collections.enumeration(names);
            }
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public synchronized void invalidate() {
        super.invalidate();
        ByteString id = new ByteString(this.internalPersistenceObject.getId());
        this.persistenceService.invalidateSession(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doPassivate() {
        InternalHttpSessionInterface internalHttpSessionInterface = this.internalPersistenceObject;
        synchronized (internalHttpSessionInterface) {
            if (this.isInfoEnabled()) {
                log.info("session will passivate " + this.getId());
            }
            Set entries = this.internalPersistenceObject.entrySet();
            Iterator i = entries.iterator();
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                Object value = entry.getValue();
                if (!(value instanceof HttpSessionActivationListener)) continue;
                ((HttpSessionActivationListener)value).sessionWillPassivate(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doActivate() {
        InternalHttpSessionInterface internalHttpSessionInterface = this.internalPersistenceObject;
        synchronized (internalHttpSessionInterface) {
            if (this.isInfoEnabled()) {
                log.info("session activated " + this.getId());
            }
            Set entries = this.internalPersistenceObject.entrySet();
            Iterator i = entries.iterator();
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                Object value = entry.getValue();
                if (!(value instanceof HttpSessionActivationListener)) continue;
                ((HttpSessionActivationListener)value).sessionDidActivate(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy(boolean timedOut, boolean executeListeners) {
        if (this.isInfoEnabled()) {
            log.info("Destroying session with id '" + this.getId() + "' at " + new Date(System.currentTimeMillis()) + " (created at " + new Date(this.getCreationTime()) + ")");
        }
        InternalHttpSessionInterface internalHttpSessionInterface = this.internalPersistenceObject;
        synchronized (internalHttpSessionInterface) {
            if (executeListeners) {
                Set entries = this.internalPersistenceObject.entrySet();
                Iterator i = entries.iterator();
                while (i.hasNext()) {
                    Map.Entry entry = (Map.Entry)i.next();
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (!(value instanceof HttpSessionBindingListener)) continue;
                    ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, key));
                }
            }
        }
    }

    private boolean isInfoEnabled() {
        return log.isLoggable(Level.INFO);
    }

    private void error(String msg, Exception e) {
        log.log(Level.SEVERE, msg, e);
    }

    private byte[] convertObjectToBtye(Object object) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(object);
            out.close();
            byte[] buf = bos.toByteArray();
            return buf;
        }
        catch (IOException e) {
            m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
            return null;
        }
    }

    private Object convertByteToObject(byte[] buffer) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer));
            Object anObject = in.readObject();
            in.close();
            return anObject;
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException e) {
            m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
        }
        return null;
    }

    static {
        if (HTTPProperties.getHttpClusterDebug()) {
            log.setLevel(Level.ALL);
        }
    }

    class RemoteWrapper
    implements Serializable {
        transient Remote value;
        transient byte[] broadcastValue;

        RemoteWrapper(EJBObject obj) {
            this.value = obj;
        }

        RemoteWrapper(EJBHome home) {
            this.value = home;
        }

        public Remote getValue(ClassLoader loader) {
            if (this.value != null) {
                return this.value;
            }
            ByteArrayInputStream o = new ByteArrayInputStream(this.broadcastValue);
            try {
                EJBInputStream in = new EJBInputStream((InputStream)o, loader);
                this.value = (Remote)in.readObject();
            }
            catch (IOException e) {
                m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
            }
            return this.value;
        }

        private void writeObject(ObjectOutputStream outStream) throws IOException {
            byte[] bytes = this.broadcastValue;
            if (this.value != null) {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                EJBOutputStream out = new EJBOutputStream(o);
                out.writeObject(this.value);
                out.close();
                bytes = o.toByteArray();
            }
            outStream.writeObject(bytes);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.broadcastValue = (byte[])in.readObject();
        }
    }
}

