/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HtmlTag;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.util.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSIPage {
    public static final int COMMAND_CONTENT = 0;
    public static final int COMMAND_INCLUDE_VIRTUAL = 1;
    public static final int COMMAND_INCLUDE_FILE = 2;
    public static final int COMMAND_FILE_LASTMODIFIED = 3;
    public static final int COMMAND_FILE_SIZE = 4;
    public static final int COMMAND_SERVER_NAME = 6;
    public static final int COMMAND_SERVER_PORT = 7;
    public static final int COMMAND_SERVER_PROTOCOL = 19;
    public static final int COMMAND_AUTH_TYPE = 8;
    public static final int COMMAND_REMOTE_USER = 9;
    public static final int COMMAND_REMOTE_ADDR = 10;
    public static final int COMMAND_REMOTE_HOST = 11;
    public static final int COMMAND_CONTENT_LENGTH = 12;
    public static final int COMMAND_CONTENT_TYPE = 13;
    public static final int COMMAND_HTTP_HEADER = 14;
    public static final int COMMAND_REQUEST_METHOD = 16;
    public static final int COMMAND_QUERYSTRING = 20;
    public static final int COMMAND_DATE_LOCAL = 17;
    public static final int COMMAND_DATE_GMT = 18;
    public static final int COMMAND_DATE_FORMAT = 22;
    public static final int COMMAND_INCLUDE_PROCESS = 21;
    private File file;
    private int[] command;
    private Object[] data;
    private ServletContext context;
    public long lastModified;

    public SSIPage(List command, List data, ServletContext context, File file) {
        this.command = new int[command.size()];
        this.data = new Object[command.size()];
        this.context = context;
        this.lastModified = this.lastModified;
        this.file = file;
        for (int i = 0; i < this.command.length; ++i) {
            this.command[i] = (Integer)command.get(i);
            this.data[i] = data.get(i);
        }
    }

    public void write(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object errorMessage = null;
        DateFormat dateFormat = null;
        ServletOutputStream out = response.getOutputStream();
        block22: for (int i = 0; i < this.command.length; ++i) {
            switch (this.command[i]) {
                case 0: {
                    out.write((byte[])this.data[i]);
                    continue block22;
                }
                case 1: {
                    RequestDispatcher dispatcher = this.context.getRequestDispatcher((String)this.data[i]);
                    if (dispatcher == null) continue block22;
                    dispatcher.include((ServletRequest)request, (ServletResponse)response);
                    continue block22;
                }
                case 2: {
                    File file = (File)this.data[i];
                    if (!file.exists()) continue block22;
                    ByteString requestURI = request instanceof EvermindHttpServletRequest ? ((EvermindHttpServletRequest)request).servletPath : new ByteString(request.getServletPath());
                    HttpApplication application = (HttpApplication)this.context;
                    application.include((ServletRequest)request, (ServletResponse)response, file, requestURI, true, null);
                    continue block22;
                }
                case 3: {
                    if (dateFormat == null) {
                        dateFormat = new SimpleDateFormat();
                    }
                    out.write(dateFormat.format(new Date(((File)this.data[i]).lastModified())).toString().getBytes());
                    continue block22;
                }
                case 4: {
                    out.write(String.valueOf(((File)this.data[i]).length()).getBytes());
                    continue block22;
                }
                case 6: {
                    out.write(request.getServerName().getBytes());
                    continue block22;
                }
                case 7: {
                    out.write(String.valueOf(request.getServerPort()).getBytes());
                    continue block22;
                }
                case 19: {
                    out.write(request.getProtocol().getBytes());
                    continue block22;
                }
                case 8: {
                    String authType = request.getAuthType();
                    if (authType == null) continue block22;
                    out.write(authType.getBytes());
                    continue block22;
                }
                case 9: {
                    String remoteUser = request.getRemoteUser();
                    if (remoteUser == null) continue block22;
                    out.write(remoteUser.getBytes());
                    continue block22;
                }
                case 10: {
                    out.write(request.getRemoteAddr().getBytes());
                    continue block22;
                }
                case 11: {
                    out.write(request.getRemoteHost().getBytes());
                    continue block22;
                }
                case 12: {
                    out.write(String.valueOf(request.getContentLength()).getBytes());
                    continue block22;
                }
                case 13: {
                    out.write(String.valueOf(request.getContentType()).getBytes());
                    continue block22;
                }
                case 14: {
                    String header = request.getHeader((String)this.data[i]);
                    if (header == null) continue block22;
                    out.write(header.getBytes());
                    continue block22;
                }
                case 16: {
                    out.write(request.getMethod().getBytes());
                    continue block22;
                }
                case 20: {
                    String query = request.getQueryString();
                    if (query == null) continue block22;
                    out.write(query.getBytes());
                    continue block22;
                }
                case 17: {
                    if (dateFormat == null) {
                        dateFormat = new SimpleDateFormat();
                    }
                    out.write(dateFormat.format(new Date()).toString().getBytes());
                    continue block22;
                }
                case 18: {
                    if (dateFormat == null) {
                        dateFormat = new SimpleDateFormat();
                    }
                    dateFormat.setTimeZone(HttpDateFormat.GMT_TIMEZONE);
                    out.write(dateFormat.format(new Date()).toString().getBytes());
                    dateFormat.setTimeZone(TimeZone.getDefault());
                    continue block22;
                }
                case 21: 
                case 22: {
                    int readLength;
                    Process process = Runtime.getRuntime().exec((String)this.data[i]);
                    InputStream processIn = process.getInputStream();
                    byte[] buffer = new byte[1024];
                    while ((readLength = processIn.read(buffer)) > 0) {
                        out.write(buffer, 0, readLength);
                    }
                    continue block22;
                }
            }
        }
    }

    public boolean isUpToDate() {
        return this.lastModified == this.file.lastModified();
    }

    public static SSIPage compile(ServletContext context, String requestURI, File file) throws IOException {
        byte[] source = new byte[(int)file.length()];
        FileInputStream in = new FileInputStream(file);
        ((InputStream)in).read(source);
        ((InputStream)in).close();
        int pos = 0;
        int length = source.length;
        int lastNormalPieceStart = 0;
        ArrayList<Integer> command = new ArrayList<Integer>();
        ArrayList<Object> data = new ArrayList<Object>();
        block3: while (pos < length) {
            byte value = source[pos++];
            switch (value) {
                case 60: {
                    int tagStartPos = pos;
                    if (tagStartPos >= length - 5 || source[tagStartPos] != 33 || source[tagStartPos + 1] != 45 || source[tagStartPos + 2] != 45) break;
                    if (source[tagStartPos + 3] == 35) {
                        File targetFile;
                        String virtual;
                        int normalPieceLength = pos - lastNormalPieceStart - 1;
                        if (normalPieceLength > 0) {
                            command.add(new Integer(0));
                            byte[] contentChunk = new byte[normalPieceLength];
                            System.arraycopy(source, lastNormalPieceStart, contentChunk, 0, normalPieceLength);
                            data.add(contentChunk);
                        }
                        pos = tagStartPos += 4;
                        while (pos != length && (source[pos++] != 45 || pos != length && (source[pos++] != 45 || pos != length && source[pos++] != 62))) {
                        }
                        lastNormalPieceStart = pos;
                        HtmlTag tag = HtmlTag.getTag(new String(source, tagStartPos, pos - 3 - tagStartPos));
                        String tagName = tag.getName();
                        if (tagName.equals("include")) {
                            virtual = tag.getProperty("virtual");
                            if (virtual != null) {
                                if (!virtual.startsWith("/")) {
                                    virtual = requestURI.substring(0, requestURI.lastIndexOf(47) + 1).concat(virtual);
                                }
                                command.add(new Integer(1));
                                data.add(virtual);
                                break;
                            }
                            virtual = tag.getProperty("file");
                            if (virtual == null) continue block3;
                            targetFile = new File(virtual);
                            if (!targetFile.isAbsolute()) {
                                targetFile = new File(file.getParent() + File.separatorChar + targetFile.getPath());
                            }
                            command.add(new Integer(2));
                            data.add(targetFile);
                            break;
                        }
                        if (tagName.equals("exec")) {
                            virtual = tag.getProperty("cgi");
                            if (virtual != null) {
                                if (!virtual.startsWith("/")) {
                                    virtual = requestURI.substring(0, requestURI.lastIndexOf(47) + 1).concat(virtual);
                                }
                                command.add(new Integer(1));
                                data.add(virtual);
                                break;
                            }
                            virtual = tag.getProperty("cmd");
                            if (virtual == null) continue block3;
                            command.add(new Integer(21));
                            data.add(virtual);
                            break;
                        }
                        if (tagName.equals("echo")) {
                            String var = tag.getProperty("var");
                            if (var == null) continue block3;
                            if (var.equals("DOCUMENT_NAME")) {
                                command.add(new Integer(0));
                                data.add(file.getName().getBytes());
                                break;
                            }
                            if (var.equals("DOCUMENT_URI") || var.equals("SCRIPT_NAME")) {
                                command.add(new Integer(0));
                                data.add(requestURI.getBytes());
                                break;
                            }
                            if (var.equals("QUERY_STRING_UNESCAPED") || var.equals("QUERY_STRING")) {
                                command.add(new Integer(20));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("DATE_LOCAL")) {
                                command.add(new Integer(17));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("DATE_GMT")) {
                                command.add(new Integer(18));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("LAST_MODIFIED")) {
                                command.add(new Integer(0));
                                data.add(new Date(file.lastModified()).toString().getBytes());
                                break;
                            }
                            if (var.equals("SERVER_SOFTWARE")) {
                                command.add(new Integer(0));
                                data.add(context.getServerInfo().getBytes());
                                break;
                            }
                            if (var.equals("SERVER_NAME")) {
                                command.add(new Integer(6));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("GATEWAY_INTERFACE")) {
                                command.add(new Integer(0));
                                data.add("CGI/0.0.0".getBytes());
                                break;
                            }
                            if (var.equals("SERVER_PROTOCOL")) {
                                command.add(new Integer(19));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("SERVER_PORT")) {
                                command.add(new Integer(7));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("SERVER_PORT")) {
                                command.add(new Integer(7));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("REQUEST_METHOD")) {
                                command.add(new Integer(16));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("PATH_INFO") || var.equals("PATH_TRANSLATED")) break;
                            if (var.equals("REMOTE_HOST")) {
                                command.add(new Integer(11));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("REMOTE_ADDR")) {
                                command.add(new Integer(10));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("AUTH_TYPE")) {
                                command.add(new Integer(8));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("REMOTE_USER")) {
                                command.add(new Integer(9));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("REMOTE_IDENT")) break;
                            if (var.equals("CONTENT_TYPE")) {
                                command.add(new Integer(13));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("CONTENT_LENGTH")) {
                                command.add(new Integer(12));
                                data.add(new Object());
                                break;
                            }
                            if (var.equals("HTTP_ACCEPT")) {
                                command.add(new Integer(14));
                                data.add("ACCEPT");
                                break;
                            }
                            if (!var.equals("HTTP_USER_AGENT")) continue block3;
                            command.add(new Integer(14));
                            data.add("USER-AGENT");
                            break;
                        }
                        if (!tagName.equals("flastmod") && !tagName.equals("fsize")) continue block3;
                        virtual = tag.getProperty("virtual");
                        targetFile = null;
                        if (virtual != null) {
                            if (!virtual.startsWith("/")) {
                                virtual = requestURI.substring(0, requestURI.lastIndexOf(47) + 1).concat(virtual);
                            }
                            targetFile = new File(context.getRealPath(virtual));
                        } else {
                            virtual = tag.getProperty("file");
                            if (virtual != null) {
                                targetFile = new File(virtual);
                            }
                        }
                        if (!targetFile.isAbsolute()) {
                            targetFile = new File(file.getParent() + File.separatorChar + targetFile.getPath());
                        }
                        if (tagName.equals("flastmod")) {
                            command.add(new Integer(3));
                        } else {
                            command.add(new Integer(4));
                        }
                        data.add(targetFile);
                        break;
                    }
                    while (pos != length && (source[pos++] != 45 || pos != length && (source[pos++] != 45 || pos != length && source[pos++] != 62))) {
                    }
                    break;
                }
            }
        }
        int normalPieceLength = length - lastNormalPieceStart;
        if (normalPieceLength > 0) {
            command.add(new Integer(0));
            byte[] contentChunk = new byte[normalPieceLength];
            System.arraycopy(source, lastNormalPieceStart, contentChunk, 0, normalPieceLength);
            data.add(contentChunk);
        }
        return new SSIPage(command, data, context, file);
    }

    public String createDateFormat(String ssiDateFormat) {
        return ssiDateFormat;
    }
}

