/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.util.HTTPProperties;
import com.evermind.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class SessionAsyncInvalidateHandler
implements Runnable {
    private static final int DEFAULT_MAX_THREAD_COUNT = 1;
    private volatile int workingThreadCount = 0;
    private Collection asyncInvalidateSessions = new ArrayList();
    private ThreadPool threadPool = null;

    public SessionAsyncInvalidateHandler(ThreadPool aThreadPool) {
        this.threadPool = aThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean haveSomeSessions = true;
        Iterator sessionIterator = null;
        EvermindHttpSession sess = null;
        boolean cleanup = false;
        try {
            do {
                sessionIterator = null;
                sess = null;
                Collection collection = this.asyncInvalidateSessions;
                synchronized (collection) {
                    boolean bl = haveSomeSessions = !this.asyncInvalidateSessions.isEmpty();
                    if (!haveSomeSessions) {
                        --this.workingThreadCount;
                        cleanup = true;
                        break;
                    }
                    sessionIterator = this.asyncInvalidateSessions.iterator();
                    sess = (EvermindHttpSession)sessionIterator.next();
                    sessionIterator.remove();
                }
                this.invalidateSession(sess);
            } while (haveSomeSessions);
        }
        finally {
            if (!cleanup) {
                --this.workingThreadCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(EvermindHttpSession sess) {
        Collection collection = this.asyncInvalidateSessions;
        synchronized (collection) {
            this.asyncInvalidateSessions.add(sess);
            if (this.workingThreadCount < this.getMaxThreadCount()) {
                ++this.workingThreadCount;
                this.threadPool.launch(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSession(EvermindHttpSession sess) {
        ThreadState state = ThreadState.getInheritableCurrentState();
        ContextContainer previousContainer = state.contextContainer;
        try {
            if (sess != null) {
                state.contextContainer = sess.application;
                sess.invalidate();
            }
        }
        finally {
            state.contextContainer = previousContainer;
        }
    }

    private int getMaxThreadCount() {
        int maxThreads = HTTPProperties.getHttpSessionInvalidatingThreads();
        return 0 < maxThreads ? maxThreads : 1;
    }
}

