/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import java.util.Iterator;
import java.util.List;

class SessionTimeoutTask
implements Runnable {
    HttpServer server;
    HttpSite[] site;
    HttpSite defaultSite;
    private int counter = 25;
    private int checkInterval = 30;
    private int cacheCheckCounter;
    private int cacheCheckInterval = 240;
    private int shutdownCheckInterval = 240;
    private int shutdownCheckCounter;

    SessionTimeoutTask(HttpServer server, List sites) {
        this.server = server;
        this.site = sites.toArray(new HttpSite[sites.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HttpDateFormat.updateCurrentTime();
        for (int i = 0; i < this.site.length; ++i) {
            if (this.site[i].requestLogger == null) continue;
            this.site[i].requestLogger.flush();
        }
        if (this.counter++ >= this.checkInterval) {
            long time = HttpDateFormat.currentTimeLong;
            if (this.server.hitsLastMinuteCleared + 60000L < time) {
                HttpSite site;
                Iterator iterator;
                HttpServer httpServer = this.server;
                synchronized (httpServer) {
                    this.server.hitsLastMinuteClearedPrevious = this.server.hitsLastMinuteCleared;
                    this.server.hitsLastMinuteCleared = time;
                    if (this.server.sites != null) {
                        iterator = this.server.sites.iterator();
                        while (iterator.hasNext()) {
                            site = (HttpSite)iterator.next();
                            site.hitsLastHour += site.hitsLastMinutePrevious;
                            site.hitsLastMinutePrevious = site.hitsLastMinute;
                            site.hitsLastMinute = 0;
                        }
                    }
                }
                if (this.server.hitsLastHourCleared + 3600000L < time) {
                    httpServer = this.server;
                    synchronized (httpServer) {
                        this.server.hitsLastHourClearedPrevious = this.server.hitsLastHourCleared;
                        this.server.hitsLastHourCleared = time;
                        if (this.server.sites != null) {
                            iterator = this.server.sites.iterator();
                            while (iterator.hasNext()) {
                                site = (HttpSite)iterator.next();
                                site.hits += site.hitsLastHourPrevious;
                                site.hitsLastHourPrevious = site.hitsLastHour;
                                site.hitsLastHour = 0;
                            }
                        }
                    }
                }
            }
            this.checkSessionTimeouts();
            this.counter = 0;
            this.cacheCheckCounter += this.checkInterval;
            if (this.cacheCheckCounter >= this.cacheCheckInterval) {
                this.cacheCheckCounter = 0;
                this.updateCaches();
                this.shutdownCheckCounter += this.cacheCheckInterval;
                if (this.shutdownCheckCounter >= this.shutdownCheckInterval) {
                    this.checkApplicationActivity();
                }
            }
        }
    }

    protected void checkApplicationActivity() {
        for (int i = 0; i < this.site.length; ++i) {
            this.site[i].checkApplicationActivity();
        }
    }

    protected void checkSessionTimeouts() {
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < this.site.length; ++i) {
            this.site[i].checkSessionTimeouts();
        }
    }

    public void updateCaches() {
        for (int i = 0; i < this.site.length; ++i) {
            this.site[i].removeUnusedCacheFiles();
        }
    }
}

