/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.BNFCharType;

public class SimpleBNFScanner {
    private char[] chars;
    private int i = 0;
    private int cCount;

    public SimpleBNFScanner(char[] characters) {
        this.chars = characters;
        this.cCount = this.chars.length;
    }

    public static char[] stringToChars(String characterString) {
        char[] chars = new char[characterString.length()];
        characterString.getChars(0, characterString.length(), chars, 0);
        return chars;
    }

    public int back(int n) {
        n = n > this.i ? this.i : n;
        this.i -= n;
        return n;
    }

    public boolean hasMore() {
        return this.i < this.cCount;
    }

    public char peek() {
        return this.i < this.cCount ? this.chars[this.i] : (char)'\u0000';
    }

    public int getIndex() {
        return this.i;
    }

    public char[] getWhile(Predicate predicate) {
        if (this.i >= this.cCount) {
            return null;
        }
        int startI = this.i;
        while (this.i < this.cCount && predicate.invoke(this.chars[this.i])) {
            ++this.i;
        }
        char[] result = new char[this.i - startI];
        System.arraycopy(this.chars, startI, result, 0, this.i - startI);
        return result;
    }

    public int skip(int n) {
        int count = n + this.i < this.cCount ? n : this.cCount - this.i;
        this.i += count;
        return count;
    }

    public int skipWhile(Predicate predicate) {
        int count = 0;
        while (this.i < this.cCount) {
            if (!predicate.invoke(this.chars[this.i])) {
                return count;
            }
            ++this.i;
            ++count;
        }
        return count;
    }

    public String toString() {
        return new String(this.chars, 0, this.getIndex()) + "<Scanner Position>" + new String(this.chars, this.getIndex(), this.cCount - this.getIndex());
    }

    public static class Not
    implements Predicate {
        private Predicate arg;

        public Not(Predicate predicate) {
            this.arg = predicate;
        }

        public boolean invoke(char c) {
            return !this.arg.invoke(c);
        }
    }

    public static class IsSpace
    implements Predicate {
        public boolean invoke(char c) {
            return BNFCharType.isSpace(c);
        }
    }

    public static class IsToken
    implements Predicate {
        public boolean invoke(char c) {
            return BNFCharType.isToken(c);
        }
    }

    public static class IsCharacter
    implements Predicate {
        private char character;

        public IsCharacter(char c) {
            this.character = c;
        }

        public boolean invoke(char c) {
            return c == this.character;
        }
    }

    public static interface MutablePredicate
    extends Predicate {
        public void reset();
    }

    public static interface Predicate {
        public boolean invoke(char var1);
    }
}

