/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.administration;

import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationReference;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.HttpSiteConfig;
import com.evermind.server.http.XMLHttpSiteConfig;
import com.evermind.server.http.administration.DefaultHttpApplicationAdministrator;
import com.evermind.server.http.administration.HttpApplicationAdministrator;
import com.evermind.server.http.administration.HttpSiteAdministrator;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.ByteString;
import com.evermind.util.ErrorHandler;
import com.evermind.util.ObjectUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import oracle.oc4j.security.OC4JSSLSocketFactory;

public class DefaultHttpSiteAdministrator
implements HttpSiteAdministrator {
    XMLHttpSiteConfig config;
    HttpSite site;

    public DefaultHttpSiteAdministrator(HttpSite site, HttpSiteConfig config) {
        this.config = (XMLHttpSiteConfig)config;
        if (site == null) {
            throw new NullPointerException("site was null");
        }
        this.site = site;
    }

    public HttpApplicationAdministrator getDefaultApplication() throws InstantiationException {
        if (this.site == null) {
            throw new NullPointerException("site was null");
        }
        HttpApplication application = this.site.getDefaultApplication();
        if (application == null) {
            throw new NullPointerException("application was null");
        }
        return new DefaultHttpApplicationAdministrator(application, application.getConfig());
    }

    public String getName() {
        String name = this.config.getDisplayName();
        if (name == null || name.equals("")) {
            return this.config.getName();
        }
        return name;
    }

    public HttpApplicationAdministrator bindWebApp(String root, String applicationName, String webAppName) throws InstantiationException, IOException {
        String rootCtx = root;
        if (root == null || root.trim().equals("")) {
            rootCtx = "/";
        }
        if (!rootCtx.startsWith("/")) {
            rootCtx = "/" + rootCtx;
        }
        if (!rootCtx.equals("/") && rootCtx.endsWith("/")) {
            rootCtx = rootCtx.substring(0, rootCtx.length() - 1);
        }
        HttpApplicationReference reference = new HttpApplicationReference(applicationName, webAppName);
        reference.setRoot(rootCtx);
        reference.setPreload();
        this.config.addApplication(reference);
        this.config.store();
        this.site.addHttpApplication(reference, root);
        HttpApplication httpApplication = this.site.getApplication(new ByteString(rootCtx));
        return new DefaultHttpApplicationAdministrator(httpApplication, httpApplication.getConfig());
    }

    public void remove() throws InstantiationException, IOException {
        this.site.getServer().getConfig().removeSite(this.config);
        this.site.getServer().getApplicationServer().getConfig().store();
        this.site.getServer().setSites();
    }

    public Map getApplications(ErrorHandler errorHandler) throws InstantiationException {
        Map apps = this.site.getApplications(errorHandler);
        Iterator iterator = apps.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                HttpApplication application = (HttpApplication)entry.getValue();
                entry.setValue(new DefaultHttpApplicationAdministrator(application, application.getConfig()));
            }
            catch (ClassCastException e) {}
        }
        return apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStatistics() {
        long time = System.currentTimeMillis();
        HttpServer httpServer = this.site.getServer();
        synchronized (httpServer) {
            HashMap<String, Number> statistics = new HashMap<String, Number>();
            statistics.put("hits", new Integer(this.site.hits + this.site.hitsLastHourPrevious + this.site.hitsLastHour + this.site.hitsLastMinute + this.site.hitsLastMinutePrevious));
            double hourRatio = (double)(time - this.site.getServer().hitsLastHourClearedPrevious) / 3600000.0;
            statistics.put("hitsLastHour", new Integer((int)((double)(this.site.hitsLastHour + this.site.hitsLastHourPrevious + this.site.hitsLastMinute + this.site.hitsLastMinutePrevious) / hourRatio)));
            double minuteRatio = (double)(time - this.site.getServer().hitsLastMinuteClearedPrevious) / 60000.0;
            statistics.put("hitsLastMinute", new Integer((int)((double)(this.site.hitsLastMinute + this.site.hitsLastMinutePrevious) / minuteRatio)));
            statistics.put("startTime", new Long(this.site.startTime));
            statistics.put("uptime", new Long(time - this.site.startTime));
            return statistics;
        }
    }

    public void setName(String name) throws IOException {
        this.site.getConfig().setDisplayName(name);
        this.site.getConfig().store();
    }

    public void removeBinding(String path) throws IOException, InstantiationException {
        this.config.removeApplication(path);
        this.config.store();
        this.site.removeHttpApplication(path);
    }

    public void removeApplicationBindings(String applicationName) throws IOException, InstantiationException {
        if (applicationName == null || applicationName.length() <= 1) {
            return;
        }
        Iterator iterator = this.config.getApplications().iterator();
        while (iterator.hasNext()) {
            HttpApplicationReference reference = (HttpApplicationReference)iterator.next();
            if (applicationName.equals(reference.getApplicationName())) {
                iterator.remove();
            }
            this.site.removeHttpApplication(reference.getRoot());
        }
        this.config.store();
    }

    public Map getConfigurationInfo() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("port", new Integer(this.config.getPort()));
        response.put("address", this.config.getAddress().getHostAddress());
        if (this.config.getHostNameHeaders() != null) {
            response.put("hostNames", this.config.getHostNameHeaders());
        }
        if (this.config.getDescription() != null) {
            response.put("description", this.config.getDescription());
        }
        response.put("secure", this.config.isSecure() ? Boolean.TRUE : Boolean.FALSE);
        return response;
    }

    public void setConfigurationInfo(Map info) throws UnknownHostException, IOException, InstantiationException {
        Integer clusterIsland;
        InetAddress address;
        String addressString;
        String description;
        Integer port = (Integer)info.get("port");
        boolean updated = false;
        boolean connectorUpdated = false;
        if (port.intValue() != this.config.getPort()) {
            this.config.setPort(port);
            updated = true;
            connectorUpdated = true;
        }
        if ((description = (String)info.get("description")) != null && description.equals("")) {
            description = null;
        }
        if (!ObjectUtils.equals(description, this.config.getDescription())) {
            this.config.setDescription(description);
            updated = true;
        }
        if ((addressString = (String)info.get("address")).equalsIgnoreCase("[ALL]")) {
            addressString = "0.0.0.0";
        }
        if (!(address = InetAddress.getByName(addressString)).equals(this.config.getAddress())) {
            this.config.setAddress(address);
            updated = true;
            connectorUpdated = true;
        }
        if (Boolean.TRUE.equals(info.get("secure")) != this.config.isSecure()) {
            this.config.setSecure(!this.config.isSecure());
            updated = true;
            connectorUpdated = true;
        }
        if ((clusterIsland = (Integer)info.get("clusterIsland")) == null) {
            clusterIsland = new Integer(-1);
        }
        if (clusterIsland.intValue() != this.config.getIslandID()) {
            updated = true;
            this.config.setIslandID(clusterIsland);
        }
        if (this.config.isSecure()) {
            SSLConfig l_sslCfg = this.config.getSSLConfig();
            if (l_sslCfg != null) {
                Properties l_propOld;
                String l_szOldValue = null;
                String l_szNewValue = null;
                l_szOldValue = l_sslCfg.getSocketFactory();
                if (!this.equals(l_szOldValue, l_szNewValue = (String)info.get("factory"))) {
                    updated = true;
                    connectorUpdated = true;
                    l_sslCfg.setFactoryName(l_szNewValue);
                }
                if (!this.equals(l_szOldValue = l_sslCfg.getKeyStorePath(), l_szNewValue = (String)info.get("keystore"))) {
                    updated = true;
                    connectorUpdated = true;
                    l_sslCfg.setKeyStorePath(l_szNewValue);
                }
                if (!this.equals(l_szOldValue = (String)(l_propOld = l_sslCfg.getProperties()).get("provider"), l_szNewValue = (String)info.get("provider"))) {
                    updated = true;
                    connectorUpdated = true;
                    l_propOld.put("provider", l_szNewValue);
                }
                if (!this.equals(l_szOldValue = (String)l_propOld.get("needs-client-auth"), l_szNewValue = (String)info.get("needs-client-auth"))) {
                    updated = true;
                    connectorUpdated = true;
                    l_propOld.put("needs-client-auth", l_szNewValue);
                }
                if (!this.equals(l_szOldValue = (String)l_propOld.get("keyStore.password"), l_szNewValue = (String)info.get("storepass"))) {
                    updated = true;
                    connectorUpdated = true;
                    l_propOld.put("keyStore.password", l_szNewValue);
                }
            }
            this.config.setSSLConfig(l_sslCfg);
        }
        if (updated) {
            this.config.store();
        }
        if (connectorUpdated) {
            this.site.getServer().setSites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check() {
        URL l_url = null;
        String l_szProt = "http";
        HttpURLConnection l_huc = null;
        try {
            if (this.config.isSecure()) {
                this.addKeyStoreCertificates();
                l_szProt = "https";
            }
            l_url = new URL(l_szProt, this.config.getAddress().getHostName(), this.config.getPort(), "/");
            l_huc = (HttpURLConnection)l_url.openConnection();
            l_huc.setDoInput(true);
            l_huc.setDoOutput(true);
            l_huc.setRequestMethod("GET");
            int l_iHttpCode = l_huc.getResponseCode();
            if (l_iHttpCode != 200) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (l_huc != null) {
                l_huc.disconnect();
            }
        }
    }

    private boolean equals(String p_szOldValue, String p_szNewValue) {
        return (p_szOldValue != null || p_szNewValue == null) && (p_szOldValue == null || p_szNewValue == null || p_szOldValue.equalsIgnoreCase(p_szNewValue));
    }

    private void addKeyStoreCertificates() throws Exception {
        SSLConfig l_sslCfg = this.config.getSSLConfig();
        if (l_sslCfg == null) {
            throw new Exception("SSLConfig information missing.");
        }
        OC4JSSLSocketFactory sslSocketFactory = new OC4JSSLSocketFactory("http", l_sslCfg);
        SSLSocketFactory l_sslSF = (SSLSocketFactory)sslSocketFactory.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(l_sslSF);
    }
}

