/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TagLibraryUse
implements XMLizable {
    protected String uri;
    protected String location;

    public TagLibraryUse() {
    }

    public TagLibraryUse(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("#text")) continue;
            if (name.equals("taglib-uri")) {
                this.uri = XMLUtils.getStringValue(node);
                continue;
            }
            if (!name.equals("taglib-location")) continue;
            this.location = XMLUtils.getStringValue(node);
        }
        if (this.uri == null) {
            throw new InstantiationException("taglib-uri not specified in taglib tag");
        }
    }

    public String getURI() {
        return this.uri;
    }

    public String getLocation() {
        return this.location;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<taglib>");
        if (this.uri != null) {
            out.println(indention + "\t<taglib-uri>" + XMLUtils.encode(this.uri) + "</taglib-uri>");
        }
        if (this.location != null) {
            out.println(indention + "\t<taglib-location>" + XMLUtils.encode(this.location) + "</taglib-location>");
        }
        out.println(indention + "</taglib>");
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

