/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.deployment.J2EEContextAnnotationParser;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.http.deployment.ServletDescriptor;
import com.evermind.server.http.deployment.WARAnnotationParser;
import com.evermind.server.http.deployment.WARAnnotations;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import oracle.oc4j.configuration.J2EEContextConfigDelegate;

public class WARAnnotationHelper
extends J2EEContextAnnotationParser {
    public boolean parseAnnotatedClass(HttpApplicationDescriptor desc, Class cls) throws InstantiationException {
        J2EEContextConfigDelegate jccd = null;
        jccd = desc.getConfigDelegate();
        this.parse(jccd, cls);
        this.parseSecurityAnnotations(desc, cls);
        for (Method method : this.getAnnotationManager().getMethods(cls)) {
            this.parseLifecycleAnnotations(desc, method, cls);
        }
        return true;
    }

    protected void parseSecurityAnnotations(HttpApplicationDescriptor desc, Class cls) throws InstantiationException {
        Object annot = cls.getAnnotation(WARAnnotations.RUN_AS_ANNOTATION);
        if (annot != null) {
            this.parseRunAsAnnotation(desc, ((RunAs)annot).value(), cls);
        }
        if ((annot = cls.getAnnotation(WARAnnotations.DECLARE_ROLES_ANNOTATION)) != null) {
            this.parseDeclareRolesAnnotation(desc, ((DeclareRoles)annot).value());
        }
    }

    protected void parseLifecycleAnnotations(HttpApplicationDescriptor desc, Method method, Class baseCls) throws InstantiationException {
        if (method.isAnnotationPresent(WARAnnotations.POST_CONSTRUCT_ANNOTATION)) {
            WARAnnotationParser.setPostConstructMethod(desc, method, baseCls);
        }
        if (method.isAnnotationPresent(WARAnnotations.PRE_DESTROY_ANNOTATION)) {
            WARAnnotationParser.setPreDestroyMethod(desc, method, baseCls);
        }
    }

    private void parseRunAsAnnotation(HttpApplicationDescriptor desc, String runAs, Class cls) {
        ServletDescriptor servletDesc = desc.getServletDescriptor(cls);
        if (servletDesc != null) {
            servletDesc.setRunAsRoleName(runAs);
        }
    }

    private void parseDeclareRolesAnnotation(HttpApplicationDescriptor desc, String[] roleNames) {
        for (String role : roleNames) {
            desc.addSecurityRole(new SecurityRole(role));
        }
    }

    protected boolean checkForAnnotations(Class cls) {
        try {
            if (cls.getAnnotations().length > 0) {
                return true;
            }
            for (Method method : cls.getDeclaredMethods()) {
                if (method.getAnnotations().length <= 0) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
                if (accessibleObject.getAnnotations().length <= 0) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

