/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public final class CMTMessageProducer
implements MessageProducer {
    private final CMTSession m_sess;
    private final MessageProducer m_prod;

    CMTMessageProducer(CMTSession sess, MessageProducer prod) {
        this.m_sess = sess;
        this.m_prod = prod;
    }

    public MessageProducer unwrap() {
        return this.m_prod;
    }

    public String toString() {
        return "CMTMessageProducer[" + this.m_sess + "," + this.m_prod + "]";
    }

    public void close() throws JMSException {
        this.m_prod.close();
    }

    public int getDeliveryMode() throws JMSException {
        return this.m_prod.getDeliveryMode();
    }

    public Destination getDestination() throws JMSException {
        return this.m_prod.getDestination();
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.m_prod.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.m_prod.getDisableMessageTimestamp();
    }

    public int getPriority() throws JMSException {
        return this.m_prod.getPriority();
    }

    public long getTimeToLive() throws JMSException {
        return this.m_prod.getTimeToLive();
    }

    public synchronized void send(Destination d, Message msg) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_prod.send(d, msg);
    }

    public synchronized void send(Destination d, Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_prod.send(d, msg, deliveryMode, priority, ttl);
    }

    public synchronized void send(Message msg) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_prod.send(msg);
    }

    public synchronized void send(Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_prod.send(msg, deliveryMode, priority, ttl);
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.m_prod.setDeliveryMode(deliveryMode);
    }

    public void setDisableMessageID(boolean noMsgID) throws JMSException {
        this.m_prod.setDisableMessageID(noMsgID);
    }

    public void setDisableMessageTimestamp(boolean noTimestamp) throws JMSException {
        this.m_prod.setDisableMessageTimestamp(noTimestamp);
    }

    public void setPriority(int priority) throws JMSException {
        this.m_prod.setPriority(priority);
    }

    public void setTimeToLive(long ttl) throws JMSException {
        this.m_prod.setTimeToLive(ttl);
    }
}

