/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.security.SecuritySensitive;
import com.evermind.server.jms.JMSServerProxy;
import java.io.Serializable;
import java.net.InetAddress;

public class ConnectInfo
implements Serializable {
    private final InetAddress m_addr;
    private final int m_port;
    private final String m_tunnel;
    private final String m_keystore;
    private final String m_keystorePassword;
    private final String m_truststore;
    private final String m_truststorePassword;
    private final String m_provider;
    private final String m_user;
    private final String m_pass;
    private final String m_clientID;
    private transient String m_clear_pass;
    private transient String m_clear_keystorePassword;
    private transient String m_clear_truststorePassword;
    static final long serialVersionUID = -7663314644520435217L;

    protected ConnectInfo(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID) {
        this.m_addr = addr;
        this.m_port = port;
        this.m_tunnel = tunnel;
        this.m_keystore = keystore;
        this.m_keystorePassword = keystorePassword;
        this.m_truststore = truststore;
        this.m_truststorePassword = truststorePassword;
        this.m_provider = provider;
        this.m_user = user;
        this.m_pass = pass;
        this.m_clientID = clientID;
    }

    protected final InetAddress getAddr() {
        return this.m_addr;
    }

    protected final int getPort() {
        return this.m_port;
    }

    protected final String getTunnel() {
        return this.m_tunnel;
    }

    protected final String getKeystore() {
        return this.m_keystore;
    }

    protected final String getKeystorePassword() {
        this.m_clear_keystorePassword = this.getSecurePassword(this.m_keystorePassword, this.m_clear_keystorePassword);
        return this.m_clear_keystorePassword;
    }

    protected final String getTruststore() {
        return this.m_truststore;
    }

    protected final String getTruststorePassword() {
        this.m_clear_truststorePassword = this.getSecurePassword(this.m_truststorePassword, this.m_clear_truststorePassword);
        return this.m_clear_truststorePassword;
    }

    protected final String getProvider() {
        return this.m_provider;
    }

    protected final String getUser() {
        return this.m_user;
    }

    protected final String getPass() {
        this.m_clear_pass = this.getSecurePassword(this.m_pass, this.m_clear_pass);
        return this.m_clear_pass;
    }

    private final String getSecurePassword(String pass, String clearPass) {
        String tmpClearPass = clearPass;
        if (tmpClearPass == null && this.getProxy().inContainer()) {
            tmpClearPass = SecuritySensitive.global().decode(pass, null);
        } else if (pass != null && !this.getProxy().inContainer()) {
            tmpClearPass = pass;
        }
        return tmpClearPass;
    }

    protected final String getClientID() {
        return this.m_clientID;
    }

    protected final JMSServerProxy getProxy() {
        return JMSServerProxy.getProxy();
    }
}

