/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSStats;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.MessageSelector;
import com.evermind.server.jms.ServerDestination;
import com.evermind.server.jms.Tset;
import com.evermind.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Topic;
import oracle.oc4j.admin.management.callbackinterfaces.JMSDurableSubscriberCallBackIf;
import oracle.oc4j.admin.management.mbeans.JMSDurableSubscriber;

public final class ConsumerInfo
implements Serializable,
JMSDurableSubscriberCallBackIf {
    private final Serializable m_dest;
    private final String m_name;
    private final MessageSelector m_selector;
    private final boolean m_noLocal;
    private final boolean m_isDurable;
    private final String m_clientID;
    private final String m_connID;
    private final int m_count;
    private final String m_id;
    private final Tset m_isClosed = new Tset(false);
    private final String m_statsName;
    private transient String m_statsSelf = null;
    private transient JMSStats m_jstats = null;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(ConsumerInfo.class);
    private static int s_count = 0;
    private static final Map s_intCons = new HashMap();
    private static final Map s_nameCons = new HashMap();
    static final long serialVersionUID = -6201211890272364113L;

    ConsumerInfo(ServerDestination sdest, String name, String selector, boolean noLocal, String clientID, String connID) throws JMSException {
        this(sdest.getDestination(), name, selector, noLocal, clientID, connID, JMSUtils.newID("ServerConsumer"));
        ConsumerInfo.addMap(this);
        sdest.addConsumer(this);
    }

    private ConsumerInfo(Destination dest, String name, String selector, boolean noLocal, String clientID, String connID, String id) throws JMSException {
        this.m_dest = (Serializable)dest;
        this.m_name = name;
        this.m_selector = MessageSelector.getSelector(selector);
        this.m_noLocal = noLocal;
        this.m_isDurable = this.m_dest instanceof Topic && !JMSUtils.isNull(this.m_name);
        this.m_clientID = clientID;
        this.m_connID = connID;
        this.m_count = ConsumerInfo.nextCount();
        this.m_id = id;
        this.m_statsSelf = this.m_isDurable ? "DurableSubscriber." + this.m_name : null;
        this.m_statsName = this.m_isDurable ? JMSUtils.path("/JMS", this.m_statsSelf) : null;
    }

    public boolean equals(Object obj) {
        return obj == null ? false : (obj instanceof ConsumerInfo ? this.isSame((ConsumerInfo)obj) : false);
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public String toString() {
        return "ConsumerInfo[destination=" + this.m_dest + ",name=" + this.m_name + ",selector=" + this.m_selector + ",noLocal=" + this.m_noLocal + ",clientID=" + this.m_clientID + ",connection=" + this.m_connID + ",count=" + this.m_count + ",id=" + this.m_id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toXML() {
        String string;
        if (!this.m_isDurable) {
            return "";
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            pw.println("<durable-consumer");
            pw.println("    name=\"" + XMLUtils.encode(JMSUtils.fold(this.m_name)) + "\"");
            pw.println("    destination=\"" + XMLUtils.encode(JMSUtils.getName((Destination)this.m_dest)) + "\"");
            pw.println("    selector=\"" + XMLUtils.encode(this.m_selector.getSelectorString()) + "\"");
            pw.println("    noLocal=\"" + this.m_noLocal + "\"");
            pw.println("    clientID=\"" + XMLUtils.encode(JMSUtils.fold(this.m_clientID)) + "\" />");
            pw.flush();
            sw.flush();
            string = sw.toString();
        }
        catch (Throwable ex) {
            try {
                s_traceLogger.fine("toXML", ex);
            }
            catch (Throwable throwable) {
                JMSUtils.closeIt(sw);
                JMSUtils.closeIt(pw);
                throw throwable;
            }
            JMSUtils.closeIt(sw);
            JMSUtils.closeIt(pw);
            return "";
        }
        JMSUtils.closeIt(sw);
        JMSUtils.closeIt(pw);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized byte[] toBytes() throws IOException {
        ByteArrayOutputStream bout = null;
        DataOutputStream dout = null;
        byte[] buf = null;
        try {
            bout = new ByteArrayOutputStream();
            dout = new DataOutputStream(bout);
            this.writeTo(dout);
            dout.flush();
            bout.flush();
            buf = bout.toByteArray();
        }
        catch (Throwable throwable) {
            JMSUtils.closeIt(dout);
            JMSUtils.closeIt(bout);
            throw throwable;
        }
        JMSUtils.closeIt(dout);
        JMSUtils.closeIt(bout);
        return buf;
    }

    private void writeTo(DataOutput dout) throws IOException {
        dout.writeByte(7);
        JMSUtils.cuteWrite((Destination)this.m_dest, dout);
        JMSUtils.packWrite(this.m_name, dout);
        dout.writeUTF(this.m_selector.getSelectorString());
        dout.writeBoolean(this.m_noLocal);
        dout.writeUTF(JMSUtils.fold(this.m_clientID));
        dout.writeUTF(this.m_connID);
        dout.writeUTF(this.m_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized ConsumerInfo toConsumer(byte[] buf) throws IOException {
        ConsumerInfo cons;
        block6: {
            ByteArrayInputStream binp = null;
            DataInputStream dinp = null;
            cons = null;
            try {
                binp = new ByteArrayInputStream(buf);
                dinp = new DataInputStream(binp);
                byte code = dinp.readByte();
                if (code == 7) {
                    cons = ConsumerInfo.readConsumer(dinp);
                }
                JMSUtils.closeIt(dinp);
            }
            catch (JMSException ex) {
                JMSUtils.toIOException("toConsumer", ex);
                break block6;
            }
            finally {
                JMSUtils.closeIt(dinp);
                JMSUtils.closeIt(binp);
            }
            JMSUtils.closeIt(binp);
        }
        return cons;
    }

    private static ConsumerInfo readConsumer(DataInput dinp) throws IOException, JMSException {
        Destination dest = JMSUtils.cuteRead(dinp);
        String name = (String)JMSUtils.packRead(dinp);
        String selector = dinp.readUTF();
        boolean noLocal = dinp.readBoolean();
        String clientID = dinp.readUTF();
        String connID = dinp.readUTF();
        String id = dinp.readUTF();
        ConsumerInfo ret = ConsumerInfo.find(clientID, name);
        if (ret == null) {
            ret = new ConsumerInfo(dest, name, selector, noLocal, clientID, connID, id);
        }
        return ret;
    }

    Destination getDestination() {
        return (Destination)this.m_dest;
    }

    String getName() {
        return this.m_name;
    }

    MessageSelector getSelector() {
        return this.m_selector;
    }

    boolean isNoLocal() {
        return this.m_noLocal;
    }

    boolean isDurable() {
        return this.m_isDurable;
    }

    String getClientID() {
        return this.m_clientID;
    }

    String getConnID() {
        return this.m_connID;
    }

    int getCount() {
        return this.m_count;
    }

    String getID() {
        return this.m_id;
    }

    boolean isSame(String dName, String selector, boolean noLocal) throws JMSException {
        return JMSUtils.getName((Destination)this.m_dest).equals(dName) && this.m_selector.equals(selector) && this.m_noLocal == noLocal;
    }

    synchronized void close() {
        this.m_isClosed.set(true);
        this.updateActive();
    }

    synchronized void open() {
        this.m_isClosed.set(false);
        this.updateActive();
    }

    synchronized boolean isClosed() {
        return this.m_isClosed.test();
    }

    void remove(ServerDestination sdest) throws JMSException {
        sdest.removeConsumer(this);
        ConsumerInfo.removeMap(this);
    }

    static synchronized void clear() {
        s_intCons.clear();
        s_nameCons.clear();
    }

    static synchronized void loadConsumers(List dcons) throws InstantiationException {
        try {
            Iterator iter = dcons.iterator();
            while (iter.hasNext()) {
                ConsumerInfo cons = (ConsumerInfo)iter.next();
                if (!cons.isDurable()) {
                    JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-01000", cons));
                }
                ConsumerInfo.addMap(cons);
                cons.close();
            }
        }
        catch (Throwable ex) {
            JMSUtils.toInstantiationException("loadConsumers", ex);
        }
    }

    static synchronized void unloadConsumers(List dcons) throws InstantiationException {
        try {
            Iterator iter = dcons.iterator();
            while (iter.hasNext()) {
                ConsumerInfo cons = (ConsumerInfo)iter.next();
                if (!cons.isDurable()) {
                    JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-01000", cons));
                }
                ConsumerInfo.removeMap(cons);
                cons.close();
            }
        }
        catch (Throwable ex) {
            JMSUtils.toInstantiationException("unloadConsumers", ex);
        }
    }

    static synchronized List listDurables() {
        ArrayList<ConsumerInfo> ret = new ArrayList<ConsumerInfo>();
        Iterator iter = s_intCons.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ConsumerInfo cons = (ConsumerInfo)entry.getValue();
            if (!cons.isDurable()) continue;
            ret.add(cons);
        }
        return ret;
    }

    static synchronized ConsumerInfo find(String clientID, String name) {
        if (JMSUtils.isNull(name)) {
            return null;
        }
        if (!s_nameCons.containsKey(clientID)) {
            return null;
        }
        Map m = (Map)s_nameCons.get(clientID);
        if (!m.containsKey(name)) {
            return null;
        }
        return (ConsumerInfo)m.get(name);
    }

    static synchronized ConsumerInfo find(int consID) {
        Integer i = new Integer(consID);
        if (!s_intCons.containsKey(i)) {
            return null;
        }
        return (ConsumerInfo)s_intCons.get(i);
    }

    private boolean isSame(ConsumerInfo cons) {
        if (!this.isDurable()) {
            return this.getID().equals(cons.getID());
        }
        return this.m_dest.equals(cons.m_dest) && this.m_name.equals(cons.m_name) && this.m_selector.equals(cons.m_selector) && this.m_clientID.equals(cons.m_clientID) && this.m_noLocal == cons.m_noLocal;
    }

    private static synchronized int nextCount() {
        return ++s_count;
    }

    private static synchronized void addMap(ConsumerInfo cons) throws JMSException {
        ConsumerInfo old = ConsumerInfo.find(cons.m_clientID, cons.m_name);
        if (old != null) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01001", cons, old));
        }
        s_intCons.put(new Integer(cons.m_count), cons);
        if (cons.isDurable()) {
            HashMap<String, ConsumerInfo> m = (HashMap<String, ConsumerInfo>)s_nameCons.get(cons.m_clientID);
            if (m == null) {
                m = new HashMap<String, ConsumerInfo>();
                s_nameCons.put(cons.m_clientID, m);
            }
            m.put(cons.m_name, cons);
            cons.initStats();
        }
    }

    private static synchronized void removeMap(ConsumerInfo cons) throws JMSException {
        s_intCons.remove(new Integer(cons.m_count));
        if (!cons.isDurable()) {
            return;
        }
        ConsumerInfo old = ConsumerInfo.find(cons.m_clientID, cons.m_name);
        Map m = (Map)s_nameCons.get(cons.m_clientID);
        m.remove(cons.m_name);
        if (cons.m_jstats != null) {
            cons.m_jstats.close();
        }
    }

    private void initStats() throws JMSException {
        if (JMSUtils.isNull(this.m_statsName)) {
            return;
        }
        this.m_jstats = JMSStats.create("/JMS", this.m_statsSelf, "JMSDurableSubscriber");
        this.m_jstats.setMBean(new JMSDurableSubscriber(this, this.m_name, this.m_statsSelf, JMSUtils.getName((Destination)this.m_dest), JMSUtils.fold(this.m_clientID), this.m_selector.getSelectorString(), this.m_noLocal));
        this.m_jstats.state("name", this.m_name, true);
        this.m_jstats.state("destination", JMSUtils.getName((Destination)this.m_dest), true);
        this.m_jstats.state("clientID", JMSUtils.fold(this.m_clientID), true);
        this.m_jstats.state("selector", this.m_selector.getSelectorString(), true);
        this.m_jstats.state("noLocal", new Boolean(this.m_noLocal), true);
        this.updateActive();
    }

    private void updateActive() {
        if (this.m_jstats != null) {
            this.m_jstats.state("isActive", new Boolean(!this.m_isClosed.test()));
        }
    }

    public boolean isActive() {
        return !this.m_isClosed.test();
    }
}

