/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.config.XMLConfigElement;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class DummyXMLConfigElement
implements XMLConfigElement {
    private final Node m_node;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(DummyXMLConfigElement.class);

    public DummyXMLConfigElement(Node node) {
        this.m_node = node;
        s_traceLogger.finer("using DummyXMLConfigElement");
    }

    public void writeXML(PrintWriter out, String indent) throws IOException {
        DummyXMLConfigElement.writeElement(this.m_node, out, indent, 1);
        out.println("");
    }

    private static void writeElement(Node node, PrintWriter out, String indent, int depth) throws IOException {
        String thisIndent = DummyXMLConfigElement.getIndent(indent, depth);
        out.print("\n" + thisIndent + "<" + node.getNodeName());
        s_traceLogger.finer("wrote element <{0}>", new Object[]{node.getNodeName()});
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int index = 0; index < attrs.getLength(); ++index) {
                Node attr = attrs.item(index);
                out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                s_traceLogger.finer("wrote attribute {0}=\"{1}\"", new Object[]{attr.getNodeName(), attr.getNodeValue()});
            }
        }
        out.print(">");
        NodeList nodes = node.getChildNodes();
        boolean wroteChild = false;
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node child = nodes.item(index);
            if (child.getNodeType() == 8) {
                out.print("\n" + thisIndent + indent + "<!--" + child.getNodeValue() + "-->");
                wroteChild = true;
                s_traceLogger.finer("wrote comment <!--{0}-->", new Object[]{child.getNodeValue()});
                continue;
            }
            if (child.getNodeType() == 3 && !child.getNodeValue().trim().equals("")) {
                out.print(child.getNodeValue().trim());
                s_traceLogger.finer("wrote text \"{0}\"", new Object[]{child.getNodeValue().trim()});
                continue;
            }
            if (!child.getNodeName().startsWith("#")) {
                DummyXMLConfigElement.writeElement(child, out, indent, depth + 1);
                wroteChild = true;
                continue;
            }
            s_traceLogger.finer("did not write node \"{0}\"", new Object[]{child.getNodeName()});
        }
        out.print((wroteChild ? "\n" + thisIndent : "") + "</" + node.getNodeName() + ">");
    }

    private static String getIndent(String indent, int depth) {
        if (depth <= 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer(indent);
        while (depth > 1) {
            buff.append(indent);
            --depth;
        }
        return buff.toString();
    }
}

