/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindConnection;
import com.evermind.server.jms.EvermindQueueSession;
import com.evermind.server.jms.EvermindSession;
import com.evermind.server.jms.EvermindXAQueueSession;
import java.net.InetAddress;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;

public class EvermindQueueConnection
extends EvermindConnection
implements QueueConnection {
    public EvermindQueueConnection(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass) throws JMSException {
        this(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, null, false);
    }

    EvermindQueueConnection(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID, boolean isXA) throws JMSException {
        super(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID, isXA, 0);
    }

    public final synchronized ConnectionConsumer createConnectionConsumer(Queue q, String selector, ServerSessionPool pool, int maxMessages) throws JMSException {
        return super.createConnectionConsumer((Destination)q, selector, pool, maxMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        this.lock("createQueueSession");
        try {
            EvermindSession evermindSession = this.isXA() ? new EvermindXAQueueSession(this) : new EvermindQueueSession(this, transacted, ackMode);
            return evermindSession;
        }
        finally {
            this.unlock();
        }
    }
}

