/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindConnectionFactory;
import com.evermind.server.jms.EvermindQueueConnection;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import java.net.InetAddress;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;

public class EvermindQueueConnectionFactory
extends EvermindConnectionFactory
implements QueueConnectionFactory {
    static final long serialVersionUID = 5261527459160219858L;

    EvermindQueueConnectionFactory(InetAddress addr, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID, boolean isXA) {
        super(addr, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID, isXA, 0);
    }

    public final synchronized QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(this.getUser(), this.getPass());
    }

    public final synchronized QueueConnection createQueueConnection(final String user, final String pass) throws JMSException {
        QueueConnection conn = null;
        try {
            conn = (QueueConnection)this.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return EvermindQueueConnectionFactory.this.unprivileged_createQueueConnection(user, pass);
                }
            });
        }
        catch (JMSException jex) {
            throw jex;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JMSUtils.toJMSSecurityException(ex.getMessage());
        }
        return conn;
    }

    private QueueConnection unprivileged_createQueueConnection(String user, String pass) throws JMSException {
        return new EvermindQueueConnection(this.getAddr(), this.getPort(), this.getTunnel(), this.getKeystore(), this.getKeystorePassword(), this.getTruststore(), this.getTruststorePassword(), this.getProvider(), user, pass, this.getClientID(), false);
    }
}

