/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.jms.ConfigPropertiesController;
import com.evermind.server.jms.DummyStats;
import com.evermind.server.jms.EvermindConnection;
import com.evermind.server.jms.EvermindConnectionConsumer;
import com.evermind.server.jms.JMSCommands;
import com.evermind.server.jms.JMSConnectionCallBack;
import com.evermind.server.jms.JMSConnectionConsumerCallBack;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSStats;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.KnobsController;
import com.evermind.server.jms.SecureOperation;
import java.net.InetAddress;
import javax.jms.JMSException;
import javax.management.j2ee.statistics.JMSConnectionStats;
import javax.management.j2ee.statistics.JMSConsumerStats;
import javax.management.j2ee.statistics.JMSEndpointStats;
import javax.management.j2ee.statistics.JMSProducerStats;
import javax.management.j2ee.statistics.JMSSessionStats;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import oracle.oc4j.admin.management.mbeans.JMSConnection;
import oracle.oc4j.admin.management.mbeans.JMSConnectionConsumer;
import oracle.oc4j.admin.management.shared.statistic.JMSConnectionStatsImpl;
import oracle.oc4j.admin.management.shared.statistic.JMSConsumerStatsImpl;
import oracle.oc4j.admin.management.shared.statistic.JMSProducerStatsImpl;
import oracle.oc4j.admin.management.shared.statistic.JMSSessionStatsImpl;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;

class InContainerProxy
extends JMSServerProxy {
    private final JMSServer m_jmsServer;

    InContainerProxy(JMSServer server) {
        this.m_jmsServer = server;
    }

    public boolean inContainer() {
        return true;
    }

    public boolean getDebug() {
        InContainerProxy inContainerProxy = this;
        return inContainerProxy.m_jmsServer.getDebug();
    }

    public JMSCommands getJMSServer(String user, String password) throws JMSException {
        return JMSServer.getJMSServer(user, password);
    }

    public JMSCommands getJMSServer(InetAddress addr, int port, String user, String password) throws JMSException {
        return JMSServer.getJMSServer(addr, port, user, password);
    }

    public void verifyJMSServer(JMSCommands server) throws JMSException {
        JMSServer.verifyServer(server);
    }

    public void setState(String clientID, String connID, boolean doClone) {
        try {
            ThreadState curr = ThreadState.getCurrentState();
            if (curr != null) {
                curr.setAttribute("Oc4jJMS.clientID", clientID);
                curr.setAttribute("Oc4jJMS.connectionID", connID);
                curr.setAttribute("Oc4jJMS.doClone", new Boolean(doClone));
            }
        }
        catch (Throwable ex) {
            JMSMessages.severeCannotSetState(clientID, connID, ex);
        }
    }

    public Object getState(String key) {
        Object ret = null;
        try {
            ThreadState curr = ThreadState.getCurrentState();
            if (curr != null) {
                ret = curr.getAttribute(key);
            }
        }
        catch (Throwable ex) {
            JMSMessages.severeCannotGetState(key, ex);
        }
        return ret;
    }

    public ConfigPropertiesController getPropertiesController() {
        return KnobsController.getKnobsController();
    }

    public Transaction getEnlistingTrans() {
        try {
            return ApplicationServer.getInstance().getTransactionManager().getTransaction();
        }
        catch (SystemException systemException) {
            return null;
        }
    }

    public boolean doEnlist(Transaction appTrans, Transaction tx) {
        ThreadState state = ThreadState.getCurrentState();
        return state != null && tx != appTrans;
    }

    public Object doSecureOp(final SecureOperation op) throws Exception {
        Object ret = null;
        if (!OC4JSecurity.isSecurityOn()) {
            ret = op.execute();
        } else {
            OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

                public Object oc4jRun() throws Exception {
                    return op.execute();
                }
            };
            ret = OC4JSecurity.doPrivileged(action);
        }
        return ret;
    }

    public Object doSecureOpNoException(final SecureOperation op) {
        Object ret = null;
        if (!OC4JSecurity.isSecurityOn()) {
            ret = op.executeNoException();
        } else {
            OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

                public Object oc4jRun() {
                    return op.executeNoException();
                }
            };
            ret = OC4JSecurity.doPrivileged(action);
        }
        return ret;
    }

    public JMSConnectionStats getJMSConnectionStats(String metricPath) {
        return new JMSConnectionStatsImpl(metricPath);
    }

    public JMSSessionStats getJMSSessionStats(String metricPath) {
        return new JMSSessionStatsImpl(metricPath);
    }

    public JMSConsumerStats getJMSConsumerStats(String origin, String metricPath) {
        return new JMSConsumerStatsImpl(origin, metricPath);
    }

    public JMSProducerStats getJMSProducerStats(String dest, String metricPath) {
        return new JMSProducerStatsImpl(dest, metricPath);
    }

    public void addConnection(JMSConnectionStats conn) {
        JMSServer.add(conn);
    }

    public void removeConnection(JMSConnectionStats conn) {
        JMSServer.remove(conn);
    }

    public void addSession(JMSConnectionStats conn, JMSSessionStats sess, boolean transacted) {
        if (conn != null) {
            ((JMSConnectionStatsImpl)conn).add(sess);
            ((JMSConnectionStatsImpl)conn).setTransactional(transacted);
        }
    }

    public void removeSession(JMSConnectionStats conn, JMSSessionStats sess) {
        if (conn != null) {
            ((JMSConnectionStatsImpl)conn).remove(sess);
            ((JMSConnectionStatsImpl)conn).setTransactional(false);
        }
    }

    public void addEndpoint(JMSSessionStats sess, JMSEndpointStats endpoint) {
        if (sess != null) {
            ((JMSSessionStatsImpl)sess).add(endpoint);
        }
    }

    public void removeEndpoint(JMSSessionStats sess, JMSEndpointStats endpoint) {
        if (sess != null) {
            ((JMSSessionStatsImpl)sess).remove(endpoint);
        }
    }

    public DummyStats createStats(String parent, String self, String type) {
        return JMSStats.create(parent, self, type);
    }

    public void setJMSConnectionMBean(DummyStats stats, EvermindConnection conn, long startTime, boolean isLocal, InetAddress addr, int port) {
        ((JMSStats)stats).setMBean(isLocal ? new JMSConnection(new JMSConnectionCallBack(conn), conn.getID(), JMSUtils.fold(conn.getUser()), JMSUtils.pp(conn.getDomain()), conn.isXA(), startTime) : new JMSConnection(new JMSConnectionCallBack(conn), conn.getID(), JMSUtils.fold(conn.getUser()), JMSUtils.pp(conn.getDomain()), conn.isXA(), addr, port, startTime));
    }

    public void setJMSConnectionConsumerMBean(DummyStats stats, EvermindConnectionConsumer cons, EvermindConnection conn, String dest, String name, String selector, int maxMsgs) {
        ((JMSStats)stats).setMBean(new JMSConnectionConsumer(new JMSConnectionConsumerCallBack(cons), cons.getID(), conn.getID(), dest, name, selector, maxMsgs));
    }
}

