/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConsumerInfo;
import com.evermind.server.jms.EvermindConnection;
import com.evermind.server.jms.EvermindConnectionFactory;
import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.EvermindMessageBrowser;
import com.evermind.server.jms.EvermindMessageConsumer;
import com.evermind.server.jms.EvermindMessageProducer;
import com.evermind.server.jms.EvermindObjectMessage;
import com.evermind.server.jms.EvermindSession;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSProvider;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.Knobs;
import com.evermind.server.jms.MessageSelector;
import com.evermind.server.jms.ServerDestination;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import oracle.oc4j.admin.management.callbackinterfaces.JMSUtilsCallBackIf;

public class JMSServerUtils {
    private static final String USAGE = "Usage: JMSUtils <generic-options> <command> <command-options> <arguments>\n       JMSUtils help\n";
    private static final String HELP = "Usage: JMSUtils <generic-options> <command> <command-options> <arguments>\n\n\nThis command is meant to be used as a standalone Java application,\ninvoked from a shell commandline.  It is not meant to be used within\nWeb or EJB containers.  All of the operations of this command require\nOC4J JMS administered objects (i.e. connection factories and\ndestinations); attempts to use this as a generic JMS tool with\narbitrary JMS providers will result in errors.\n\nOC4J JMS administered objects are created directly, and not through\nJNDI.  OC4J JMS connection factories are specified via the generic\noptions, and the OC4J JMS destinations are specified via\nprovider-specific destination names (which are not necessarily the same\nas JNDI locations that these names are mapped to).\n\nJMSUtils will work only in an environment with full network\nconnectivity between the client and the OC4J JMS server.  It will not\nwork across firewalls.\n\n\nGeneric Options:\n\n    Generic options are used to identify an OC4J JMS server and\n    create an appropriate connection factory.  It is required for\n    all commands except for `help' and `check'.\n\n\n    -host <hostname>\n    -port <port>\n        The host/port identifying the OC4J JMS server to\n        connect to.\n\n        The default hostname is an empty string that is\n        internally converted to the hostname of the machine\n        where this command is being run.  The default port is\n        \"9127\".\n\n\n    -username <value>\n    -password <value>\n        The username/password for creating JMS connections.\n\n        If either of these options is not specified or is an\n        empty string, the default user identity and password\n        (as configured in the OC4J server) will be used.\n\n\n    -clientID <id>\n        Use the specified <id> as the clientID for all\n        JMS connections.\n\n        If a clientID is not specified, a default value of an\n        empty string is used. A clientID is required to\n        identify durable subscriptions on topics.\n\n\nCommands Options:\n\n    -selector <selector>\n        Create queue receivers and durable subscribers with the\n        specified message <selector>.\n\n        If this option is not specified, a default value of\n        `null' will be used (with the attendent semantics as\n        specified by JMS).\n\n\n    -noLocal (true|false)\n        Use the specified setting for the noLocal flag while\n        creating a durable subscriber.\n\n        The default value of this option is `false', and any\n        settings provided is ignored for all commands except\n        `subscribe'.\n\n\n    -name <name>\n        Use the specified <name> when operating on durable\n        subscriptions (`subscribe' and `unsubscribe'), and as\n        the <name> of an existing durable subscription for\n        commands that operate on topics.\n\n        This option is mandatory for commands that read topics,\n        and is ignored for commands that operate on queues.\n\n        When a <name> is specified while creating message\n        consumers/browsers on a topic, any settings specified\n        for `-selector' and `-noLocal' are ignored, and the\n        durable subscriber is recreated in its original state.\n\n\n    -silent\n        Do not pretty-print messages while processing them.  A\n        count of the total number of messages processed will\n        always be printed to standard error.\n\n\n    -count <count>\n        Do not process more than <count> messages during the\n        current operation.  By default or if <count> <= 0, all\n        available/selected messages are processed.\n\n\nCommands:\n\n\n    help\n        Print this help message.\n\n\n    check [<other-selector>]\n        Check the validity of the provided `-selector'.\n        Optionally also check if the specified <other-selector>\n        _is equal to_ the `-selector' according to OC4J JMS.\n\n\n    knobs\n        Print all available control knobs (and the current\n        settings of these knobs) in this OC4J JMS server.\n\n    stats\n        Print all available DMS statistics in this OC4J JMS\n        server.  This will print non-JMS statistics as well.\n\n\n    destinations\n        List all of the known permanent destinations in this\n        OC4J JMS server.  The output is in the same format used\n        for declaring OC4J JMS destinations in\n        `$J2EE_HOME/config/jms.xml'.\n\n\n    durables\n        List all known durable subscriptions in this OC4J JMS\n        server.\n\n\n    subscribe <topic>\n        Create a durable subscription on the provider-specific\n        <topic> name with the specified `-name', `-selector',\n        `-noLocal', in the specified `-clientID'.\n\n        If the subscription already exists and is active, an\n        exception will be thrown and no changes made.  If the\n        subscription already exists, but is inactive, this\n        command will _replace_ the original subscription with a\n        new one.  Use with care.\n\n\n    unsubscribe\n        Unsubscribe the specified durable subscription with the\n        specified `-name' in the specified `-clientID'.  If the\n        subscription does not exist or is currently active, an\n        exception will be thrown.\n\n\n    browse <destination>\n        Browse the provider-specific <destination> name of all\n        selected messages (always pretty-printing them to\n        standard output).\n\n\n    drain <destination>\n        Drain the provider-specific <destination> name of all\n        selected messages (optionally pretty-printing them to\n        standard output).\n\n\n    copy <from-destination> <to-destination>\n        Copy all selected messages from the <from-destination>\n        to the <to-destination> (optionally pretty-printing\n        them on standard output).\n\n\n    move <from-destination> <to-destination>\n        Move all selected messages from the <from-destination>\n        to the <to-destination> (optionally pretty-printing\n        them on standard output).\n\n\n";

    private JMSServerUtils() {
    }

    public static void main(String[] argv) {
        int argc;
        System.out.println(JMSProvider.NAME + ", " + "OC4J JMS 1.1\n");
        String host = "";
        int port = 9127;
        String tunnel = null;
        String keystore = null;
        String keystorePassword = null;
        String truststore = null;
        String truststorePassword = null;
        String provider = null;
        String user = null;
        String pass = null;
        String clientID = "";
        boolean noXact = false;
        if (argv.length == 0) {
            JMSServerUtils.usage(null);
        }
        for (argc = 0; argc < argv.length && argv[argc].startsWith("-"); ++argc) {
            if (JMSServerUtils.peekArg(argv, argc, "-host", 1)) {
                host = argv[++argc];
                continue;
            }
            if (JMSServerUtils.peekArg(argv, argc, "-port", 1)) {
                port = Integer.parseInt(argv[++argc]);
                continue;
            }
            if (JMSServerUtils.peekArg(argv, argc, "-username", 1)) {
                user = argv[++argc];
                continue;
            }
            if (JMSServerUtils.peekArg(argv, argc, "-password", 1)) {
                pass = argv[++argc];
                continue;
            }
            if (JMSServerUtils.peekArg(argv, argc, "-clientID", 1)) {
                clientID = argv[++argc];
                continue;
            }
            if (JMSServerUtils.peekArg(argv, argc, "-noXact", 0)) {
                noXact = true;
                continue;
            }
            JMSServerUtils.usage("unknown generic option `" + argv[argc] + "'");
        }
        if (argc >= argv.length) {
            JMSServerUtils.usage("no <command> specified");
        }
        String cmd = argv[argc++];
        String selector = null;
        boolean noLocal = false;
        String name = null;
        boolean doPrint = true;
        int count = 0;
        while (argc < argv.length && argv[argc].startsWith("-")) {
            if (JMSServerUtils.peekArg(argv, argc, "-selector", 1)) {
                selector = argv[++argc];
            } else if (JMSServerUtils.peekArg(argv, argc, "-noLocal", 1)) {
                noLocal = Boolean.valueOf(argv[++argc]);
            } else if (JMSServerUtils.peekArg(argv, argc, "-name", 1)) {
                name = argv[++argc];
            } else if (JMSServerUtils.peekArg(argv, argc, "-silent", 0)) {
                doPrint = false;
            } else if (JMSServerUtils.peekArg(argv, argc, "-count", 1)) {
                count = Integer.parseInt(argv[++argc]);
            } else {
                JMSServerUtils.usage("unknown option `" + argv[argc] + "' for command `" + cmd + "'");
            }
            ++argc;
        }
        EvermindConnectionFactory cf = null;
        try {
            cf = JMSServerUtils.makeCf(host, port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID);
        }
        catch (Throwable ex) {
            JMSServerUtils.usage("unknown hostname `" + host + "': lookup threw exception " + ex.toString());
        }
        if (cmd.equals("help")) {
            JMSServerUtils.help();
        } else if (cmd.equals("check")) {
            if (JMSUtils.isNull(selector)) {
                JMSServerUtils.usage(cmd + " requires a non-null `-selector'");
            }
            JMSServerUtils.sel(selector, argc >= argv.length ? null : argv[argc++]);
        } else if (cmd.equals("knobs")) {
            JMSServerUtils.knobs(cf);
        } else if (cmd.equals("stats")) {
            JMSServerUtils.stats(cf);
        } else if (cmd.equals("subscribe")) {
            if (argc >= argv.length) {
                JMSServerUtils.usage(cmd + " requires a <topic>");
            }
            if (JMSUtils.isNull(name)) {
                JMSServerUtils.usage(cmd + " requires a non-null `-name'");
            }
            if (JMSUtils.isNull(argv[argc])) {
                JMSServerUtils.usage(cmd + " requires a non-null <topic>");
            }
            JMSServerUtils.subs(cf, argv[argc++], noXact, name, selector, noLocal);
        } else if (cmd.equals("unsubscribe")) {
            if (JMSUtils.isNull(name)) {
                JMSServerUtils.usage(cmd + " requires a non-null `-name'");
            }
            JMSServerUtils.subs(cf, null, noXact, name, null, false);
        } else if (cmd.equals("destinations")) {
            JMSServerUtils.dest(cf);
        } else if (cmd.equals("durables")) {
            JMSServerUtils.durable(cf);
        } else if (cmd.equals("browse")) {
            if (argc + 0 >= argv.length) {
                JMSServerUtils.usage(cmd + " requires a <destination>");
            }
            if (JMSUtils.isNull(argv[argc])) {
                JMSServerUtils.usage(cmd + " requires a non-null <destination>");
            }
            JMSServerUtils.scan(cf, argv[argc++], null, noXact, name, selector, true, false, count);
        } else if (cmd.equals("drain")) {
            if (argc + 0 >= argv.length) {
                JMSServerUtils.usage(cmd + " requires a <destination>");
            }
            if (JMSUtils.isNull(argv[argc])) {
                JMSServerUtils.usage(cmd + " requires a non-null <destination>");
            }
            JMSServerUtils.scan(cf, argv[argc++], null, noXact, name, selector, doPrint, true, count);
        } else if (cmd.equals("copy")) {
            if (argc + 1 >= argv.length) {
                JMSServerUtils.usage(cmd + " requires two <destination>s");
            }
            if (JMSUtils.isNull(argv[argc]) || JMSUtils.isNull(argv[argc + 1])) {
                JMSServerUtils.usage(cmd + " requires non-null <destination>s");
            }
            JMSServerUtils.scan(cf, argv[argc++], argv[argc++], noXact, name, selector, doPrint, false, count);
        } else if (cmd.equals("move")) {
            if (argc + 1 >= argv.length) {
                JMSServerUtils.usage(cmd + " requires two <destination>s");
            }
            if (JMSUtils.isNull(argv[argc]) || JMSUtils.isNull(argv[argc + 1])) {
                JMSServerUtils.usage(cmd + " requires non-null <destination>s");
            }
            JMSServerUtils.scan(cf, argv[argc++], argv[argc++], noXact, name, selector, doPrint, true, count);
        } else {
            JMSServerUtils.usage("unknown command `" + cmd + "'");
        }
        System.exit(0);
    }

    private static boolean peekArg(String[] argv, int argc, String option, int nargs) {
        if (!argv[argc].equals(option)) {
            return false;
        }
        if (argc + nargs >= argv.length) {
            JMSServerUtils.usage("option <" + option + "> requires `" + nargs + "' arguments");
        }
        return true;
    }

    static EvermindConnectionFactory makeCf(String host, int port, String tunnel, String keystore, String keystorePassword, String truststore, String truststorePassword, String provider, String user, String pass, String clientID) throws InstantiationException {
        return new EvermindConnectionFactory(JMSUtils.toAddress(host), port, tunnel, keystore, keystorePassword, truststore, truststorePassword, provider, user, pass, clientID, true, 2);
    }

    private static void usage(String msg) {
        if (!JMSUtils.isNull(msg)) {
            System.out.println("*** " + msg + " ***\n");
        }
        System.out.println(USAGE);
        System.exit(1);
    }

    private static void help() {
        System.out.println(HELP);
        System.exit(1);
    }

    public static void sel(String sel1, String sel2) {
        try {
            System.out.println(JMSServerUtils.check(sel1));
            if (sel2 != null && !sel2.equals("")) {
                System.out.println(JMSServerUtils.check(sel2));
                System.out.println("    equal:      " + JMSServerUtils.compare(sel1, sel2));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        System.out.println("");
    }

    public static String check(String sel) throws InvalidSelectorException {
        StringBuffer buff = new StringBuffer();
        MessageSelector selector = MessageSelector.getSelector(sel);
        buff.append("selector:       \"" + sel + "\" is valid.\n");
        buff.append("    canonical:  \"" + selector.getCanonicalString() + "\"\n");
        buff.append("    idempotent: " + selector.isIdempotent());
        return buff.toString();
    }

    public static boolean compare(String sel1, String sel2) throws InvalidSelectorException {
        MessageSelector s1 = MessageSelector.getSelector(sel1);
        MessageSelector s2 = MessageSelector.getSelector(sel2);
        return s1.equals(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void knobs(EvermindConnectionFactory cf) {
        EvermindConnection c = null;
        try {
            c = (EvermindConnection)cf.createConnection();
            System.out.println(c.getKnobs());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            JMSUtils.closeIt(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stats(EvermindConnectionFactory cf) {
        EvermindConnection c = null;
        try {
            c = (EvermindConnection)cf.createConnection();
            System.out.println(c.getStats());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            JMSUtils.closeIt(c);
        }
    }

    private static void subs(EvermindConnectionFactory cf, String tN, boolean noXact, String name, String selector, boolean noLocal) {
        try {
            JMSServerUtils.internalSubs(cf, tN, noXact, name, selector, noLocal);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void internalSubs(EvermindConnectionFactory cf, String tN, boolean noXact, String name, String selector, boolean noLocal) throws JMSException {
        EvermindSession s;
        EvermindConnection c;
        block3: {
            c = null;
            s = null;
            try {
                c = (EvermindConnection)cf.createConnection();
                EvermindSession evermindSession = s = noXact ? (EvermindSession)c.createSession(false, 1) : (EvermindSession)c.createSession(true, 0);
                if (!JMSUtils.isNull(tN)) {
                    TopicSubscriber sub = s.createDurableSubscriber(s.createTopic(tN), name, selector, noLocal);
                    JMSUtils.closeIt(sub);
                    break block3;
                }
                s.unsubscribe(name);
            }
            catch (Throwable throwable) {
                JMSUtils.closeIt(s);
                JMSUtils.closeIt(c);
                throw throwable;
            }
        }
        JMSUtils.closeIt(s);
        JMSUtils.closeIt(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dest(EvermindConnectionFactory cf) {
        EvermindConnection c = null;
        try {
            c = (EvermindConnection)cf.createConnection();
            List l = c.listDestinations();
            for (int i = 0; i < l.size(); ++i) {
                EvermindDestination d;
                String xml;
                if (!(l.get(i) instanceof EvermindDestination) || JMSUtils.isNull(xml = ServerDestination.toXML(d = (EvermindDestination)l.get(i)))) continue;
                System.out.println(ServerDestination.toXML(d));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            JMSUtils.closeIt(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void durable(EvermindConnectionFactory cf) {
        EvermindConnection c = null;
        try {
            c = (EvermindConnection)cf.createConnection();
            List l = c.listDurables();
            for (int i = 0; i < l.size(); ++i) {
                ConsumerInfo cons = (ConsumerInfo)l.get(i);
                if (!cons.isDurable()) continue;
                System.out.println(cons.toXML());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            JMSUtils.closeIt(c);
        }
    }

    private static void scan(EvermindConnectionFactory cf, String d0N, String d1N, boolean noXact, String name, String selector, boolean doPrint, boolean doDel, int maxMsgs) {
        try {
            String msg = JMSServerUtils.internalScan(cf, d0N, d1N, noXact, name, selector, doDel, maxMsgs);
            if (doPrint) {
                System.out.println(msg);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String internalScan(EvermindConnectionFactory cf, String d0N, String d1N, boolean noXact, String name, String selector, boolean doDel, int maxMsgs) throws JMSException {
        StringBuffer buff = new StringBuffer();
        EvermindConnection c = null;
        EvermindSession s = null;
        EvermindMessageBrowser b = null;
        EvermindMessageConsumer r = null;
        EvermindMessageProducer p = null;
        boolean noLocal = false;
        try {
            c = (EvermindConnection)cf.createConnection();
            Map dmap = JMSServerUtils.getDestinations(c);
            Destination d0 = (Destination)dmap.get(d0N);
            Destination d1 = (Destination)dmap.get(d1N);
            if (d0 == null) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02306", d0N, c));
            }
            if (!JMSUtils.isNull(d1N) && d1 == null) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02306", d1N, c));
            }
            if (d0 instanceof Topic) {
                if (JMSUtils.isNull(name)) {
                    JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01201", d0));
                }
                boolean found = false;
                List l = c.listDurables();
                for (int i = 0; i < l.size(); ++i) {
                    ConsumerInfo cons = (ConsumerInfo)l.get(i);
                    if (!cons.getClientID().equals(c.getClientID()) || !cons.getName().equals(name)) continue;
                    if (doDel) {
                        selector = cons.getSelector().getSelectorString();
                        noLocal = cons.isNoLocal();
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01201", name, c.getClientID()));
                }
            }
            EvermindSession evermindSession = s = noXact ? (EvermindSession)c.createSession(false, 1) : (EvermindSession)c.createSession(true, 0);
            if (JMSUtils.getName(d0).equals(JMSUtils.getName(d1))) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-01201", d0, d1));
            }
            if (!doDel) {
                b = s.makeBrowser(d0, name, selector);
            } else {
                r = d0 instanceof Topic ? (EvermindMessageConsumer)s.createDurableSubscriber((Topic)d0, name, selector, noLocal) : (EvermindMessageConsumer)s.createConsumer(d0);
            }
            p = d1 == null ? null : (EvermindMessageProducer)s.createProducer(d1);
            c.start();
            int count = 0;
            Message msg = null;
            Enumeration e = b == null ? null : b.getEnumeration();
            HashSet<String> seen = new HashSet<String>();
            while (maxMsgs <= 0 || count < maxMsgs) {
                if (doDel) {
                    msg = r.receiveNoWait();
                } else {
                    Message message = msg = e.hasMoreElements() ? (Message)e.nextElement() : null;
                }
                if (msg == null) break;
                if (seen.contains(msg.getJMSMessageID())) {
                    buff.append("*** skipping " + msg.getJMSMessageID() + ", already seen ***");
                    continue;
                }
                if (!JMSUtils.isNull(msg.getJMSMessageID())) {
                    seen.add(msg.getJMSMessageID());
                }
                ++count;
                buff.append(JMSUtils.pp(msg));
                if (p == null) continue;
                p.send(msg);
                if (JMSUtils.isNull(msg.getJMSMessageID())) continue;
                seen.add(msg.getJMSMessageID());
            }
            if (s.getTransacted()) {
                s.commit();
            }
            buff.append(count + " messages processed");
            Object var23_23 = null;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            JMSUtils.closeIt(p);
            JMSUtils.closeIt(r);
            JMSUtils.closeIt(b);
            JMSUtils.closeIt(s);
            JMSUtils.closeIt(c);
            throw throwable;
        }
        JMSUtils.closeIt(p);
        JMSUtils.closeIt(r);
        JMSUtils.closeIt(b);
        JMSUtils.closeIt(s);
        JMSUtils.closeIt(c);
        return buff.toString();
    }

    private static Map getDestinations(EvermindConnection c) throws JMSException {
        HashMap<String, EvermindDestination> ret = new HashMap<String, EvermindDestination>();
        List l = c.listDestinations();
        for (int i = 0; i < l.size(); ++i) {
            if (!(l.get(i) instanceof EvermindDestination)) continue;
            EvermindDestination d = (EvermindDestination)l.get(i);
            ret.put(JMSUtils.getName(d), d);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EvermindMessage wrapExpired(EvermindMessage msg, ConsumerInfo cons) throws JMSException {
        EvermindMessage evermindMessage = msg;
        synchronized (evermindMessage) {
            msg.wrapExpired();
            EvermindObjectMessage nmsg = new EvermindObjectMessage(msg);
            nmsg.setIntProperty("JMSXState", 3);
            EvermindMessage.copyExceptionHeaders(nmsg, msg);
            if (cons == null) {
                return nmsg;
            }
            nmsg.setStringProperty("JMS_OC4J_Selector", JMSUtils.fold(cons.getSelector().getSelectorString()));
            nmsg.setBooleanProperty("JMS_OC4J_NoLocal", cons.isNoLocal());
            if (cons.isDurable()) {
                nmsg.setStringProperty("JMS_OC4J_ClientID", JMSUtils.fold(cons.getClientID()));
                nmsg.setStringProperty("JMS_OC4J_Name", JMSUtils.fold(cons.getName()));
            } else {
                nmsg.setStringProperty("JMS_OC4J_Consumer", cons.getID());
            }
            return nmsg;
        }
    }

    public static int getPort(int def) throws InstantiationException {
        String prop = null;
        try {
            prop = Knobs.getProperty("port.jms");
            if (JMSUtils.isNull(prop) && JMSServer.IN_OPMN) {
                prop = "-1";
            }
        }
        catch (Throwable ex) {
            JMSUtils.toInstantiationException("getProperty(port.jms)", ex);
        }
        return JMSServerUtils.checkPort(prop, def);
    }

    public static int checkPort(String prop, int def) throws InstantiationException {
        int port = def;
        try {
            if (!JMSUtils.isNull(prop)) {
                port = Integer.parseInt(prop);
            }
        }
        catch (Throwable ex) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-02605", prop), ex);
        }
        if (!(port > 0 || JMSServer.IN_OPMN && port == -1)) {
            JMSUtils.toInstantiationException(JMSMessages.getMessage("J2EE JMS-02605", new Integer(port)));
        }
        return port;
    }

    static JMSUtilsCallBackIf getJMSUtilsCallBack(String dest, boolean isT) {
        return new JMSUtilsCommandLineUtilities(dest, isT);
    }

    private static class JMSUtilsCommandLineUtilities
    implements JMSUtilsCallBackIf {
        private final String m_dest;
        private final boolean m_isT;

        JMSUtilsCommandLineUtilities(String dest, boolean isT) {
            this.m_dest = dest;
            this.m_isT = isT;
        }

        public void subscribe(String name, String selector, Boolean noLocal, Boolean xact, String clientId) throws Exception {
            boolean boolNoLocal = false;
            try {
                boolNoLocal = noLocal;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            boolean boolXact = true;
            try {
                boolXact = xact;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            if (!this.m_isT) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02201", this.m_dest, "subscribe"));
            }
            JMSServerUtils.internalSubs(JMSUtilsCommandLineUtilities.makeDefaultCf(clientId), this.m_dest, !boolXact, name, selector, boolNoLocal);
        }

        public void unsubscribe(String name, Boolean xact, String clientId) throws Exception {
            if (!this.m_isT) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02201", this.m_dest, "unsubscribe"));
            }
            boolean boolXact = true;
            try {
                boolXact = xact;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            JMSServerUtils.internalSubs(JMSUtilsCommandLineUtilities.makeDefaultCf(clientId), null, !boolXact, name, null, false);
        }

        public String browse(String sub, String selector, Integer count, Boolean xact, String clientId) throws Exception {
            int intCnt = 0;
            try {
                intCnt = count;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            boolean boolXact = true;
            try {
                boolXact = xact;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            return JMSServerUtils.internalScan(JMSUtilsCommandLineUtilities.makeDefaultCf(clientId), this.m_dest, null, !boolXact, sub, selector, false, intCnt);
        }

        public void drain(String sub, String selector, Integer count, Boolean xact, String clientId) throws Exception {
            int intCnt = 0;
            try {
                intCnt = count;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            boolean boolXact = true;
            try {
                boolXact = xact;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            JMSServerUtils.internalScan(JMSUtilsCommandLineUtilities.makeDefaultCf(clientId), this.m_dest, null, !boolXact, sub, selector, true, intCnt);
        }

        public void copy(String toDest, String sub, String selector, Integer count, Boolean xact, String clientId) throws Exception {
            int intCnt = 0;
            try {
                intCnt = count;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            boolean boolXact = true;
            try {
                boolXact = xact;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            JMSServerUtils.internalScan(JMSUtilsCommandLineUtilities.makeDefaultCf(clientId), this.m_dest, toDest, !boolXact, sub, selector, false, intCnt);
        }

        public void move(String toDest, String sub, String selector, Integer count, Boolean xact, String clientId) throws Exception {
            int intCnt = 0;
            try {
                intCnt = count;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            boolean boolXact = true;
            try {
                boolXact = xact;
            }
            catch (Throwable tr) {
                // empty catch block
            }
            JMSServerUtils.internalScan(JMSUtilsCommandLineUtilities.makeDefaultCf(clientId), this.m_dest, toDest, !boolXact, sub, selector, true, intCnt);
        }

        private static EvermindConnectionFactory makeDefaultCf(String clientId) throws InstantiationException {
            return JMSServerUtils.makeCf("", JMSServer.getServer().getPort(), null, null, null, null, null, null, null, null, clientId);
        }
    }
}

