/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConfigPropertyEvent;
import com.evermind.server.jms.ConfigPropertyListener;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.KnobsController;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;

public final class JMXSupport {
    private static final JMSTraceLogger s_traceLogger;
    private static MBeanServer s_svr;
    private static boolean s_noJmx;

    static void forceAdd(J2EEManagedObjectBase bean) throws Throwable {
        JMXSupport.add(bean, true);
    }

    static void add(J2EEManagedObjectBase bean) throws Throwable {
        JMXSupport.add(bean, !JMXSupport.getNoJmx());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(J2EEManagedObjectBase bean, boolean reallyAdd) throws Throwable {
        if (!reallyAdd) {
            return;
        }
        if (bean == null) {
            throw new IllegalArgumentException("Argument \"bean\" cannot be null");
        }
        if (s_svr == null) {
            return;
        }
        ObjectName name = bean.getObjectName();
        MBeanServer mBeanServer = s_svr;
        synchronized (mBeanServer) {
            if (s_svr.isRegistered(name)) {
                s_svr.unregisterMBean(name);
            }
            s_svr.registerMBean(bean, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(ObjectName name) throws Throwable {
        if (s_svr == null) {
            return;
        }
        MBeanServer mBeanServer = s_svr;
        synchronized (mBeanServer) {
            if (s_svr.isRegistered(name)) {
                s_svr.unregisterMBean(name);
            }
        }
    }

    static String getCanonicalName(J2EEManagedObjectBase mbean) {
        try {
            if (mbean == null || mbean.getObjectName() == null) {
                return "";
            }
            return mbean.getObjectName().getCanonicalName();
        }
        catch (Throwable ex) {
            s_traceLogger.fine("getCanonicalName({0})", new Object[]{String.valueOf(mbean)}, ex);
            return "";
        }
    }

    private static boolean getNoJmx() {
        return s_noJmx;
    }

    private static void setNoJmx(boolean noJmx) {
        s_noJmx = noJmx;
    }

    public static Object invoke(ObjectName objName, String operation, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return s_svr.invoke(objName, operation, params, signature);
    }

    public static boolean isInstanceOf(ObjectName objName, String className) throws InstanceNotFoundException {
        return s_svr.isInstanceOf(objName, className);
    }

    static {
        s_svr = null;
        s_noJmx = (Boolean)KnobsController.getKnobsController().listenToConfigProperty("oc4j.jms.noJmx", new ConfigPropertyListener(){

            public void onConfigPropertyChange(ConfigPropertyEvent event) {
                JMXSupport.setNoJmx((Boolean)event.getPropertyValue());
            }
        });
        s_traceLogger = new JMSTraceLogger(JMXSupport.class);
        try {
            s_svr = Oc4jMBeanServerFactory.getMBeanServer();
            if (s_svr == null) {
                s_svr = MBeanServerFactory.newMBeanServer();
            }
        }
        catch (Throwable ex) {
            s_traceLogger.fine("JMXSupport", ex);
        }
    }
}

