/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.net.SocketNetworkConnection;
import com.evermind.server.jms.DummyStats;
import com.evermind.server.jms.JMSRemoteServer;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;

public final class TCPJMSRemoteServer
extends JMSRemoteServer {
    private static final Set m_1012addresses = new HashSet();
    public static final int BUFSIZE = Math.max(8192, (Integer)TCPJMSRemoteServer.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.socketBufsize"));
    public static final int RECONNECT_ATTEMPTS = (Integer)TCPJMSRemoteServer.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.reconnectAttempts");
    public static final long RECONNECT_WAIT = (Long)TCPJMSRemoteServer.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.reconnectWait");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TCPJMSRemoteServer(InetAddress addr, int port, String user, String pass) throws JMSException {
        this.m_addr = addr;
        this.m_port = port;
        this.m_user = user;
        this.m_pass = pass;
        String targetAddress = this.m_addr.getCanonicalHostName() + ":" + port;
        Set set = m_1012addresses;
        synchronized (set) {
            this.m_protocol = m_1012addresses.contains(targetAddress) ? -559038735 : -559038734;
        }
        try {
            this.initializeConnection();
        }
        catch (JMSException e) {
            if (this.m_protocol == -559038735) {
                throw e;
            }
            this.m_protocol = -559038735;
            s_traceLogger.fine("Try to connect with older protocol.");
            try {
                this.initializeConnection();
            }
            catch (Throwable ignored) {
                throw e;
            }
            Set set2 = m_1012addresses;
            synchronized (set2) {
                m_1012addresses.add(targetAddress);
            }
        }
        final String self = "RemoteServer." + this.m_name;
        this.m_jstats = (DummyStats)TCPJMSRemoteServer.getProxy().doSecureOpNoException(new SecureOperation(){

            public Object executeNoException() {
                return JMSRemoteServer.getProxy().createStats("/JMS", self, "TCPJMSRemoteServer");
            }
        });
        this.m_jstats.state("address", this.m_addr, true);
        this.m_jstats.state("host", JMSUtils.normalize(this.m_addr), true);
        this.m_jstats.state("port", new Integer(this.m_port), true);
        this.m_jstats.state("user", this.m_user, true);
    }

    protected void initializeConnection() throws JMSException {
        this.initializeConnection(true);
    }

    protected void initializeConnection(boolean isFirstTry) throws JMSException {
        try {
            this.m_conn = new SocketNetworkConnection(this.makeSocket(this.m_addr, this.m_port));
            this.m_name = this.m_conn.getInetAddress().getHostName() + ":" + this.m_conn.getPort();
            if (this.m_conn instanceof SocketNetworkConnection) {
                Socket s = ((SocketNetworkConnection)this.m_conn).getSocket();
                s.setReceiveBufferSize(BUFSIZE);
                s.setSendBufferSize(BUFSIZE);
            }
            this.m_dinp = new DataInputStream(new BufferedInputStream(this.m_conn.getInputStream(), BUFSIZE));
            this.m_dout = new DataOutputStream(new BufferedOutputStream(this.m_conn.getOutputStream(), BUFSIZE));
            this.sendProtocol(this.m_protocol);
            this.readProtocol(this.m_protocol);
            this.sendLogin(this.m_user, this.m_pass);
            this.readLogin(this.m_user);
            this.m_name = this.m_protocol != -559038735 ? (String)((Object)JMSUtils.read(this.m_dinp)) : "JMSProvider10.1.2";
        }
        catch (Throwable ex) {
            if (isFirstTry) {
                JMSUtils.closeIt(this.m_dout);
                JMSUtils.closeIt(this.m_dinp);
                try {
                    if (this.m_conn != null) {
                        this.m_conn.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                JMSUtils.toJMSException("initializeConnection", ex);
            }
            this.shutdownForce("initializeConnection", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(JMSRemoteServer.Op op) throws JMSException {
        long wait = RECONNECT_WAIT;
        int attempt = 1;
        while (true) {
            try {
                if (attempt > 1) {
                    String string;
                    boolean success = false;
                    try {
                        s_traceLogger.fine("{0}: reconnect attempt: {1}", new Object[]{this, new Integer(attempt)});
                        JMSUtils.sleep(wait);
                        wait *= 2L;
                        this.initializeConnection(false);
                        success = true;
                        Object var7_7 = null;
                        string = success ? "{0}: reconnect succeeded" : "{0}: reconnect failed";
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        s_traceLogger.fine(success ? "{0}: reconnect succeeded" : "{0}: reconnect failed", new Object[]{this});
                        throw throwable;
                    }
                    s_traceLogger.fine(string, new Object[]{this});
                    this.redoOps();
                }
                long token = this.m_jstats.phase(op.name());
                Object ret = null;
                try {
                    token = this.m_jstats.phase(op.name());
                    this.sendRequest(op);
                    ret = this.readResponse(op);
                }
                finally {
                    this.m_jstats.phase(op.name(), token);
                }
                return ret;
            }
            catch (Throwable ex) {
                if (this.pingInProgress) {
                    this.pingLastException = JMSUtils.makeJMSException(op.name(), ex);
                    this.pingDone = true;
                    return this.pingLastException;
                }
                if (ex instanceof JMSException) {
                    throw (JMSException)ex;
                }
                if (attempt > RECONNECT_ATTEMPTS) {
                    this.shutdownForce(op.name(), ex);
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public synchronized void closeConnection() {
        String func = "closeConnection";
        try {
            this.shutdownForce(func, null);
        }
        catch (Throwable ex) {
            s_traceLogger.throwing("closeConnection", ex);
        }
        this.m_jstats.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redoOps() throws Throwable {
        this.m_badSess.addAll(this.m_sess);
        this.m_sess.clear();
        this.pingDone = false;
        this.pingLastException = null;
        if (this.connectionState == 1) {
            JMSRemoteServer.Op regConOp = this.registerConnectionOp(this.m_clientID, this.m_connID, this.m_cuser);
            long token = this.m_jstats.phase(regConOp.name());
            try {
                this.sendRequest(regConOp);
                this.readResponse(regConOp);
            }
            finally {
                this.m_jstats.phase(regConOp.name(), token);
            }
        }
        Iterator iter = this.m_cons.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer consID = (Integer)entry.getKey();
            JMSRemoteServer.Consumer cons = (JMSRemoteServer.Consumer)entry.getValue();
            JMSRemoteServer.Op creConOp = this.createConsumerOp(cons.getDestination(), cons.getName(), cons.getSelector(), cons.getNoLocal());
            Integer newID = null;
            long token = this.m_jstats.phase(creConOp.name());
            try {
                this.sendRequest(creConOp);
                newID = (Integer)this.readResponse(creConOp);
            }
            finally {
                this.m_jstats.phase(creConOp.name(), token);
            }
            if (consID.intValue() == newID.intValue()) continue;
            s_traceLogger.fine("redoOps: mapping {0} to {1}", new Object[]{consID, newID});
            this.m_consMap.put(consID, newID);
        }
    }

    private void shutdownForce(String where, Throwable ex) throws JMSException {
        if (this.connectionState == 2) {
            return;
        }
        this.connectionState = 2;
        try {
            this.m_dout.writeInt(1002);
            this.m_dout.flush();
            JMSUtils.closeIt(this.m_dout);
            JMSUtils.closeIt(this.m_dinp);
            this.m_conn.close();
        }
        catch (Throwable nex) {
            s_traceLogger.throwing("shutdownForce", ex);
        }
        if (ex != null) {
            JMSUtils.toJMSException(where, ex);
        }
    }

    private Socket makeSocket(final InetAddress addr, final int port) throws IOException {
        Socket ret = null;
        try {
            ret = (Socket)TCPJMSRemoteServer.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return new Socket(addr, port);
                }
            });
        }
        catch (Exception ex) {
            throw (IOException)ex;
        }
        ret.setTcpNoDelay(true);
        return ret;
    }
}

