/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.deployment.EnvironmentPropertyDescription;
import com.evermind.server.deployment.ResourceInfo;
import com.evermind.server.deployment.ResourceProvider;
import com.evermind.server.jms.CMTConnectionFactory;
import com.evermind.server.jms.JMSUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;

public final class UniversalCMTProvider
implements ResourceProvider {
    private String m_name = null;
    private boolean m_isXA = true;
    private Context m_ctx = null;
    private static final String IS_XA = "isXA";

    public String getDisplayName() {
        return "UniversalCMTProvider";
    }

    public String getDescription() {
        return "Universal CMT wrapper resource provider";
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public EnvironmentPropertyDescription[] getPropertyDescriptions() {
        return null;
    }

    public Set getHandledTypes() {
        return new HashSet();
    }

    public ResourceInfo getDefaultResource(String type) {
        return null;
    }

    public Set getResources(String type) {
        return new HashSet();
    }

    public void init(Map props) throws InstantiationException {
        if (props.containsKey(IS_XA)) {
            this.m_isXA = new Boolean((String)props.get(IS_XA));
        }
    }

    public synchronized Object getResource(String name) throws InstantiationException {
        Object ret = null;
        try {
            if (this.m_ctx == null) {
                this.m_ctx = new InitialContext();
            }
            ret = this.munge(this.m_ctx.lookup("java:comp/resource/" + name));
        }
        catch (Exception ex) {
            JMSUtils.toInstantiationException("getResource(" + name + ")", ex);
        }
        return ret;
    }

    private Object munge(Object o) {
        return o instanceof Destination || o instanceof CMTConnectionFactory ? o : (this.m_isXA ? new CMTConnectionFactory(o) : new CMTConnectionFactory(o, false));
    }
}

