/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.FloatExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IFloatExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class FloatDiv
extends FloatExpression {
    FloatDiv(IFloatExpression leftExpr, IFloatExpression rightExpr) {
        super(leftExpr.toString() + " / " + rightExpr.toString(), leftExpr, rightExpr);
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_null = false;
        if (this.m_leftExpr.isNull() || this.m_rightExpr.isNull()) {
            this.m_null = true;
        } else {
            this.m_val = this.m_leftExpr.getFloatVal() / this.m_rightExpr.getFloatVal();
        }
    }

    public boolean equals(Object expr) {
        if (expr instanceof FloatDiv) {
            return this.m_leftExpr.equals(((FloatDiv)expr).m_leftExpr) && this.m_rightExpr.equals(((FloatDiv)expr).m_rightExpr);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_leftExpr = (IFloatExpression)this.m_leftExpr.depthFirstApply(app);
        this.m_rightExpr = (IFloatExpression)this.m_rightExpr.depthFirstApply(app);
        return app.apply(this);
    }
}

