/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.FieldAccess;
import com.evermind.server.jms.filter.FloatExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.NoSuchFieldException;
import javax.jms.Message;

class FloatFieldName
extends FloatExpression {
    private String m_fieldName;
    private FieldAccess acc;

    FloatFieldName(String name, FieldAccess acc) {
        super(name);
        this.acc = acc;
        this.m_fieldName = name;
    }

    public void eval(Message m) {
        this.m_null = false;
        Float i = null;
        try {
            Object o = this.acc.getValue(m);
            i = o instanceof Float ? (Float)o : (o instanceof Byte ? new Float(((Byte)o).byteValue()) : (o instanceof Short ? new Float(((Short)o).shortValue()) : (o instanceof Integer ? new Float(((Integer)o).intValue()) : (o instanceof Long ? new Float(((Long)o).longValue()) : null))));
        }
        catch (NoSuchFieldException nsfEx) {
            this.m_null = true;
        }
        if (i == null) {
            this.m_null = true;
        } else {
            this.m_val = i.floatValue();
        }
    }

    public boolean equals(Object op) {
        if (op instanceof FloatFieldName) {
            return this.m_fieldName.equals(((FloatFieldName)op).m_fieldName);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        return app.apply(this);
    }
}

