/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.BooleanFieldName;
import com.evermind.server.jms.filter.DoubleFieldName;
import com.evermind.server.jms.filter.DynamicFieldName;
import com.evermind.server.jms.filter.Expression;
import com.evermind.server.jms.filter.FieldAccess;
import com.evermind.server.jms.filter.FloatFieldName;
import com.evermind.server.jms.filter.FormatField;
import com.evermind.server.jms.filter.IExpression;
import com.evermind.server.jms.filter.IntegerFieldName;
import com.evermind.server.jms.filter.LongFieldName;
import com.evermind.server.jms.filter.NoSuchFieldException;
import com.evermind.server.jms.filter.PNode;
import com.evermind.server.jms.filter.PTokenIdent;
import com.evermind.server.jms.filter.Query;
import com.evermind.server.jms.filter.QuerySemanticException;
import com.evermind.server.jms.filter.StringFieldName;
import com.evermind.server.jms.filter.UnsupportedFieldException;

class PFieldName
extends PNode {
    PTokenIdent m_name;

    PFieldName(PTokenIdent name) {
        this.m_name = name;
    }

    String getFieldName() {
        return this.m_name.m_ident;
    }

    /*
     * WARNING - void declaration
     */
    IExpression convert(Query q) throws QuerySemanticException {
        void var4_7;
        String fieldName = this.getFieldName();
        FormatField f = q.getFormat().lookupField(fieldName);
        if (f == null) {
            throw Query.semanticError("field name " + fieldName + " not in format for: " + this);
        }
        FieldAccess acc = null;
        try {
            acc = q.getFieldAccess(fieldName);
        }
        catch (NoSuchFieldException nsfEx) {
            throw Query.semanticError("field name " + fieldName + " not valid for: " + this);
        }
        catch (UnsupportedFieldException uEx) {
            throw Query.semanticError("field name " + fieldName + " not valid for: " + this);
        }
        switch (f.getType()) {
            case 2: {
                Expression op = new IntegerFieldName(fieldName, acc);
                break;
            }
            case 4: {
                Expression op = new LongFieldName(fieldName, acc);
                break;
            }
            case 3: {
                Expression op = new StringFieldName(fieldName, acc);
                break;
            }
            case 1: {
                Expression op = new BooleanFieldName(fieldName, acc);
                break;
            }
            case 5: {
                Expression op = new FloatFieldName(fieldName, acc);
                break;
            }
            case 6: {
                Expression op = new DoubleFieldName(fieldName, acc);
                break;
            }
            case 7: {
                Expression op = new DynamicFieldName(fieldName, acc);
                break;
            }
            default: {
                throw Query.semanticError("type not yet implemented: " + f.getType() + " for " + this);
            }
        }
        return var4_7;
    }

    public String toString() {
        return this.m_name.toString();
    }
}

