/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.AssertException;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IBooleanExpression;
import com.evermind.server.jms.filter.IDoubleExpression;
import com.evermind.server.jms.filter.IDynamicExpression;
import com.evermind.server.jms.filter.IExpression;
import com.evermind.server.jms.filter.IFloatExpression;
import com.evermind.server.jms.filter.IIntegerExpression;
import com.evermind.server.jms.filter.ILongExpression;
import com.evermind.server.jms.filter.IStringExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import com.evermind.server.jms.filter.TestBoolean;
import com.evermind.server.jms.filter.TestDouble;
import com.evermind.server.jms.filter.TestDynamic;
import com.evermind.server.jms.filter.TestFloat;
import com.evermind.server.jms.filter.TestHolder;
import com.evermind.server.jms.filter.TestInt;
import com.evermind.server.jms.filter.TestLong;
import com.evermind.server.jms.filter.TestNull;
import com.evermind.server.jms.filter.TestString;
import java.util.Vector;
import javax.jms.Message;

public class TestContent
implements Apply {
    public Object apply(Object obj) {
        return obj;
    }

    public static void main(String[] args) {
        if (TestContent.mainContent(true, null)) {
            System.out.println("success");
        }
    }

    public static boolean mainContent(boolean debug, Message fmsg) {
        Vector exprs = new Vector();
        TestContent.getExpressions(exprs);
        System.err.println("# of expressions = " + exprs.size());
        TestContent applicator = new TestContent();
        int size = exprs.size();
        for (int i = 0; i < size; ++i) {
            TestHolder holder = (TestHolder)exprs.elementAt(i);
            IExpression expr = holder.expr;
            Object result = holder.value;
            try {
                expr.eval(fmsg);
                expr.equals(expr);
                expr.equals(new Integer(1));
                expr.depthFirstApply(applicator);
                if (TestContent.checkResult(expr, result)) continue;
                System.err.println("Evaluation error: " + expr.toString() + " != " + result);
                return false;
            }
            catch (AssertException assEx) {
                System.err.println("AssertException: " + assEx.getMessage());
                assEx.printStackTrace();
                System.err.println("Expr ::" + expr.toString() + "::");
                return false;
            }
            catch (QueryTypeException qtEx) {
                System.err.println("QueryTypeException: " + qtEx.getMessage());
                qtEx.printStackTrace();
                System.err.println("Expr ::" + expr.toString() + "::");
                return false;
            }
            catch (GeneralException gEx) {
                System.err.println("GeneralException: " + gEx.getMessage());
                gEx.printStackTrace();
                System.err.println("Expr ::" + expr.toString() + "::");
                return false;
            }
        }
        return true;
    }

    private static boolean checkResult(IExpression expr, Object result) {
        try {
            if (expr instanceof IDynamicExpression) {
                IDynamicExpression de = (IDynamicExpression)expr;
                if (de.isNull()) {
                    return TestContent.checkNull(de, result);
                }
                switch (de.getCurrentType()) {
                    case 2: {
                        return TestContent.checkInt((IIntegerExpression)expr, result);
                    }
                    case 4: {
                        return TestContent.checkLong((ILongExpression)expr, result);
                    }
                    case 5: {
                        return TestContent.checkFloat((IFloatExpression)expr, result);
                    }
                    case 6: {
                        return TestContent.checkDouble((IDoubleExpression)expr, result);
                    }
                    case 3: {
                        return TestContent.checkString((IStringExpression)expr, result);
                    }
                    case 1: {
                        return TestContent.checkBool((IBooleanExpression)expr, result);
                    }
                }
                System.err.println("dynamic type = " + de.getCurrentType());
                System.err.println(" for " + expr.toString());
                return false;
            }
            if (expr instanceof IIntegerExpression) {
                return TestContent.checkInt((IIntegerExpression)expr, result);
            }
            if (expr instanceof IStringExpression) {
                return TestContent.checkString((IStringExpression)expr, result);
            }
            if (expr instanceof IBooleanExpression) {
                return TestContent.checkBool((IBooleanExpression)expr, result);
            }
            if (expr instanceof ILongExpression) {
                return TestContent.checkLong((ILongExpression)expr, result);
            }
            if (expr instanceof IFloatExpression) {
                return TestContent.checkFloat((IFloatExpression)expr, result);
            }
            if (expr instanceof IDoubleExpression) {
                return TestContent.checkDouble((IDoubleExpression)expr, result);
            }
            System.err.println("In check result: expression type unsupported: " + expr.getClass().getName() + " for expression = " + expr.toString());
            return false;
        }
        catch (QueryTypeException qtEx) {
            qtEx.printStackTrace();
            System.err.println("For " + expr.toString() + " exception accessing value");
            return false;
        }
    }

    private static boolean checkNull(IDynamicExpression expr, Object result) throws QueryTypeException {
        if (result != null) {
            System.err.println(expr + " evaluated to null " + result + " was expected ");
            return false;
        }
        return true;
    }

    private static boolean checkInt(IIntegerExpression expr, Object result) throws QueryTypeException {
        if (expr.isNull()) {
            if (result == null) {
                return true;
            }
            System.err.println("unexpected null for " + expr.toString());
            return false;
        }
        if (!(result instanceof Integer)) {
            System.err.println("integer result expected for " + expr.toString());
            return false;
        }
        IIntegerExpression cexpr = expr;
        Integer res = (Integer)result;
        if (res.intValue() != cexpr.getIntVal()) {
            System.err.println("unexpected result for : " + expr.toString() + " = " + cexpr.getIntVal() + " expected " + res);
            return false;
        }
        return true;
    }

    private static boolean checkString(IStringExpression expr, Object result) throws QueryTypeException {
        if (expr.isNull()) {
            if (result == null) {
                return true;
            }
            System.err.println("unexpected null for " + expr.toString());
            return false;
        }
        if (!(result instanceof String)) {
            System.err.println("string result expected for " + expr.toString());
            return false;
        }
        String res = (String)result;
        IStringExpression cexpr = expr;
        if (!res.equals(cexpr.getStringVal())) {
            System.err.println("unexpected result for : " + expr.toString() + " = " + cexpr.getStringVal() + " expected " + res);
            return false;
        }
        return true;
    }

    private static boolean checkBool(IBooleanExpression expr, Object result) throws QueryTypeException {
        if (expr.isNull()) {
            if (result == null) {
                return true;
            }
            System.err.println("unexpected null for " + expr.toString());
            return false;
        }
        if (!(result instanceof Boolean)) {
            System.err.println("boolean result expected for " + expr.toString() + " isNull = " + expr.isNull());
            return false;
        }
        IBooleanExpression cexpr = expr;
        Boolean res = (Boolean)result;
        if (res.booleanValue() != cexpr.getBooleanVal()) {
            System.err.println("unexpected result for : " + expr.toString() + " = " + cexpr.getBooleanVal() + " expected " + res);
            return false;
        }
        return true;
    }

    private static boolean checkLong(ILongExpression expr, Object result) throws QueryTypeException {
        if (expr.isNull()) {
            if (result == null) {
                return true;
            }
            System.err.println("unexpected null for " + expr.toString());
            return false;
        }
        if (!(result instanceof Long)) {
            System.err.println("long result expected for " + expr.toString());
            return false;
        }
        ILongExpression cexpr = expr;
        Long res = (Long)result;
        if (res.longValue() != cexpr.getLongVal()) {
            System.err.println("unexpected result for : " + expr.toString() + " = " + cexpr.getLongVal() + " expected " + res);
            return false;
        }
        return true;
    }

    private static boolean checkDouble(IDoubleExpression expr, Object result) throws QueryTypeException {
        if (expr.isNull()) {
            if (result == null) {
                return true;
            }
            System.err.println("unexpected null for " + expr.toString());
            return false;
        }
        if (!(result instanceof Double)) {
            System.err.println("double result expected for " + expr.toString() + " actual result = " + result + " which is " + result.getClass().getName());
            Thread.currentThread();
            Thread.dumpStack();
            return false;
        }
        IDoubleExpression cexpr = expr;
        Double res = (Double)result;
        if (res.doubleValue() != cexpr.getDoubleVal()) {
            System.err.println("unexpected result for : " + expr.toString() + " = " + cexpr.getDoubleVal() + " expected " + res);
            return false;
        }
        return true;
    }

    private static boolean checkFloat(IFloatExpression expr, Object result) throws QueryTypeException {
        if (expr.isNull()) {
            if (result == null) {
                return true;
            }
            System.err.println("unexpected null for " + expr.toString());
            return false;
        }
        if (!(result instanceof Float)) {
            System.err.println("float result expected for " + expr.toString());
            return false;
        }
        IFloatExpression cexpr = expr;
        Float res = (Float)result;
        if (res.floatValue() != cexpr.getFloatVal()) {
            System.err.println("unexpected result for : " + expr.toString() + " = " + cexpr.getFloatVal() + " expected " + res);
            return false;
        }
        return true;
    }

    private static void getExpressions(Vector v) {
        Vector intV = new Vector();
        Vector boolV = new Vector();
        Vector longV = new Vector();
        Vector floatV = new Vector();
        Vector doubleV = new Vector();
        Vector stringV = new Vector();
        TestNull.getNull(v);
        TestDynamic.getAll(v);
        TestDouble.getDouble_Double(v);
        TestDouble.getDouble_Boolean(v);
        TestDouble.getDouble_Double(doubleV);
        TestDouble.getDouble_Boolean(doubleV);
        TestBoolean.getBoolean_Boolean(v);
        TestBoolean.getBoolean_Boolean(boolV);
        TestInt.getInt_Boolean(v);
        TestInt.getInt_Int(v);
        TestInt.getInt_Boolean(intV);
        TestInt.getInt_Int(intV);
        TestLong.getLong_Long(v);
        TestLong.getLong_Boolean(v);
        TestLong.getLong_Long(longV);
        TestLong.getLong_Boolean(longV);
        TestString.getString_String(v);
        TestString.getString_Boolean(v);
        TestString.getString_String(stringV);
        TestString.getString_Boolean(stringV);
        TestFloat.getFloat_Float(v);
        TestFloat.getFloat_Boolean(v);
        TestFloat.getFloat_Float(floatV);
        TestFloat.getFloat_Boolean(floatV);
        TestContent.dump(v);
    }

    private static void dump(Vector v) {
        int size = v.size();
        System.err.println("{");
        for (int i = 0; i < size; ++i) {
            TestHolder th = (TestHolder)v.elementAt(i);
            Object res = th.value;
            if (res == null) {
                res = new Boolean(false);
            }
            if (!(res instanceof Boolean)) continue;
            String com = ", ";
            if (i == size - 1) {
                com = "";
            }
            System.err.println("{\" " + th.expr.toString() + "\", " + "new Boolean(" + res + ") }" + com);
        }
        System.err.println("};");
    }
}

