/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.DynamicExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IBooleanExpression;
import com.evermind.server.jms.filter.IDoubleExpression;
import com.evermind.server.jms.filter.IExpression;
import com.evermind.server.jms.filter.IFloatExpression;
import com.evermind.server.jms.filter.IIntegerExpression;
import com.evermind.server.jms.filter.ILongExpression;
import com.evermind.server.jms.filter.IStringExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class WrapDynamicExpression
extends DynamicExpression {
    private IExpression nonDynExpr;

    WrapDynamicExpression(IExpression expr) {
        super(" DYNAMIC(" + expr.toString() + ") ");
        this.nonDynExpr = expr;
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_null = false;
        this.boolean_val = false;
        if (this.nonDynExpr.isNull()) {
            this.m_null = true;
            return;
        }
        switch (this.nonDynExpr.typeOf()) {
            case 1: {
                this.setBooleanVal(((IBooleanExpression)this.nonDynExpr).getBooleanVal());
                break;
            }
            case 2: {
                this.setIntVal(((IIntegerExpression)this.nonDynExpr).getIntVal());
                break;
            }
            case 3: {
                this.setStringVal(((IStringExpression)this.nonDynExpr).getStringVal());
                break;
            }
            case 4: {
                this.setLongVal(((ILongExpression)this.nonDynExpr).getLongVal());
                break;
            }
            case 5: {
                this.setFloatVal(((IFloatExpression)this.nonDynExpr).getFloatVal());
                break;
            }
            case 6: {
                this.setDoubleVal(((IDoubleExpression)this.nonDynExpr).getDoubleVal());
                break;
            }
            default: {
                throw new QueryTypeException("eval not supported for dynamic types");
            }
        }
    }

    public boolean equals(Object op) {
        if (op instanceof WrapDynamicExpression) {
            return this.nonDynExpr.equals(((WrapDynamicExpression)op).nonDynExpr);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.nonDynExpr = (IExpression)app.apply(this.nonDynExpr);
        return app.apply(this);
    }
}

