/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindTopicConnection;
import com.evermind.server.multicastjms.JMSServer;
import java.io.IOException;
import javax.jms.JMSException;

public class LocalTopicConnection
extends EvermindTopicConnection {
    private JMSServer server;
    private boolean addedToServer;

    public LocalTopicConnection(JMSServer server) throws IOException, InstantiationException {
        super(server.getConfig().getAddress(), server.getConfig().getPort());
        this.server = server;
    }

    public void run() {
    }

    public void send(String topicName, EvermindMessage message) throws JMSException {
        this.server.handleTopicMessage(this, topicName, message.cloneMessage());
    }

    public void distribute(String topicName, EvermindMessage message) {
    }

    public void registerTopicInterest(String topicName) {
        if (!this.addedToServer) {
            this.addedToServer = true;
            this.server.registerLocalTopicConnection(this);
        }
    }

    public void stop() throws JMSException {
        super.stop();
        if (this.addedToServer) {
            this.server.removeLocalTopicConnection(this);
            this.addedToServer = false;
        }
    }

    public void close() throws JMSException {
        super.close();
        this.stop();
    }

    JMSServer getServer() {
        return this.server;
    }
}

