/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.util.RMIProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectEncoder {
    private static Logger m_logger = Logger.getLogger(ObjectEncoder.class.getName());

    public static byte[] objectToBytes(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(obj);
        oos.flush();
        byte[] buf = out.toByteArray();
        out.close();
        if (RMIProperties.getRmiAltMarshallDebug()) {
            m_logger.log(Level.ALL, "objectToBytes" + buf.length + " obj" + obj);
        }
        return buf;
    }

    public static Object bytesToObject(byte[] buf) throws IOException, ClassNotFoundException {
        return ObjectEncoder.bytesToObject(buf, buf.getClass().getClassLoader());
    }

    public static Object bytesToObject(byte[] buf, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(buf);
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(in, classLoader);
        Object obj = ois.readObject();
        in.close();
        if (RMIProperties.getRmiAltMarshallDebug()) {
            m_logger.log(Level.ALL, "bytesToObject " + buf.length + " obj" + obj);
        }
        return obj;
    }

    public static Object clone(Object obj) throws ClassNotFoundException, IOException {
        byte[] ba = ObjectEncoder.objectToBytes(obj);
        Object response = ObjectEncoder.bytesToObject(ba);
        return response;
    }
}

