/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.io.IOUtils;
import com.evermind.server.rmi.Credentials;
import com.evermind.server.rmi.ObjectEncoder;
import com.evermind.server.rmi.RMICall;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIInterceptorContext;
import com.evermind.server.rmi.RMIInterceptorManager;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIOutputStream;
import com.evermind.server.rmi.RmiCallQueue;
import com.evermind.util.LongHashMap;
import com.evermind.util.RMIProperties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.RmiCommandSource;
import oracle.oc4j.rmi.RmiTransport;
import oracle.oc4j.security.ExchangingEncryptor;

public class RMIProtocol {
    private static Logger m_logger = TraceLogger.getLogger(RMIProtocol.class);
    private static boolean m_altMarshall = RMIProperties.getRmiAltMarshall();
    private static boolean m_disablePropagation = RMIProperties.getRmiDisablePropagation();
    private static boolean m_useKeyExchange = !RMIProperties.getRmiPlaintextPasswords();
    private Version m_remoteVersion;
    private Version m_localVersion;
    private RMIInterceptorManager m_interceptorManager;
    public static final int PROTOCOL_VERIFICATION = 227;
    public static final int SERIALIZATION_TYPE = 1;
    private static RMIInterceptorManager NULL_INTERCEPTOR_MANAGER = new NullInterceptorManager();
    static final Version VERSION_1_0 = new Version_1_0();
    static final Version VERSION_1_1 = new Version_1_1();
    static final Version VERSION_1_2 = new Version_1_2();
    static final Version VERSION_1_3;
    static final Version LATEST_VERSION;
    static final Version[] KNOWN_VERSIONS;
    static /* synthetic */ Class class$java$lang$Object;

    static void setDisablePropagation(boolean disablePropagation) {
        m_disablePropagation = disablePropagation;
    }

    static void setDisableAltMarshalling(boolean disableAltMarshalling) {
        m_altMarshall = !disableAltMarshalling;
    }

    static void setDisableKeyExchange(boolean disableKeyExchange) {
        m_useKeyExchange = !disableKeyExchange;
    }

    static void resetOptions() {
        m_altMarshall = RMIProperties.getRmiAltMarshall();
        m_disablePropagation = RMIProperties.getRmiDisablePropagation();
        m_useKeyExchange = !RMIProperties.getRmiPlaintextPasswords();
    }

    public RMIProtocol(RMIInterceptorManager interceptorManager) {
        this.m_interceptorManager = interceptorManager;
        this.m_remoteVersion = this.m_localVersion = Version.versionCompatibleWith(m_altMarshall, !m_disablePropagation, m_useKeyExchange);
    }

    public String getEffectiveProtocol() {
        return this.m_localVersion.asString();
    }

    void writeObject(ObjectOutput out, Class type, Object value) throws IOException {
        this.m_localVersion.marshallParameter(out, type, value);
    }

    Object readObject(ObjectInputStream is, Class type) throws IOException, ClassNotFoundException {
        return this.m_localVersion.unmarshallParameter(is, type);
    }

    public Credentials createCredentials(String userName, String password) {
        return this.m_localVersion.createCredentials(userName, password);
    }

    RMIInterceptorManager getInterceptorManager() {
        return this.m_localVersion.isPropagationSupported() ? this.m_interceptorManager : NULL_INTERCEPTOR_MANAGER;
    }

    public void sendCredentials(InputStream bufferIn, OutputStream bufferOut, String username, String password) throws IOException {
        this.m_localVersion.createCredentials(username, password).send(bufferIn, bufferOut);
    }

    public Credentials receiveCredentials(InputStream in, OutputStream out) throws IOException {
        return this.m_localVersion.receiveCredentials(in, out);
    }

    void writeValue(Class type, ObjectOutputStream out, Object value) throws IOException {
        if (type == Void.TYPE) {
            return;
        }
        if (type == String.class) {
            out.writeBoolean(value != null);
            if (value != null) {
                IOUtils.writeLongUTF(out, (String)value);
            }
        } else if (type == Integer.TYPE) {
            IOUtils.writeCompressedInt(out, ((Number)value).intValue());
        } else if (type == Float.TYPE) {
            out.writeFloat(((Number)value).floatValue());
        } else if (type == Long.TYPE) {
            out.writeLong(((Number)value).longValue());
        } else if (type == Double.TYPE) {
            out.writeDouble(((Number)value).doubleValue());
        } else if (type == Byte.TYPE) {
            out.writeByte(((Number)value).byteValue());
        } else if (type == Character.TYPE) {
            out.writeChar(((Character)value).charValue());
        } else if (type == Short.TYPE) {
            out.writeShort(((Number)value).shortValue());
        } else if (type == Boolean.TYPE) {
            out.writeBoolean((Boolean)value);
        } else {
            this.writeObject(out, type, value);
        }
    }

    Object readValue(Class type, ObjectInputStream is) throws IOException, ClassNotFoundException {
        if (type == Void.TYPE) {
            return null;
        }
        if (type == String.class) {
            if (is.readBoolean()) {
                return IOUtils.readLongUTF(is);
            }
            return null;
        }
        if (type == Integer.TYPE) {
            return new Integer(IOUtils.readCompressedInt(is));
        }
        if (type == Float.TYPE) {
            return new Float(is.readFloat());
        }
        if (type == Long.TYPE) {
            return new Long(is.readLong());
        }
        if (type == Double.TYPE) {
            return new Double(is.readDouble());
        }
        if (type == Byte.TYPE) {
            return new Byte(is.readByte());
        }
        if (type == Character.TYPE) {
            return new Character(is.readChar());
        }
        if (type == Short.TYPE) {
            return new Short(is.readShort());
        }
        if (type == Boolean.TYPE) {
            return is.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.readObject(is, type);
    }

    boolean isCallIdRequired(int command) {
        return this.m_localVersion.isCallIdRequired(command);
    }

    RMICall readQueuedCall(int command, RmiCallQueue queue, ObjectInputStream in) throws IOException {
        return this.m_localVersion.readQueuedCall(command, queue, in);
    }

    int readStatus(int command, ObjectInputStream in) throws IOException {
        return this.m_localVersion.readStatus(command, in);
    }

    void writeNormalResponse(RMIOutputStream out, int command, int callId, int status, LongHashMap serverInterceptors) throws IOException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "[{0}] Write command: {1}", new Object[]{Thread.currentThread().getName(), new Integer(command)});
        }
        this.m_localVersion.writeNormalResponse(out, command, callId, status, serverInterceptors, this.getInterceptorManager());
    }

    long readObjectResponseId(int status, ObjectInputStream in) throws IOException {
        return this.m_localVersion.readObjectResponseId(status, in);
    }

    void writeObjectResponseId(ObjectOutputStream out, long id) throws IOException {
        this.m_localVersion.writeObjectResponseId(out, id);
    }

    public RmiTransport.MessageOut createRequest(RmiTransport transport, RMIConnection connection) throws IOException {
        return this.m_localVersion.createMessageOut(transport, connection);
    }

    public RmiCommandSource.MessageIn getMessageIn(RMIConnection connection, RmiCommandSource commandSource) throws IOException {
        return this.m_localVersion.getMessageIn(commandSource, connection);
    }

    public int readConnectionHeader(InputStream inputStream, ConnectionTypeValidation validation) throws IOException, RMILoginFailedException {
        int type = inputStream.read();
        if (type == -1) {
            throw new EOFException("Disconnected");
        }
        if (type == 227) {
            this.m_remoteVersion = Version.read(inputStream);
            Version selectedVersion = Version.lower(this.m_localVersion, this.m_remoteVersion);
            if (this.m_remoteVersion != this.m_localVersion && m_logger.isLoggable(Level.INFO)) {
                m_logger.info("Local ORMI version = " + this.m_localVersion.asString() + " different from remote version " + this.m_remoteVersion.asString() + " will use " + selectedVersion.asString());
            }
            this.m_localVersion = selectedVersion;
        } else {
            validation.validateConnectionType(type);
        }
        return type;
    }

    public void writeConnectionHeader(OutputStream bufferOut) throws IOException {
        bufferOut.write(227);
        this.m_localVersion.write(bufferOut);
    }

    static {
        LATEST_VERSION = VERSION_1_3 = new Version_1_3();
        KNOWN_VERSIONS = new Version[]{VERSION_1_3, VERSION_1_2, VERSION_1_1, VERSION_1_0};
    }

    static class NullInterceptorManager
    implements RMIInterceptorManager {
        NullInterceptorManager() {
        }

        public void fireSendRequestInterceptor(LongHashMap clientInterceptors, ObjectOutputStream out, int command, int callId) {
        }

        public boolean fireReadReplyInterceptor(LongHashMap clientInterceptors, ObjectInputStream in, int callId) {
            return false;
        }

        public void fireReceiveExceptionInterceptor(LongHashMap clientInterceptors, int id, Throwable exception) {
        }

        public void fireReceiveReplyInterceptor(LongHashMap clientInterceptors, int callId) {
        }

        public void fireReadRequestContextInterceptor(LongHashMap serverInterceptors, ObjectInputStream in, int command, int callId) {
        }

        public void fireReceiveRequestInterceptor(LongHashMap serverInterceptors, int callId, RMIInterceptorContext metaContext) {
        }

        public void fireSendExceptionInterceptor(LongHashMap serverInterceptors, ObjectOutputStream out, int callId, Throwable exception) {
        }

        public void fireSendReplyInterceptor(LongHashMap serverInterceptors, RMIOutputStream out, int callId) {
        }
    }

    static class Version_1_3
    extends Version_1_2 {
        private static final int MINOR_VERSION = 3;

        Version_1_3() {
        }

        short getMinor() {
            return 3;
        }

        boolean isKeyExchangeSupported() {
            return true;
        }

        AbstractCredentials createCredentials() {
            return new SecureCredentials();
        }
    }

    static class Version_1_2
    extends Version_1_0 {
        private static final int BYTES_PER_LONG = 8;
        private static final int BITS_PER_BYTE = 8;

        Version_1_2() {
        }

        short getMinor() {
            return 2;
        }

        boolean isPropagationSupported() {
            return true;
        }

        RmiTransport.MessageOut createMessageOut(RmiTransport transport, RMIConnection connection) throws IOException {
            return transport.createDiscreteMessageOut(connection);
        }

        RmiCommandSource.MessageIn getMessageIn(RmiCommandSource commandSource, RMIConnection connection) throws IOException {
            return commandSource.createDiscreteMessageIn(connection);
        }

        public boolean isCallIdRequired(int command) {
            return true;
        }

        public RMICall readQueuedCall(int command, RmiCallQueue queue, ObjectInputStream in) throws IOException {
            int id = IOUtils.readCompressedInt(in);
            RMICall call = queue.getQueuedClass(id);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "callQueue id : " + id + " call object : " + call);
            }
            return call;
        }

        public int readStatus(int command, ObjectInputStream in) throws IOException {
            return in.read();
        }

        public void writeNormalResponse(RMIOutputStream out, int command, int callId, int status, LongHashMap serverInterceptors, RMIInterceptorManager interceptor) throws IOException {
            out.write(command);
            IOUtils.writeCompressedInt(out, callId);
            interceptor.fireSendReplyInterceptor(serverInterceptors, out, callId);
            out.write(status);
        }

        public long readObjectResponseId(int status, ObjectInputStream in) throws IOException {
            return this.read7byteLong(status, in);
        }

        public void writeObjectResponseId(ObjectOutputStream out, long id) throws IOException {
            this.write7byteLong(out, id);
        }

        private long read7byteLong(int mostSignificantByte, ObjectInputStream in) throws IOException {
            long result = mostSignificantByte;
            for (int i = 0; i < 7; ++i) {
                long aByte = (long)in.read() & 0xFFL;
                result <<= (int)(8L + aByte);
            }
            return result;
        }

        private void write7byteLong(ObjectOutputStream out, long id) throws IOException {
            out.writeByte((byte)(id >>> 48));
            out.writeByte((byte)(id >>> 40));
            out.writeByte((byte)(id >>> 32));
            out.writeByte((byte)(id >>> 24));
            out.writeByte((byte)(id >>> 16));
            out.writeByte((byte)(id >>> 8));
            out.writeByte((byte)(id >>> 0));
        }
    }

    static class Version_1_1
    extends Version_1_0 {
        Version_1_1() {
        }

        short getMinor() {
            return 1;
        }

        boolean usesAltMarshalling() {
            return true;
        }

        void marshallParameter(ObjectOutput out, Class type, Object value) throws IOException {
            if (type == (class$java$lang$Object == null ? (class$java$lang$Object = RMIProtocol.class$("java.lang.Object")) : class$java$lang$Object)) {
                Version_1_1.marshallParameterInMemory(out, value);
            } else {
                Version_1_1.marshallParameterDirectly(out, value);
            }
        }

        Object unmarshallParameter(ObjectInputStream is, Class type) throws IOException, ClassNotFoundException {
            if (type == (class$java$lang$Object == null ? (class$java$lang$Object = RMIProtocol.class$("java.lang.Object")) : class$java$lang$Object)) {
                return Version_1_1.unmarshallParameterInMemory(is);
            }
            return Version_1_1.unmarshallParameterDirectly(is);
        }
    }

    static class Version_1_0
    extends Version {
        Version_1_0() {
        }

        short getMajor() {
            return 1;
        }

        short getMinor() {
            return 0;
        }

        boolean usesAltMarshalling() {
            return false;
        }

        boolean isPropagationSupported() {
            return false;
        }

        boolean isKeyExchangeSupported() {
            return false;
        }

        void marshallParameter(ObjectOutput out, Class type, Object value) throws IOException {
            Version_1_0.marshallParameterDirectly(out, value);
        }

        Object unmarshallParameter(ObjectInputStream is, Class type) throws IOException, ClassNotFoundException {
            return Version_1_0.unmarshallParameterDirectly(is);
        }

        AbstractCredentials createCredentials() {
            return new BasicCredentials();
        }

        RmiTransport.MessageOut createMessageOut(RmiTransport transport, RMIConnection connection) throws IOException {
            return transport.createContinuousMessageOut(connection);
        }

        RmiCommandSource.MessageIn getMessageIn(RmiCommandSource commandSource, RMIConnection connection) throws IOException {
            return commandSource.createContinuousMessageIn(connection);
        }

        public boolean isCallIdRequired(int command) {
            return command != 8 && command != 8;
        }

        public RMICall readQueuedCall(int command, RmiCallQueue queue, ObjectInputStream in) throws IOException {
            if (command != 52) {
                int id = IOUtils.readCompressedInt(in);
                RMICall call = queue.getQueuedClass(id);
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "callQueue id : " + id + " call object : " + call);
                }
                return call;
            }
            return new RMICall(false, -1, -1);
        }

        public int readStatus(int command, ObjectInputStream in) throws IOException {
            return command != 52 ? in.read() : 0;
        }

        public void writeNormalResponse(RMIOutputStream out, int command, int callId, int status, LongHashMap serverInterceptors, RMIInterceptorManager interceptor) throws IOException {
            out.write(command);
            if (command != 52) {
                IOUtils.writeCompressedInt(out, callId);
            }
            interceptor.fireSendReplyInterceptor(serverInterceptors, out, callId);
            if (command != 52) {
                out.write(status);
            }
        }

        public long readObjectResponseId(int status, ObjectInputStream in) throws IOException {
            return in.readLong();
        }

        public void writeObjectResponseId(ObjectOutputStream out, long id) throws IOException {
            out.writeLong(id);
        }
    }

    static abstract class Version {
        Version() {
        }

        static Version versionCompatibleWith(boolean supportObjectParameterMarshalling, boolean supportPropagation, boolean supportKeyExchange) {
            for (int i = 0; i < KNOWN_VERSIONS.length; ++i) {
                Version candidate = KNOWN_VERSIONS[i];
                if (!candidate.isCompatible(supportObjectParameterMarshalling, supportPropagation, supportKeyExchange)) continue;
                return candidate;
            }
            return VERSION_1_0;
        }

        static Version read(InputStream inputStream) throws IOException {
            inputStream.read();
            inputStream.read();
            inputStream.read();
            inputStream.read();
            short major = (short)IOUtils.readShort(inputStream);
            short minor = (short)IOUtils.readShort(inputStream);
            for (int i = 0; i < KNOWN_VERSIONS.length; ++i) {
                Version candidate = KNOWN_VERSIONS[i];
                if (candidate.getMajor() != major || candidate.getMinor() != minor) continue;
                return candidate;
            }
            return LATEST_VERSION;
        }

        public static Version lower(Version version1, Version version2) {
            if (version1.getMajor() < version2.getMajor()) {
                return version1;
            }
            if (version1.getMajor() > version2.getMajor()) {
                return version2;
            }
            if (version1.getMinor() < version2.getMinor()) {
                return version1;
            }
            if (version1.getMinor() > version2.getMinor()) {
                return version2;
            }
            return version1;
        }

        void write(OutputStream out) throws IOException {
            out.write(13);
            out.write(10);
            out.write(13);
            out.write(10);
            IOUtils.writeShort(out, this.getMajor());
            IOUtils.writeShort(out, this.getMinor());
        }

        abstract short getMajor();

        abstract short getMinor();

        abstract boolean usesAltMarshalling();

        abstract boolean isPropagationSupported();

        abstract boolean isKeyExchangeSupported();

        abstract void marshallParameter(ObjectOutput var1, Class var2, Object var3) throws IOException;

        abstract Object unmarshallParameter(ObjectInputStream var1, Class var2) throws IOException, ClassNotFoundException;

        abstract AbstractCredentials createCredentials();

        static Object unmarshallParameterInMemory(ObjectInputStream is) throws IOException, ClassNotFoundException {
            int numRead;
            int len = is.readInt();
            if (len > 0x500000) {
                throw new IOException("Unmarshall error - serialized parameter appears too long");
            }
            byte[] ba = new byte[len];
            for (int total = 0; total < len; total += numRead) {
                numRead = is.read(ba, total, len - total);
                if (numRead >= 0) continue;
                throw new EOFException("EOF detected after reading " + total + " of " + len + " bytes of serialized object");
            }
            return ObjectEncoder.bytesToObject(ba, ((ClassLoaderObjectInputStream)is).getClassLoader());
        }

        static Object unmarshallParameterDirectly(ObjectInputStream is) throws IOException, ClassNotFoundException {
            return is.readObject();
        }

        boolean isCompatible(boolean mayUseAltMarshalling, boolean mayUsePropagation, boolean mayUseKeyExchange) {
            if (this.usesAltMarshalling() && !mayUseAltMarshalling) {
                return false;
            }
            if (this.isPropagationSupported() && !mayUsePropagation) {
                return false;
            }
            return !this.isKeyExchangeSupported() || mayUseKeyExchange;
        }

        String asString() {
            return this.getMajor() + "." + this.getMinor();
        }

        static void marshallParameterInMemory(ObjectOutput out, Object value) throws IOException {
            byte[] buf = ObjectEncoder.objectToBytes(value);
            out.writeInt(buf.length);
            out.write(buf);
        }

        static void marshallParameterDirectly(ObjectOutput out, Object value) throws IOException {
            out.writeObject(value);
        }

        final AbstractCredentials createCredentials(String userName, String password) {
            AbstractCredentials credentials = this.createCredentials();
            credentials.setUsername(userName);
            credentials.setPassword(password);
            return credentials;
        }

        final Credentials receiveCredentials(InputStream in, OutputStream out) throws IOException {
            AbstractCredentials credentials = this.createCredentials();
            credentials.receive(in, out);
            return credentials;
        }

        abstract RmiTransport.MessageOut createMessageOut(RmiTransport var1, RMIConnection var2) throws IOException;

        abstract RmiCommandSource.MessageIn getMessageIn(RmiCommandSource var1, RMIConnection var2) throws IOException;

        abstract boolean isCallIdRequired(int var1);

        abstract RMICall readQueuedCall(int var1, RmiCallQueue var2, ObjectInputStream var3) throws IOException;

        abstract int readStatus(int var1, ObjectInputStream var2) throws IOException;

        abstract void writeNormalResponse(RMIOutputStream var1, int var2, int var3, int var4, LongHashMap var5, RMIInterceptorManager var6) throws IOException;

        abstract long readObjectResponseId(int var1, ObjectInputStream var2) throws IOException;

        abstract void writeObjectResponseId(ObjectOutputStream var1, long var2) throws IOException;
    }

    public static interface ConnectionTypeValidation {
        public void validateConnectionType(int var1) throws RMILoginFailedException;
    }

    static class SecureCredentials
    extends AbstractCredentials {
        SecureCredentials() {
        }

        void receive(InputStream in, OutputStream out) throws IOException {
            ExchangingEncryptor encryptor = this.initializeEncryptor(in, out);
            this.setUsername(IOUtils.readUTF(in));
            this.setPassword(encryptor.getDecryptedValue(this.readCountedBytes(in)));
        }

        void send(InputStream in, OutputStream out) throws IOException {
            ExchangingEncryptor encryptor = this.initializeEncryptor(in, out);
            IOUtils.writeUTF(out, this.getUsername());
            this.writeCountedBytes(out, encryptor.getEncryptedValue(this.getPassword()));
        }

        private ExchangingEncryptor initializeEncryptor(InputStream in, OutputStream out) throws IOException {
            ExchangingEncryptor encryptor = ExchangingEncryptor.create();
            this.writeCountedBytes(out, encryptor.getLocalPublicKey());
            out.flush();
            encryptor.setRemotePublicKey(this.readCountedBytes(in));
            return encryptor;
        }

        private byte[] readCountedBytes(InputStream in) throws IOException {
            int chunkSize;
            int length = IOUtils.readCompressedInt(in);
            byte[] bytes = new byte[length];
            for (int count = 0; count < length; count += chunkSize) {
                chunkSize = in.read(bytes, count, length - count);
                if (chunkSize >= 0) continue;
                throw new EOFException();
            }
            return bytes;
        }

        private void writeCountedBytes(OutputStream out, byte[] bytes) throws IOException {
            IOUtils.writeCompressedInt(out, bytes.length);
            out.write(bytes);
        }
    }

    static class BasicCredentials
    extends AbstractCredentials {
        BasicCredentials() {
        }

        void send(InputStream in, OutputStream out) throws IOException {
            IOUtils.writeUTF(out, this.getUsername());
            IOUtils.writeUTF(out, this.getPassword());
        }

        void receive(InputStream in, OutputStream out) throws IOException {
            this.setUsername(IOUtils.readUTF(in));
            this.setPassword(IOUtils.readUTF(in));
        }
    }

    static abstract class AbstractCredentials
    implements Credentials {
        private String m_username = "";
        private String m_password = "";

        protected AbstractCredentials() {
        }

        protected AbstractCredentials(String password, String username) {
            this.setPassword(password);
            this.setUsername(username);
        }

        void setUsername(String username) {
            this.m_username = username == null ? "" : username;
        }

        void setPassword(String password) {
            this.m_password = password == null ? "" : password;
        }

        public String getUsername() {
            return this.m_username;
        }

        public String getPassword() {
            return this.m_password;
        }

        abstract void send(InputStream var1, OutputStream var2) throws IOException;

        abstract void receive(InputStream var1, OutputStream var2) throws IOException;
    }
}

