/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.naming.SubContext;
import com.evermind.net.AddressContainer;
import com.evermind.security.User;
import com.evermind.server.Application;
import com.evermind.server.ApplicationContext;
import com.evermind.server.rmi.RMIBinding;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIServer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class RMIServerContext
extends RMIContext {
    private static final String ROOT_CONTEXT_NAME = "system";
    private RMIServer m_server;
    private ApplicationContext applicationContext;
    private ClassLoader m_classLoader;

    RMIServerContext(RMIServer server, String domain) {
        super(server, domain, null);
        this.m_server = server;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }

    public Object lookupLocalObject(String name) throws NamingException {
        if (name.startsWith("java:comp/resource")) {
            return this.applicationContext == null ? null : this.applicationContext.handleResourceLookup(name);
        }
        return super.lookupLocalObject(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookupRemoteableObject(String name) throws NamingException {
        if (name.startsWith("java:comp/resource")) {
            return this.applicationContext == null ? null : this.applicationContext.handleResourceLookup(name);
        }
        Object object = super.lookupRemoteableObject(name);
        if (object == null && !((object = this.lookupInFederatedContexts(name)) instanceof Serializable)) {
            object = null;
        }
        if (object == null && RMIContext.isGlobalJNDILookupEnabled()) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.m_classLoader);
                object = this.m_server.lookupAcrossContexts(this, name);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        return object;
    }

    protected RMIBinding getBinding(String name) {
        RMIBinding binding = super.getBinding(name);
        if (binding != null) {
            return binding;
        }
        return this.getParentContext() == null ? null : this.getParentContext().getBinding(name);
    }

    protected Map getListValues(String startContextName, AddressContainer addressContainer, boolean bindings) throws IOException, NamingException {
        return this.listLocalContext(startContextName, bindings, null, addressContainer, false);
    }

    protected RMIContext getParentContext() {
        if (this.getParentName() != null) {
            return this.m_server.getServerContext(this.getParentName(), false);
        }
        if (this.domain == null || this.domain.equals(ROOT_CONTEXT_NAME)) {
            return null;
        }
        return this.m_server.getDefaultContext();
    }

    private String getParentName() {
        return this.getApplicationContext() == null ? null : this.getApplicationContext().getApplicationParentName();
    }

    protected ClassLoader selectClassLoader() {
        Application application;
        ClassLoader classLoader = null;
        if (this.getApplicationContext() != null) {
            classLoader = this.getApplicationContext().getBeansClassLoader();
        } else if (this.m_server.getApplicationServer() != null && (application = this.m_server.getApplicationServer().getDefaultApplication()) != null) {
            classLoader = application.getBeansClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    private ApplicationContext getApplicationContext() {
        if (this.applicationContext == null && this.m_server.getApplicationServer() != null) {
            try {
                Application application;
                Application application2 = application = this.domain == null ? this.m_server.getApplicationServer().getDefaultApplication() : this.m_server.getApplicationServer().getApplication(this.domain);
                if (application != null) {
                    this.applicationContext = application.getContext();
                }
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return this.applicationContext;
    }

    protected boolean isListable(String bindingName, User user, AddressContainer addressContainer) {
        return user == null || this.getApplicationContext().hasReadAccess(bindingName, user, addressContainer);
    }

    boolean hasReadAccess(String name, User user, AddressContainer addressContainer) {
        return this.getApplicationContext() == null || this.getApplicationContext().hasReadAccess(name, user, addressContainer);
    }

    boolean hasWriteAccess(String name, User user, AddressContainer addressContainer) {
        return this.getApplicationContext() == null || this.getApplicationContext().hasWriteAccess(name, user, addressContainer);
    }

    public Object lookup(String name) throws NamingException {
        RMIServer server = (RMIServer)this.getManager();
        if (name.length() == 0) {
            return new SubContext(this, name);
        }
        Object object = this.lookupLocalObject(name);
        if (object == null && this.hasLocalBindingInParentHierarchy(name)) {
            return null;
        }
        if (object == null && this.domain != null) {
            object = server.getDefaultContext().lookupLocalObject(name);
        }
        if (object == null) {
            object = this.lookupInFederatedContexts(name);
        }
        if (object != null) {
            return "<context>".equals(object) ? new SubContext(this, name) : object;
        }
        if (RMIContext.isGlobalJNDILookupEnabled() && (object = server.lookupAcrossContexts(this, name)) != null) {
            return object;
        }
        throw new NameNotFoundException(name + " not found");
    }

    public ClassLoader getClassLoader() {
        if (this.m_classLoader == null) {
            this.m_classLoader = this.selectClassLoader();
        }
        return this.m_classLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_classLoader = loader;
    }

    public void unbindLocalObject(String name) throws NamingException {
        this.unbind(name, 0);
    }

    boolean isApplicationRunning() {
        Application app;
        ApplicationContext appCtx = this.getApplicationContext();
        if (appCtx != null && (app = appCtx.getApplication()) != null) {
            return app.isRunning();
        }
        return false;
    }
}

