/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.server.rmi.BoundObject;
import com.evermind.server.rmi.CallbackReference;
import com.evermind.server.rmi.ServerRmiMessageHandler;
import java.io.IOException;
import java.io.InputStream;

public class RMIServerInputStream
extends ClassLoaderObjectInputStream {
    private ServerRmiMessageHandler m_handler;

    public RMIServerInputStream(InputStream in, ServerRmiMessageHandler handler) throws IOException {
        super(in, null);
        this.enableResolveObject(true);
        this.m_handler = handler;
    }

    public ClassLoader getClassLoader() {
        return this.m_handler.getClassLoader();
    }

    public Object resolveObject(Object object) throws IOException {
        if (object instanceof CallbackReference) {
            BoundObject bo = this.m_handler.getBoundObject(((CallbackReference)object).id);
            return bo == null ? null : bo.getObject();
        }
        return object;
    }
}

