/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.sql;

import com.evermind.security.AbstractUserManager;
import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.server.ApplicationServerGroup;
import com.evermind.sql.DataSourceUser;
import com.evermind.util.ObjectUtils;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataSourceUserManager
extends AbstractUserManager {
    protected static final int CASING_SENSITIVE = 1;
    protected static final int CASING_TOUPPER = 2;
    protected static final int CASING_TOLOWER = 3;
    protected DataSource dataSource = null;
    protected String dataSourceLocation = null;
    protected boolean destroyed;
    protected String tableName;
    protected String usernameField;
    protected String passwordField;
    protected String certificateIssuerField;
    protected String certificateSerialField;
    protected String localeField;
    protected boolean debug;
    protected String groupMembershipTableName;
    protected String groupMembershipUserField = "username";
    protected String groupMembershipGroupField = "group";
    protected Map users = new HashMap();
    protected long stalenessTime = -1L;
    protected int casing;
    private HashMap groups = new HashMap();
    private final DataSourceLookupStrategy m_dataSourceLookupStrategy;

    public DataSourceUserManager() {
        this(new StandardDataSourceLookupStrategy());
    }

    protected DataSourceUserManager(DataSourceLookupStrategy dataSourceLookupStrategy) {
        this.m_dataSourceLookupStrategy = dataSourceLookupStrategy;
    }

    public void init(Properties properties) throws InstantiationException {
        String defaultGroupsString;
        String staleness = properties.getProperty("staleness");
        String casing = properties.getProperty("casing");
        if (staleness != null) {
            try {
                this.stalenessTime = Integer.parseInt(staleness);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Invalid staleness value: '" + staleness + "', must be a valid integer");
            }
        }
        if (casing == null || casing.equalsIgnoreCase("sensitive")) {
            this.casing = 1;
        } else if (casing.equalsIgnoreCase("toupper")) {
            this.casing = 2;
        } else if (casing.equalsIgnoreCase("tolower")) {
            this.casing = 3;
        } else {
            throw new InstantiationException("Unknown casing type: '" + casing + "'");
        }
        String location = properties.getProperty("dataSource");
        if (location == null) {
            throw new InstantiationException("No dataSource specified");
        }
        this.dataSourceLocation = location;
        this.tableName = properties.getProperty("table", properties.getProperty("tableName", "users"));
        this.usernameField = properties.getProperty("usernameField", "username");
        this.passwordField = properties.getProperty("passwordField", "password");
        this.certificateIssuerField = properties.getProperty("certificateIssuerField", null);
        this.certificateSerialField = properties.getProperty("certificateSerialField", null);
        this.localeField = properties.getProperty("localeField", null);
        this.groupMembershipTableName = properties.getProperty("groupMembershipTableName");
        this.groupMembershipUserField = properties.getProperty("groupMembershipUsernameField");
        this.groupMembershipGroupField = properties.getProperty("groupMembershipGroupField");
        if (properties.getProperty("groupMembershipUsernameFieldName") != null) {
            this.groupMembershipUserField = properties.getProperty("groupMembershipUsernameFieldName");
        }
        if (properties.getProperty("groupMembershipGroupFieldName") != null) {
            this.groupMembershipGroupField = properties.getProperty("groupMembershipGroupFieldName");
        }
        this.debug = "true".equalsIgnoreCase(properties.getProperty("debug"));
        if (this.groupMembershipGroupField == null) {
            this.groupMembershipGroupField = "group";
        }
        if (this.groupMembershipUserField == null) {
            this.groupMembershipUserField = "username";
        }
        if ((defaultGroupsString = properties.getProperty("defaultGroups")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(defaultGroupsString, ", ");
            while (tokenizer.hasMoreElements()) {
                this.addDefaultGroup(tokenizer.nextToken());
            }
        }
    }

    public Group getGroup(String name) {
        Group group = (Group)this.groups.get(name);
        if (group == null) {
            group = new ApplicationServerGroup(name);
            this.groups.put(name, group);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User createUser(String username, String password) throws InstantiationException {
        username = this.toCase(username);
        DataSourceUser user = null;
        try {
            Connection connection = this.getDataSource().getConnection();
            try {
                DataSourceUserManager dataSourceUserManager = this;
                synchronized (dataSourceUserManager) {
                    PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + this.tableName + " WHERE " + this.usernameField + " = ?");
                    statement.setString(1, username);
                    ResultSet resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        resultSet.close();
                        statement.close();
                        throw new InstantiationException("User already exists");
                    }
                    resultSet.close();
                    statement.close();
                    statement = connection.prepareStatement("INSERT INTO " + this.tableName + "(" + this.usernameField + ", " + this.passwordField + ") VALUES (?, ?)");
                    statement.setString(1, username);
                    statement.setString(2, password);
                    statement.executeUpdate();
                    statement.close();
                    user = new DataSourceUser(this, username, password, null, null, null, this.stalenessTime >= 0L ? System.currentTimeMillis() : 0L);
                    Map map = this.users;
                    synchronized (map) {
                        this.users.put(username, user);
                    }
                }
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException: " + e.getMessage());
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String username) {
        username = this.toCase(username);
        if (this.debug) {
            System.out.println("DataSourceUserManager.getUser(" + username + ")");
        }
        User user = null;
        Map map = this.users;
        synchronized (map) {
            user = (DataSourceUser)this.users.get(username);
        }
        if (user != null && (this.stalenessTime < 0L || user.fetchedTime >= System.currentTimeMillis() - this.stalenessTime)) {
            return user;
        }
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            try {
                DataSourceUserManager dataSourceUserManager = this;
                synchronized (dataSourceUserManager) {
                    PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + this.tableName + " WHERE " + this.usernameField + " = ?");
                    statement.setString(1, username);
                    ResultSet resultSet = statement.executeQuery();
                    if (!resultSet.next()) {
                        resultSet.close();
                        statement.close();
                        if (this.parent != null) {
                            user = this.parent.getUser(username);
                        }
                    } else {
                        String serialString;
                        String password = resultSet.getString(this.passwordField);
                        String issuer = null;
                        BigInteger serial = null;
                        Locale locale = null;
                        if (this.certificateIssuerField != null) {
                            issuer = resultSet.getString(this.certificateIssuerField);
                        }
                        if (this.certificateSerialField != null && (serialString = resultSet.getString(this.certificateSerialField)) != null) {
                            serial = new BigInteger(serialString);
                        }
                        if (this.localeField != null) {
                            locale = ObjectUtils.toLocale(resultSet.getString(this.localeField));
                        }
                        user = new DataSourceUser(this, username, password, issuer, serial, locale, this.stalenessTime >= 0L ? System.currentTimeMillis() : 0L);
                        resultSet.close();
                        statement.close();
                        Map map2 = this.users;
                        synchronized (map2) {
                            this.users.put(username, user);
                        }
                    }
                }
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException e) {
            if (this.debug) {
                System.err.println("SQLException in getUser(...):");
                e.printStackTrace();
            }
            throw new RuntimeException("SQLException: " + e.getMessage());
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(User user) {
        String name = user.getName();
        boolean response = false;
        if (name == null) {
            return false;
        }
        Map map = this.users;
        synchronized (map) {
            this.users.remove(user);
        }
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            try {
                DataSourceUserManager dataSourceUserManager = this;
                synchronized (dataSourceUserManager) {
                    PreparedStatement statement = connection.prepareStatement("DELETE FROM " + this.tableName + " WHERE " + this.usernameField + "= ?");
                    statement.setString(1, name);
                    response = statement.executeUpdate() != 0;
                    statement.close();
                }
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException: " + e.getMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateUserInfo(String username, String issuer, BigInteger serial, Locale locale) {
        if (issuer != null || serial != null) {
            if (this.certificateIssuerField == null) throw new UnsupportedOperationException("certificateIssuerField or certificateSerialField not specified");
            if (this.certificateSerialField == null) {
                throw new UnsupportedOperationException("certificateIssuerField or certificateSerialField not specified");
            }
        }
        Connection connection = null;
        try {
            try {
                connection = this.getDataSource().getConnection();
                DataSourceUserManager dataSourceUserManager = this;
                synchronized (dataSourceUserManager) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("update " + this.tableName + " set ");
                    boolean first = true;
                    if (this.certificateIssuerField != null) {
                        first = false;
                        buffer.append(this.certificateIssuerField + " = ?");
                    }
                    if (this.certificateSerialField != null) {
                        if (!first) {
                            buffer.append(", ");
                        }
                        first = false;
                        buffer.append(this.certificateSerialField + " = ?");
                    }
                    if (this.localeField != null) {
                        if (!first) {
                            buffer.append(", ");
                        }
                        first = false;
                        buffer.append(this.localeField + " = ?");
                    }
                    buffer.append(" WHERE " + this.usernameField + " = ?");
                    PreparedStatement statement = connection.prepareStatement(buffer.toString());
                    int nr = 1;
                    if (this.certificateIssuerField != null) {
                        if (issuer == null) {
                            statement.setNull(nr++, 12);
                        } else {
                            statement.setString(nr++, issuer);
                        }
                    }
                    if (this.certificateSerialField != null) {
                        if (serial == null) {
                            statement.setNull(nr++, 12);
                        } else {
                            statement.setString(nr++, serial.toString());
                        }
                    }
                    if (this.localeField != null) {
                        if (locale == null) {
                            statement.setNull(nr++, 12);
                        } else {
                            statement.setString(nr++, ObjectUtils.toString(locale));
                        }
                    }
                    statement.setString(nr++, username);
                    statement.executeUpdate();
                    statement.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("SQLException: " + e.getMessage());
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        if (connection == null) return;
        connection.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User getUser(String issuerDN, BigInteger serial) {
        User user = null;
        if (this.certificateIssuerField != null && this.certificateSerialField != null) {
            Object iterator;
            if (this.users != null) {
                Map map = this.users;
                synchronized (map) {
                    iterator = this.users.values().iterator();
                    while (iterator.hasNext()) {
                        user = (DataSourceUser)iterator.next();
                        BigInteger userSerial = user.getCertificateSerial();
                        if (userSerial == null || !userSerial.equals(serial) || !issuerDN.equals(user.getCertificateIssuerDN())) continue;
                        return user;
                    }
                }
            }
            Connection connection = null;
            try {
                try {
                    connection = this.getDataSource().getConnection();
                    iterator = this;
                    synchronized (iterator) {
                        PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + this.tableName + " WHERE " + this.certificateIssuerField + " = ? AND " + this.certificateSerialField + " = ?");
                        statement.setString(1, issuerDN);
                        statement.setString(2, serial.toString());
                        ResultSet resultSet = statement.executeQuery();
                        if (!resultSet.next()) {
                            resultSet.close();
                            statement.close();
                            if (this.parent != null) {
                                user = this.parent.getUser(issuerDN, serial);
                            }
                        } else {
                            String username = resultSet.getString(this.usernameField);
                            String password = resultSet.getString(this.passwordField);
                            Locale locale = null;
                            if (this.localeField != null) {
                                locale = ObjectUtils.toLocale(resultSet.getString(this.localeField));
                            }
                            user = new DataSourceUser(this, username, password, issuerDN, serial, locale, this.stalenessTime >= 0L ? System.currentTimeMillis() : 0L);
                            resultSet.close();
                            statement.close();
                            Map map = this.users;
                            synchronized (map) {
                                this.users.put(username, user);
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException("SQLException: " + e.getMessage());
                }
                Object var15_13 = null;
                {
                }
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                try {
                    if (connection == null) throw throwable;
                    connection.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException e) {}
            if (connection != null) {
                connection.close();
            }
        }
        if (user != null) return user;
        if (this.parent == null) return user;
        return this.parent.getUser(issuerDN, serial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getGroups(DataSourceUser user) throws SQLException {
        HashSet<Group> hashSet;
        if (this.debug) {
            System.out.println("Getting groups for " + user.getName() + "...");
        }
        if (this.groupMembershipTableName == null) {
            if (this.debug) {
                System.out.println("Groups for " + user.getName() + ": <none> (no groupMembershipTableName defined)");
            }
            return null;
        }
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            PreparedStatement statement = connection.prepareStatement("select " + this.groupMembershipGroupField + " from " + this.groupMembershipTableName + " where " + this.groupMembershipUserField + " = ?");
            statement.setString(1, user.getName());
            ResultSet set = statement.executeQuery();
            HashSet<Group> response = new HashSet<Group>();
            while (set.next()) {
                Group currGroup = this.getGroup(set.getString(1));
                if (currGroup == null) continue;
                response.add(currGroup);
            }
            set.close();
            statement.close();
            if (this.debug) {
                System.out.println("Groups for " + user.getName() + ": " + response);
            }
            hashSet = response;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
            throw throwable;
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToGroup(DataSourceUser user, Group group) throws SQLException {
        if (this.groupMembershipTableName == null) {
            return;
        }
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            PreparedStatement statement = connection.prepareStatement("insert into " + this.groupMembershipTableName + " (" + this.groupMembershipUserField + ", " + this.groupMembershipGroupField + ") values (?, ?)");
            statement.setString(1, user.getName());
            statement.setString(1, group.getName());
            statement.executeUpdate();
            statement.close();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromGroup(DataSourceUser user, Group group) throws SQLException {
        if (this.groupMembershipTableName == null) {
            return;
        }
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            PreparedStatement statement = connection.prepareStatement("delete from " + this.groupMembershipTableName + " where " + this.groupMembershipUserField + " = ? and " + this.groupMembershipGroupField + " = ?");
            statement.setString(1, user.getName());
            statement.setString(2, group.getName());
            statement.executeUpdate();
            statement.close();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUserCount() {
        int n;
        Connection connection = null;
        try {
            try {
                connection = this.getDataSource().getConnection();
                PreparedStatement statement = connection.prepareStatement("select count(*) as numberOfUsers from " + this.tableName);
                ResultSet set = statement.executeQuery();
                set.next();
                int count = set.getInt("numberOfUsers");
                set.close();
                statement.close();
                n = count;
                Object var7_7 = null;
            }
            catch (SQLException e) {
                throw new RuntimeException("SQLException: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException e2) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            // empty catch block
            return n;
        }
        if (connection == null) return n;
        connection.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getUsers(int start, int length) {
        ArrayList<User> arrayList;
        Connection connection = null;
        try {
            try {
                connection = this.getDataSource().getConnection();
                PreparedStatement statement = connection.prepareStatement("select " + this.usernameField + " from " + this.tableName);
                ResultSet set = statement.executeQuery();
                while (start > 0 && set.next()) {
                }
                ArrayList<User> response = new ArrayList<User>();
                while (length > 0 && set.next()) {
                    response.add(this.getUser(set.getString(this.usernameField)));
                }
                set.close();
                statement.close();
                arrayList = response;
                Object var9_9 = null;
            }
            catch (SQLException e) {
                throw new RuntimeException("SQLException: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException e2) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            // empty catch block
            return arrayList;
        }
        if (connection == null) return arrayList;
        connection.close();
        return arrayList;
    }

    public String toCase(String name) {
        switch (this.casing) {
            case 2: {
                boolean needsToChange = false;
                for (int i = 0; i < name.length(); ++i) {
                    if (!Character.isLowerCase(name.charAt(i))) continue;
                    needsToChange = true;
                    break;
                }
                return needsToChange ? name.toUpperCase() : name;
            }
            case 3: {
                boolean needsToChange = false;
                for (int i = 0; i < name.length(); ++i) {
                    if (!Character.isUpperCase(name.charAt(i))) continue;
                    needsToChange = true;
                    break;
                }
                return needsToChange ? name.toLowerCase() : name;
            }
        }
        return name;
    }

    protected DataSource getDataSource() {
        if (this.dataSource == null) {
            try {
                this.dataSource = this.m_dataSourceLookupStrategy.lookupDataSource(this.dataSourceLocation);
            }
            catch (ClassCastException e) {
                if (this.debug) {
                    e.printStackTrace();
                    System.out.println("DataSourceUserManager.getDataResource - Not a valid DataSource at " + this.dataSourceLocation);
                }
                this.dataSource = null;
            }
            catch (NamingException e) {
                if (this.debug) {
                    e.printStackTrace();
                    System.out.println("DataSourceUserManager.getDataResource - Error in lookup of datasource : " + this.dataSourceLocation + " exception is " + e.getMessage());
                }
                this.dataSource = null;
            }
        }
        return this.dataSource;
    }

    static class StandardDataSourceLookupStrategy
    implements DataSourceLookupStrategy {
        StandardDataSourceLookupStrategy() {
        }

        public DataSource lookupDataSource(String dataSourceLocation) throws NamingException {
            InitialContext context = new InitialContext();
            return (DataSource)context.lookup(dataSourceLocation);
        }
    }

    static interface DataSourceLookupStrategy {
        public DataSource lookupDataSource(String var1) throws NamingException;
    }
}

