/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.ssl;

import com.evermind.ssl.SSLServerSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import oracle.oc4j.security.OC4JSSLSocketFactory;
import oracle.oc4j.security.SSLMessages;

public class JSSESSLServerSocketFactory
implements SSLServerSocketFactory {
    public static final char[] DEFAULT_PASSWORD = OC4JSSLSocketFactory.DEFAULT_PASSWORD;
    public static final int DEFAULT_SOCKET_TIMEOUT = 20000;

    public ServerSocket createServerSocket(int port, int backlog, InetAddress address, String provider, Properties securityProperties, Properties systemProperties, InputStream keyStoreIn, String keyStorePassword, InputStream trustStoreIn, String trustStorePassword, boolean needClientAuth, boolean wantClientAuth, String[] cipherSuites) throws IOException {
        return this.createServerSocket(port, backlog, address, provider, null, null, securityProperties, systemProperties, keyStoreIn, null == keyStorePassword ? DEFAULT_PASSWORD : keyStorePassword.toCharArray(), trustStoreIn, null == trustStorePassword ? DEFAULT_PASSWORD : trustStorePassword.toCharArray(), needClientAuth, wantClientAuth, cipherSuites);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress address, String provider, String storeType, String keyAlgorithmType, Properties securityProperties, Properties systemProperties, InputStream keyStoreIn, char[] keyStorePassword, InputStream trustStoreIn, char[] trustStorePassword, boolean needClientAuth, boolean wantClientAuth, String[] cipherSuites) throws IOException {
        SSLServerSocket sSLServerSocket;
        block6: {
            SSLMessages.logGetSecureSocket(address, port, backlog);
            Properties savedSystemProperties = null;
            try {
                this.handleSecurityProperties(securityProperties);
                savedSystemProperties = this.handleSystemProperties(systemProperties);
                KeyStore keyStore = this.getStore(storeType, provider, keyStoreIn, keyStorePassword);
                KeyStore trustStore = this.getStore(storeType, provider, trustStoreIn, trustStorePassword);
                if (null == trustStore) {
                    trustStore = keyStore;
                }
                KeyManager[] keyManagers = this.getKeyManagers(keyStore, keyStorePassword, storeType, provider, keyAlgorithmType);
                TrustManager[] trustManagers = needClientAuth || wantClientAuth ? this.getTrustManagers(trustStore, trustStorePassword, storeType, provider, keyAlgorithmType) : null;
                SSLContext sslContext = this.getSSLContext(provider, keyManagers, trustManagers);
                sSLServerSocket = this.createServerSocket(sslContext, port, backlog, address, needClientAuth, wantClientAuth, trustStore == keyStore, cipherSuites);
                if (savedSystemProperties == null) break block6;
            }
            catch (Exception e) {
                try {
                    IOException ioe = new IOException(e.getLocalizedMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                catch (Throwable throwable) {
                    if (savedSystemProperties != null) {
                        System.setProperties(savedSystemProperties);
                    }
                    throw throwable;
                }
            }
            System.setProperties(savedSystemProperties);
        }
        return sSLServerSocket;
    }

    protected SSLServerSocket createServerSocket(SSLContext sslContext, int port, int backlog, InetAddress address, boolean needClientAuth, boolean wantClientAuth, boolean allowAnonymous, String[] cipherSuites) throws IOException {
        javax.net.ssl.SSLServerSocketFactory ssf = sslContext.getServerSocketFactory();
        SSLServerSocket sss = (SSLServerSocket)ssf.createServerSocket(port, backlog, address);
        if (needClientAuth) {
            sss.setNeedClientAuth(needClientAuth);
        } else if (wantClientAuth) {
            sss.setWantClientAuth(wantClientAuth);
        } else if (null != cipherSuites) {
            sss.setEnabledCipherSuites(cipherSuites);
        } else if (allowAnonymous) {
            sss.setEnabledCipherSuites(sss.getSupportedCipherSuites());
        }
        sss.setEnableSessionCreation(true);
        sss.setSoTimeout(20000);
        return sss;
    }

    protected SSLContext getSSLContext(String provider, KeyManager[] keyManagers, TrustManager[] trustManagers) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        return OC4JSSLSocketFactory.getSSLContext(null, provider, keyManagers, trustManagers);
    }

    protected KeyManager[] getKeyManagers(KeyStore store, char[] password, String storeType, String provider, String keyAlgorithmType) throws NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException, KeyStoreException {
        return OC4JSSLSocketFactory.getKeyManagers(store, password, storeType, provider, keyAlgorithmType);
    }

    protected TrustManager[] getTrustManagers(KeyStore store, char[] password, String storeType, String provider, String _keyAlgorithmType) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        return OC4JSSLSocketFactory.getTrustManagers(store, password, storeType, provider, _keyAlgorithmType);
    }

    protected KeyStore getStore(String storeType, String provider, InputStream storeIn, char[] password) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException {
        return OC4JSSLSocketFactory.getStore(storeType, provider, storeIn, password);
    }

    private Properties handleSystemProperties(Properties systemProperties) {
        Properties savedSystemProperties = null;
        if (systemProperties != null) {
            savedSystemProperties = System.getProperties();
            Properties newProps = new Properties(savedSystemProperties);
            Iterator<Map.Entry<Object, Object>> i = systemProperties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> prop = i.next();
                String key = (String)prop.getKey();
                String value = (String)prop.getValue();
                newProps.setProperty(key, value);
            }
            System.setProperties(newProps);
        }
        return savedSystemProperties;
    }

    private void handleSecurityProperties(Properties securityProperties) {
        if (securityProperties != null) {
            Iterator<Map.Entry<Object, Object>> i = securityProperties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> prop = i.next();
                String key = (String)prop.getKey();
                String value = (String)prop.getValue();
                Security.setProperty(key, value);
            }
        }
    }
}

