/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ArrayUtils;
import com.evermind.util.ByteString;
import com.evermind.util.HashedByteString;
import java.util.HashMap;
import java.util.Map;

public class ByteStringCache {
    private Map instances;
    private byte[] cache = new byte[100];
    private int cacheLength;

    public ByteString getByteString(String string) {
        return this.getByteString(new HashedByteString(string));
    }

    public ByteString getByteString(byte[] data) {
        return this.getByteString(new HashedByteString(data, 0, data.length));
    }

    public int getLength() {
        return this.cacheLength;
    }

    public ByteString getByteString(byte[] data, int offset, int length) {
        return this.getByteString(new HashedByteString(data, offset, length));
    }

    public ByteString getByteString(ByteString value) {
        ByteString replacement;
        ByteString byteString = replacement = this.instances == null ? null : (ByteString)this.instances.get(value);
        if (replacement != null) {
            return replacement;
        }
        byte[] cache = this.cache;
        boolean found = false;
        if (value.length == 0) {
            found = true;
        } else {
            for (int i = 0; i < this.cacheLength - value.length; ++i) {
                if (cache[i] != value.data[value.offset] || !ArrayUtils.compare(cache, i, value.length, value.data, value.offset, value.length)) continue;
                value.data = cache;
                value.offset = i;
                found = true;
                break;
            }
        }
        if (!found) {
            while (this.cacheLength + value.length > cache.length) {
                byte[] newArray = new byte[cache.length + 100];
                System.arraycopy(cache, 0, newArray, 0, cache.length);
                cache = newArray;
                this.cache = newArray;
            }
            System.arraycopy(value.data, value.offset, cache, this.cacheLength, value.length);
            value.offset = this.cacheLength;
            value.data = cache;
            this.cacheLength += value.length;
        }
        if (this.instances == null) {
            this.instances = new HashMap();
        }
        this.instances.put(value, value);
        return value;
    }

    public synchronized void flushInstances() {
        this.instances = null;
    }
}

