/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.naming.archive.ArchiveContext;
import com.evermind.util.ServerProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ExtendedFile
extends File {
    public ExtendedFile(File parent, String child) throws NullPointerException {
        super(parent, child);
    }

    public ExtendedFile(String pathname) throws NullPointerException {
        super(pathname);
    }

    public ExtendedFile(String parent, String child) throws NullPointerException {
        super(parent, child);
    }

    public final void recursiveRemove() throws IOException {
        ExtendedFile.recursiveRemove(this);
    }

    public final void createNewFileRecursive() throws IOException {
        String fileName = this.getPath();
        String partialPath = "";
        if (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') {
            partialPath = partialPath + fileName.charAt(0);
        }
        StringTokenizer st = new StringTokenizer(fileName, "/\\");
        while (st.hasMoreTokens()) {
            File file = new File(partialPath = partialPath + st.nextToken());
            if (!file.exists()) {
                if (st.hasMoreTokens()) {
                    if (!file.mkdir()) {
                        throw new IOException("Cannot create directory " + file);
                    }
                } else if (!this.createNewFile()) {
                    throw new IOException("Cannot create file " + this.toString());
                }
            }
            partialPath = partialPath + File.separator;
        }
    }

    public static File createTempDir() throws IOException {
        try {
            File tmpFile = File.createTempFile("dir", "tmp");
            File tmpDir = new File(tmpFile.getAbsolutePath());
            tmpFile.delete();
            if (!tmpDir.mkdir()) {
                throw new IOException("Cannot create temp directory " + tmpDir.getAbsolutePath());
            }
            return tmpDir;
        }
        catch (Exception e) {
            throw new IOException("Cannot create temp directory: " + e.getMessage());
        }
    }

    public static void recursiveRemove(File file) throws IOException {
        boolean deleted;
        if (file == null) {
            if (ServerProperties.getApplicationServerDebug()) {
                System.err.println("ExtendedFile.recursiveRemove(): file is null");
            }
            return;
        }
        if (!file.exists()) {
            if (ServerProperties.getApplicationServerDebug()) {
                System.err.println("ExtendedFile.recursiveRemove(): file " + file.getAbsolutePath() + " does not exist");
            }
            return;
        }
        if (ServerProperties.getApplicationServerDebug()) {
            System.err.println("ExtendedFile.recursiveRemove(" + file.getAbsolutePath() + ")");
        }
        boolean success = true;
        if (file.isDirectory()) {
            File[] xfiles = file.listFiles();
            for (int i = 0; i < xfiles.length; ++i) {
                if (xfiles[i].isDirectory()) {
                    try {
                        ExtendedFile.recursiveRemove(xfiles[i]);
                    }
                    catch (IOException e) {
                        success = false;
                    }
                    continue;
                }
                deleted = ExtendedFile.attemptDelete(xfiles[i]);
                if (deleted) continue;
                success = false;
            }
        }
        if (!(deleted = ExtendedFile.attemptDelete(file))) {
            success = false;
        }
        if (!success) {
            throw new IOException("Unable to remove " + file.getAbsolutePath());
        }
    }

    private static boolean attemptDelete(File xfile) {
        boolean closed = ArchiveContext.close(xfile);
        boolean deleted = xfile.delete();
        if (!deleted) {
            System.err.print(xfile.getAbsolutePath() + " could not be deleted ...");
            System.err.print("ArchiveContext.close() returns " + closed);
            System.err.println(" Read: " + xfile.canRead() + " Write: " + xfile.canWrite());
            System.err.flush();
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unjar(File archive, String dirName) throws IllegalArgumentException, IOException, FileNotFoundException, SecurityException {
        File directory;
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("unjar " + archive.getAbsolutePath() + " in " + dirName);
        }
        if ((directory = new File(dirName)).exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(dirName + " already exist, but is not a directory");
            }
        } else if (!directory.mkdir()) {
            throw new IOException("Cannot create directory " + dirName);
        }
        if (!directory.canWrite()) {
            throw new IOException("Cannot write to directory " + dirName);
        }
        if (dirName.charAt(dirName.length() - 1) != File.separatorChar) {
            dirName = dirName + File.separatorChar;
        }
        if (!archive.exists()) {
            throw new FileNotFoundException("Archive file " + archive + " does not exist");
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(archive);
            byte[] buf = new byte[4096];
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                InputStream entryStream;
                block18: {
                    Object var12_11;
                    JarEntry entry = new JarEntry((ZipEntry)e.nextElement());
                    String entryName = dirName + entry.getName();
                    if (entry.isDirectory()) {
                        new File(entryName).mkdir();
                        continue;
                    }
                    ExtendedFile entryFile = new ExtendedFile(entryName);
                    if (!entryFile.exists()) {
                        entryFile.createNewFileRecursive();
                    }
                    entryStream = null;
                    FileOutputStream fileStream = null;
                    try {
                        entryStream = jarFile.getInputStream(entry);
                        fileStream = new FileOutputStream(entryFile);
                        ExtendedFile.copy(entryStream, fileStream, buf);
                        var12_11 = null;
                        if (fileStream == null) break block18;
                    }
                    catch (Throwable throwable) {
                        var12_11 = null;
                        if (fileStream != null) {
                            fileStream.close();
                        }
                        if (entryStream == null) throw throwable;
                        entryStream.close();
                        throw throwable;
                        return;
                    }
                    fileStream.close();
                }
                if (entryStream == null) continue;
                entryStream.close();
                {
                }
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    private static void copy(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        int bytes;
        while ((bytes = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytes);
        }
    }
}

