/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ExternalComparator;
import com.evermind.util.Link;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ExternalHashSet
extends AbstractSet
implements Serializable {
    public static final boolean DEBUG = false;
    private ExternalComparator comparator;
    private Link[] entries;
    private int size;
    private float loadFactor = 1.0f;

    public ExternalHashSet(ExternalComparator comparator) {
        this.comparator = comparator;
        this.entries = new Link[100];
    }

    public ExternalHashSet() {
        this(ExternalComparator.DEFAULT_COMPARATOR);
    }

    public Object get(Object key) {
        try {
            int hashCode = this.comparator.hashCode(key) & Integer.MAX_VALUE;
            int pos = hashCode % this.entries.length;
            Link entry = this.entries[pos];
            while (entry != null) {
                if (entry.hashCode == hashCode && this.comparator.equals(key, entry)) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException t) {
            t.printStackTrace();
            throw t;
        }
    }

    public boolean add(Object value) {
        return this.add((Link)value) != null;
    }

    public Object add(Link value) {
        int hashCode;
        value.hashCode = hashCode = this.comparator.hashCode(value) & Integer.MAX_VALUE;
        int pos = hashCode % this.entries.length;
        if (this.entries[pos] != null) {
            Link previousEntry = null;
            Link entry = this.entries[pos];
            do {
                if (entry.hashCode == hashCode && this.comparator.equals(value, entry)) {
                    if (previousEntry != null) {
                        previousEntry.next = value;
                    } else {
                        this.entries[pos] = value;
                    }
                    value.next = entry.next != null ? entry.next : null;
                    entry.next = null;
                    return entry;
                }
                previousEntry = entry;
            } while ((entry = entry.next) != null);
        }
        ++this.size;
        value.next = this.entries[pos];
        this.entries[pos] = value;
        if (this.size > this.entries.length) {
            this.setHashSize((int)((double)this.size * (1.0 + (double)this.loadFactor)));
        }
        return null;
    }

    public boolean remove(Object key) {
        return this.removeLink(key) != null;
    }

    public Object removeLink(Object key) {
        int hashCode = this.comparator.hashCode(key) & Integer.MAX_VALUE;
        int pos = hashCode % this.entries.length;
        if (this.entries[pos] != null) {
            Link previousEntry = null;
            Link entry = this.entries[pos];
            do {
                if (entry.hashCode == hashCode && this.comparator.equals(key, entry)) {
                    --this.size;
                    if (previousEntry != null) {
                        previousEntry.next = entry.next;
                    } else {
                        this.entries[pos] = entry.next;
                    }
                    return entry;
                }
                previousEntry = entry;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void setHashSize(int length) {
        if (length == this.entries.length) {
            return;
        }
        if (length < 1) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        Link[] entries = this.entries;
        Link[] newEntries = new Link[length];
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null) continue;
            Link next = entries[i];
            while (next != null) {
                Link entry = next;
                next = entry.next;
                int pos = entry.hashCode % length;
                entry.next = newEntries[pos];
                newEntries[pos] = entry;
            }
        }
        this.entries = newEntries;
    }

    public Iterator iterator() {
        return new ExternalHashSetIterator();
    }

    public class ExternalHashSetIterator
    implements Iterator {
        private int pos;
        private Link previousEntry;
        private Link entry;

        public ExternalHashSetIterator() {
            if (ExternalHashSet.this.entries[0] != null) {
                this.entry = ExternalHashSet.this.entries[0];
            } else {
                this.getNextEntry();
            }
        }

        public Object next() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            Link entry = this.entry;
            this.getNextEntry();
            return entry;
        }

        public void remove() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            if (this.previousEntry != null && this.previousEntry.next == this.entry) {
                this.previousEntry.next = this.entry.next;
                this.entry = this.previousEntry;
                this.getNextEntry();
            } else {
                ((ExternalHashSet)ExternalHashSet.this).entries[this.pos] = null;
                this.getNextEntry();
            }
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        private void getNextEntry() {
            this.previousEntry = this.entry;
            if (this.entry != null && this.entry.next != null) {
                this.entry = this.entry.next;
                return;
            }
            do {
                if (++this.pos < ExternalHashSet.this.entries.length) continue;
                this.entry = null;
                return;
            } while (ExternalHashSet.this.entries[this.pos] == null);
            this.entry = ExternalHashSet.this.entries[this.pos];
        }
    }
}

