/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.BasicMapEntry;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class FastMap
extends AbstractMap {
    private int length = 0;
    private int[] hash = new int[10];
    private Object[] key = new Object[10];
    private Object[] value = new Object[10];

    public Set entrySet() {
        return new FastMapEntrySet();
    }

    private int getIndex(int hash) {
        int searchIndex = this.length / 2;
        int[] hashTable = this.hash;
        for (int jumpSize = this.length / 4; jumpSize > 1; jumpSize /= 2) {
            int comparator = hashTable[searchIndex];
            if (comparator > hash) {
                searchIndex -= jumpSize;
                continue;
            }
            if (comparator < hash) {
                searchIndex += jumpSize;
                continue;
            }
            while (searchIndex > 0 && hashTable[searchIndex - 1] == hash) {
                --searchIndex;
            }
            return searchIndex;
        }
        while (true) {
            if (hashTable[searchIndex] > hash) {
                if (searchIndex == 0 || hashTable[searchIndex - 1] < hash) {
                    return -1;
                }
                --searchIndex;
                continue;
            }
            if (hashTable[searchIndex] >= hash) break;
            if (searchIndex > this.length - 1 || hashTable[searchIndex + 1] > hash) {
                return -1;
            }
            ++searchIndex;
        }
        return searchIndex;
    }

    private int getClosestIndex(int hash) {
        int searchIndex = this.length / 2;
        int jumpSize = this.length / 4;
        if (jumpSize < 1) {
            jumpSize = 1;
        }
        while (true) {
            int comparator;
            if ((comparator = this.hash[searchIndex]) > hash) {
                if (this.length > 0 && this.hash[searchIndex - 1] > hash) {
                    return searchIndex;
                }
                searchIndex -= jumpSize;
            } else if (comparator < hash) {
                if (searchIndex >= this.length - 1 || this.hash[searchIndex + 1] > hash) {
                    return searchIndex + 1;
                }
                searchIndex += jumpSize;
            } else {
                return searchIndex;
            }
            if (jumpSize <= 1) continue;
            jumpSize /= 2;
        }
    }

    public Object get(Object key) {
        int hashForKey = key.hashCode();
        int index = this.getIndex(hashForKey);
        if (index < 0) {
            return null;
        }
        do {
            if (!this.key[index].equals(key)) continue;
            return this.value[index];
        } while (++index < this.length && this.hash[index] == hashForKey);
        return null;
    }

    public Object put(Object key, Object value) {
        int index;
        int hashForKey = key.hashCode();
        for (index = this.getClosestIndex(hashForKey); this.hash[index] == hashForKey && index < this.length; ++index) {
            if (!this.key[index].equals(key)) continue;
            this.value[index] = value;
            return this.value[index];
        }
        this.makeRoom(index);
        this.hash[index] = hashForKey;
        this.key[index] = key;
        this.value[index] = value;
        return value;
    }

    private void makeRoom(int index) {
        int currentArrayLength = this.key.length;
        ++this.length;
        if (currentArrayLength == this.length) {
            int[] newHash = new int[currentArrayLength += 10];
            Object[] newKey = new Object[currentArrayLength];
            Object[] newValue = new Object[currentArrayLength];
            System.arraycopy(this.hash, 0, newHash, 0, index);
            System.arraycopy(this.key, 0, newKey, 0, index);
            System.arraycopy(this.value, 0, newValue, 0, index);
            System.arraycopy(this.hash, index, newHash, index + 1, this.length - index - 1);
            System.arraycopy(this.key, index, newKey, index + 1, this.length - index - 1);
            System.arraycopy(this.value, index, newValue, index + 1, this.length - index - 1);
            this.hash = newHash;
            this.key = newKey;
            this.value = newValue;
            return;
        }
        System.arraycopy(this.hash, index, this.hash, index + 1, this.length - index - 1);
        System.arraycopy(this.key, index, this.key, index + 1, this.length - index - 1);
        System.arraycopy(this.value, index, this.value, index + 1, this.length - index - 1);
    }

    private void removeElement(int index) {
        --this.length;
        System.arraycopy(this.hash, index + 1, this.hash, index, this.length - index);
        System.arraycopy(this.key, index + 1, this.key, index, this.length - index);
        System.arraycopy(this.value, index + 1, this.value, index, this.length - index);
    }

    public Object remove(Object key) {
        int hashForKey = key.hashCode();
        int index = this.getIndex(hashForKey);
        if (index >= 0) {
            do {
                if (!this.key[index].equals(key)) continue;
                Object value = this.value[index];
                this.removeElement(index);
                return value;
            } while (++index < this.length && this.hash[index] == hashForKey);
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            buffer.append(this.hash[i]);
            buffer.append(" : ");
            buffer.append(this.key[i]);
            buffer.append(" : ");
            buffer.append(this.value[i]);
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    private class FastMapEntrySet
    extends AbstractSet {
        private FastMapEntrySet() {
        }

        public int size() {
            return FastMap.this.length;
        }

        public Iterator iterator() {
            return new FastMapEntrySetIterator();
        }

        private class FastMapEntrySetIterator
        implements Iterator {
            int index = 0;

            private FastMapEntrySetIterator() {
            }

            public Object next() {
                if (this.index == FastMap.this.length) {
                    throw new NoSuchElementException();
                }
                BasicMapEntry entry = new BasicMapEntry(FastMap.this.key[this.index], FastMap.this.value[this.index], FastMap.this);
                ++this.index;
                return entry;
            }

            public boolean hasNext() {
                return this.index < FastMap.this.length;
            }

            public void remove() {
                if (this.index == 0) {
                    throw new NoSuchElementException();
                }
                FastMap.this.removeElement(this.index - 1);
            }
        }
    }
}

