/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.LongLinkedEntry;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class LongHashMap
extends AbstractMap
implements Serializable {
    private LongLinkedEntry[] m_entries;
    private int m_size;
    private static final int EXPANSION_FACTOR = 2;

    public LongHashMap() {
        this(100);
    }

    public LongHashMap(int initialSize) {
        this.m_entries = new LongLinkedEntry[initialSize];
    }

    public Set entrySet() {
        return new LongHashMapEntrySet();
    }

    public Object get(Object key) {
        try {
            return this.get(((Number)key).longValue());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Object get(long key) {
        int pos = LongHashMap.getEntryIndex(key, this.m_entries.length);
        LongLinkedEntry entry = this.m_entries[pos];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        return this.put(((Number)key).longValue(), value);
    }

    public synchronized Object put(long key, Object value) {
        int length = this.m_entries.length;
        int pos = LongHashMap.getEntryIndex(key, length);
        LongLinkedEntry entry = this.m_entries[pos];
        if (entry != null) {
            do {
                if (entry.key != key) continue;
                Object previousValue = entry.value;
                entry.value = value;
                return previousValue;
            } while ((entry = entry.next) != null);
            entry = this.m_entries[pos];
        }
        ++this.m_size;
        this.m_entries[pos] = new LongLinkedEntry(key, value, entry);
        if (this.m_size > this.m_entries.length) {
            this.setHashSize(2 * this.m_size);
        }
        return null;
    }

    private static int getEntryIndex(long key, int length) {
        return ((int)key & Integer.MAX_VALUE) % length;
    }

    public Object remove(Object key) {
        try {
            return this.remove(((Number)key).longValue());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public synchronized Object remove(long key) {
        int pos = LongHashMap.getEntryIndex(key, this.m_entries.length);
        if (this.m_entries[pos] != null) {
            LongLinkedEntry previousEntry = null;
            LongLinkedEntry entry = this.m_entries[pos];
            do {
                if (entry.key == key) {
                    --this.m_size;
                    if (previousEntry != null) {
                        previousEntry.next = entry.next;
                    } else {
                        this.m_entries[pos] = entry.next;
                    }
                    return entry.value;
                }
                previousEntry = entry;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    public int size() {
        return this.m_size;
    }

    private void setHashSize(int length) {
        if (length == this.m_entries.length) {
            return;
        }
        if (length < 1) {
            throw new IllegalArgumentException("Invalid length");
        }
        LongLinkedEntry[] entries = this.m_entries;
        LongLinkedEntry[] newEntries = new LongLinkedEntry[length];
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null) continue;
            LongLinkedEntry next = entries[i];
            while (next != null) {
                LongLinkedEntry entry = next;
                next = entry.next;
                int pos = LongHashMap.getEntryIndex(entry.key, length);
                entry.next = newEntries[pos];
                newEntries[pos] = entry;
            }
        }
        this.m_entries = newEntries;
    }

    private class LongHashMapEntrySet
    extends AbstractSet {
        private LongHashMapEntrySet() {
        }

        public Iterator iterator() {
            return new LongHashMapEntrySetIterator();
        }

        public int size() {
            return LongHashMap.this.m_size;
        }
    }

    private class LongHashMapEntrySetIterator
    implements Iterator {
        private int pos;
        private LongLinkedEntry previousEntry;
        private LongLinkedEntry entry;

        private LongHashMapEntrySetIterator() {
            if (LongHashMap.this.m_entries[0] != null) {
                this.entry = LongHashMap.this.m_entries[0];
            } else {
                this.getNextEntry();
            }
        }

        public Object next() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            LongLinkedEntry entry = this.entry;
            this.getNextEntry();
            return entry;
        }

        public void remove() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            if (this.previousEntry != null && this.previousEntry.next == this.entry) {
                this.previousEntry.next = this.entry.next;
                this.entry = this.previousEntry;
                this.getNextEntry();
            } else {
                ((LongHashMap)LongHashMap.this).m_entries[this.pos] = null;
                this.getNextEntry();
            }
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        private void getNextEntry() {
            this.previousEntry = this.entry;
            if (this.entry != null && this.entry.next != null) {
                this.entry = this.entry.next;
                return;
            }
            do {
                if (++this.pos < LongHashMap.this.m_entries.length) continue;
                this.entry = null;
                return;
            } while (LongHashMap.this.m_entries[this.pos] == null);
            this.entry = LongHashMap.this.m_entries[this.pos];
        }
    }
}

