/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.LogEvent;
import com.evermind.util.Logger;
import com.evermind.util.LoggerContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import oracle.core.ojdl.BusStopLogWriter;
import oracle.core.ojdl.BusStopLogWriterException;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogManagerInitException;
import oracle.core.ojdl.LogMessage;
import oracle.dms.instrument.CorrelationContext;

public class ODLLogger
implements Logger {
    protected LogManager mLogManager;
    protected BusStopLogWriter mLogWriter;
    protected String mPath = null;
    protected String mCanonicalPath = null;
    protected Properties mMessageProperties;
    protected LoggerContext mContext;
    protected int mMaxSegmentSize;
    protected int mMaxSize;
    protected boolean mInitialized;

    public ODLLogger(String path, int maxFileSize, int maxDirectorySize) throws InstantiationException {
        if (maxFileSize > maxDirectorySize) {
            throw new InstantiationException("max-file-size must be less then the total size allowed in the log folder");
        }
        this.mPath = path;
        this.mInitialized = false;
        this.setMaxFileSize(maxFileSize);
        this.setMaxDirectorySize(maxDirectorySize);
    }

    public String getPath() {
        return this.mPath;
    }

    public void setCanonicalPath(String path) {
        this.mCanonicalPath = path;
    }

    public String getCanonicalPath() {
        return this.mCanonicalPath;
    }

    public void setContext(LoggerContext context) {
        this.mContext = context;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void init(Properties properties) {
        this.mLogManager = LogManager.getLogManager();
        try {
            this.mLogManager.init(properties);
        }
        catch (LogManagerInitException e) {
            System.err.println("Error: cannot create LogManager instance");
            e.printStackTrace();
            return;
        }
        try {
            this.mLogWriter = BusStopLogWriter.create((String)this.mCanonicalPath, (long)this.mMaxSegmentSize, (long)this.mMaxSize, null);
        }
        catch (BusStopLogWriterException e) {
            System.err.println("Error: cannot create BusStopLogWriter instance");
            e.printStackTrace();
            return;
        }
        this.mMessageProperties = new Properties();
        this.mMessageProperties.setProperty("COMPONENT_ID", "OC4J");
        this.mMessageProperties.setProperty("MSG_TYPE", "NOTIFICATION");
        this.mMessageProperties.setProperty("MSG_LEVEL", "1");
        this.mInitialized = true;
    }

    public void log(LogEvent event) {
        LogMessage.InstanceId instanceId = CorrelationContext.getExecContextId();
        if (instanceId != null) {
            this.mMessageProperties.setProperty("EXEC_CONTEXT_UNIQUE_ID", instanceId.getUniqueId());
        }
        this.mMessageProperties.setProperty("MSG_TEXT", event.getMessage());
        LogMessage logMessage = new LogMessage(this.mMessageProperties);
        logMessage.setTimestamp(event.getTime());
        this.mLogWriter.write(logMessage, true);
        if (event.getThrowable() != null) {
            this.mMessageProperties.setProperty("MSG_TYPE", "ERROR");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(out);
            if (this.mContext != null) {
                this.mContext.printStackTrace(event.getThrowable(), printWriter);
            } else {
                event.getThrowable().printStackTrace(printWriter);
            }
            printWriter.flush();
            this.mMessageProperties.setProperty("MSG_TEXT", out.toString());
            logMessage = new LogMessage(this.mMessageProperties);
            logMessage.setTimestamp(event.getTime());
            this.mLogWriter.write(logMessage, true);
            this.mMessageProperties.setProperty("MSG_TYPE", "NOTIFICATION");
        }
    }

    public void setLogTimestamp(boolean timestamp) {
    }

    public void close() {
    }

    public String toString() {
        return "ODLLogger path: " + this.mPath + " maxFileSize: " + this.getMaxFileSize() + " maxDirectorySize: " + this.getMaxDirectorySize();
    }

    public boolean equals(Object o) {
        if (o instanceof ODLLogger) {
            ODLLogger odlLogger = (ODLLogger)o;
            if (odlLogger.mPath.equals(this.mPath)) {
                return true;
            }
        }
        return false;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.mMaxSegmentSize = maxFileSize * 1000;
    }

    public void setMaxDirectorySize(int maxDirectorySize) {
        this.mMaxSize = maxDirectorySize * 1000;
    }

    public int getMaxFileSize() {
        return this.mMaxSegmentSize / 1000;
    }

    public int getMaxDirectorySize() {
        return this.mMaxSize / 1000;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.write(indention + "\t<odl path=\"" + this.mPath + "\"");
        out.write(" max-file-size=\"" + this.getMaxFileSize() + "\"");
        out.write(" max-directory-size=\"" + this.getMaxDirectorySize() + "\"");
        out.println(" />");
    }
}

