/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.xml;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyValueMapping
implements XMLizable,
Map.Entry {
    private String key = "";
    private String value = "";

    public KeyValueMapping() {
    }

    public KeyValueMapping(Node parent, String tagName, String keyName, String valueName) throws InstantiationException {
        this.parseXML(parent, tagName, keyName, valueName);
    }

    public void parseXML(Node parent, String tagName, String keyName, String valueName) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                String name = nodes.item(i).getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals(keyName)) {
                    this.setKey(XMLUtils.getStringValue(nodes.item(i)));
                    continue;
                }
                if (name.equals(valueName)) {
                    this.setValue(XMLUtils.getStringValue(nodes.item(i)));
                    continue;
                }
                this.parseAdditionalField(tagName, nodes.item(i));
            }
        }
        if (this.key == null) {
            throw new InstantiationException("Missing '" + keyName + "' subtag in " + tagName + " tag");
        }
        if (this.value == null) {
            throw new InstantiationException("Missing '" + valueName + "' subtag in " + tagName + " tag");
        }
    }

    protected void parseAdditionalField(String tagName, Node node) throws InstantiationException {
        throw new InstantiationException(tagName + " with unknown subtag: " + node.getNodeName());
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public Object setValue(Object value) {
        String previous = this.value;
        this.value = value.toString();
        return previous;
    }

    public void writeXML(PrintWriter out, String indention, String defaultKey, String defaultValue, String tagName, String keyName, String valueName, boolean writeValueFirst) {
        if (this.key == null) {
            this.key = defaultKey;
        }
        if (this.value == null) {
            this.value = defaultValue;
        }
        out.println(indention + "<" + tagName + ">");
        if (writeValueFirst) {
            out.println(indention + "\t<" + valueName + ">" + XMLUtils.encode(this.value) + "</" + valueName + ">");
        }
        out.println(indention + "\t<" + keyName + ">" + XMLUtils.encode(this.key) + "</" + keyName + ">");
        if (!writeValueFirst) {
            out.println(indention + "\t<" + valueName + ">" + XMLUtils.encode(this.value) + "</" + valueName + ">");
        }
        this.writeAdditionalFields(out, indention);
        out.println(indention + "</" + tagName + ">");
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        this.writeXML(out, indention, "", "", "mapping", "key", "value", false);
    }

    public boolean equals(Object other) {
        if (!(other instanceof KeyValueMapping)) {
            return false;
        }
        return ((KeyValueMapping)other).key.equals(this.key);
    }

    public int hashCode() {
        if (this.key == null) {
            return 0;
        }
        return this.key.hashCode();
    }

    protected void writeAdditionalFields(PrintWriter out, String indention) {
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

